/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.recipes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class JR {
    public static final int C_TBD = 1;
    public static final int C_VFP = 2;
    public static final int C_HCB = 4;
    public static final int C_ORE = 8;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    static final FastDateFormat STAMP_FORMAT = FastDateFormat.getInstance((String)"yyyyMMdd'T'HHmmss.SSZ");
    private static final ThreadLocal<ModDef> _current_modDef = new ThreadLocal();
    private static final File RECIPES_DIR = new File("C:/Temp/JR");
    private static final int _ANY_TYPE = Short.MAX_VALUE;

    public static final void setCurrentMod(@Nonnull String modid) {
        _current_modDef.set(new ModDef(modid));
    }

    public static final void setCurrentMod(@Nonnull String modid, @Nonnull Map<String, String> rmap) {
        _current_modDef.set(new ModDef(modid));
        JR._current_modDef.get().rconstants = rmap;
    }

    public static final void disableLegacyMode() {
        JR._current_modDef.get().legacymode = false;
    }

    public static final void clrCurrentMod() {
        _current_modDef.set(null);
    }

    private static File getModDir(ModDef mod) {
        File modDir = new File(new File(RECIPES_DIR, mod.modid), mod.stamp);
        if (!modDir.exists() && !modDir.mkdirs()) {
            throw new RuntimeException("Cannot mkdir " + modDir);
        }
        return modDir;
    }

    public static final IRecipe newShapedOreRecipe(@Nullable IForgeRegistry<IRecipe> recipes, @Nonnull ResourceLocation rid, int flags, @Nonnull ItemStack result, Object ... recipe) {
        Validate.notNull((Object)rid, (String)"Non-null recipe id required", (Object[])new Object[0]);
        ModDef mod = _current_modDef.get();
        if (mod != null) {
            File modDir = JR.getModDir(mod);
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            JR.conditions(mod, flags, json);
            json.put("result", JR.serialize(mod, result, 1));
            json.put("type", "forge:ore_shaped");
            int keych0 = 0;
            ArrayList<String> pattern = new ArrayList<String>();
            for (Object ro : recipe) {
                if (!(ro instanceof String)) break;
                pattern.add(ro.toString());
                ++keych0;
            }
            json.put("pattern", pattern);
            LinkedHashMap<String, Map<String, Object>> keymap = new LinkedHashMap<String, Map<String, Object>>();
            for (int i = keych0; i < recipe.length; i += 2) {
                keymap.put(recipe[i].toString(), JR.serialize(mod, recipe[i + 1], 0));
            }
            json.put("key", keymap);
            File f = new File(modDir, rid.func_110623_a() + ".json");
            try (FileWriter w = new FileWriter(f);){
                GSON.toJson(json, (Appendable)w);
            }
            catch (IOException ioX) {
                throw new RuntimeException(ioX);
            }
        }
        ShapedOreRecipe r = new ShapedOreRecipe(null, result, recipe);
        r.setRegistryName(rid);
        if (recipes != null && (mod == null || mod.legacymode)) {
            recipes.register((IForgeRegistryEntry)r);
        }
        return r;
    }

    public static final IRecipe newShapedOreRecipe(@Nonnull ResourceLocation rid, int flags, @Nonnull ItemStack result, Object ... recipe) {
        return JR.newShapedOreRecipe(null, rid, flags, result, recipe);
    }

    public static final IRecipe newShapedOreRecipe(@Nonnull ResourceLocation rid, @Nonnull ItemStack result, Object ... recipe) {
        return JR.newShapedOreRecipe(null, rid, 0, result, recipe);
    }

    public static final IRecipe newShapelessOreRecipe(@Nullable IForgeRegistry<IRecipe> recipes, @Nonnull ResourceLocation rid, int flags, @Nonnull ItemStack result, Object ... recipe) {
        Validate.notNull((Object)rid, (String)"Non-null recipe id required", (Object[])new Object[0]);
        ModDef mod = _current_modDef.get();
        if (mod != null) {
            File modDir = JR.getModDir(mod);
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            JR.conditions(mod, flags, json);
            json.put("result", JR.serialize(mod, result, 1));
            json.put("type", "forge:ore_shapeless");
            ArrayList<Map<String, Object>> inglist = new ArrayList<Map<String, Object>>();
            for (Object ro : recipe) {
                inglist.add(JR.serialize(mod, ro, 0));
            }
            json.put("ingredients", inglist);
            File f = new File(modDir, rid.func_110623_a() + ".json");
            try (FileWriter w = new FileWriter(f);){
                GSON.toJson(json, (Appendable)w);
            }
            catch (IOException ioX) {
                throw new RuntimeException(ioX);
            }
        }
        ShapelessOreRecipe r = new ShapelessOreRecipe(null, result, recipe);
        r.setRegistryName(rid);
        if (recipes != null && (mod == null || mod.legacymode)) {
            recipes.register((IForgeRegistryEntry)r);
        }
        return r;
    }

    public static final IRecipe newShapelessOreRecipe(@Nonnull ResourceLocation rid, int flags, @Nonnull ItemStack result, Object ... recipe) {
        return JR.newShapelessOreRecipe(null, rid, flags, result, recipe);
    }

    public static final IRecipe newShapelessOreRecipe(@Nonnull ResourceLocation rid, @Nonnull ItemStack result, Object ... recipe) {
        return JR.newShapelessOreRecipe(null, rid, 0, result, recipe);
    }

    private static Map<String, Object> serialize(ModDef mod, Object o, int flags) {
        if (o instanceof Block) {
            return JR.serialize(mod, new ItemStack((Block)o, 1, flags <= 0 ? Short.MAX_VALUE : 0), flags);
        }
        if (o instanceof Item) {
            return JR.serialize(mod, new ItemStack((Item)o), flags);
        }
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            ret.put("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77973_b().func_77614_k() || stack.func_77952_i() > 0) {
                ret.put("data", stack.func_77952_i());
            }
            if (flags > 0 && stack.func_190916_E() > 1) {
                ret.put("count", stack.func_190916_E());
            }
            if (flags > 0 && stack.func_77942_o()) {
                ret.put("nbt", String.valueOf(stack.func_77978_p()));
            }
            return ret;
        }
        if (o instanceof String) {
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            String oreid = o.toString();
            String mapid = mod.rconstant(oreid);
            if (mapid != null) {
                ret.put("item", "#" + mapid);
            } else {
                ret.put("type", "forge:ore_dict");
                ret.put("ore", oreid);
            }
            return ret;
        }
        throw new IllegalArgumentException("Object not a block, item, stack, or oredict name: " + o);
    }

    private static void conditions(ModDef mod, int flags, Map<String, Object> json) {
        if (flags > 0) {
            ArrayList conditions = new ArrayList();
            LinkedHashMap<String, String> c = new LinkedHashMap<String, String>();
            c.put("type", "forge:mod_loaded");
            if ((flags & 2) == 2) {
                c.put("modid", "vanillafoodpantry");
            } else if ((flags & 4) == 4) {
                c.put("modid", "superblocks");
            } else if ((flags & 8) == 8) {
                c.put("type", mod.modid + ":oreid_exists");
                c.put("ore", "*FIXME*");
            } else {
                c.put("modid", "*FIXME*");
            }
            conditions.add(c);
            json.put("conditions", conditions);
        }
    }

    public static final CraftingHelper.ShapedPrimer primerFrom(@Nonnull ShapedOreRecipe template) {
        CraftingHelper.ShapedPrimer p = new CraftingHelper.ShapedPrimer();
        p.height = template.getRecipeHeight();
        p.width = template.getRecipeWidth();
        p.input = template.func_192400_c();
        return p;
    }

    public static final NonNullList<Ingredient> parseShapelessIngredients(JsonContext context, JsonObject json, String templateString, String emptyErrString) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (JsonElement ingredient : JsonUtils.func_151214_t((JsonObject)json, (String)templateString)) {
            ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)ingredient, (JsonContext)context));
        }
        if (ingredients.isEmpty()) {
            throw new JsonParseException(emptyErrString);
        }
        return ingredients;
    }

    public static final NonNullList<Ingredient> parseShapelessIngredients(JsonContext context, JsonObject json, String emptyErrString) {
        return JR.parseShapelessIngredients(context, json, "template", emptyErrString);
    }

    public static abstract class FilledUniversalBucketIngredientFactory
    implements IIngredientFactory {
        static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

        public static final Ingredient parse(ModIntegration modid, JsonContext context, JsonObject json) {
            ItemStack filled_bucket;
            String fluidName;
            Fluid fluid;
            IngredientNBTSensitive fallback_bucket = null;
            if (json.has("mod_bucket")) {
                JsonElement e = json.get("mod_bucket");
                if (e.isJsonObject()) {
                    ItemStack owned_bucket = CraftingHelper.getItemStack((JsonObject)e.getAsJsonObject(), (JsonContext)context);
                    if (!owned_bucket.func_190926_b()) {
                        fallback_bucket = new IngredientNBTSensitive(owned_bucket);
                    }
                } else {
                    String fallback_def = e.getAsString();
                    if (fallback_def.charAt(0) == '#') {
                        fallback_bucket = new OreIngredient(fallback_def.substring(1));
                    } else {
                        ItemStack owned_bucket = modid.itemstack(fallback_def);
                        if (!owned_bucket.func_190926_b()) {
                            fallback_bucket = new IngredientNBTSensitive(owned_bucket);
                        }
                    }
                }
            }
            if ((fluid = FluidRegistry.getFluid((String)(fluidName = JsonUtils.func_151200_h((JsonObject)json, (String)"fluid")))) == null && fallback_bucket != null) {
                return fallback_bucket;
            }
            if (fluid == null) {
                throw new JsonSyntaxException("Unregistered fluid '" + fluidName + "'");
            }
            FluidStack contents = new FluidStack(fluid, 1000);
            if (json.has("nbt")) {
                try {
                    JsonElement e = json.get("nbt");
                    NBTTagCompound nbt = e.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(e)) : JsonToNBT.func_180713_a((String)e.getAsString());
                    contents = new FluidStack(fluid, 1000, nbt);
                }
                catch (Throwable malformX) {
                    malformX.printStackTrace();
                    throw new JsonSyntaxException("Unable to read fluid NBT because '" + malformX.getMessage() + "'");
                }
            }
            if ((filled_bucket = FluidUtil.getFilledBucket((FluidStack)contents)).func_190926_b()) {
                if (fallback_bucket != null) {
                    return fallback_bucket;
                }
                throw new JsonSyntaxException("No bucket found for fluid '" + fluidName + "'");
            }
            Object out = null;
            if (fallback_bucket != null) {
                NonNullList both = NonNullList.func_191196_a();
                both.add((Object)fallback_bucket);
                both.add((Object)new BucketFluidIngredient(filled_bucket, contents));
                out = new CompoundIngredientNBTSensitive((Collection<Ingredient>)both);
            } else {
                out = new BucketFluidIngredient(filled_bucket, contents);
            }
            return out;
        }
    }

    public static abstract class NoLeftoversShapelessOreRecipe
    extends LegacyShapelessOreRecipe {
        public NoLeftoversShapelessOreRecipe(@Nullable ResourceLocation group, @Nonnull ItemStack result, Object ... recipe) {
            super(group, result, recipe);
        }

        public NoLeftoversShapelessOreRecipe(@Nullable ResourceLocation group, @Nonnull ShapelessOreRecipe template) {
            super(group, (NonNullList<Ingredient>)template.func_192400_c(), template.func_77571_b());
        }

        public NoLeftoversShapelessOreRecipe(@Nullable ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result) {
            super(group, input, result);
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting grid) {
            return SharedGlue.emptyNonNullItemStackList(grid.func_70302_i_());
        }
    }

    public static class LegacyShapelessOreRecipe
    extends ShapelessOreRecipe {
        protected LegacyShapelessOreRecipe(@Nullable ResourceLocation group, @Nonnull ItemStack result, Object ... recipe) {
            super(group, result, recipe);
        }

        public LegacyShapelessOreRecipe(@Nullable ResourceLocation group, @Nonnull ShapelessOreRecipe template) {
            super(group, template.func_192400_c(), template.func_77571_b());
        }

        protected LegacyShapelessOreRecipe(@Nullable ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result) {
            super(group, input, result);
        }

        public boolean func_77569_a(InventoryCrafting grid, World world) {
            boolean m = super.func_77569_a(grid, world);
            if (!m) {
                m = this.old_matches_only_if_you_have_to(grid, world);
            }
            return m;
        }

        protected final boolean old_matches_only_if_you_have_to(InventoryCrafting grid, World world) {
            NonNullList required = NonNullList.func_191196_a();
            required.addAll((Collection)this.input);
            for (int i = 0; i < grid.func_70302_i_(); ++i) {
                ItemStack slot = grid.func_70301_a(i);
                if (slot.func_190926_b()) continue;
                boolean inRecipe = false;
                Iterator req = required.iterator();
                while (req.hasNext()) {
                    if (!((Ingredient)req.next()).apply(slot)) continue;
                    inRecipe = true;
                    req.remove();
                    break;
                }
                if (inRecipe) continue;
                return false;
            }
            return required.isEmpty();
        }
    }

    public static final class BucketFluidIngredient
    extends IngredientNBT {
        private final FluidStack _match;

        public BucketFluidIngredient(ItemStack bucket_sample) {
            super(bucket_sample);
            Validate.isTrue((!bucket_sample.func_190926_b() ? 1 : 0) != 0);
            FluidStack f = FluidUtil.getFluidContained((ItemStack)bucket_sample);
            if (f == null) {
                throw new IllegalArgumentException("Unable to find fluid from input stack: " + bucket_sample);
            }
            this._match = f;
        }

        public BucketFluidIngredient(ItemStack mod_bucket, @Nonnull FluidStack f) {
            super(mod_bucket);
            Validate.isTrue((!mod_bucket.func_190926_b() ? 1 : 0) != 0);
            Validate.notNull((Object)f, (String)"A non-null fluid stack is required", (Object[])new Object[0]);
            this._match = f;
        }

        public boolean apply(@Nullable ItemStack input) {
            if (ModIntegration.isBucketOf(input, this._match)) {
                return true;
            }
            return super.apply(input);
        }

        public boolean isSimple() {
            return false;
        }
    }

    public static final class CompoundIngredientNBTSensitive
    extends CompoundIngredient {
        public CompoundIngredientNBTSensitive(Collection<Ingredient> children) {
            super(children);
        }
    }

    public static final class IngredientNBTSensitive
    extends IngredientNBT {
        public IngredientNBTSensitive(ItemStack stack) {
            super(stack);
        }
    }

    public static final class ModDef {
        public final String modid;
        public final String stamp;
        public boolean legacymode = true;
        public Map<String, String> rconstants = Collections.emptyMap();

        ModDef(String id) {
            this.modid = id;
            this.stamp = STAMP_FORMAT.format(System.currentTimeMillis());
        }

        @Nullable
        String rconstant(String oreid) {
            return this.rconstants.get(oreid);
        }
    }
}

