/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.spawnercontrol;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import ladysnake.spawnercontrol.SpawnerControl;
import ladysnake.spawnercontrol.SpawnerUtil;
import ladysnake.spawnercontrol.config.MSCConfig;
import ladysnake.spawnercontrol.config.SpawnerConfig;
import ladysnake.spawnercontrol.controlledspawner.BlockControlledSpawner;
import ladysnake.spawnercontrol.controlledspawner.CapabilityControllableSpawner;
import ladysnake.spawnercontrol.controlledspawner.IControllableSpawner;
import ladysnake.spawnercontrol.controlledspawner.TileEntityControlledSpawner;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="spawnercontrol")
public class SpawnerEventHandler {
    private static final String NBT_TAG_SPAWNER_POS = "spawnercontrol:spawnerPos";
    @VisibleForTesting
    static Set<TileEntityMobSpawner> allSpawners = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)event.getObject();
            if ((MSCConfig.alterVanillaSpawner || spawner instanceof TileEntityControlledSpawner) && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                allSpawners.add(spawner);
            }
            if (!(spawner instanceof TileEntityControlledSpawner)) {
                event.addCapability(CapabilityControllableSpawner.CAPABILITY_KEY, (ICapabilityProvider)new CapabilityControllableSpawner.Provider(spawner));
            }
        }
    }

    @SubscribeEvent
    public static void onTickWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.side == Side.CLIENT) {
            return;
        }
        Iterator<TileEntityMobSpawner> iterator = allSpawners.iterator();
        while (iterator.hasNext()) {
            IControllableSpawner handler;
            TileEntityMobSpawner spawner = iterator.next();
            if (spawner.func_145837_r()) {
                iterator.remove();
                continue;
            }
            if (spawner.func_145831_w() != event.world || (handler = CapabilityControllableSpawner.getHandler(spawner)).canSpawn()) continue;
            if (handler.getConfig().breakSpawner) {
                spawner.func_145831_w().func_175698_g(spawner.func_174877_v());
            }
            if (spawner.func_145831_w().field_72995_K) continue;
            double x = (float)spawner.func_174877_v().func_177958_n() + spawner.func_145831_w().field_73012_v.nextFloat();
            double y = (float)spawner.func_174877_v().func_177956_o() + spawner.func_145831_w().field_73012_v.nextFloat();
            double z = (float)spawner.func_174877_v().func_177952_p() + spawner.func_145831_w().field_73012_v.nextFloat();
            ((WorldServer)spawner.func_145831_w()).func_175739_a(EnumParticleTypes.SMOKE_LARGE, x, y, z, 3, 0.0, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckSpawnerSpawn(LivingSpawnEvent.CheckSpawn event) {
        MobSpawnerBaseLogic spawner = event.getSpawner();
        if (spawner != null) {
            boolean canSpawn;
            IControllableSpawner handler;
            if (event.getWorld().func_175625_s(spawner.func_177221_b()) == null && spawner.getSpawnerEntity() == null) {
                event.setResult(Event.Result.DENY);
            }
            if ((handler = SpawnerUtil.getHandlerIfAffected(event.getWorld(), spawner.func_177221_b())) == null) {
                return;
            }
            SpawnerConfig cfg = handler.getConfig();
            if (event.getResult() == Event.Result.DEFAULT && event.getEntityLiving() instanceof EntityLiving) {
                EntityLiving spawned = (EntityLiving)event.getEntityLiving();
                canSpawn = spawned.func_70058_J();
                if (cfg.spawnConditions.forceSpawnerMobSpawns && event.getEntity() instanceof IMob) {
                    if (cfg.spawnConditions.checkSunlight) {
                        canSpawn &= !event.getWorld().func_175678_i(new BlockPos((Entity)spawned)) || !event.getWorld().func_72935_r();
                    }
                } else if (!cfg.spawnConditions.forceSpawnerAllSpawns) {
                    canSpawn &= spawned.func_70601_bi();
                }
            } else {
                boolean bl = canSpawn = event.getResult() == Event.Result.ALLOW;
            }
            if (canSpawn) {
                if (handler.canSpawn()) {
                    if (!handler.getConfig().incrementOnMobDeath) {
                        handler.incrementSpawnedMobsCount();
                    }
                    NBTTagCompound compound = new NBTTagCompound();
                    World spawnerWorld = spawner.func_98271_a();
                    if (spawnerWorld != null) {
                        compound.func_74768_a("dimension", spawnerWorld.field_73011_w.getDimension());
                        compound.func_74772_a("pos", spawner.func_177221_b().func_177986_g());
                        event.getEntity().getEntityData().func_74782_a(NBT_TAG_SPAWNER_POS, (NBTBase)compound);
                    }
                    event.setResult(Event.Result.ALLOW);
                } else {
                    event.setResult(Event.Result.DENY);
                }
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSpawnSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getSpawner() == null) {
            return;
        }
        IControllableSpawner handler = SpawnerUtil.getHandlerIfAffected(event.getWorld(), event.getSpawner().func_177221_b());
        if (handler == null) {
            return;
        }
        if (!handler.canSpawn()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        NBTTagCompound data = event.getEntityLiving().getEntityData();
        if (data.func_74764_b(NBT_TAG_SPAWNER_POS)) {
            World world;
            long spawnerPos;
            NBTBase nbt = event.getEntityLiving().getEntityData().func_74781_a(NBT_TAG_SPAWNER_POS);
            if (nbt instanceof NBTTagCompound) {
                spawnerPos = ((NBTTagCompound)nbt).func_74763_f("pos");
                world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(((NBTTagCompound)nbt).func_74762_e("dimension"));
            } else if (nbt instanceof NBTTagLong) {
                spawnerPos = ((NBTTagLong)nbt).func_150291_c();
                world = event.getEntity().func_130014_f_();
            } else {
                return;
            }
            TileEntity tile = world.func_175625_s(BlockPos.func_177969_a((long)spawnerPos));
            if (tile instanceof TileEntityMobSpawner) {
                TileEntityMobSpawner spawner = (TileEntityMobSpawner)tile;
                IControllableSpawner handler = CapabilityControllableSpawner.getHandler(spawner);
                if (handler.getConfig().incrementOnMobDeath) {
                    handler.incrementSpawnedMobsCount();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        SpawnerConfig cfg = SpawnerUtil.getConfig(event.getEntityLiving().getEntityData().func_74781_a(NBT_TAG_SPAWNER_POS));
        if (cfg != null) {
            try {
                ResourceLocation rl = EntityList.func_191301_a((Entity)event.getEntity());
                if (rl != null) {
                    SpawnerConfig.MobLoot.MobLootEntry entry = (SpawnerConfig.MobLoot.MobLootEntry)cfg.mobLoot.lootEntries.get((Object)rl);
                    event.setDroppedExperience(MathHelper.func_76141_d((float)((float)event.getOriginalExperience() * entry.xpMultiplier + (float)entry.flatXpIncrease + (float)(event.getDroppedExperience() - event.getOriginalExperience()))));
                }
            }
            catch (ExecutionException e) {
                SpawnerControl.LOGGER.error("Error while handling spawned experience drop", (Throwable)e);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingItemDrop(LivingDropsEvent event) {
        EntityLivingBase livingBase = event.getEntityLiving();
        SpawnerConfig cfg = SpawnerUtil.getConfig(livingBase.getEntityData().func_74781_a(NBT_TAG_SPAWNER_POS));
        if (cfg != null) {
            try {
                ResourceLocation rl = EntityList.func_191301_a((Entity)event.getEntity());
                if (rl != null) {
                    SpawnerConfig.MobLoot.MobLootEntry entry = (SpawnerConfig.MobLoot.MobLootEntry)cfg.mobLoot.lootEntries.get((Object)rl);
                    List drops = event.getDrops();
                    if (entry.removeAllItems) {
                        drops.clear();
                    } else {
                        for (EntityItem drop : drops.toArray(new EntityItem[0])) {
                            ItemStack stack = drop.func_92059_d();
                            for (String s : entry.removedItems) {
                                String[] split = s.split(":");
                                if (!stack.func_77977_a().equals(split[0] + ":" + split[1]) || split.length >= 3 && stack.func_77960_j() != Integer.parseInt(split[2])) continue;
                                drops.remove(drop);
                            }
                        }
                    }
                    World world = livingBase.field_70170_p;
                    double x = livingBase.field_70165_t;
                    double y = livingBase.field_70163_u;
                    double z = livingBase.field_70161_v;
                    for (String s : entry.addedItems) {
                        String[] split = s.split(":");
                        if (split.length >= 5 && !(world.field_73012_v.nextDouble() < Double.parseDouble(split[4]))) continue;
                        ResourceLocation itemRL = new ResourceLocation(split[0], split[1]);
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemRL);
                        if (item == null) {
                            item = Item.func_150898_a((Block)((Block)ForgeRegistries.BLOCKS.getValue(itemRL)));
                        }
                        if (item != Items.field_190931_a) {
                            int quantity = split.length < 3 ? 1 : Integer.parseInt(split[2]);
                            int meta = split.length < 4 ? 0 : Integer.parseInt(split[3]);
                            drops.add(new EntityItem(world, x, y, z, new ItemStack(item, quantity, meta)));
                            continue;
                        }
                        SpawnerControl.LOGGER.error("Error while handling spawned item drops");
                    }
                }
            }
            catch (NumberFormatException | ExecutionException e) {
                SpawnerControl.LOGGER.error("Error while handling spawned item drops", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        SpawnerConfig cfg = SpawnerUtil.getConfig(event.getWorld(), event.getPos());
        if (cfg != null) {
            int xp = cfg.xpDropped;
            if (cfg.randXpVariation > 0) {
                xp += event.getWorld().field_73012_v.nextInt(cfg.randXpVariation) + event.getWorld().field_73012_v.nextInt(cfg.randXpVariation);
            }
            event.setExpToDrop(xp);
        }
    }

    @SubscribeEvent
    public static void onBlockHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null) {
            SpawnerConfig cfg;
            Block block = event.getState().func_177230_c();
            if (block instanceof BlockControlledSpawner) {
                cfg = ((BlockControlledSpawner)block).getConfig();
            } else if (block instanceof BlockMobSpawner && MSCConfig.alterVanillaSpawner) {
                cfg = MSCConfig.vanillaSpawnerConfig;
            } else {
                return;
            }
            List drops = event.getDrops();
            for (String entry : cfg.itemsDropped) {
                String[] split = entry.split(":");
                if (split.length <= 1) continue;
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(split[0], split[1]));
                try {
                    int meta;
                    if (item == null) continue;
                    int count = split.length >= 3 ? Integer.parseInt(split[2]) : 1;
                    int n = meta = split.length >= 4 ? Integer.parseInt(split[3]) : 0;
                    if (split.length >= 5 && !(event.getWorld().field_73012_v.nextDouble() < Double.parseDouble(split[4]))) continue;
                    drops.add(new ItemStack(item, count, meta));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

