/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.cache;

import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import xaero.map.WorldMap;
import xaero.map.cache.placeholder.PlaceholderBlockAccess;
import xaero.map.misc.Misc;

public class BlockStateShortShapeCache {
    private IntHashMap<Boolean> shortBlockStates = new IntHashMap();
    private int lastShortChecked = -1;
    private boolean lastShortCheckedResult = false;
    private PlaceholderBlockAccess placeholderBlockAccess = new PlaceholderBlockAccess();
    private ListenableFutureTask<Boolean> ioThreadWaitingFor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShort(final int state) {
        Boolean cached;
        IntHashMap<Boolean> intHashMap = this.shortBlockStates;
        synchronized (intHashMap) {
            if (state == this.lastShortChecked) {
                return this.lastShortCheckedResult;
            }
            cached = (Boolean)this.shortBlockStates.func_76041_a(state);
        }
        if (cached == null) {
            if (!Minecraft.func_71410_x().func_152345_ab()) {
                Boolean result;
                boolean isIOThread;
                Callable<Boolean> supplier = new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return BlockStateShortShapeCache.this.isShort(state);
                    }
                };
                ListenableFutureTask future = (ListenableFutureTask)Minecraft.func_71410_x().func_152343_a((Callable)supplier);
                boolean bl = isIOThread = Thread.currentThread() == WorldMap.mapRunnerThread;
                if (isIOThread) {
                    this.ioThreadWaitingFor = future;
                }
                try {
                    result = (Boolean)future.get();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                if (isIOThread) {
                    this.ioThreadWaitingFor = null;
                }
                return result;
            }
            try {
                IBlockState blockState = Misc.getStateById(state);
                if (blockState != null && !(blockState.func_177230_c() instanceof BlockAir) && !(blockState.func_177230_c() instanceof BlockLiquid)) {
                    this.placeholderBlockAccess.setPlaceholderState(blockState);
                    AxisAlignedBB shape = blockState.func_185900_c((IBlockAccess)this.placeholderBlockAccess, BlockPos.field_177992_a);
                    cached = shape.field_72337_e < 0.25;
                } else {
                    cached = false;
                }
            }
            catch (Throwable t) {
                WorldMap.LOGGER.info("(World Map) Defaulting world-dependent block state shape to not short: " + state);
                cached = false;
            }
            intHashMap = this.shortBlockStates;
            synchronized (intHashMap) {
                this.shortBlockStates.func_76038_a(state, (Object)cached);
                this.lastShortChecked = state;
                this.lastShortCheckedResult = cached;
            }
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        IntHashMap<Boolean> intHashMap = this.shortBlockStates;
        synchronized (intHashMap) {
            this.shortBlockStates.func_76046_c();
            this.lastShortChecked = -1;
            this.lastShortCheckedResult = false;
        }
    }

    public void supplyForIOThread() {
        if (!Minecraft.func_71410_x().func_152345_ab()) {
            throw new RuntimeException(new IllegalAccessException("Supplying from the wrong thread!"));
        }
        ListenableFutureTask<Boolean> waitingFor = this.ioThreadWaitingFor;
        if (waitingFor != null && !waitingFor.isDone()) {
            waitingFor.run();
        }
    }
}

