/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeInfoSupplier;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.file.MapRegionInfo;
import xaero.map.file.PNGExporter;
import xaero.map.file.RegionDetection;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.misc.Misc;
import xaero.map.region.BranchLeveledRegion;
import xaero.map.region.LeveledRegion;
import xaero.map.region.LeveledRegionManager;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.Overlay;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;
import xaero.map.world.MapDimension;

public class MapSaveLoad {
    private static final int currentSaveMajorVersion = 0;
    private static final int currentSaveMinorVersion = 4;
    private static final int currentSaveVersion = 4;
    public static final int SAVE_TIME = 60000;
    public static final int currentCacheSaveVersion = 17;
    private ArrayList<MapRegion> toSave = new ArrayList();
    private ArrayList<MapRegion> toLoad = new ArrayList();
    private ArrayList<BranchLeveledRegion> toLoadBranchCache = new ArrayList();
    private ArrayList<File> cacheToConvertFromTemp;
    private LeveledRegion<?> nextToLoadByViewing;
    private boolean regionDetectionComplete;
    private ArrayList<Path> cacheFolders = new ArrayList();
    private Path lastRealmOwnerPath;
    public boolean loadingFiles;
    private OverlayBuilder overlayBuilder;
    private PNGExporter pngExporter;
    private List<MapDimension> workingDimList;
    public boolean saveAll;
    private MapProcessor mapProcessor;
    public int mainTextureLevel;
    private BiomeInfoSupplier biomeInfoSupplier;
    private BlockStateShortShapeCache blockStateShortShapeCache;

    public MapSaveLoad(OverlayManager overlayManager, PNGExporter pngExporter, BlockStateShortShapeCache blockStateShortShapeCache) {
        this.cacheToConvertFromTemp = new ArrayList();
        this.overlayBuilder = new OverlayBuilder(overlayManager);
        this.pngExporter = pngExporter;
        this.workingDimList = new ArrayList<MapDimension>();
        this.biomeInfoSupplier = new BiomeInfoSupplier(){

            @Override
            public void getBiomeInfo(BlockStateColorTypeCache colorTypeCache, World world, IBlockState state, BlockPos pos, int[] dest, int biomeId) {
                colorTypeCache.getBlockBiomeColour(world, state, pos, dest, biomeId);
            }
        };
        this.blockStateShortShapeCache = blockStateShortShapeCache;
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    public void exportPNG() {
        this.mapProcessor.pushProcessorPause();
        try {
            this.pngExporter.export(this.mapProcessor);
        }
        catch (Throwable e) {
            WorldMap.LOGGER.info("Failed to export PNG with exception!");
            WorldMap.crashHandler.setCrashedBy(e);
        }
        this.mapProcessor.popProcessorPause();
    }

    private File getSecondaryFile(String extension, File realFile) {
        if (realFile == null) {
            return null;
        }
        String p = realFile.getPath();
        return new File(p.substring(0, p.lastIndexOf(".")) + extension);
    }

    public File getTempFile(File realFile) {
        return this.getSecondaryFile(".zip.temp", realFile);
    }

    public void updateCacheFolderList(Path subFolder) {
        Stream<Path> allFiles;
        try {
            allFiles = Files.list(subFolder);
        }
        catch (Exception e) {
            this.cacheFolders.clear();
            return;
        }
        Object[] filesArray = allFiles.toArray();
        allFiles.close();
        this.cacheFolders.clear();
        for (int i = 0; i < filesArray.length; ++i) {
            Path path = (Path)filesArray[i];
            if (!Files.isDirectory(path, new LinkOption[0]) || !path.getFileName().toString().startsWith("cache_") || path.getFileName().toString().split("_")[1].equals("" + this.mapProcessor.getGlobalVersion())) continue;
            this.cacheFolders.add(path);
            if (!WorldMap.settings.debug) continue;
            WorldMap.LOGGER.info(path.toString());
        }
        this.cacheFolders.add(subFolder);
    }

    public Path getCacheFolder(Path subFolder) {
        if (subFolder != null) {
            return subFolder.resolve("cache_" + this.mapProcessor.getGlobalVersion());
        }
        return null;
    }

    public File getCacheFile(MapRegionInfo region, boolean checkOldFolders, boolean requestCache) throws IOException {
        Path subFolder = this.getMWSubFolder(region.getWorldId(), region.getDimId(), region.getMwId());
        Path latestCacheFolder = this.getCacheFolder(subFolder);
        if (latestCacheFolder == null) {
            return null;
        }
        if (!Files.exists(latestCacheFolder, new LinkOption[0])) {
            Files.createDirectories(latestCacheFolder, new FileAttribute[0]);
        }
        Path cacheFile = latestCacheFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".xwmc");
        if (!checkOldFolders || Files.exists(cacheFile, new LinkOption[0])) {
            return cacheFile.toFile();
        }
        if (requestCache) {
            region.setShouldCache(true, "cache file");
        }
        for (int i = 0; i < this.cacheFolders.size(); ++i) {
            Path oldCacheFolder = this.cacheFolders.get(i);
            Path oldCacheFile = oldCacheFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".xwmc");
            if (!Files.exists(oldCacheFile, new LinkOption[0])) continue;
            return oldCacheFile.toFile();
        }
        return cacheFile.toFile();
    }

    public File getFile(MapRegion region) {
        if (region.getWorldId() == null) {
            return null;
        }
        File detectedFile = region.getRegionFile();
        boolean realms = this.mapProcessor.isWorldRealms(region.getWorldId());
        boolean multiplayer = region.isMultiplayer();
        if (!multiplayer) {
            if (detectedFile != null) {
                return detectedFile;
            }
            return this.mapProcessor.getWorldDataHandler().getWorldDir().toPath().resolve("region").resolve("r." + region.getRegionX() + "." + region.getRegionZ() + ".mca").toFile();
        }
        Path mainFolder = this.getMainFolder(region.getWorldId(), region.getDimId());
        Path subFolder = this.getMWSubFolder(region.getWorldId(), mainFolder, region.getMwId());
        try {
            File subFolderFile = subFolder.toFile();
            if (!subFolderFile.exists()) {
                Path ownerPath;
                Files.createDirectories(subFolderFile.toPath(), new FileAttribute[0]);
                if (realms && WorldMap.events.getLatestRealm() != null && !(ownerPath = mainFolder.resolve(WorldMap.events.getLatestRealm().owner + ".owner")).equals(this.lastRealmOwnerPath)) {
                    if (!Files.exists(ownerPath, new LinkOption[0])) {
                        Files.createFile(ownerPath, new FileAttribute[0]);
                    }
                    this.lastRealmOwnerPath = ownerPath;
                }
            }
        }
        catch (IOException e1) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e1);
        }
        if (detectedFile != null && detectedFile.getName().endsWith(".xaero")) {
            File zipFile = subFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".zip").toFile();
            if (detectedFile.exists() && !zipFile.exists()) {
                this.xaeroToZip(detectedFile);
            }
            region.setRegionFile(zipFile);
            return zipFile;
        }
        return detectedFile == null ? subFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".zip").toFile() : detectedFile;
    }

    public static Path getRootFolder(String world) {
        if (world == null) {
            return null;
        }
        return WorldMap.saveFolder.toPath().resolve(world);
    }

    public Path getMainFolder(String world, String dim) {
        if (world == null) {
            return null;
        }
        return WorldMap.saveFolder.toPath().resolve(world).resolve(dim);
    }

    Path getMWSubFolder(String world, Path mainFolder, String mw) {
        if (world == null) {
            return null;
        }
        if (mw == null) {
            return mainFolder;
        }
        return mainFolder.resolve(mw);
    }

    public Path getMWSubFolder(String world, String dim, String mw) {
        if (world == null) {
            return null;
        }
        return this.getMWSubFolder(world, this.getMainFolder(world, dim), mw);
    }

    public Path getOldFolder(String oldUnfixedMainId, String dim) {
        if (oldUnfixedMainId == null) {
            return null;
        }
        return WorldMap.saveFolder.toPath().resolve(oldUnfixedMainId + "_" + dim);
    }

    private void xaeroToZip(File xaero) {
        File zipFile = xaero.toPath().getParent().resolve(xaero.getName().substring(0, xaero.getName().lastIndexOf(46)) + ".zip").toFile();
        try {
            int got;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(xaero), 1024);
            ZipOutputStream zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            ZipEntry e = new ZipEntry("region.xaero");
            zipOutput.putNextEntry(e);
            byte[] bytes = new byte[1024];
            while ((got = in.read(bytes)) > 0) {
                zipOutput.write(bytes, 0, got);
            }
            zipOutput.closeEntry();
            zipOutput.flush();
            zipOutput.close();
            in.close();
            Files.deleteIfExists(xaero.toPath());
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            return;
        }
    }

    public void detectRegions() {
        MapDimension mapDimension = this.mapProcessor.getMapWorld().getCurrentDimension();
        mapDimension.createDetectedRegions().clear();
        String worldId = this.mapProcessor.getCurrentWorldId();
        if (worldId == null || this.mapProcessor.isCurrentMapLocked()) {
            return;
        }
        String dimId = this.mapProcessor.getCurrentDimId();
        String mwId = this.mapProcessor.getCurrentMWId();
        if (this.mapProcessor.isWorldMultiplayer(this.mapProcessor.isWorldRealms(worldId), worldId)) {
            Path mapFolder = this.getMWSubFolder(worldId, dimId, mwId);
            if (!mapFolder.toFile().exists()) {
                return;
            }
            this.detectRegionsFromFiles(mapDimension, worldId, dimId, mwId, mapFolder, "^-?\\d+_-?\\d+\\.(zip|xaero)$", "_", 0, 1, 0);
        } else {
            File worldDir = this.mapProcessor.getWorldDataHandler().getWorldDir();
            if (worldDir == null) {
                return;
            }
            Path worldFolder = worldDir.toPath().resolve("region");
            if (!worldFolder.toFile().exists()) {
                return;
            }
            this.detectRegionsFromFiles(mapDimension, worldId, dimId, mwId, worldFolder, "^r\\.(-{0,1}[0-9]+\\.){2}mc[ar]$", "\\.", 1, 2, 8192);
        }
    }

    public void detectRegionsFromFiles(MapDimension mapDimension, String worldId, String dimId, String mwId, Path folder, String regex, String splitRegex, int xIndex, int zIndex, int emptySize) {
        int total = 0;
        try {
            Stream<Path> files = Files.list(folder);
            Iterator iter = files.iterator();
            while (!this.mapProcessor.isFinalizing() && iter.hasNext()) {
                String regionName;
                Path file = (Path)iter.next();
                if (Files.isDirectory(file, new LinkOption[0]) || !(regionName = file.getFileName().toString()).matches(regex) || Files.size(file) <= (long)emptySize) continue;
                String[] args = regionName.substring(0, regionName.lastIndexOf(46)).split(splitRegex);
                int x = Integer.parseInt(args[xIndex]);
                int z = Integer.parseInt(args[zIndex]);
                RegionDetection regionDetection = new RegionDetection(worldId, dimId, mwId, x, z, file.toFile(), this.mapProcessor.getGlobalVersion());
                File cacheFile = this.getCacheFile(regionDetection, true, true);
                regionDetection.setCacheFile(cacheFile);
                this.mapProcessor.addRegionDetection(mapDimension, regionDetection);
                ++total;
            }
            files.close();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            return;
        }
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info(String.format("%d regions detected!", total));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveRegion(MapRegion region, int extraAttempts) {
        try {
            if (!region.isMultiplayer()) {
                if (WorldMap.settings.debug) {
                    WorldMap.LOGGER.info("Save not required for singleplayer: " + region + " " + region.getWorldId() + " " + region.getDimId());
                }
                return region.countChunks() > 0;
            }
            File permFile = this.getFile(region);
            File file = this.getTempFile(permFile);
            if (file == null) {
                return true;
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            boolean regionIsEmpty = true;
            try (FilterOutputStream out = null;){
                ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                out = new DataOutputStream(zipOut);
                ZipEntry e = new ZipEntry("region.xaero");
                zipOut.putNextEntry(e);
                ((DataOutputStream)out).write(255);
                ((DataOutputStream)out).writeInt(4);
                for (int o = 0; o < 8; ++o) {
                    for (int p = 0; p < 8; ++p) {
                        MapTileChunk chunk = region.getChunk(o, p);
                        if (chunk == null) continue;
                        if (chunk.includeInSave()) {
                            ((DataOutputStream)out).write(o << 4 | p);
                            boolean chunkIsEmpty = true;
                            for (int i = 0; i < 4; ++i) {
                                for (int j = 0; j < 4; ++j) {
                                    MapTile tile = chunk.getTile(i, j);
                                    if (tile != null && tile.isLoaded()) {
                                        chunkIsEmpty = false;
                                        for (int x = 0; x < 16; ++x) {
                                            MapBlock[] c = tile.getBlockColumn(x);
                                            for (int z = 0; z < 16; ++z) {
                                                this.savePixel(c[z], (DataOutputStream)out);
                                            }
                                        }
                                        ((DataOutputStream)out).write(tile.getWorldInterpretationVersion());
                                        continue;
                                    }
                                    ((DataOutputStream)out).writeInt(-1);
                                }
                            }
                            if (chunkIsEmpty) continue;
                            regionIsEmpty = false;
                            continue;
                        }
                        region.setChunk(o, p, null);
                        MapTileChunk chunkIsEmpty = chunk;
                        synchronized (chunkIsEmpty) {
                            chunk.getLeafTexture().deleteTexturesAndBuffers();
                        }
                        BranchLeveledRegion parentRegion = region.getParent();
                        if (parentRegion == null) continue;
                        parentRegion.setShouldCheckForUpdatesRecursive(true);
                    }
                }
                zipOut.closeEntry();
            }
            if (regionIsEmpty) {
                this.safeDelete(permFile.toPath(), ".zip");
                this.safeDelete(file.toPath(), ".temp");
                if (WorldMap.settings.debug) {
                    WorldMap.LOGGER.info("Save cancelled because the region is empty: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId());
                }
                return false;
            }
            this.safeMoveAndReplace(file.toPath(), permFile.toPath(), ".temp", ".zip");
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Region saved: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId() + ", " + this.mapProcessor.getMapWriter().getUpdateCounter());
            }
            return true;
        }
        catch (IOException ioe) {
            WorldMap.LOGGER.error("IO exception while trying to save " + region, (Throwable)ioe);
            if (extraAttempts > 0) {
                WorldMap.LOGGER.info("(World Map) Retrying...");
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.saveRegion(region, extraAttempts - 1);
            }
            return true;
        }
    }

    private Path getBackupFolder(Path filePath, int saveVersion, int backupVersion) {
        return filePath.getParent().resolve(saveVersion + "_backup_" + backupVersion);
    }

    public void backupFile(File file, int saveVersion) throws IOException {
        if (file.getName().endsWith(".mca") || file.getName().endsWith(".mcr")) {
            throw new RuntimeException("World save protected: " + file);
        }
        Path filePath = file.toPath();
        int backupVersion = 0;
        Path backupFolder = this.getBackupFolder(filePath, saveVersion, backupVersion);
        String backupName = filePath.getFileName().toString();
        Path backup = backupFolder.resolve(backupName);
        while (Files.exists(backup, new LinkOption[0])) {
            backupFolder = this.getBackupFolder(filePath, saveVersion, ++backupVersion);
            backup = backupFolder.resolve(backupName);
        }
        if (!Files.exists(backupFolder, new LinkOption[0])) {
            Files.createDirectories(backupFolder, new FileAttribute[0]);
        }
        Files.move(file.toPath(), backup, new CopyOption[0]);
        WorldMap.LOGGER.info("File " + file.getPath() + " backed up to " + backupFolder.toFile().getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean loadRegion(World world, MapRegion region, BlockStateColorTypeCache colourTypeCache, int extraAttempts) {
        boolean multiplayer = region.isMultiplayer();
        File file = this.getFile(region);
        if (file == null || !file.exists()) {
            if (region.getLoadState() == 4) {
                region.setBeingWritten(false);
                region.setSaveExists(null);
            }
            return false;
        }
        int saveVersion = -1;
        boolean versionReached = false;
        int[] biomeBuffer = new int[3];
        try {
            boolean result;
            MapRegion mapRegion = region;
            synchronized (mapRegion) {
                region.setLoadState((byte)1);
            }
            region.setSaveExists(true);
            region.restoreBufferUpdateObjects();
            int totalChunks = 0;
            if (multiplayer) {
                try (FilterInputStream in = null;){
                    ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(new FileInputStream(file), 2048));
                    in = new DataInputStream(zipIn);
                    zipIn.getNextEntry();
                    int firstByte = in.read();
                    if (firstByte == 255) {
                        saveVersion = ((DataInputStream)in).readInt();
                        if (4 < saveVersion) {
                            zipIn.closeEntry();
                            in.close();
                            WorldMap.LOGGER.info("Trying to load a newer region " + region + " save using an older version of Xaero's World Map!");
                            this.backupFile(file, saveVersion);
                            region.setSaveExists(null);
                            boolean bl = false;
                            return bl;
                        }
                        firstByte = -1;
                    }
                    versionReached = true;
                    LeveledRegion leveledRegion = region.getLevel() == 3 ? region : region.getParent();
                    synchronized (leveledRegion) {
                        MapRegion mapRegion2 = region;
                        synchronized (mapRegion2) {
                            for (int o = 0; o < 8; ++o) {
                                for (int p = 0; p < 8; ++p) {
                                    MapTileChunk chunk = region.getChunk(o, p);
                                    if (chunk == null) continue;
                                    chunk.setLoadState((byte)1);
                                }
                            }
                        }
                    }
                    while (true) {
                        int n;
                        int n2 = n = firstByte == -1 ? in.read() : firstByte;
                        if (n == -1) break;
                        firstByte = -1;
                        int o = n >> 4;
                        int p = n & 0xF;
                        MapTileChunk chunk = region.getChunk(o, p);
                        if (chunk == null) {
                            chunk = new MapTileChunk(region, region.getRegionX() * 8 + o, region.getRegionZ() * 8 + p);
                            region.setChunk(o, p, chunk);
                        }
                        chunk.resetHeights();
                        for (int i = 0; i < 4; ++i) {
                            for (int j = 0; j < 4; ++j) {
                                Integer nextTile = ((DataInputStream)in).readInt();
                                if (nextTile == -1) continue;
                                MapTile tile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunk.getX() * 4 + i, chunk.getZ() * 4 + j);
                                for (int x = 0; x < 16; ++x) {
                                    MapBlock[] c = tile.getBlockColumn(x);
                                    for (int z = 0; z < 16; ++z) {
                                        if (c[z] == null) {
                                            c[z] = new MapBlock();
                                        } else {
                                            c[z].prepareForWriting();
                                        }
                                        this.loadPixel(nextTile, c[z], (DataInputStream)in, saveVersion, world, biomeBuffer, colourTypeCache);
                                        nextTile = null;
                                    }
                                }
                                if (saveVersion >= 4) {
                                    tile.setWorldInterpretationVersion(in.read());
                                }
                                chunk.setTile(i, j, tile, this.blockStateShortShapeCache);
                                tile.setLoaded(true);
                            }
                        }
                        if (!chunk.includeInSave()) {
                            region.setChunk(o, p, null);
                            chunk.getLeafTexture().deleteTexturesAndBuffers();
                            chunk = null;
                            continue;
                        }
                        region.pushWriterPause();
                        ++totalChunks;
                        chunk.setToUpdateBuffers(true);
                        chunk.setLoadState((byte)2);
                        region.popWriterPause();
                    }
                    zipIn.closeEntry();
                }
                if (totalChunks > 0) {
                    if (WorldMap.settings.debug) {
                        WorldMap.LOGGER.info("Region loaded: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId() + ", " + saveVersion);
                    }
                    return true;
                }
                region.setSaveExists(null);
                this.safeDelete(file.toPath(), ".zip");
                if (WorldMap.settings.debug) {
                    WorldMap.LOGGER.info("Cancelled loading an empty region: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId() + ", " + saveVersion);
                }
                return false;
            }
            int[] chunkCount = new int[1];
            WorldDataHandler.Result buildResult = this.mapProcessor.getWorldDataHandler().buildRegion(region, world, true, chunkCount);
            if (buildResult == WorldDataHandler.Result.CANCEL) {
                RegionDetection restoredDetection = new RegionDetection(region.getWorldId(), region.getDimId(), region.getMwId(), region.getRegionX(), region.getRegionZ(), region.getRegionFile(), this.mapProcessor.getGlobalVersion());
                restoredDetection.transferInfoFrom(region);
                this.mapProcessor.addRegionDetection(region.getDim(), restoredDetection);
                this.mapProcessor.removeMapRegion(region);
                WorldMap.LOGGER.info("Region cancelled from world save: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId());
                return false;
            }
            region.setRegionFile(file);
            boolean bl = result = buildResult == WorldDataHandler.Result.SUCCESS && chunkCount[0] > 0;
            if (!result) {
                region.setSaveExists(null);
                if (WorldMap.settings.debug) {
                    WorldMap.LOGGER.info("Region failed to load from world save: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId());
                }
            } else if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Region loaded from world save: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId());
            }
            return result;
        }
        catch (IOException ioe) {
            WorldMap.LOGGER.error("IO exception while trying to load " + region, (Throwable)ioe);
            if (extraAttempts > 0) {
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    region.setLoadState((byte)4);
                }
                WorldMap.LOGGER.info("(World Map) Retrying...");
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.loadRegion(world, region, colourTypeCache, extraAttempts - 1);
            }
            region.setSaveExists(null);
            return false;
        }
        catch (Throwable e) {
            region.setSaveExists(null);
            WorldMap.LOGGER.error("Region failed to load: " + region + (versionReached ? " " + saveVersion : ""), e);
            return false;
        }
    }

    public boolean beingSaved(MapDimension dim, int regX, int regZ) {
        for (int i = 0; i < this.toSave.size(); ++i) {
            MapRegion r = this.toSave.get(i);
            if (r == null || r.getDim() != dim || r.getRegionX() != regX || r.getRegionZ() != regZ) continue;
            return true;
        }
        return false;
    }

    public void requestLoad(MapRegion region, String reason) {
        this.requestLoad(region, reason, true);
    }

    public void requestLoad(MapRegion region, String reason, boolean prioritize) {
        this.addToLoad(region, reason, prioritize);
    }

    public void requestBranchCache(BranchLeveledRegion region, String reason) {
        this.requestBranchCache(region, reason, true);
        if (WorldMap.settings.debug && reason != null) {
            WorldMap.LOGGER.info("Requesting branch load for: " + region + ", " + reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestBranchCache(BranchLeveledRegion region, String reason, boolean prioritize) {
        ArrayList<BranchLeveledRegion> arrayList = this.toLoadBranchCache;
        synchronized (arrayList) {
            if (prioritize) {
                this.toLoadBranchCache.remove(region);
                this.toLoadBranchCache.add(0, region);
            } else if (!this.toLoadBranchCache.contains(region)) {
                this.toLoadBranchCache.add(region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLoad(MapRegion region, String reason, boolean prioritize) {
        ArrayList<MapRegion> arrayList = this.toLoad;
        synchronized (arrayList) {
            if (prioritize) {
                region.setReloadHasBeenRequested(true, reason);
                this.toLoad.remove(region);
                this.toLoad.add(0, region);
                if (WorldMap.settings.debug && reason != null) {
                    WorldMap.LOGGER.info("Requesting load for: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId() + ", " + reason);
                }
            } else if (!this.loadingFiles && !this.toLoad.contains(region)) {
                region.setReloadHasBeenRequested(true, reason);
                this.toLoad.add(region);
                if (WorldMap.settings.debug && reason != null) {
                    WorldMap.LOGGER.info("Requesting load for: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId() + ", " + reason);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToLoad(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toLoad;
        synchronized (arrayList) {
            this.toLoad.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearToLoad() {
        ArrayList<LeveledRegion> arrayList = this.toLoad;
        synchronized (arrayList) {
            this.toLoad.clear();
        }
        arrayList = this.toLoadBranchCache;
        synchronized (arrayList) {
            this.toLoadBranchCache.clear();
        }
    }

    public int getSizeOfToLoad() {
        return this.toLoad.size();
    }

    public boolean saveExists(MapRegion region) {
        if (region.getSaveExists() != null) {
            return region.getSaveExists();
        }
        boolean result = true;
        File file = this.getFile(region);
        if (file == null || !file.exists()) {
            result = false;
        }
        region.setSaveExists(result);
        return result;
    }

    public void updateSave(LeveledRegion<?> leveledRegion, long currentTime) {
        if (leveledRegion.getLevel() == 0) {
            MapRegion region = (MapRegion)leveledRegion;
            if (region.getLoadState() == 2 && region.isBeingWritten() && currentTime - region.getLastSaveTime() > 60000L && !this.beingSaved(region.getDim(), region.getRegionX(), region.getRegionZ())) {
                this.toSave.add(region);
                region.setSaveExists(true);
                region.setLastSaveTime(currentTime);
            }
        } else {
            BranchLeveledRegion region = (BranchLeveledRegion)leveledRegion;
            if (region.eligibleForSaving(currentTime)) {
                region.startDownloadingTexturesForCache(this.mapProcessor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(World world, BlockStateColorTypeCache colourTypeCache) throws Exception {
        int limit;
        if (!this.toLoad.isEmpty() && this.mapProcessor.caveStartIsDetermined()) {
            boolean loaded = false;
            this.mapProcessor.pushIsLoading();
            this.loadingFiles = true;
            limit = this.toLoad.size();
            while (!(limit <= 0 || this.mapProcessor.isWaitingForWorldUpdate() || loaded || this.toLoad.isEmpty())) {
                boolean needsLoading;
                MapRegion region;
                --limit;
                ArrayList<MapRegion> arrayList = this.toLoad;
                synchronized (arrayList) {
                    if (this.toLoad.isEmpty()) {
                        break;
                    }
                    region = this.toLoad.get(0);
                }
                int globalRegionCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                int globalReloadVersion = WorldMap.settings.reloadVersion;
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    boolean bl = needsLoading = region.getLoadState() == 0 || region.getLoadState() == 4;
                    if (needsLoading) {
                        if (region.getLoadState() == 4 || region.hasVersion() && region.getVersion() != this.mapProcessor.getGlobalVersion() || !region.hasVersion() && region.getInitialVersion() != this.mapProcessor.getGlobalVersion() || region.isMetaLoaded() && this.mainTextureLevel != region.getLevel() && globalRegionCacheHashCode != region.getCacheHashCode()) {
                            region.setShouldCache(true, "loading");
                        }
                        region.setVersion(this.mapProcessor.getGlobalVersion());
                    }
                }
                if (needsLoading) {
                    boolean justMetaData = false;
                    if (region.getLoadState() == 0 && !region.isBeingWritten()) {
                        justMetaData = region.loadCacheTextures(this.mapProcessor, !region.isMetaLoaded() && this.mainTextureLevel != region.getLevel(), 10);
                    }
                    if (justMetaData) {
                        if (WorldMap.settings.debug) {
                            WorldMap.LOGGER.info("Loaded meta data for " + region);
                        }
                    } else {
                        boolean shouldLoadProperly;
                        this.mapProcessor.addToProcess(region);
                        if (region.getLoadState() == 0) {
                            this.mapProcessor.getMapWorld().getCurrentDimension().getMapRegions().addLoadedRegion(region);
                        }
                        MapRegion mapRegion2 = region;
                        synchronized (mapRegion2) {
                            boolean goingToPrepareCache = region.shouldCache() && (region.isMetaLoaded() && this.mainTextureLevel != region.getLevel() || region.getLoadState() == 4 || region.getCacheFile() == null || !region.getCacheFile().exists());
                            boolean bl = shouldLoadProperly = region.isBeingWritten() || goingToPrepareCache;
                            if (!shouldLoadProperly) {
                                region.setLoadState((byte)3);
                            } else if (region.shouldCache()) {
                                region.setRecacheHasBeenRequested(true, "loading");
                            }
                        }
                        if (shouldLoadProperly) {
                            region.setCacheHashCode(globalRegionCacheHashCode);
                            region.setReloadVersion(globalReloadVersion);
                            loaded = this.loadRegion(world, region, colourTypeCache, 10);
                            if (!loaded) {
                                region.setShouldCache(false, "couldn't load");
                                region.setRecacheHasBeenRequested(false, "couldn't load");
                                if (region.getSaveExists() == null) {
                                    mapRegion2 = region;
                                    synchronized (mapRegion2) {
                                        region.setLoadState((byte)4);
                                    }
                                    region.deleteTexturesAndBuffers();
                                    if (region.isBeingWritten()) {
                                        region.clean(this.mapProcessor);
                                        mapRegion2 = region;
                                        synchronized (mapRegion2) {
                                            region.setLoadState((byte)1);
                                        }
                                    } else {
                                        this.mapProcessor.removeMapRegion(region);
                                    }
                                }
                            } else {
                                for (int i = 0; i < 8; ++i) {
                                    for (int j = 0; j < 8; ++j) {
                                        MapTileChunk mapTileChunk = region.getChunk(i, j);
                                        if (mapTileChunk == null || mapTileChunk.includeInSave()) continue;
                                        region.setChunk(i, j, null);
                                        mapTileChunk.getLeafTexture().deleteTexturesAndBuffers();
                                    }
                                }
                            }
                            MapRegion i = region;
                            synchronized (i) {
                                if (region.getLoadState() <= 1) {
                                    region.setLoadState((byte)2);
                                }
                                region.setLastSaveTime(System.currentTimeMillis());
                            }
                            BranchLeveledRegion parentRegion = region.getParent();
                            if (parentRegion != null) {
                                parentRegion.setShouldCheckForUpdatesRecursive(true);
                            }
                        } else if (WorldMap.settings.debug) {
                            WorldMap.LOGGER.info("Loaded from cache only for " + region);
                        }
                        region.loadingNeededForBranchLevel = 0;
                    }
                    region.setReloadHasBeenRequested(false, "loading");
                }
                this.removeToLoad(region);
            }
            this.loadingFiles = false;
            this.mapProcessor.popIsLoading();
        }
        int regionsToSave = 3;
        while (!this.toSave.isEmpty() && (this.saveAll || regionsToSave > 0)) {
            boolean regionLoaded;
            MapRegion region;
            MapRegion needsLoading = region = this.toSave.get(0);
            synchronized (needsLoading) {
                regionLoaded = region.getLoadState() == 2;
            }
            if (regionLoaded) {
                if (!region.isBeingWritten()) {
                    throw new Exception("Saving a weird region: " + region);
                }
                region.pushWriterPause();
                boolean notEmpty = this.saveRegion(region, 20);
                if (notEmpty) {
                    if (!region.isAllCachePrepared()) {
                        MapRegion globalRegionCacheHashCode = region;
                        synchronized (globalRegionCacheHashCode) {
                            region.requestRefresh(this.mapProcessor);
                        }
                    }
                    region.setRecacheHasBeenRequested(true, "saving");
                    region.setShouldCache(true, "saving");
                    region.setBeingWritten(false);
                    --regionsToSave;
                } else {
                    this.mapProcessor.removeMapRegion(region);
                }
                region.popWriterPause();
                if (region.getWorldId() == null || !this.mapProcessor.isEqual(region.getWorldId(), region.getDimId(), region.getMwId())) {
                    if (region.getCacheFile() != null) {
                        try {
                            Files.deleteIfExists(region.getCacheFile().toPath());
                        }
                        catch (IOException e) {
                            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                        }
                        if (WorldMap.settings.debug) {
                            WorldMap.LOGGER.info(String.format("Deleting cache for region %s because it IS outdated.", region));
                        }
                    }
                    region.clearRegion(this.mapProcessor);
                }
            } else if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Tried to save a weird region: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId() + " " + region.getLoadState());
            }
            this.toSave.remove(region);
        }
        this.saveAll = false;
        if (!this.toLoadBranchCache.isEmpty()) {
            limit = this.toLoadBranchCache.size();
            this.mapProcessor.pushIsLoading();
            if (!this.mapProcessor.isWaitingForWorldUpdate()) {
                while (limit > 0) {
                    BranchLeveledRegion region;
                    --limit;
                    ArrayList<BranchLeveledRegion> notEmpty = this.toLoadBranchCache;
                    synchronized (notEmpty) {
                        if (this.toLoadBranchCache.isEmpty()) {
                            break;
                        }
                        region = this.toLoadBranchCache.get(0);
                    }
                    region.preCacheLoad();
                    LeveledRegionManager regionManager = this.mapProcessor.getMapWorld().getCurrentDimension().getMapRegions();
                    regionManager.addListRegion(region);
                    regionManager.addLoadedRegion(region);
                    region.setCacheFile(region.findCacheFile(this));
                    region.loadCacheTextures(this.mapProcessor, false, 10);
                    this.mapProcessor.addToProcess(region);
                    if (region.getCacheFile() == null) {
                        region.setShouldCheckForUpdatesRecursive(true);
                    }
                    region.setShouldCache(false, "branch loading");
                    region.setLoaded(true);
                    if (WorldMap.settings.debug) {
                        WorldMap.LOGGER.info("Loaded cache for branch region " + region);
                    }
                    region.setReloadHasBeenRequested(false, "loading");
                    ArrayList<BranchLeveledRegion> e = this.toLoadBranchCache;
                    synchronized (e) {
                        this.toLoadBranchCache.remove(region);
                    }
                }
            }
            this.mapProcessor.popIsLoading();
        }
        if (this.mapProcessor.getMapWorld().getCurrentDimensionId() != null) {
            this.workingDimList.clear();
            this.mapProcessor.getMapWorld().getDimensions(this.workingDimList);
            for (int d = 0; d < this.workingDimList.size(); ++d) {
                MapDimension dim = this.workingDimList.get(d);
                while (!dim.regionsToCache.isEmpty()) {
                    LeveledRegion<?> region = this.removeToCache(dim, 0);
                    region.preCache();
                    boolean skipCaching = region.skipCaching(this.mapProcessor);
                    if (!region.shouldCache() || skipCaching) {
                        if (WorldMap.settings.detailed_debug) {
                            WorldMap.LOGGER.info("toCache cancel: " + region + " " + !region.shouldCache() + " " + !region.isAllCachePrepared() + " " + skipCaching + " " + this.mapProcessor.getGlobalVersion());
                        }
                        if (region.shouldCache()) {
                            region.deleteBuffers();
                        }
                        region.setShouldCache(false, "toCache cancel");
                        region.setRecacheHasBeenRequested(false, "toCache cancel");
                        region.postCache(null, this, false);
                        continue;
                    }
                    if (!region.isAllCachePrepared()) {
                        throw new RuntimeException("Trying to save cache for a region with cache not prepared: " + region + " " + region.getExtraInfo());
                    }
                    File permFile = region.findCacheFile(this);
                    File tempFile = this.getSecondaryFile(".xwmc.temp", permFile);
                    boolean successfullySaved = region.saveCacheTextures(tempFile, 10);
                    if (successfullySaved) {
                        this.cacheToConvertFromTemp.add(permFile);
                        region.setCacheFile(permFile);
                    }
                    region.setShouldCache(false, "toCache normal");
                    region.setRecacheHasBeenRequested(false, "toCache normal");
                    region.postCache(permFile, this, successfullySaved);
                }
            }
        }
        for (int i = 0; i < this.cacheToConvertFromTemp.size(); ++i) {
            File permFile = this.cacheToConvertFromTemp.get(i);
            File tempFile = this.getSecondaryFile(".xwmc.temp", permFile);
            try {
                if (Files.exists(tempFile.toPath(), new LinkOption[0])) {
                    Misc.safeMoveAndReplace(tempFile.toPath(), permFile.toPath(), true);
                }
                this.cacheToConvertFromTemp.remove(i);
                --i;
                continue;
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
    }

    private void savePixel(MapBlock pixel, DataOutputStream out) throws IOException {
        int biome;
        int parametres = pixel.getParametres();
        out.writeInt(parametres);
        if (!pixel.isGrass()) {
            out.writeInt(pixel.getState());
        }
        if ((parametres & 0x1000000) != 0) {
            out.write(pixel.getTopHeight());
        }
        if (pixel.getNumberOfOverlays() != 0) {
            out.write(pixel.getOverlays().size());
            for (int i = 0; i < pixel.getOverlays().size(); ++i) {
                this.saveOverlay(pixel.getOverlays().get(i), out);
            }
        }
        if (pixel.getColourType() == 3) {
            out.writeInt(pixel.getCustomColour());
        }
        if ((biome = pixel.getBiome()) != -1) {
            if (biome < 255) {
                out.write(pixel.getBiome());
            } else {
                out.write(255);
                out.writeInt(biome);
            }
        }
    }

    private void loadPixel(Integer next, MapBlock pixel, DataInputStream in, int saveVersion, World world, int[] biomeBuffer, BlockStateColorTypeCache colorTypeCache) throws IOException {
        boolean topHeightIsDifferent;
        int parametres = next != null ? next.intValue() : in.readInt();
        if ((parametres & 1) != 0) {
            pixel.setState(in.readInt());
        } else {
            pixel.setState(Block.func_176210_f((IBlockState)Blocks.field_150349_c.func_176223_P()));
        }
        if ((parametres & 0x40) != 0) {
            pixel.setHeight(in.read());
        } else {
            pixel.setHeight(parametres >> 12 & 0xFF);
        }
        boolean bl = saveVersion < 4 ? false : (topHeightIsDifferent = (parametres & 0x1000000) != 0);
        if (topHeightIsDifferent) {
            pixel.setTopHeight(in.read());
        } else {
            pixel.setTopHeight(pixel.getHeight());
        }
        this.overlayBuilder.startBuilding();
        if ((parametres & 2) != 0) {
            int amount = in.read();
            for (int i = 0; i < amount; ++i) {
                this.loadOverlay(pixel, in, saveVersion, world, biomeBuffer, colorTypeCache);
            }
        }
        this.overlayBuilder.finishBuilding(pixel);
        int savedColourType = parametres >> 2 & 3;
        if (savedColourType == 3) {
            pixel.setColourType((byte)3);
            pixel.setCustomColour(in.readInt());
        }
        int biomeKey = -1;
        if (savedColourType != 0 && savedColourType != 3 || (parametres & 0x100000) != 0) {
            int biomeByte = in.read();
            biomeKey = saveVersion < 3 || biomeByte < 255 ? biomeByte : in.readInt();
        }
        if (savedColourType != 3) {
            colorTypeCache.getBlockBiomeColour(world, Misc.getStateById(pixel.getState()), null, biomeBuffer, biomeKey);
            pixel.setColourType((byte)biomeBuffer[0]);
            pixel.setCustomColour(biomeBuffer[2]);
        }
        pixel.setBiome(biomeKey);
        if (pixel.getColourType() == 3 && pixel.getCustomColour() == -1) {
            pixel.setColourType((byte)0);
        }
        pixel.setCaveBlock((parametres & 0x80) != 0);
        pixel.setLight((byte)(parametres >> 8 & 0xF));
        pixel.setGlowing(this.mapProcessor.getMapWriter().isGlowing(Misc.getStateById(pixel.getState())));
    }

    private void saveOverlay(Overlay o, DataOutputStream out) throws IOException {
        out.writeInt(o.getParametres());
        if (!o.isWater()) {
            out.writeInt(o.getState());
        }
        if (o.getColourType() == 3) {
            out.writeInt(o.getCustomColour());
        }
        if (o.getOpacity() > 1) {
            out.writeInt(o.getOpacity());
        }
    }

    private void loadOverlay(MapBlock pixel, DataInputStream in, int saveVersion, World world, int[] biomeBuffer, BlockStateColorTypeCache colourTypeCache) throws IOException {
        byte savedColourType;
        int parametres = in.readInt();
        int state = (parametres & 1) != 0 ? in.readInt() : Block.func_176210_f((IBlockState)Blocks.field_150355_j.func_176223_P());
        int opacity = 1;
        if (saveVersion < 1 && (parametres & 2) != 0) {
            in.readInt();
        }
        if ((savedColourType = (byte)(parametres >> 8 & 3)) == 2 || (parametres & 4) != 0) {
            biomeBuffer[0] = 3;
            biomeBuffer[2] = in.readInt();
            if (biomeBuffer[2] == -1) {
                biomeBuffer[0] = 0;
            }
            savedColourType = (byte)biomeBuffer[0];
        }
        if ((parametres & 8) != 0) {
            opacity = in.readInt();
        }
        byte light = (byte)(parametres >> 4 & 0xF);
        this.overlayBuilder.build(state, biomeBuffer, opacity, light, world, this.mapProcessor, null, 0, colourTypeCache, savedColourType == 3 ? null : this.biomeInfoSupplier);
    }

    public boolean isRegionDetectionComplete() {
        return this.regionDetectionComplete;
    }

    public void setRegionDetectionComplete(boolean regionDetectionComplete) {
        this.regionDetectionComplete = regionDetectionComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCache(LeveledRegion<?> region) {
        if (!this.toCacheContains(region)) {
            ArrayList<LeveledRegion<?>> arrayList = region.getDim().regionsToCache;
            synchronized (arrayList) {
                region.getDim().regionsToCache.add(region);
            }
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Requesting cache! " + region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeveledRegion<?> removeToCache(MapDimension mapDim, int index) {
        ArrayList<LeveledRegion<?>> arrayList = mapDim.regionsToCache;
        synchronized (arrayList) {
            return mapDim.regionsToCache.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToCache(LeveledRegion<?> region) {
        ArrayList<LeveledRegion<?>> arrayList = region.getDim().regionsToCache;
        synchronized (arrayList) {
            region.getDim().regionsToCache.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toCacheContains(LeveledRegion<?> region) {
        ArrayList<LeveledRegion<?>> arrayList = region.getDim().regionsToCache;
        synchronized (arrayList) {
            return region.getDim().regionsToCache.contains(region);
        }
    }

    public ArrayList<MapRegion> getToSave() {
        return this.toSave;
    }

    public LeveledRegion<?> getNextToLoadByViewing() {
        return this.nextToLoadByViewing;
    }

    @Deprecated
    public void setNextToLoadByViewing(MapRegion nextToLoadByViewing) {
        this.setNextToLoadByViewing((LeveledRegion<?>)nextToLoadByViewing);
    }

    public void setNextToLoadByViewing(LeveledRegion<?> nextToLoadByViewing) {
        this.nextToLoadByViewing = nextToLoadByViewing;
    }

    public void safeDelete(Path filePath, String extension) throws IOException {
        if (!filePath.getFileName().toString().endsWith(extension)) {
            throw new RuntimeException("Incorrect file extension: " + filePath);
        }
        Files.deleteIfExists(filePath);
    }

    public void safeMoveAndReplace(Path fromPath, Path toPath, String fromExtension, String toExtension) throws IOException {
        if (!toPath.getFileName().toString().endsWith(toExtension) || !fromPath.getFileName().toString().endsWith(fromExtension)) {
            throw new RuntimeException("Incorrect file extension: " + fromPath + " " + toPath);
        }
        Misc.safeMoveAndReplace(fromPath, toPath, true);
    }

    public int getSizeOfToLoadBranchCache() {
        return this.toLoadBranchCache.size();
    }

    public ArrayList<Path> getCacheFolders() {
        return this.cacheFolders;
    }
}

