/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.pool;

import java.util.ArrayList;
import java.util.List;
import xaero.map.pool.PoolUnit;

public abstract class MapPool<T extends PoolUnit> {
    private int maxSize;
    private List<T> units;

    public MapPool(int maxSize) {
        this.maxSize = maxSize;
        this.units = new ArrayList<T>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T get(Object ... args) {
        PoolUnit unit = null;
        List<T> list = this.units;
        synchronized (list) {
            if (!this.units.isEmpty()) {
                unit = (PoolUnit)this.takeFromPool();
            }
        }
        if (unit == null) {
            return this.construct(args);
        }
        unit.create(args);
        return (T)unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToPool(T unit) {
        List<T> list = this.units;
        synchronized (list) {
            if (this.units.size() < this.maxSize) {
                this.units.add(unit);
            }
        }
    }

    private T takeFromPool() {
        return (T)((PoolUnit)this.units.remove(0));
    }

    public int size() {
        return this.units.size();
    }

    protected abstract T construct(Object ... var1);
}

