/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.api.IWeaponCallback;
import com.oblivioussp.spartanweaponry.api.ToolMaterialEx;
import com.oblivioussp.spartanweaponry.client.gui.CreativeTabsSW;
import com.oblivioussp.spartanweaponry.item.IHudQuiverDisplay;
import com.oblivioussp.spartanweaponry.item.ItemQuiverArrow;
import com.oblivioussp.spartanweaponry.item.ItemQuiverBase;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import com.oblivioussp.spartanweaponry.util.StringHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ItemLongbow
extends ItemBow
implements IHudQuiverDisplay {
    protected ToolMaterialEx material;
    protected static float maxVelocity = 1.2f;
    protected String modId = null;
    protected String displayName = null;
    protected boolean doCraftCheck = true;
    protected boolean canBeCrafted = true;
    protected IWeaponCallback callback = null;

    public ItemLongbow(String unlocName, ToolMaterialEx toolMaterial) {
        this.field_77777_bU = 1;
        this.material = toolMaterial;
        this.func_77656_e((int)((float)toolMaterial.getMaxUses() * 1.5f));
        this.func_77637_a(CreativeTabsSW.TAB_SW);
        this.setRegistryName(unlocName);
        this.func_77655_b(unlocName);
        maxVelocity = ConfigHandler.multiplierLongbow;
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return !itemstack.func_190926_b() ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / (20.0f * maxVelocity) : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public ItemLongbow(String unlocName, String externalModId, ToolMaterialEx material) {
        this(unlocName, material);
        this.modId = externalModId;
        this.displayName = "longbow_custom";
    }

    public ItemLongbow(String unlocName, String externalModId, ToolMaterialEx material, IWeaponCallback weaponCallback) {
        this(unlocName, externalModId, material);
        this.callback = weaponCallback;
    }

    public String func_77658_a() {
        if (this.modId != null) {
            return StringHelper.getItemUnlocalizedName(super.func_77658_a(), this.modId);
        }
        return StringHelper.getItemUnlocalizedName(super.func_77658_a());
    }

    public String func_77667_c(ItemStack itemStack) {
        if (this.modId != null) {
            return StringHelper.getItemUnlocalizedName(super.func_77658_a(), this.modId);
        }
        return StringHelper.getItemUnlocalizedName(super.func_77658_a());
    }

    protected ItemStack func_185060_a(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = this.func_185060_a(entityplayer);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)((EntityPlayer)entityLiving), (int)i, (itemstack != null || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || flag) {
                float f;
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack(Items.field_151032_g);
                }
                if ((double)(f = ItemLongbow.getArrowVelocity(i)) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = entityplayer.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemArrow && ((ItemArrow)itemstack.func_77973_b()).isInfinite(itemstack, stack, entityplayer);
                    if (!worldIn.field_72995_K) {
                        int k;
                        int j;
                        ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
                        EntityArrow entityarrow = itemarrow.func_185052_a(worldIn, itemstack, (EntityLivingBase)entityplayer);
                        entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * 3.0f, 0.5f);
                        if (f == maxVelocity) {
                            entityarrow.func_70243_d(true);
                        }
                        if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                            entityarrow.func_70240_a(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            entityarrow.func_70015_d(100);
                        }
                        stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                        if (flag1) {
                            entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_72838_d((Entity)entityarrow);
                    }
                    worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1) {
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            entityplayer.field_71071_by.func_184437_d(itemstack);
                        }
                    }
                    entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
                }
            }
        }
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > maxVelocity) {
            f = maxVelocity;
        }
        return f;
    }

    public int getArrowSlotToUseFirst(@Nonnull IItemHandler quiverHandler) {
        for (int i = 0; i < quiverHandler.getSlots(); ++i) {
            ItemStack stack = quiverHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack bow = playerIn.func_184586_b(handIn);
        boolean flag = false;
        flag = !this.func_185060_a(playerIn).func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bow) > 0;
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)bow, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)handIn, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return flag ? new ActionResult(EnumActionResult.PASS, (Object)bow) : new ActionResult(EnumActionResult.FAIL, (Object)bow);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)bow);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (toRepair.func_190926_b() || repair.func_190926_b()) {
            return false;
        }
        if (this.material.doesOreDictMatch(repair)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public String func_77653_i(ItemStack stack) {
        if (this.displayName != null) {
            String name = I18n.func_74837_a((String)String.format("item.%s:%s.name", "spartanweaponry", this.displayName), (Object[])new Object[]{I18n.func_74838_a((String)this.material.getFullUnlocName())});
            return name;
        }
        return super.func_77653_i(stack);
    }

    @Nullable
    public String getCreatorModId(ItemStack itemStack) {
        if (this.modId != null) {
            return this.modId;
        }
        return super.getCreatorModId(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean isShiftPressed = GuiScreen.func_146272_n();
        if (this.doCraftCheck && worldIn != null) {
            NonNullList ores;
            if (this.material.getModId() == "spartanweaponry" && ((ores = OreDictionary.getOres((String)this.material.getOreDictForRepairMaterial(), (boolean)false)) == null || ores.isEmpty())) {
                this.canBeCrafted = false;
            }
            this.doCraftCheck = false;
        } else if (!ConfigHandler.forceDisableUncraftableTooltips && !this.canBeCrafted) {
            tooltip.add(TextFormatting.RED + StringHelper.translateFormattedString("cantCraftMissingMaterial", "tooltip", "spartanweaponry", StringHelper.translateString(this.material.getOreDictForRepairMaterial(), "material", this.material.getModId())));
        }
        if (this.callback != null) {
            this.callback.onTooltip(this.material, stack, worldIn, tooltip, flagIn);
            tooltip.add("");
        }
        tooltip.add(TextFormatting.GOLD + StringHelper.translateFormattedString("description", "tooltip", "spartanweaponry", isShiftPressed ? TextFormatting.DARK_GRAY + StringHelper.translateString("showingDescription", "tooltip", "spartanweaponry") : TextFormatting.DARK_GRAY + StringHelper.translateFormattedString("showDescription", "tooltip", "spartanweaponry", TextFormatting.AQUA + "SHIFT" + TextFormatting.DARK_GRAY)));
        if (GuiScreen.func_146272_n()) {
            tooltip.add(StringHelper.translateString("longbow", "tooltip"));
            tooltip.add(StringHelper.translateString("longbow.desc", "tooltip"));
        }
        tooltip.add("");
        tooltip.add(TextFormatting.DARK_AQUA + StringHelper.translateFormattedString("modifiers.ammo.type", "tooltip", "spartanweaponry", TextFormatting.GRAY + StringHelper.translateString("modifiers.ammo.arrow", "tooltip")));
        tooltip.add(TextFormatting.DARK_AQUA + StringHelper.translateFormattedString("modifiers.longbow.draw_length", "tooltip", "spartanweaponry", TextFormatting.GRAY + "" + maxVelocity));
        tooltip.add(TextFormatting.DARK_AQUA + StringHelper.translateFormattedString("modifiers.longbow.speed_multiplier", "tooltip", "spartanweaponry", TextFormatting.GRAY + StringHelper.translateFormattedString("modifiers.longbow.speed_multiplier.value", "tooltip", "spartanweaponry", Float.valueOf(maxVelocity))));
        tooltip.add("");
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        if (this.callback != null) {
            this.callback.onCreateItem(this.material, stack);
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            if (this.callback != null) {
                this.callback.onCreateItem(this.material, stack);
            }
            items.add((Object)stack);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.callback != null && entityIn instanceof EntityLivingBase) {
            this.callback.onItemUpdate(this.material, stack, worldIn, (EntityLivingBase)entityIn, itemSlot, isSelected);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public Class<? extends ItemQuiverBase> getRequiredQuiverClass() {
        return ItemQuiverArrow.class;
    }
}

