/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.tree;

import fr.raksrinana.fallingtree.config.ToolConfiguration;
import fr.raksrinana.fallingtree.config.TreeConfiguration;
import fr.raksrinana.fallingtree.tree.Tree;
import fr.raksrinana.fallingtree.utils.FallingTreeUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class TreeHandler {
    @Nonnull
    public static Optional<Tree> getTree(@Nonnull World world, @Nonnull BlockPos blockPos) {
        Block logBlock = world.func_180495_p(blockPos).func_177230_c();
        if (!FallingTreeUtils.isTreeBlock(logBlock)) {
            return Optional.empty();
        }
        LinkedList<BlockPos> toAnalyzePos = new LinkedList<BlockPos>();
        HashSet<BlockPos> analyzedPos = new HashSet<BlockPos>();
        Tree tree = new Tree(world, blockPos);
        toAnalyzePos.add(blockPos);
        while (!toAnalyzePos.isEmpty()) {
            BlockPos analyzingPos = (BlockPos)toAnalyzePos.remove();
            tree.addLog(analyzingPos);
            analyzedPos.add(analyzingPos);
            Collection<BlockPos> nearbyPos = TreeHandler.neighborLogs(world, logBlock, analyzingPos, analyzedPos);
            nearbyPos.removeAll(analyzedPos);
            toAnalyzePos.addAll(nearbyPos.stream().filter(pos -> !toAnalyzePos.contains(pos)).collect(Collectors.toList()));
        }
        if (TreeConfiguration.getBreakMode().shouldCheckLeavesAround()) {
            int aroundRequired = TreeConfiguration.getMinimumLeavesAroundRequired();
            if (tree.getTopMostLog().map(topLog -> TreeHandler.getLeavesAround(world, topLog) < (long)aroundRequired).orElse(true).booleanValue()) {
                return Optional.empty();
            }
        }
        return Optional.of(tree);
    }

    private static long getLeavesAround(@Nonnull World world, @Nonnull BlockPos blockPos) {
        return Arrays.stream(EnumFacing.values()).map(arg_0 -> ((BlockPos)blockPos).func_177972_a(arg_0)).filter(testPos -> FallingTreeUtils.isLeafBlock(world.func_180495_p(testPos).func_177230_c())).count();
    }

    @Nonnull
    private static Collection<BlockPos> neighborLogs(@Nonnull World world, @Nonnull Block logBlock, @Nonnull BlockPos blockPos, @Nonnull Collection<BlockPos> analyzedPos) {
        LinkedList<BlockPos> neighborLogs = new LinkedList<BlockPos>();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    checkPos.func_181079_c(blockPos.func_177958_n() + x, blockPos.func_177956_o() + y, blockPos.func_177952_p() + z);
                    if (analyzedPos.contains(checkPos) || !TreeHandler.isSameTree(world, (BlockPos)checkPos, logBlock)) continue;
                    neighborLogs.add(checkPos.func_185334_h());
                }
            }
        }
        neighborLogs.addAll(analyzedPos);
        return neighborLogs;
    }

    private static boolean isSameTree(@Nonnull World world, BlockPos checkBlockPos, Block parentLogBlock) {
        Block checkBlock = world.func_180495_p(checkBlockPos).func_177230_c();
        if (TreeConfiguration.isAllowMixedLogs()) {
            return FallingTreeUtils.isTreeBlock(checkBlock);
        }
        return checkBlock.equals(parentLogBlock);
    }

    public static boolean destroyInstant(@Nonnull Tree tree, @Nonnull EntityPlayer player, @Nonnull ItemStack tool) {
        int radius;
        double rawWeightedUsesLeft;
        World world = tree.getWorld();
        int damageMultiplicand = ToolConfiguration.getDamageMultiplicand();
        int toolUsesLeft = tool.func_77984_f() ? tool.func_77958_k() - tool.func_77952_i() : Integer.MAX_VALUE;
        double d = rawWeightedUsesLeft = damageMultiplicand == 0 ? (double)(toolUsesLeft - 1) : 1.0 * (double)toolUsesLeft / (double)damageMultiplicand;
        if (ToolConfiguration.isPreserve()) {
            if (rawWeightedUsesLeft <= 1.0) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.falling_tree.prevented_break_tool", new Object[0]));
                return false;
            }
            if ((double)tree.getLogCount() >= rawWeightedUsesLeft) {
                rawWeightedUsesLeft = Math.ceil(rawWeightedUsesLeft) - 1.0;
            }
        }
        boolean isTreeFullyBroken = damageMultiplicand == 0 || rawWeightedUsesLeft >= (double)tree.getLogCount();
        tree.getLogs().stream().limit((int)rawWeightedUsesLeft).forEachOrdered(logBlock -> {
            IBlockState logState = world.func_180495_p(logBlock);
            player.func_71029_a(StatList.func_188059_c((Item)Item.func_150898_a((Block)logState.func_177230_c())));
            logState.func_177230_c().func_180657_a(world, player, logBlock, logState, world.func_175625_s(logBlock), tool);
            world.func_175655_b(logBlock, false);
        });
        int toolDamage = damageMultiplicand * (int)Math.min((double)tree.getLogCount(), rawWeightedUsesLeft) - 1;
        if (toolDamage > 0) {
            tool.func_77972_a(toolDamage, (EntityLivingBase)player);
        }
        if (isTreeFullyBroken && (radius = TreeConfiguration.getLeavesBreakingForceRadius()) > 0) {
            tree.getLogs().stream().max(Comparator.comparingInt(Vec3i::func_177956_o)).ifPresent(topLog -> {
                BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
                for (int dx = -radius; dx < radius; ++dx) {
                    for (int dy = -radius; dy < radius; ++dy) {
                        for (int dz = -radius; dz < radius; ++dz) {
                            checkPos.func_181079_c(topLog.func_177958_n() + dx, topLog.func_177956_o() + dy, topLog.func_177952_p() + dz);
                            IBlockState checkState = world.func_180495_p((BlockPos)checkPos);
                            Block checkBlock = checkState.func_177230_c();
                            if (!FallingTreeUtils.isLeafBlock(checkBlock)) continue;
                            checkBlock.func_176226_b(world, (BlockPos)checkPos, checkState, 0);
                            world.func_175655_b((BlockPos)checkPos, false);
                        }
                    }
                }
            });
        }
        return true;
    }

    public static boolean destroyShift(@Nonnull Tree tree, @Nonnull EntityPlayer player, @Nonnull ItemStack tool) {
        double rawWeightedUsesLeft;
        World world = tree.getWorld();
        int damageMultiplicand = ToolConfiguration.getDamageMultiplicand();
        int toolUsesLeft = tool.func_77984_f() ? tool.func_77958_k() - tool.func_77952_i() : Integer.MAX_VALUE;
        double d = rawWeightedUsesLeft = damageMultiplicand == 0 ? (double)(toolUsesLeft - 1) : 1.0 * (double)toolUsesLeft / (double)damageMultiplicand;
        if (ToolConfiguration.isPreserve() && rawWeightedUsesLeft <= 1.0) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.falling_tree.prevented_break_tool", new Object[0]));
            return false;
        }
        tree.getTopMostFurthestLog().ifPresent(logBlock -> {
            IBlockState logState = world.func_180495_p(logBlock);
            player.func_71029_a(StatList.func_188059_c((Item)Item.func_150898_a((Block)logState.func_177230_c())));
            logState.func_177230_c().func_180657_a(world, player, tree.getHitPos(), logState, world.func_175625_s(logBlock), tool);
            world.func_175655_b(logBlock, false);
        });
        int toolDamage = damageMultiplicand;
        if (toolDamage > 0) {
            tool.func_77972_a(toolDamage, (EntityLivingBase)player);
        }
        return true;
    }
}

