/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts;

import chumbanotz.mutantbeasts.MBConfig;
import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.entity.BodyPartEntity;
import chumbanotz.mutantbeasts.entity.CreeperMinionEggEntity;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.EndersoulCloneEntity;
import chumbanotz.mutantbeasts.entity.EndersoulFragmentEntity;
import chumbanotz.mutantbeasts.entity.SkullSpiritEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantSkeletonEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantSnowGolemEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import chumbanotz.mutantbeasts.entity.mutant.SpiderPigEntity;
import chumbanotz.mutantbeasts.entity.projectile.ChemicalXEntity;
import chumbanotz.mutantbeasts.entity.projectile.MutantArrowEntity;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.item.ChemicalXItem;
import chumbanotz.mutantbeasts.item.CreeperShardItem;
import chumbanotz.mutantbeasts.item.EndersoulHandItem;
import chumbanotz.mutantbeasts.item.HulkHammerItem;
import chumbanotz.mutantbeasts.item.MutantSkeletonArmorItem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mutantbeasts")
public class RegistryHandler {
    private static int entityId;

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RegistryHandler.setRegistryName("chemical_x", new ChemicalXItem().func_77625_d(1)), RegistryHandler.setRegistryName("creeper_minion_tracker", new Item().func_77625_d(1)), RegistryHandler.setRegistryName("creeper_shard", new CreeperShardItem().func_77625_d(1).func_77656_e(32)), RegistryHandler.setRegistryName("endersoul_hand", new EndersoulHandItem().func_77625_d(1).func_77656_e(240)), RegistryHandler.setRegistryName("hulk_hammer", new HulkHammerItem().func_77625_d(1).func_77656_e(64)), RegistryHandler.setRegistryName("mutant_skeleton_arms", new Item()), RegistryHandler.setRegistryName("mutant_skeleton_limb", new Item()), RegistryHandler.setRegistryName("mutant_skeleton_shoulder_pad", new Item()), RegistryHandler.setRegistryName("mutant_skeleton_rib", new Item()), RegistryHandler.setRegistryName("mutant_skeleton_rib_cage", new Item()), RegistryHandler.setRegistryName("mutant_skeleton_pelvis", new Item()), (Item)RegistryHandler.setRegistryName("mutant_skeleton_skull", new MutantSkeletonArmorItem(EntityEquipmentSlot.HEAD)), (Item)RegistryHandler.setRegistryName("mutant_skeleton_chestplate", new MutantSkeletonArmorItem(EntityEquipmentSlot.CHEST)), (Item)RegistryHandler.setRegistryName("mutant_skeleton_leggings", new MutantSkeletonArmorItem(EntityEquipmentSlot.LEGS)), (Item)RegistryHandler.setRegistryName("mutant_skeleton_boots", new MutantSkeletonArmorItem(EntityEquipmentSlot.FEET))});
    }

    @SubscribeEvent
    public static void registerEntityEntries(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityEntry[]{RegistryHandler.createEntityEntry("body_part", BodyPartEntity.class).tracker(64, 10, true).build(), RegistryHandler.createEntityEntry("chemical_x", ChemicalXEntity.class).tracker(160, 10, true).build(), RegistryHandler.createEntityEntry("creeper_minion", CreeperMinionEntity.class, 894731, 0xB7B7B7).build(), RegistryHandler.createEntityEntry("creeper_minion_egg", CreeperMinionEggEntity.class).tracker(160, 20, true).build(), RegistryHandler.createEntityEntry("endersoul_clone", EndersoulCloneEntity.class, 15027455, 15027455).build(), RegistryHandler.createEntityEntry("endersoul_fragment", EndersoulFragmentEntity.class).tracker(64, 10, true).build(), RegistryHandler.createEntityEntry("mutant_arrow", MutantArrowEntity.class).tracker(80, 3, false).build(), RegistryHandler.createEntityEntry("mutant_creeper", MutantCreeperEntity.class, 5349438, 11013646).build(), RegistryHandler.createEntityEntry("mutant_enderman", MutantEndermanEntity.class, 0x161616, 8860812).build(), RegistryHandler.createEntityEntry("mutant_skeleton", MutantSkeletonEntity.class, 0xC1C1C1, 6310217).build(), RegistryHandler.createEntityEntry("mutant_snow_golem", MutantSnowGolemEntity.class, 0xE5FFFF, 16753434).build(), RegistryHandler.createEntityEntry("mutant_zombie", MutantZombieEntity.class, 7969893, 44975).build(), RegistryHandler.createEntityEntry("skull_spirit", SkullSpiritEntity.class).tracker(160, 20, false).build(), RegistryHandler.createEntityEntry("spider_pig", SpiderPigEntity.class, 3419431, 15771042).build(), RegistryHandler.createEntityEntry("throwable_block", ThrowableBlockEntity.class).tracker(64, 100, true).build()});
        RegistryHandler.addSpawns();
    }

    @SubscribeEvent
    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{RegistryHandler.createSoundEvent("entity.creeper_minion.ambient"), RegistryHandler.createSoundEvent("entity.creeper_minion.death"), RegistryHandler.createSoundEvent("entity.creeper_minion.hurt"), RegistryHandler.createSoundEvent("entity.creeper_minion.primed"), RegistryHandler.createSoundEvent("entity.creeper_minion_egg.hatch"), RegistryHandler.createSoundEvent("entity.endersoul_clone.death"), RegistryHandler.createSoundEvent("entity.endersoul_clone.teleport"), RegistryHandler.createSoundEvent("entity.endersoul_fragment.explode"), RegistryHandler.createSoundEvent("entity.mutant_creeper.ambient"), RegistryHandler.createSoundEvent("entity.mutant_creeper.charge"), RegistryHandler.createSoundEvent("entity.mutant_creeper.death"), RegistryHandler.createSoundEvent("entity.mutant_creeper.hurt"), RegistryHandler.createSoundEvent("entity.mutant_enderman.ambient"), RegistryHandler.createSoundEvent("entity.mutant_enderman.death"), RegistryHandler.createSoundEvent("entity.mutant_enderman.hurt"), RegistryHandler.createSoundEvent("entity.mutant_enderman.morph"), RegistryHandler.createSoundEvent("entity.mutant_enderman.scream"), RegistryHandler.createSoundEvent("entity.mutant_enderman.stare"), RegistryHandler.createSoundEvent("entity.mutant_enderman.teleport"), RegistryHandler.createSoundEvent("entity.mutant_skeleton.ambient"), RegistryHandler.createSoundEvent("entity.mutant_skeleton.death"), RegistryHandler.createSoundEvent("entity.mutant_skeleton.hurt"), RegistryHandler.createSoundEvent("entity.mutant_skeleton.step"), RegistryHandler.createSoundEvent("entity.mutant_snow_golem.death"), RegistryHandler.createSoundEvent("entity.mutant_snow_golem.hurt"), RegistryHandler.createSoundEvent("entity.mutant_zombie.ambient"), RegistryHandler.createSoundEvent("entity.mutant_zombie.attack"), RegistryHandler.createSoundEvent("entity.mutant_zombie.death"), RegistryHandler.createSoundEvent("entity.mutant_zombie.grunt"), RegistryHandler.createSoundEvent("entity.mutant_zombie.hurt"), RegistryHandler.createSoundEvent("entity.mutant_zombie.roar"), RegistryHandler.createSoundEvent("entity.spider_pig.ambient"), RegistryHandler.createSoundEvent("entity.spider_pig.death"), RegistryHandler.createSoundEvent("entity.spider_pig.hurt")});
        EntityParrot.registerMimicSound(MutantCreeperEntity.class, (SoundEvent)SoundEvents.field_193792_eN);
        EntityParrot.registerMimicSound(MutantSkeletonEntity.class, (SoundEvent)SoundEvents.field_193811_fa);
        EntityParrot.registerMimicSound(MutantZombieEntity.class, (SoundEvent)SoundEvents.field_193821_fk);
    }

    @SubscribeEvent
    public static void fixMissingMappings(RegistryEvent.MissingMappings<SoundEvent> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (!mapping.key.func_110623_a().startsWith("entity.mutant_husk")) continue;
            mapping.ignore();
        }
    }

    private static <T extends EntityLiving> EntityEntryBuilder<T> createEntityEntry(String name, Class<T> entityClass, int eggPrimary, int eggSecondary) {
        return RegistryHandler.createEntityEntry(name, entityClass).egg(eggPrimary, eggSecondary).tracker(80, 3, true);
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntityEntry(String name, Class<T> entityClass) {
        if (EntityLiving.class.isAssignableFrom(entityClass)) {
            LootTableList.func_186375_a((ResourceLocation)MutantBeasts.prefix("entities/" + name));
        }
        return EntityEntryBuilder.create().entity(entityClass).id(MutantBeasts.prefix(name), entityId++).name("mutantbeasts." + name);
    }

    public static void addSpawns() {
        List<String> biomeWhitelist = Arrays.asList(MBConfig.biomeWhitelist);
        if (biomeWhitelist.isEmpty()) {
            MutantBeasts.LOGGER.warn("Biome whitelist is empty. No mutants will spawn any biomes!");
            return;
        }
        for (Biome biome : ForgeRegistries.BIOMES) {
            List monsterEntries;
            if (biome.getRegistryName() == null || !biomeWhitelist.contains(biome.getRegistryName().func_110624_b()) || (monsterEntries = biome.func_76747_a(EnumCreatureType.MONSTER)).isEmpty() || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.VOID)) continue;
            RegistryHandler.addSpawn(monsterEntries, MutantEndermanEntity.class, MBConfig.mutantEndermanSpawnRate, 1, 1);
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
            RegistryHandler.addSpawn(monsterEntries, MutantCreeperEntity.class, MBConfig.mutantCreeperSpawnRate, 1, 1);
            RegistryHandler.addSpawn(monsterEntries, MutantSkeletonEntity.class, MBConfig.mutantSkeletonSpawnRate, 1, 1);
            RegistryHandler.addSpawn(monsterEntries, MutantZombieEntity.class, MBConfig.mutantZombieSpawnRate, 1, 1);
        }
    }

    private static void addSpawn(List<Biome.SpawnListEntry> spawnListEntries, Class<? extends EntityLiving> entityClass, int weight, int min, int max) {
        if (weight > 0) {
            spawnListEntries.add(new Biome.SpawnListEntry(entityClass, weight, min, max));
        }
    }

    private static SoundEvent createSoundEvent(String name) {
        ResourceLocation registryName = MutantBeasts.prefix(name);
        return (SoundEvent)new SoundEvent(registryName).setRegistryName(registryName);
    }

    private static <T extends IForgeRegistryEntry<T>> T setRegistryName(String name, T entry) {
        ResourceLocation registryName = MutantBeasts.prefix(name);
        if (entry instanceof Item) {
            ((Item)entry).func_77655_b("mutantbeasts." + registryName.func_110623_a());
            ((Item)entry).func_77637_a(MutantBeasts.CREATIVE_TAB);
        }
        return (T)((IForgeRegistryEntry)entry.setRegistryName(registryName));
    }
}

