/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.model.MutantEndermanModel;
import chumbanotz.mutantbeasts.client.renderer.entity.EndersoulCloneRenderer;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelEnderman;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class MutantEndermanRenderer
extends RenderLiving<MutantEndermanEntity> {
    private static final Field RENDER_POS_X = ObfuscationReflectionHelper.findField(RenderManager.class, (String)"field_78725_b");
    private static final Field RENDER_POS_Y = ObfuscationReflectionHelper.findField(RenderManager.class, (String)"field_78726_c");
    private static final Field RENDER_POS_Z = ObfuscationReflectionHelper.findField(RenderManager.class, (String)"field_78723_d");
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_enderman/mutant_enderman");
    private static final ResourceLocation EYES_TEXTURE = MutantBeasts.getEntityTexture("mutant_enderman/eyes");
    private static final ResourceLocation DEATH_TEXTURE = MutantBeasts.getEntityTexture("mutant_enderman/death");
    private final MutantEndermanModel endermanModel;
    private final ModelEnderman cloneModel;
    private boolean teleportAttack;

    public MutantEndermanRenderer(RenderManager manager) {
        super(manager, (ModelBase)new MutantEndermanModel(), 0.8f);
        this.endermanModel = (MutantEndermanModel)this.field_77045_g;
        this.cloneModel = new ModelEnderman(0.0f);
        this.func_177094_a(new EyesLayer());
        this.func_177094_a(new EndersoulLayer());
        this.func_177094_a(new HeldBlocksLayer());
    }

    public boolean shouldRender(MutantEndermanEntity livingEntity, ICamera camera, double camX, double camY, double camZ) {
        if (super.func_177071_a((EntityLiving)livingEntity, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntity.getAttackID() == 4) {
            BlockPos pos = livingEntity.getTeleportPosition();
            float width = livingEntity.field_70130_N / 2.0f;
            return camera.func_78546_a(new AxisAlignedBB((double)pos.func_177958_n() + 0.5 - (double)width, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5 - (double)width, (double)pos.func_177958_n() + 0.5 + (double)width, (double)pos.func_177956_o() + (double)livingEntity.field_70131_O, (double)pos.func_177952_p() + 0.5 + (double)width));
        }
        return false;
    }

    protected void renderModel(MutantEndermanEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        if (entitylivingbaseIn.field_70725_aQ > 80) {
            float blendFactor = (float)(entitylivingbaseIn.field_70725_aQ - 80) / 200.0f;
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)blendFactor);
            this.func_110776_a(DEATH_TEXTURE);
            this.field_77045_g.func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179143_c((int)514);
        }
        super.func_77036_a((EntityLivingBase)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        GlStateManager.func_179143_c((int)515);
    }

    public void doRender(MutantEndermanEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        boolean death;
        if (entity.isClone()) {
            this.field_76989_e = 0.5f;
            this.field_76987_f = 0.5f;
            this.field_77045_g = this.cloneModel;
        } else {
            this.field_76989_e = 0.8f;
            this.field_76987_f = 1.0f;
            this.field_77045_g = this.endermanModel;
        }
        this.teleportAttack = false;
        this.cloneModel.field_78125_b = entity.isAggressive();
        boolean forcedLook = entity.getAttackID() == 3;
        boolean scream = entity.getAttackID() == 5;
        boolean clone = entity.isClone() && entity.isAggressive();
        boolean telesmash = entity.getAttackID() == 7 && entity.getAttackTick() < 18;
        boolean bl = death = entity.getAttackID() == 8;
        if (forcedLook || scream || clone || telesmash || death) {
            double shake = 0.03;
            if (entity.getAttackTick() >= 40 && !clone && !death) {
                shake *= 0.5;
            }
            if (clone) {
                shake = 0.02;
            }
            if (death) {
                shake = entity.getAttackTick() < 80 ? (double)0.02f : (double)0.05f;
            }
            x += entity.func_70681_au().nextGaussian() * shake;
            z += entity.func_70681_au().nextGaussian() * shake;
        }
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        if (entity.getAttackID() == 4) {
            this.teleportAttack = true;
            try {
                double renderPosX = (double)entity.getTeleportPosition().func_177958_n() + 0.5 - RENDER_POS_X.getDouble(this.field_76990_c);
                double renderPosY = (double)entity.getTeleportPosition().func_177956_o() - RENDER_POS_Y.getDouble(this.field_76990_c);
                double renderPosZ = (double)entity.getTeleportPosition().func_177952_p() + 0.5 - RENDER_POS_Z.getDouble(this.field_76990_c);
                super.func_76986_a((EntityLiving)entity, renderPosX, renderPosY, renderPosZ, entityYaw, partialTicks);
                super.func_76979_b((Entity)entity, renderPosX, renderPosY, renderPosZ, entityYaw, partialTicks);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("Something went wrong trying to access private fields in RenderManager", e);
            }
        }
    }

    protected float getDeathMaxRotation(MutantEndermanEntity entityLivingBaseIn) {
        return 0.0f;
    }

    protected ResourceLocation getEntityTexture(MutantEndermanEntity entity) {
        return entity.isClone() ? null : TEXTURE;
    }

    class HeldBlocksLayer
    implements LayerRenderer<MutantEndermanEntity> {
        HeldBlocksLayer() {
        }

        public void doRenderLayer(MutantEndermanEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (!(MutantEndermanRenderer.this.field_77045_g instanceof MutantEndermanModel)) {
                return;
            }
            GlStateManager.func_179091_B();
            for (int i = 1; i < entityIn.heldBlock.length; ++i) {
                if (entityIn.heldBlock[i] == 0) continue;
                GlStateManager.func_179094_E();
                ((MutantEndermanModel)MutantEndermanRenderer.this.field_77045_g).postRenderArm(0.0625f, i);
                GlStateManager.func_179109_b((float)0.0f, (float)1.2f, (float)0.0f);
                float tick = (float)entityIn.field_70173_aa + (float)i * 2.0f * (float)Math.PI + partialTicks;
                GlStateManager.func_179114_b((float)(tick * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(tick * 8.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(tick * 6.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                float f = 0.75f;
                GlStateManager.func_179152_a((float)(-f), (float)(-f), (float)f);
                int var4 = entityIn.func_70070_b();
                int var5 = var4 % 65536;
                int var6 = var4 / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)var5, (float)var6);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                MutantEndermanRenderer.this.func_110776_a(TextureMap.field_110575_b);
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.5f);
                Minecraft.func_71410_x().func_175602_ab().func_175016_a(Block.func_176220_d((int)entityIn.heldBlock[i]), 1.0f);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179101_C();
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    class EndersoulLayer
    implements LayerRenderer<MutantEndermanEntity> {
        EndersoulLayer() {
        }

        public void doRenderLayer(MutantEndermanEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            boolean teleport = entityIn.getAttackID() == 4 && entityIn.getAttackTick() < 10;
            boolean scream = entityIn.getAttackID() == 5;
            boolean clone = entityIn.isClone();
            if (teleport || scream || clone) {
                float glowScale = 2.0f;
                float alpha = 1.0f;
                if (teleport) {
                    glowScale = 1.2f + ((float)entityIn.getAttackTick() + partialTicks) / 10.0f;
                    if (MutantEndermanRenderer.this.teleportAttack) {
                        glowScale = 2.2f - ((float)entityIn.getAttackTick() + partialTicks) / 10.0f;
                        if (entityIn.getAttackTick() < 2) {
                            alpha = ((float)entityIn.getAttackTick() + partialTicks) / 2.0f;
                        }
                    } else if (entityIn.getAttackTick() >= 8) {
                        alpha -= ((float)(entityIn.getAttackTick() - 8) + partialTicks) / 2.0f;
                    }
                }
                if (scream) {
                    if (entityIn.getAttackTick() < 40) {
                        glowScale = 1.2f + ((float)entityIn.getAttackTick() + partialTicks) / 40.0f;
                        alpha = ((float)entityIn.getAttackTick() + partialTicks) / 40.0f;
                    } else if (entityIn.getAttackTick() < 160) {
                        glowScale = 2.2f;
                    } else {
                        glowScale = 2.2f - ((float)entityIn.getAttackTick() + partialTicks) / 10.0f;
                        alpha = 1.0f - ((float)entityIn.getAttackTick() + partialTicks) / 40.0f;
                    }
                }
                if (!clone) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)glowScale, (float)(glowScale * 0.8f), (float)glowScale);
                }
                EndersoulCloneRenderer.render((Entity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, MutantEndermanRenderer.this.field_77045_g, alpha);
                if (!clone) {
                    GlStateManager.func_179121_F();
                }
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    class EyesLayer
    implements LayerRenderer<MutantEndermanEntity> {
        EyesLayer() {
        }

        public void doRenderLayer(MutantEndermanEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (!entityIn.isClone()) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179132_a((!entityIn.func_82150_aj() ? 1 : 0) != 0);
                MutantEndermanRenderer.this.func_110776_a(EYES_TEXTURE);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)61680.0f, (float)0.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                MutantEndermanRenderer.this.field_77045_g.func_78088_a((Entity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                MutantEndermanRenderer.this.func_177105_a((EntityLiving)entityIn);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179145_e();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

