/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity;

import chumbanotz.mutantbeasts.entity.EndersoulCloneEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class EndersoulFragmentEntity
extends Entity {
    public static final Predicate<Entity> IS_VALID_TARGET = entity -> {
        Class<?> entityClass = entity.getClass();
        return EntitySelectors.field_188444_d.apply(entity) && entityClass != EntityItem.class && entityClass != EntityXPOrb.class && entityClass != EntityEnderCrystal.class && entityClass != EndersoulCloneEntity.class && entityClass != EndersoulFragmentEntity.class && entityClass != MutantEndermanEntity.class && entityClass != EntityDragon.class && entityClass != EntityEnderman.class;
    };
    private static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EndersoulFragmentEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private int explodeTick;
    public final float[][] stickRotations;
    private EntityPlayer owner;

    public EndersoulFragmentEntity(World world) {
        super(world);
        this.explodeTick = 20 + this.field_70146_Z.nextInt(20);
        this.stickRotations = new float[8][3];
        this.field_70156_m = true;
        for (int i = 0; i < this.stickRotations.length; ++i) {
            for (int j = 0; j < this.stickRotations[i].length; ++j) {
                this.stickRotations[i][j] = this.field_70146_Z.nextFloat() * 2.0f * (float)Math.PI;
            }
        }
        this.func_70105_a(0.75f, 0.75f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
    }

    public EntityPlayer getOwner() {
        return this.owner;
    }

    public boolean isTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.field_70180_af.func_187227_b(TAMED, (Object)tamed);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public boolean func_70104_M() {
        return this.func_70089_S();
    }

    public void func_70103_a(byte id) {
        if (id == 3) {
            EntityUtil.spawnEndersoulParticles(this, 64, 0.8f);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.owner == null && this.field_70181_x > (double)-0.05f && !this.func_189652_ae()) {
            this.field_70181_x = Math.max((double)-0.05f, this.field_70181_x - (double)0.1f);
        }
        if (!(this.owner == null || this.owner.func_70089_S() && this.owner.isAddedToWorld() && this.field_70170_p == this.owner.field_70170_p)) {
            this.owner = null;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.9;
        this.field_70181_x *= 0.9;
        this.field_70179_y *= 0.9;
        if (!this.field_70170_p.field_72995_K) {
            if (!this.isTamed() && --this.explodeTick == 0) {
                this.explode();
            }
            if (this.owner != null && !this.owner.func_175149_v() && this.func_70068_e((Entity)this.owner) > 9.0) {
                float scale = 0.05f;
                this.func_70024_g((this.owner.field_70165_t - this.field_70165_t) * (double)scale, (this.owner.field_70163_u + (double)(this.owner.field_70131_O / 3.0f) - this.field_70163_u) * (double)scale, (this.owner.field_70161_v - this.field_70161_v) * (double)scale);
            }
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.isTamed()) {
            if (this.owner == null && !player.func_70093_af()) {
                this.owner = player;
                this.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
                return true;
            }
            if (this.owner == player && player.func_70093_af()) {
                this.owner = null;
                this.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.5f);
                return true;
            }
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setTamed(true);
        }
        this.owner = player;
        this.func_184185_a(SoundEvents.field_187802_ec, 1.0f, 1.5f);
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && this.field_70173_aa > 0) {
            this.explode();
        }
        return true;
    }

    private void explode() {
        this.func_184185_a(MBSoundEvents.ENTITY_ENDERSOUL_FRAGMENT_EXPLODE, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g(5.0), IS_VALID_TARGET)) {
            if (!(this.func_70068_e(entity) <= 25.0)) continue;
            boolean protectedEntity = EndersoulFragmentEntity.isProtected(entity);
            boolean causeDamage = true;
            if (protectedEntity) {
                boolean bl = causeDamage = this.field_70146_Z.nextInt(3) == 0;
            }
            if (causeDamage) {
                entity.func_70097_a(DamageSource.field_76376_m, 1.0f);
            }
            if (protectedEntity) continue;
            double x = entity.field_70165_t - this.field_70165_t;
            double z = entity.field_70161_v - this.field_70161_v;
            double d = Math.sqrt(x * x + z * z);
            entity.field_70159_w = (double)0.8f * x / d;
            entity.field_70181_x = this.field_70146_Z.nextFloat() * 0.6f - 0.1f;
            entity.field_70179_y = (double)0.8f * z / d;
            EntityUtil.sendPlayerVelocityPacket(entity);
        }
        this.func_70106_y();
    }

    public static boolean isProtected(Entity entity) {
        if (!(entity instanceof EntityLivingBase)) {
            return false;
        }
        EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
        return entityLivingBase.func_184614_ca().func_77973_b() == MBItems.ENDERSOUL_HAND || entityLivingBase.func_184592_cb().func_77973_b() == MBItems.ENDERSOUL_HAND;
    }

    public SoundCategory func_184176_by() {
        return this.isTamed() ? SoundCategory.NEUTRAL : SoundCategory.HOSTILE;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("Tamed", this.isTamed());
        compound.func_74768_a("ExplodeTick", this.explodeTick);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setTamed(compound.func_74767_n("Collected") || compound.func_74767_n("Tamed"));
        if (compound.func_74764_b("ExplodeTick")) {
            this.explodeTick = compound.func_74762_e("ExplodeTick");
        }
    }
}

