/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.entity.CreeperMinionEggEntity;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.ai.EntityAIAvoidDamage;
import chumbanotz.mutantbeasts.entity.ai.EntityAIHurtByNearestTarget;
import chumbanotz.mutantbeasts.entity.ai.MBEntityAIAttackMelee;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import chumbanotz.mutantbeasts.util.MutatedExplosion;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class MutantCreeperEntity
extends EntityCreeper
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(MutantCreeperEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final int MAX_CHARGE_TIME = 100;
    public static final int MAX_DEATH_TIME = 100;
    private int chargeTime;
    private int chargeHits;
    private int lastFlashTick;
    private int flashTick;
    private boolean summonLightning;
    private DamageSource deathCause;
    public int field_70725_aQ;

    public MutantCreeperEntity(World worldIn) {
        super(worldIn);
        this.chargeHits = 3 + this.field_70146_Z.nextInt(3);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 30;
        this.func_70105_a(1.98f, 2.8f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new JumpAttackGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new SpawnMinionsGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new ChargeAttackGoal());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new MBEntityAIAttackMelee((EntityCreature)this, 1.3));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidDamage((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByNearestTarget((EntityCreature)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true).func_190882_b(100));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(120.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(4.5);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
    }

    public boolean func_70830_n() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 1) != 0;
    }

    private void setPowered(boolean powered) {
        this.field_70178_ae = powered;
        this.field_70728_aV = powered ? 40 : 30;
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        this.field_70180_af.func_187227_b(STATUS, (Object)(powered ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isJumpAttacking() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 2) != 0;
    }

    private void setJumpAttacking(boolean jumping) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        this.field_70180_af.func_187227_b(STATUS, (Object)(jumping ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public boolean isCharging() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 4) != 0;
    }

    private void setCharging(boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        this.field_70180_af.func_187227_b(STATUS, (Object)(flag ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB)));
    }

    public float func_70047_e() {
        return 2.6f;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((EntityLiving)this, worldIn);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        super.func_184231_a(y, onGroundIn, state, pos);
        if (!this.field_70170_p.field_72995_K && this.isJumpAttacking() && (onGroundIn || state.func_185904_a().func_76224_d() || state.func_185904_a() == Material.field_151569_G)) {
            MutatedExplosion.create((Entity)this, this.func_70830_n() ? 6.0f : 4.0f, false, true);
            this.setJumpAttacking(false);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        double x = entityIn.field_70165_t - this.field_70165_t;
        double y = entityIn.field_70163_u - this.field_70163_u;
        double z = entityIn.field_70161_v - this.field_70161_v;
        double d = Math.sqrt(x * x + y * y + z * z);
        entityIn.field_70159_w = x / d * 0.5;
        entityIn.field_70181_x = y / d * (double)0.05f + (double)0.15f;
        entityIn.field_70179_y = z / d * 0.5;
        entityIn.field_70133_I = true;
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        this.func_184609_a(EnumHand.MAIN_HAND);
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag;
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_94541_c()) {
            float healAmount = amount / 2.0f;
            if (this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP() && !(source.func_76346_g() instanceof MutantCreeperEntity)) {
                this.func_70691_i(healAmount);
                EntityUtil.sendParticlePacket((Entity)this, EnumParticleTypes.HEART, (int)(healAmount / 2.0f));
            }
            return false;
        }
        boolean bl = flag = !(source.func_76346_g() instanceof EntityCreeper) && super.func_70097_a(source, amount);
        if (this.isCharging() && flag && amount > 0.0f) {
            --this.chargeHits;
        }
        return flag;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        this.setPowered(true);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70103_a(byte id) {
        if (id == 6) {
            EntityUtil.spawnParticleAtEntity((EntityLivingBase)this, EnumParticleTypes.HEART, 15, new int[0]);
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.lastFlashTick = this.flashTick;
        if (this.isJumpAttacking()) {
            if (this.flashTick == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 2.0f, this.func_70647_i() * 0.5f);
            }
            ++this.flashTick;
        } else if (this.flashTick > 0) {
            this.flashTick = 0;
        }
    }

    protected boolean func_184228_n(Entity entityIn) {
        return super.func_184228_n(entityIn) && entityIn instanceof EntityLivingBase;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public float func_70831_j(float partialTick) {
        if (this.field_70725_aQ > 0) {
            return (float)this.field_70725_aQ / 100.0f * 255.0f;
        }
        if (this.isCharging()) {
            return (this.field_70173_aa % 20 < 10 ? 0.6f : 0.0f) * 255.0f;
        }
        return ((float)this.lastFlashTick + (float)(this.flashTick - this.lastFlashTick) * partialTick) / 28.0f;
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            this.deathCause = cause;
            this.setCharging(false);
            this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_CREEPER_DEATH, 2.0f, 1.0f);
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            if (this.field_70718_bc > 0) {
                this.field_70718_bc += 100;
            }
        }
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        float explosionPower = this.func_70830_n() ? 12.0f : 8.0f;
        float radius = explosionPower * 1.5f;
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g((double)radius), EntitySelectors.field_188444_d)) {
            double x = this.field_70165_t - entity.field_70165_t;
            double y = this.field_70163_u - entity.field_70163_u;
            double z = this.field_70161_v - entity.field_70161_v;
            double d = Math.sqrt(x * x + y * y + z * z);
            float f2 = (float)this.field_70725_aQ / 100.0f;
            entity.field_70159_w += x / d * (double)f2 * 0.09;
            entity.field_70181_x += y / d * (double)f2 * 0.09;
            entity.field_70179_y += z / d * (double)f2 * 0.09;
        }
        this.field_70165_t += (double)(this.field_70146_Z.nextFloat() * 0.2f) - (double)0.1f;
        this.field_70161_v += (double)(this.field_70146_Z.nextFloat() * 0.2f) - (double)0.1f;
        if (this.field_70725_aQ >= 100) {
            if (!this.field_70170_p.field_72995_K) {
                MutatedExplosion.create((Entity)this, explosionPower, this.func_70027_ad(), true);
                EntityUtil.spawnLingeringCloud((EntityLivingBase)this);
                EntityUtil.dropExperience((EntityLiving)this, this.field_70718_bc, arg_0 -> ((MutantCreeperEntity)this).func_70693_a(arg_0), this.field_70717_bb);
                super.func_70645_a(this.deathCause != null ? this.deathCause : DamageSource.field_76377_j);
                if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && this.field_70717_bb != null) {
                    this.field_70170_p.func_72838_d((Entity)new CreeperMinionEggEntity(this, this.field_70717_bb));
                }
            }
            this.func_70106_y();
        }
    }

    public boolean func_70650_aV() {
        return this.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
    }

    @Deprecated
    public boolean func_146078_ca() {
        return false;
    }

    @Deprecated
    public int func_70832_p() {
        return -1;
    }

    protected void func_70629_bd() {
        this.field_70181_x += (double)0.04f;
    }

    protected void func_180466_bG() {
        this.func_70629_bd();
    }

    public float func_180428_a(Explosion explosionIn, World worldIn, BlockPos pos, IBlockState blockStateIn) {
        float f = super.func_180428_a(explosionIn, worldIn, pos, blockStateIn);
        return this.func_70830_n() && blockStateIn.func_185887_b(worldIn, pos) > -1.0f && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)pos, (IBlockState)blockStateIn) ? Math.min(0.8f, f) : f;
    }

    public void func_70642_aH() {
        if (this.func_70638_az() == null) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_MUTANT_CREEPER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_CREEPER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_CREEPER_HURT;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("JumpAttacking", this.isJumpAttacking());
        compound.func_74757_a("Charging", this.isCharging());
        compound.func_74768_a("ChargeTime", this.chargeTime);
        compound.func_74768_a("ChargeHits", this.chargeHits);
        compound.func_74757_a("SummonLightning", this.summonLightning);
        compound.func_74777_a("DeathTime", (short)this.field_70725_aQ);
        if (this.func_70830_n()) {
            compound.func_74757_a("Powered", true);
        }
        for (String unusedNBT : new String[]{"powered", "Fuse", "ExplosionRadius", "ignited"}) {
            compound.func_82580_o(unusedNBT);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setPowered(compound.func_74767_n("Powered"));
        this.setJumpAttacking(compound.func_74767_n("JumpAttacking"));
        this.setCharging(compound.func_74767_n("Charging"));
        this.chargeTime = compound.func_74762_e("ChargeTime");
        this.chargeHits = compound.func_74762_e("ChargeHits");
        this.summonLightning = compound.func_74767_n("SummonLightning");
        this.field_70725_aQ = ((EntityCreeper)this).field_70725_aQ;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.flashTick);
        buffer.writeInt(this.field_70725_aQ);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.flashTick = additionalData.readInt();
        this.field_70725_aQ = additionalData.readInt();
    }

    protected ResourceLocation func_184647_J() {
        return EntityUtil.getLootTable((Entity)this);
    }

    class JumpAttackGoal
    extends EntityAIBase {
        JumpAttackGoal() {
        }

        public boolean func_75250_a() {
            return MutantCreeperEntity.this.field_70122_E && MutantCreeperEntity.this.func_70638_az() != null && !MutantCreeperEntity.this.isCharging() && (double)MutantCreeperEntity.this.func_70032_d((Entity)MutantCreeperEntity.this.func_70638_az()) <= 1024.0 && MutantCreeperEntity.this.field_70146_Z.nextFloat() * 100.0f < 0.9f;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            MutantCreeperEntity.this.field_70134_J = false;
            MutantCreeperEntity.this.setJumpAttacking(true);
            MutantCreeperEntity.this.field_70159_w = (MutantCreeperEntity.this.func_70638_az().field_70165_t - MutantCreeperEntity.this.field_70165_t) * 0.2;
            MutantCreeperEntity.this.field_70181_x = 1.4;
            MutantCreeperEntity.this.field_70179_y = (MutantCreeperEntity.this.func_70638_az().field_70161_v - MutantCreeperEntity.this.field_70161_v) * 0.2;
        }
    }

    class ChargeAttackGoal
    extends EntityAIBase {
        public ChargeAttackGoal() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase target = MutantCreeperEntity.this.func_70638_az();
            return target != null && MutantCreeperEntity.this.field_70122_E && !(MutantCreeperEntity.this.func_110138_aP() - MutantCreeperEntity.this.func_110143_aJ() < MutantCreeperEntity.this.func_110138_aP() / 6.0f) && MutantCreeperEntity.this.func_70068_e((Entity)target) >= 25.0 && MutantCreeperEntity.this.func_70068_e((Entity)target) <= 1024.0 && MutantCreeperEntity.this.field_70146_Z.nextFloat() * 100.0f < 0.7f || MutantCreeperEntity.this.isCharging();
        }

        public boolean func_75253_b() {
            if (MutantCreeperEntity.this.summonLightning && MutantCreeperEntity.this.func_70638_az() != null && MutantCreeperEntity.this.func_70068_e((Entity)MutantCreeperEntity.this.func_70638_az()) < 25.0 && MutantCreeperEntity.this.field_70170_p.func_175678_i(MutantCreeperEntity.this.func_180425_c())) {
                MutantCreeperEntity.this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(MutantCreeperEntity.this.field_70170_p, MutantCreeperEntity.this.field_70165_t, MutantCreeperEntity.this.field_70163_u, MutantCreeperEntity.this.field_70161_v, false));
                return false;
            }
            return MutantCreeperEntity.this.chargeTime < 100 && MutantCreeperEntity.this.chargeHits > 0;
        }

        public void func_75249_e() {
            MutantCreeperEntity.this.setCharging(true);
            if (MutantCreeperEntity.this.field_70146_Z.nextInt(MutantCreeperEntity.this.field_70170_p.func_72911_I() ? 2 : 6) == 0 && !MutantCreeperEntity.this.func_70830_n()) {
                MutantCreeperEntity.this.summonLightning = true;
            }
        }

        public void func_75246_d() {
            MutantCreeperEntity.this.func_70661_as().func_75499_g();
            int i = MutantCreeperEntity.this.chargeTime % 20;
            if (i == 0 || i == 20) {
                MutantCreeperEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_CREEPER_CHARGE, 0.6f, 0.7f + MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.6f);
            }
            ++MutantCreeperEntity.this.chargeTime;
        }

        public void func_75251_c() {
            if (MutantCreeperEntity.this.chargeTime >= 100) {
                MutantCreeperEntity.this.func_70691_i(MutantCreeperEntity.this.func_110138_aP() / 4.0f);
                MutantCreeperEntity.this.field_70170_p.func_72960_a((Entity)MutantCreeperEntity.this, (byte)6);
            }
            MutantCreeperEntity.this.chargeTime = 0;
            MutantCreeperEntity.this.chargeHits = 4 + MutantCreeperEntity.this.field_70146_Z.nextInt(3);
            MutantCreeperEntity.this.setCharging(false);
            MutantCreeperEntity.this.summonLightning = false;
        }
    }

    class SpawnMinionsGoal
    extends EntityAIBase {
        SpawnMinionsGoal() {
        }

        public boolean func_75250_a() {
            return MutantCreeperEntity.this.func_70638_az() != null && MutantCreeperEntity.this.func_70068_e((Entity)MutantCreeperEntity.this.func_70638_az()) <= 1024.0 && !MutantCreeperEntity.this.isCharging() && !MutantCreeperEntity.this.isJumpAttacking() && MutantCreeperEntity.this.field_70146_Z.nextFloat() * 100.0f < 0.6f;
        }

        public void func_75249_e() {
            for (int i = (int)Math.ceil(MutantCreeperEntity.this.func_110143_aJ() / MutantCreeperEntity.this.func_110138_aP() * 4.0f); i > 0; --i) {
                CreeperMinionEntity creeper = new CreeperMinionEntity(MutantCreeperEntity.this.field_70170_p);
                double x = MutantCreeperEntity.this.field_70165_t + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() - MutantCreeperEntity.this.field_70146_Z.nextFloat());
                double y = MutantCreeperEntity.this.field_70163_u + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.5f);
                double z = MutantCreeperEntity.this.field_70161_v + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() - MutantCreeperEntity.this.field_70146_Z.nextFloat());
                double xx = MutantCreeperEntity.this.func_70638_az().field_70165_t - MutantCreeperEntity.this.field_70165_t;
                double yy = MutantCreeperEntity.this.func_70638_az().field_70163_u - MutantCreeperEntity.this.field_70163_u;
                double zz = MutantCreeperEntity.this.func_70638_az().field_70161_v - MutantCreeperEntity.this.field_70161_v;
                creeper.field_70159_w = xx * (double)0.15f + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.05f);
                creeper.field_70181_x = yy * (double)0.15f + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.05f);
                creeper.field_70179_y = zz * (double)0.15f + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.05f);
                creeper.func_70012_b(x, y, z, MutantCreeperEntity.this.field_70177_z, 0.0f);
                creeper.func_184754_b(MutantCreeperEntity.this.field_96093_i);
                if (MutantCreeperEntity.this.func_70830_n()) {
                    creeper.setPowered(true);
                }
                MutantCreeperEntity.this.field_70170_p.func_72838_d((Entity)creeper);
            }
        }

        public boolean func_75253_b() {
            return false;
        }
    }
}

