/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.entity.EndersoulCloneEntity;
import chumbanotz.mutantbeasts.entity.EndersoulFragmentEntity;
import chumbanotz.mutantbeasts.entity.ai.EntityAIAvoidDamage;
import chumbanotz.mutantbeasts.entity.ai.EntityAIHurtByNearestTarget;
import chumbanotz.mutantbeasts.entity.ai.MBEntityAIAttackMelee;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.item.EndersoulHandItem;
import chumbanotz.mutantbeasts.packet.HeldBlockPacket;
import chumbanotz.mutantbeasts.packet.MBPacketHandler;
import chumbanotz.mutantbeasts.packet.TeleportPacket;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBParticles;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class MutantEndermanEntity
extends EntityMob
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Byte> ACTIVE_ARM = EntityDataManager.func_187226_a(MutantEndermanEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> CLONE = EntityDataManager.func_187226_a(MutantEndermanEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final int MAX_DEATH_TIME = 280;
    public static final byte MELEE_ATTACK = 1;
    public static final byte THROW_ATTACK = 2;
    public static final byte STARE_ATTACK = 3;
    public static final byte TELEPORT_ATTACK = 4;
    public static final byte SCREAM_ATTACK = 5;
    public static final byte CLONE_ATTACK = 6;
    public static final byte TELESMASH_ATTACK = 7;
    public static final byte DEATH_ATTACK = 8;
    private int attackID;
    private int attackTick;
    private int prevArmScale;
    private int armScale;
    public int hasTarget;
    private BlockPos teleportPosition = BlockPos.field_177992_a;
    private int screamDelayTick;
    public final int[] heldBlock = new int[5];
    public final int[] heldBlockTick = new int[5];
    private boolean triggerThrowBlock;
    private int blockFrenzy;
    private List<Entity> capturedEntities;
    private int dirty = -1;
    private DamageSource deathCause;
    public int field_70725_aQ;

    public MutantEndermanEntity(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 40;
        this.field_70138_W = 1.5f;
        this.func_70105_a(1.2f, 4.2f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MeleeGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new ThrowBlockGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new StareGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new TeleportGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new ScreamGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new CloneGoal());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new TeleSmashGoal());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new MBEntityAIAttackMelee((EntityCreature)this, 1.2).setMaxAttackTick(10));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidDamage((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByNearestTarget((EntityCreature)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new FindTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityEndermite.class, 10, true, true, EntityEndermite::func_175495_n));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(96.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ACTIVE_ARM, (Object)0);
        this.field_70180_af.func_187214_a(CLONE, (Object)false);
    }

    public BlockPos getTeleportPosition() {
        return this.teleportPosition;
    }

    public void setTeleportPosition(BlockPos pos) {
        this.teleportPosition = pos;
        this.attackID = 4;
        if (this.field_70170_p.field_72995_K) {
            this.spawnTeleportParticles();
        } else {
            MBPacketHandler.INSTANCE.sendToAllTracking((IMessage)new TeleportPacket(this, pos), (Entity)this);
        }
    }

    public int getActiveArm() {
        return ((Byte)this.field_70180_af.func_187225_a(ACTIVE_ARM)).byteValue();
    }

    private void setActiveArm(int armID) {
        this.field_70180_af.func_187227_b(ACTIVE_ARM, (Object)((byte)armID));
    }

    public boolean isClone() {
        return (Boolean)this.field_70180_af.func_187225_a(CLONE);
    }

    private void setClone(boolean clone) {
        this.field_70180_af.func_187227_b(CLONE, (Object)clone);
        this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_MORPH, 2.0f, this.func_70647_i());
    }

    public int getAttackID() {
        return this.attackID;
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    private void setAttackID(int attackID) {
        this.attackID = attackID;
        this.attackTick = 0;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)(-attackID));
        }
    }

    public float func_70047_e() {
        return this.isClone() ? 2.55f : 3.9f;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((EntityLiving)this, worldIn).setAvoidRain(true);
    }

    public int func_70641_bl() {
        return 1;
    }

    public int func_82143_as() {
        return this.isClone() ? 3 : super.func_82143_as();
    }

    public boolean func_70067_L() {
        return super.func_70067_L() && this.attackID != 4;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (CLONE.equals(key)) {
            if (this.isClone()) {
                this.func_70105_a(0.6f, 2.9f);
            } else {
                this.func_70105_a(1.2f, 4.2f);
            }
        }
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        this.func_70052_a(2, entitylivingbaseIn != null);
    }

    public boolean isAggressive() {
        return this.func_70083_f(2);
    }

    public float getArmScale(float partialTicks) {
        return ((float)this.prevArmScale + (float)(this.armScale - this.prevArmScale) * partialTicks) / 10.0f;
    }

    private void updateTargetTick() {
        this.prevArmScale = this.armScale;
        if (this.isAggressive()) {
            this.hasTarget = 20;
        }
        boolean emptyHanded = true;
        for (int i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] > 0) {
                emptyHanded = false;
            }
            if (this.hasTarget > 0) {
                if (this.heldBlock[i] <= 0) continue;
                this.heldBlockTick[i] = Math.min(10, this.heldBlockTick[i] + 1);
                continue;
            }
            this.heldBlockTick[i] = Math.max(0, this.heldBlockTick[i] - 1);
        }
        if (this.hasTarget > 0) {
            this.armScale = Math.min(10, this.armScale + 1);
        } else if (emptyHanded) {
            this.armScale = Math.max(0, this.armScale - 1);
        } else if (!this.field_70170_p.field_72995_K) {
            boolean mobGriefing = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
            for (int i = 1; i < this.heldBlock.length; ++i) {
                if (this.heldBlock[i] == 0 || this.heldBlockTick[i] != 0) continue;
                BlockPos placePos = new BlockPos(this.field_70165_t - 1.5 + this.field_70146_Z.nextDouble() * 4.0, this.field_70163_u - 0.5 + this.field_70146_Z.nextDouble() * 2.5, this.field_70161_v - 1.5 + this.field_70146_Z.nextDouble() * 4.0);
                Block heldBlock = Block.func_149729_e((int)this.heldBlock[i]);
                if (MutantEndermanEntity.canPlaceBlock(this.field_70170_p, placePos, placePos.func_177977_b(), heldBlock) && mobGriefing) {
                    this.field_70170_p.func_175656_a(placePos, Block.func_176220_d((int)this.heldBlock[i]));
                    SoundType soundType = heldBlock.getSoundType(heldBlock.func_176223_P(), this.field_70170_p, placePos, (Entity)this);
                    this.func_184185_a(soundType.func_185841_e(), (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                    this.sendHoldBlock(i, 0);
                    continue;
                }
                if (mobGriefing && this.field_70146_Z.nextInt(50) != 0) continue;
                this.triggerThrowBlock = true;
            }
        }
        this.hasTarget = Math.max(0, this.hasTarget - 1);
    }

    private static boolean canPlaceBlock(World world, BlockPos placePos, BlockPos downPos, Block heldBlock) {
        return heldBlock.func_176196_c(world, placePos) && world.func_175623_d(placePos) && !world.func_175623_d(downPos) && world.func_180495_p(downPos).func_185917_h();
    }

    private void updateScreamEntities() {
        this.screamDelayTick = Math.max(0, this.screamDelayTick - 1);
        if (this.attackID == 5 && this.attackTick >= 40 && this.attackTick <= 160) {
            if (this.attackTick == 160) {
                this.capturedEntities = null;
            } else if (this.capturedEntities == null) {
                this.capturedEntities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(20.0, 12.0, 20.0), EndersoulFragmentEntity.IS_VALID_TARGET);
            }
            for (int i = 0; this.capturedEntities != null && i < this.capturedEntities.size(); ++i) {
                Entity entity = this.capturedEntities.get(i);
                if (this.func_70068_e(entity) > 400.0 || !EntitySelectors.field_180132_d.apply((Object)entity) || !entity.isAddedToWorld()) {
                    this.capturedEntities.remove(i);
                    --i;
                    continue;
                }
                if (this.attackTick == 40) {
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h().func_82726_p(), 4.0f);
                    if (entity instanceof EntityLiving) {
                        EntityLiving living = (EntityLiving)entity;
                        living.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 120, 3));
                        if (this.field_70146_Z.nextInt(2) != 0) {
                            living.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 120 + this.field_70146_Z.nextInt(180), this.field_70146_Z.nextInt(2)));
                        }
                        if (this.field_70146_Z.nextInt(4) != 0) {
                            living.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 300 + this.field_70146_Z.nextInt(300), this.field_70146_Z.nextInt(2)));
                        }
                        if (this.field_70146_Z.nextInt(3) != 0) {
                            living.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 120 + this.field_70146_Z.nextInt(60), 10 + this.field_70146_Z.nextInt(2)));
                        }
                        if (this.field_70146_Z.nextInt(4) != 0) {
                            living.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 120 + this.field_70146_Z.nextInt(400), 0));
                        }
                    }
                }
                entity.field_70125_A += (this.field_70146_Z.nextFloat() - 0.3f) * 6.0f;
            }
        }
    }

    public void func_70103_a(byte id) {
        if (id <= 0) {
            this.setAttackID(Math.abs(id));
            if (this.attackID == 6) {
                this.spawnTeleportParticles();
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70636_d() {
        this.field_70703_bu = false;
        super.func_70636_d();
        if (this.attackID != 0) {
            ++this.attackTick;
        }
        if (this.field_70170_p.field_72995_K && this.attackID == 5 && this.attackTick == 40) {
            this.spawnTeleportParticles();
        }
        if (this.attackID == 8) {
            this.field_70725_aQ = this.attackTick;
        }
        this.updateTargetTick();
        this.updateScreamEntities();
        if (this.field_70170_p.field_72995_K && !this.isClone()) {
            double h = this.attackID != 8 ? (double)this.field_70131_O : (double)(this.field_70131_O + 1.0f);
            double w = this.attackID != 8 ? (double)this.field_70130_N : (double)(this.field_70130_N * 1.5f);
            for (int i = 0; i < 3; ++i) {
                double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * w;
                double y = this.field_70163_u + this.field_70146_Z.nextDouble() * h - 0.25;
                double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * w;
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, x, y, z, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
    }

    private void updateBlockFrenzy() {
        this.blockFrenzy = Math.max(0, this.blockFrenzy - 1);
        if (this.func_70638_az() != null && this.attackID == 0) {
            if (this.blockFrenzy == 0 && (this.func_189748_bU() instanceof EntityDamageSourceIndirect || this.field_70146_Z.nextInt(!this.func_70781_l() ? 200 : 600) == 0)) {
                this.blockFrenzy = 200 + this.field_70146_Z.nextInt(80);
            }
            if (this.blockFrenzy > 0 && this.field_70146_Z.nextInt(8) == 0) {
                int index = this.getFavorableHand();
                if (index == -1) {
                    return;
                }
                BlockPos pos = new BlockPos(this.field_70165_t - 2.5 + this.field_70146_Z.nextDouble() * 5.0, this.field_70163_u - 0.5 + this.field_70146_Z.nextDouble() * 3.0, this.field_70161_v - 2.5 + this.field_70146_Z.nextDouble() * 5.0);
                IBlockState blockState = this.field_70170_p.func_180495_p(pos);
                if (index != -1 && EndersoulHandItem.canCarry(this.field_70170_p, pos, blockState)) {
                    this.sendHoldBlock(index, Block.func_176210_f((IBlockState)blockState));
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                        this.field_70170_p.func_175698_g(pos);
                    }
                }
            }
        }
    }

    private void updateTeleport() {
        EntityLivingBase entity = this.func_70638_az();
        this.teleportByChance(entity == null ? 1600 : 800, (Entity)entity);
        if (this.func_70090_H() || this.field_70143_R > 3.0f || entity != null && (this.func_184223_x((Entity)entity) || this.func_70068_e((Entity)entity) > 1024.0 || !this.func_70781_l() && !this.func_70635_at().func_75522_a((Entity)entity))) {
            this.teleportByChance(10, (Entity)entity);
        }
    }

    protected void func_70619_bc() {
        if (this.field_70173_aa % 100 == 0 && !this.isClone() && this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.dirty >= 0) {
            ++this.dirty;
        }
        if (this.dirty >= 8) {
            this.dirty = -1;
            for (int i = 1; i < this.heldBlock.length; ++i) {
                if (this.heldBlock[i] <= 0) continue;
                this.sendHoldBlock(i, this.heldBlock[i]);
            }
        }
        this.updateBlockFrenzy();
        this.updateTeleport();
    }

    protected void func_85033_bc() {
        if (!this.isClone()) {
            super.func_85033_bc();
        }
    }

    private int getAvailableHand() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            list.add(i);
        }
        if (list.isEmpty()) {
            return -1;
        }
        return (Integer)list.get(this.field_70146_Z.nextInt(list.size()));
    }

    private int getFavorableHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            if (i <= 2) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!outer.isEmpty()) {
            return (Integer)outer.get(this.field_70146_Z.nextInt(outer.size()));
        }
        return (Integer)inner.get(this.field_70146_Z.nextInt(inner.size()));
    }

    private int getThrowingHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] == 0) continue;
            if (i <= 2) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!inner.isEmpty()) {
            return (Integer)inner.get(this.field_70146_Z.nextInt(inner.size()));
        }
        return (Integer)outer.get(this.field_70146_Z.nextInt(outer.size()));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K && this.attackID == 0) {
            int i = this.getAvailableHand();
            if (!this.teleportByChance(6, entityIn)) {
                if (i != -1) {
                    boolean allHandsFree;
                    boolean bl = allHandsFree = this.heldBlock[1] == 0 && this.heldBlock[2] == 0;
                    if (allHandsFree && this.field_70146_Z.nextInt(10) == 0) {
                        this.attackID = 6;
                    } else if (allHandsFree && this.field_70146_Z.nextInt(7) == 0) {
                        this.attackID = 7;
                    } else {
                        this.setActiveArm(i);
                        this.attackID = 1;
                    }
                } else {
                    this.triggerThrowBlock = true;
                }
            }
        }
        if (this.isClone()) {
            boolean flag = super.func_70652_k(entityIn);
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(2) == 0) {
                double x = entityIn.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
                double y = entityIn.field_70163_u + (double)this.field_70146_Z.nextInt(5) + 4.0;
                double z = entityIn.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
                this.teleportTo(x, y, z);
            }
            if (flag) {
                this.func_70691_i(2.0f);
            }
            this.func_184609_a(EnumHand.MAIN_HAND);
            return flag;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityDragon || source.func_76346_g() instanceof MutantEndermanEntity) {
            return false;
        }
        if ((this.attackID == 4 || this.attackID == 5) && source != DamageSource.field_76380_i) {
            return false;
        }
        boolean damaged = super.func_70097_a(source, amount);
        if (damaged && (this.attackID == 3 || this.attackID == 6)) {
            this.attackID = 0;
            return damaged;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && (this.func_70638_az() == null || source != DamageSource.field_76371_c && source.func_76364_f() != null)) {
            boolean betterDodge;
            Entity entity = source.func_76346_g();
            boolean bl = betterDodge = entity == null;
            if (source.func_76352_a() || source.func_94541_c() || source == DamageSource.field_76379_h) {
                betterDodge = true;
            }
            if (this.teleportByChance(betterDodge ? 3 : 6, entity) && source != DamageSource.field_76380_i) {
                if (entity != null && entity instanceof EntityLivingBase) {
                    this.func_70604_c((EntityLivingBase)entity);
                }
                return false;
            }
            this.teleportByChance(source == DamageSource.field_76369_e || source == DamageSource.field_76368_d ? 3 : 5, entity);
        }
        return damaged;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return !this.isClone() && super.func_70687_e(potioneffectIn);
    }

    private boolean teleportByChance(int chance, @Nullable Entity entity) {
        if (this.attackID != 0 && !this.isClone()) {
            return false;
        }
        if (this.field_70146_Z.nextInt(Math.max(1, chance)) == 0) {
            return entity == null ? this.teleportRandomly() : this.teleportToEntity(entity);
        }
        return false;
    }

    private boolean teleportRandomly() {
        if (this.attackID != 0 && !this.isClone()) {
            return false;
        }
        double radius = 24.0;
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        double y = this.field_70163_u + (double)this.field_70146_Z.nextInt((int)radius * 2) - radius;
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        return this.teleportTo(x, y, z);
    }

    private boolean teleportToEntity(Entity entity) {
        if (this.attackID != 0 && !this.isClone()) {
            return false;
        }
        double d = this.func_70068_e(entity);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double radius = 16.0;
        if (d < 100.0) {
            x = entity.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
            y = entity.field_70163_u + this.field_70146_Z.nextDouble() * radius;
            z = entity.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        } else {
            Vec3d vec = new Vec3d(this.field_70165_t - entity.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.field_70131_O / 2.0 - entity.field_70163_u + (double)entity.func_70047_e(), this.field_70161_v - entity.field_70161_v);
            vec = vec.func_72432_b();
            x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec.field_72450_a * radius;
            y = this.field_70163_u + (double)this.field_70146_Z.nextInt(8) - vec.field_72448_b * radius;
            z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec.field_72449_c * radius;
        }
        return this.teleportTo(x, y, z);
    }

    private boolean teleportTo(double targetX, double targetY, double targetZ) {
        if (!this.func_70613_aW()) {
            return false;
        }
        if (this.isClone()) {
            boolean flag = EntityUtil.teleportTo((EntityLiving)this, targetX, targetY, targetZ);
            if (flag) {
                this.func_184210_p();
                if (!this.func_174814_R()) {
                    this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r + (double)this.field_70131_O / 2.0, this.field_70166_s, MBSoundEvents.ENTITY_ENDERSOUL_CLONE_TELEPORT, this.func_184176_by(), 1.0f, 1.0f);
                    this.func_184185_a(MBSoundEvents.ENTITY_ENDERSOUL_CLONE_TELEPORT, 1.0f, 1.0f);
                }
            }
            return flag;
        }
        if (this.attackID == 0) {
            this.attackID = 4;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos().func_189532_c(targetX, targetY, targetZ);
            if (this.field_70170_p.func_175667_e((BlockPos)pos)) {
                do {
                    pos.func_189536_c(EnumFacing.DOWN);
                } while (pos.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)pos).func_185904_a().func_76230_c());
                pos.func_189536_c(EnumFacing.UP);
            }
            if (!this.func_70038_c(pos.func_177958_n() - MathHelper.func_76128_c((double)this.field_70165_t), pos.func_177956_o() - MathHelper.func_76128_c((double)this.field_70163_u), pos.func_177952_p() - MathHelper.func_76128_c((double)this.field_70161_v))) {
                this.attackID = 0;
                return false;
            }
            this.setTeleportPosition(pos.func_185334_h());
            return true;
        }
        return false;
    }

    private void spawnTeleportParticles() {
        int temp = this.attackID == 4 ? 512 : 256;
        for (int i = 0; i < temp; ++i) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 1.8f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 1.8f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 1.8f;
            boolean useCurrentPos = this.attackID != 4 || i < temp / 2;
            double tempX = (useCurrentPos ? this.field_70165_t : (double)this.getTeleportPosition().func_177958_n()) + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
            double tempY = (useCurrentPos ? this.field_70163_u : (double)this.getTeleportPosition().func_177956_o()) + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70131_O + 1.5;
            double tempZ = (useCurrentPos ? this.field_70161_v : (double)this.getTeleportPosition().func_177952_p()) + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
            this.field_70170_p.func_175688_a(MBParticles.ENDERSOUL, tempX, tempY, tempZ, (double)f, (double)f1, (double)f2, new int[0]);
        }
    }

    public static void teleportAttack(EntityLivingBase attacker) {
        double radius = 3.0;
        int duration = 140 + attacker.func_70681_au().nextInt(60);
        DamageSource damageSource = DamageSource.func_76358_a((EntityLivingBase)attacker);
        if (attacker instanceof EntityPlayer) {
            radius = 2.0;
            duration = 100;
            damageSource = DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker));
        }
        for (Entity entity : attacker.field_70170_p.func_175674_a((Entity)attacker, attacker.func_174813_aQ().func_186662_g(radius), EndersoulFragmentEntity.IS_VALID_TARGET)) {
            if (entity instanceof EntityLivingBase && entity.func_70097_a(damageSource, 4.0f) && attacker.func_70681_au().nextInt(3) == 0) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76440_q, duration));
            }
            double x = entity.field_70165_t - attacker.field_70165_t;
            double z = entity.field_70161_v - attacker.field_70161_v;
            double signX = x / Math.abs(x);
            double signZ = z / Math.abs(z);
            if (Double.isNaN(signX) || Double.isNaN(signZ)) {
                return;
            }
            entity.field_70159_w = (radius * signX * 2.0 - x) * (double)0.2f;
            entity.field_70181_x = 0.2f;
            entity.field_70179_y = (radius * signZ * 2.0 - z) * (double)0.2f;
        }
    }

    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(3.5);
    }

    protected boolean func_184228_n(Entity entityIn) {
        return super.func_184228_n(entityIn) && entityIn instanceof EntityLivingBase;
    }

    public boolean func_70685_l(Entity entityIn) {
        return !entityIn.getClass().getSimpleName().equals("EntityGorgon") && super.func_70685_l(entityIn);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.capturedEntities = null;
        if (!this.field_70170_p.field_72995_K) {
            this.deathCause = cause;
            if (this.isClone()) {
                this.setClone(false);
            }
            this.setAttackID(8);
            if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                super.func_82160_b(this.field_70718_bc > 0, ForgeHooks.getLootingLevel((Entity)this, (Entity)cause.func_76346_g(), (DamageSource)cause));
            }
            if (this.field_70718_bc > 0) {
                this.field_70718_bc += 280;
            }
        }
    }

    protected void func_70609_aI() {
        this.field_70159_w = 0.0;
        this.field_70181_x = Math.min(this.field_70181_x, 0.0);
        this.field_70179_y = 0.0;
        if (this.field_70725_aQ == 80) {
            this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_DEATH, 5.0f, this.func_70647_i());
        }
        if (this.field_70725_aQ >= 60) {
            if (this.field_70725_aQ < 80 && this.capturedEntities == null) {
                this.capturedEntities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(10.0, 8.0, 10.0), EndersoulFragmentEntity.IS_VALID_TARGET);
            }
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(3) != 0) {
                EndersoulFragmentEntity orb = new EndersoulFragmentEntity(this.field_70170_p);
                orb.func_70107_b(this.field_70165_t, this.field_70163_u + 3.8, this.field_70161_v);
                orb.field_70159_w = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
                orb.field_70181_x = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
                orb.field_70179_y = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
                this.field_70170_p.func_72838_d((Entity)orb);
            }
        }
        if (this.field_70725_aQ >= 80 && this.field_70725_aQ < 260 && this.capturedEntities != null) {
            for (int i = 0; i < this.capturedEntities.size(); ++i) {
                Entity entity = this.capturedEntities.get(i);
                if (EndersoulFragmentEntity.isProtected(entity) || !EntitySelectors.field_180132_d.apply((Object)entity) || !entity.isAddedToWorld()) {
                    this.capturedEntities.remove(i);
                    --i;
                    continue;
                }
                if (entity.field_70143_R > 4.5f) {
                    entity.field_70143_R = 4.5f;
                }
                if (!(this.func_70068_e(entity) > 64.0)) continue;
                double x = this.field_70165_t - entity.field_70165_t;
                double z = this.field_70161_v - entity.field_70161_v;
                double d = Math.sqrt(x * x + z * z);
                entity.field_70159_w = (double)0.8f * x / d;
                entity.field_70179_y = (double)0.8f * z / d;
                if (!(this.field_70163_u + 4.0 > entity.field_70163_u)) continue;
                entity.field_70181_x = Math.max(entity.field_70181_x, (double)0.4f);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70725_aQ >= 100 && this.field_70725_aQ < 150 && this.field_70725_aQ % 6 == 0 && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            DamageSource source = this.deathCause != null ? this.deathCause : DamageSource.field_76377_j;
            this.func_184610_a(this.field_70718_bc > 0, ForgeHooks.getLootingLevel((Entity)this, (Entity)source.func_76346_g(), (DamageSource)source), source);
        }
        if (this.field_70725_aQ >= 280) {
            EntityUtil.dropExperience((EntityLiving)this, this.field_70718_bc, arg_0 -> ((MutantEndermanEntity)this).func_70693_a(arg_0), this.field_70717_bb);
            this.func_70106_y();
        }
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    protected boolean func_146066_aG() {
        return false;
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        return super.func_70099_a(stack, this.field_70725_aQ > 0 ? 3.84f : offsetY);
    }

    public String func_70005_c_() {
        return this.isClone() ? I18n.func_74838_a((String)"entity.mutantbeasts.endersoul_clone.name") : super.func_70005_c_();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ScreamDelay", this.screamDelayTick);
        compound.func_74768_a("BlockFrenzy", this.blockFrenzy);
        compound.func_74777_a("DeathTime", (short)this.field_70725_aQ);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.screamDelayTick = compound.func_74762_e("ScreamDelay");
        this.blockFrenzy = compound.func_74762_e("BlockFrenzy");
        this.field_70725_aQ = ((EntityMob)this).field_70725_aQ;
        if (this.field_70725_aQ > 0) {
            this.attackID = 8;
            this.attackTick = this.field_70725_aQ;
            ((EntityMob)this).field_70725_aQ = 0;
        }
    }

    public int func_70627_aG() {
        return 200;
    }

    public void func_70642_aH() {
        if (!this.isClone()) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_MUTANT_ENDERMAN_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_ENDERMAN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_ENDERMAN_HURT;
    }

    protected ResourceLocation func_184647_J() {
        return EntityUtil.getLootTable((Entity)this);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.attackID);
        buffer.writeInt(this.attackTick);
        buffer.writeInt(this.field_70725_aQ);
        buffer.writeInt(this.armScale);
        buffer.writeInt(this.hasTarget);
        buffer.writeLong(this.teleportPosition.func_177986_g());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.attackID = additionalData.readInt();
        this.attackTick = additionalData.readInt();
        this.field_70725_aQ = additionalData.readInt();
        this.armScale = additionalData.readInt();
        this.hasTarget = additionalData.readInt();
        this.teleportPosition = BlockPos.func_177969_a((long)additionalData.readLong());
    }

    public void sendHoldBlock(int blockIndex, int blockId) {
        this.heldBlock[blockIndex] = blockId;
        this.heldBlockTick[blockIndex] = 0;
        if (!this.field_70170_p.field_72995_K) {
            MBPacketHandler.INSTANCE.sendToAllTracking((IMessage)new HeldBlockPacket(this, blockId, blockIndex), (Entity)this);
        }
    }

    private boolean isBeingLookedAtBy(EntityLivingBase target) {
        if (target instanceof EntityLiving) {
            return ((EntityLiving)target).func_70638_az() == this && target.func_70685_l((Entity)this);
        }
        Vec3d playerVec = target.func_70676_i(1.0f).func_72432_b();
        Vec3d targetVec = new Vec3d(this.field_70165_t - target.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (target.field_70163_u + (double)target.func_70047_e()), this.field_70161_v - target.field_70161_v);
        double length = targetVec.func_72433_c();
        double d = playerVec.func_72430_b(targetVec = targetVec.func_72432_b());
        return d > 1.0 - 0.08 / length ? target.func_70685_l((Entity)this) : false;
    }

    public class ThrowBlockGoal
    extends EntityAIBase {
        public boolean func_75250_a() {
            if (MutantEndermanEntity.this.attackID != 0) {
                return false;
            }
            if (!MutantEndermanEntity.this.triggerThrowBlock && MutantEndermanEntity.this.field_70146_Z.nextInt(28 - MutantEndermanEntity.this.field_70737_aN) != 0) {
                return false;
            }
            if (MutantEndermanEntity.this.func_70638_az() != null && !MutantEndermanEntity.this.func_70635_at().func_75522_a((Entity)MutantEndermanEntity.this.func_70638_az())) {
                return false;
            }
            int id = MutantEndermanEntity.this.getThrowingHand();
            if (id == -1) {
                return false;
            }
            MutantEndermanEntity.this.setActiveArm(id);
            return true;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.attackTick = 0;
            MutantEndermanEntity.this.setAttackID(2);
            int id = MutantEndermanEntity.this.getActiveArm();
            MutantEndermanEntity.this.field_70170_p.func_72838_d((Entity)new ThrowableBlockEntity(MutantEndermanEntity.this.field_70170_p, MutantEndermanEntity.this, id));
            MutantEndermanEntity.this.sendHoldBlock(id, 0);
        }

        public boolean func_75253_b() {
            return MutantEndermanEntity.this.attackID == 2 && MutantEndermanEntity.this.attackTick < 14;
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.setAttackID(0);
            MutantEndermanEntity.this.setActiveArm(0);
            MutantEndermanEntity.this.triggerThrowBlock = false;
        }
    }

    class TeleSmashGoal
    extends EntityAIBase {
        private EntityLivingBase attackTarget;

        public TeleSmashGoal() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantEndermanEntity.this.func_70638_az();
            return this.attackTarget != null && MutantEndermanEntity.this.attackID == 7;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.setAttackID(7);
            this.attackTarget.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 5));
            this.attackTarget.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 160 + this.attackTarget.func_70681_au().nextInt(160), 0));
        }

        public boolean func_75253_b() {
            return MutantEndermanEntity.this.attackID == 7 && MutantEndermanEntity.this.attackTick < 30;
        }

        public void func_75246_d() {
            MutantEndermanEntity.this.func_70661_as().func_75499_g();
            if (MutantEndermanEntity.this.attackTick < 20) {
                MutantEndermanEntity.this.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            if (MutantEndermanEntity.this.attackTick == 17) {
                this.attackTarget.func_184210_p();
            }
            if (MutantEndermanEntity.this.attackTick == 18) {
                double x = this.attackTarget.field_70165_t + (double)((this.attackTarget.func_70681_au().nextFloat() - 0.5f) * 14.0f);
                double y = this.attackTarget.field_70163_u + (double)this.attackTarget.func_70681_au().nextFloat() + (this.attackTarget instanceof EntityPlayer ? 13.0 : 7.0);
                double z = this.attackTarget.field_70161_v + (double)((this.attackTarget.func_70681_au().nextFloat() - 0.5f) * 14.0f);
                EntityUtil.sendParticlePacket((Entity)this.attackTarget, MBParticles.ENDERSOUL, 256);
                this.attackTarget.func_70634_a(x, y, z);
                this.attackTarget.field_70170_p.func_184148_a(null, x, y, z, SoundEvents.field_187539_bB, this.attackTarget.func_184176_by(), 1.2f, 0.9f + this.attackTarget.func_70681_au().nextFloat() * 0.2f);
                this.attackTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)MutantEndermanEntity.this).func_76348_h().func_82726_p(), 6.0f);
            }
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.setAttackID(0);
            this.attackTarget = null;
        }
    }

    class TeleportGoal
    extends EntityAIBase {
        public TeleportGoal() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return MutantEndermanEntity.this.attackID == 4;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.attackTick = 0;
            MutantEndermanEntity.this.func_70661_as().func_75499_g();
            if (MutantEndermanEntity.this.func_70638_az() != null) {
                MutantEndermanEntity.this.func_70671_ap().func_75651_a((Entity)MutantEndermanEntity.this.func_70638_az(), 30.0f, 30.0f);
            }
            MutantEndermanEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            MutantEndermanEntity.teleportAttack((EntityLivingBase)MutantEndermanEntity.this);
            MutantEndermanEntity.this.func_70107_b((double)MutantEndermanEntity.this.getTeleportPosition().func_177958_n() + 0.5, MutantEndermanEntity.this.getTeleportPosition().func_177956_o(), (double)MutantEndermanEntity.this.getTeleportPosition().func_177952_p() + 0.5);
            MutantEndermanEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            MutantEndermanEntity.teleportAttack((EntityLivingBase)MutantEndermanEntity.this);
            MutantEndermanEntity.this.func_70107_b(MutantEndermanEntity.this.field_70169_q, MutantEndermanEntity.this.field_70167_r, MutantEndermanEntity.this.field_70166_s);
        }

        public boolean func_75253_b() {
            return this.func_75250_a() && MutantEndermanEntity.this.attackTick < 10;
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.field_70143_R = 0.0f;
            MutantEndermanEntity.this.func_70107_b((double)MutantEndermanEntity.this.getTeleportPosition().func_177958_n() + 0.5, MutantEndermanEntity.this.getTeleportPosition().func_177956_o(), (double)MutantEndermanEntity.this.getTeleportPosition().func_177952_p() + 0.5);
            MutantEndermanEntity.this.setAttackID(0);
            MutantEndermanEntity.this.func_184210_p();
            MutantEndermanEntity.this.field_70169_q = MutantEndermanEntity.this.field_70165_t;
            MutantEndermanEntity.this.field_70167_r = MutantEndermanEntity.this.field_70163_u;
            MutantEndermanEntity.this.field_70166_s = MutantEndermanEntity.this.field_70161_v;
        }
    }

    class ScreamGoal
    extends EntityAIBase {
        public ScreamGoal() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            if (MutantEndermanEntity.this.func_70638_az() != null && MutantEndermanEntity.this.attackID == 0) {
                return MutantEndermanEntity.this.screamDelayTick > 0 ? false : MutantEndermanEntity.this.field_70146_Z.nextInt(MutantEndermanEntity.this.func_70026_G() ? 400 : 1200) == 0;
            }
            return false;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.setAttackID(5);
            MutantEndermanEntity.this.field_70757_a = -MutantEndermanEntity.this.func_70627_aG();
        }

        public boolean func_75253_b() {
            return MutantEndermanEntity.this.attackTick < 165;
        }

        public void func_75246_d() {
            MutantEndermanEntity.this.func_70661_as().func_75499_g();
            if (MutantEndermanEntity.this.attackTick == 40) {
                if (MutantEndermanEntity.this.field_70170_p.func_72896_J() && ForgeEventFactory.getMobGriefingEvent((World)MutantEndermanEntity.this.field_70170_p, (Entity)MutantEndermanEntity.this)) {
                    MutantEndermanEntity.this.field_70170_p.func_72912_H().func_76084_b(false);
                }
                MutantEndermanEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_SCREAM, 6.0f, 0.7f + MutantEndermanEntity.this.field_70146_Z.nextFloat() * 0.2f);
            }
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.setAttackID(0);
            MutantEndermanEntity.this.screamDelayTick = 600;
        }
    }

    class CloneGoal
    extends EntityAIBase {
        private final List<EndersoulCloneEntity> cloneList = new ArrayList<EndersoulCloneEntity>();
        private EntityLivingBase attackTarget;

        CloneGoal() {
        }

        public boolean func_75250_a() {
            if (MutantEndermanEntity.this.func_70638_az() == null) {
                return false;
            }
            if (MutantEndermanEntity.this.heldBlock[1] == 0 && MutantEndermanEntity.this.heldBlock[2] == 0) {
                return MutantEndermanEntity.this.attackID == 6 || MutantEndermanEntity.this.attackID == 0 && MutantEndermanEntity.this.field_70146_Z.nextInt(300) == 0;
            }
            return false;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.setAttackID(6);
            MutantEndermanEntity.this.setClone(true);
            MutantEndermanEntity.this.func_70066_B();
            MutantEndermanEntity.this.func_70674_bp();
            MutantEndermanEntity.this.field_70138_W = 1.0f;
            MutantEndermanEntity.this.field_70172_ad = 15;
            this.attackTarget = MutantEndermanEntity.this.func_70638_az();
            for (int i = 0; i < 7; ++i) {
                double x = this.attackTarget.field_70165_t + (MutantEndermanEntity.this.field_70146_Z.nextDouble() - 0.5) * 24.0;
                double y = this.attackTarget.field_70163_u + 8.0;
                double z = this.attackTarget.field_70161_v + (MutantEndermanEntity.this.field_70146_Z.nextDouble() - 0.5) * 24.0;
                this.createClone(x, y, z);
            }
            double x = this.attackTarget.field_70165_t + (MutantEndermanEntity.this.field_70146_Z.nextDouble() - 0.5) * 24.0;
            double y = this.attackTarget.field_70163_u + 8.0;
            double z = this.attackTarget.field_70161_v + (MutantEndermanEntity.this.field_70146_Z.nextDouble() - 0.5) * 24.0;
            EntityUtil.teleportTo((EntityLiving)MutantEndermanEntity.this, x, y, z);
            this.createClone(MutantEndermanEntity.this.field_70169_q, MutantEndermanEntity.this.field_70167_r, MutantEndermanEntity.this.field_70166_s);
            EntityUtil.divertAttackers((EntityLiving)MutantEndermanEntity.this, (EntityLivingBase)this.getRandomClone());
        }

        public boolean func_75253_b() {
            return MutantEndermanEntity.this.attackID == 6 && MutantEndermanEntity.this.func_70638_az() != null && MutantEndermanEntity.this.func_70638_az().func_70089_S() && !this.cloneList.isEmpty() && MutantEndermanEntity.this.isClone() && MutantEndermanEntity.this.attackTick < 600;
        }

        public void func_75246_d() {
            for (int i = this.cloneList.size() - 1; i >= 0; --i) {
                EndersoulCloneEntity clone = this.cloneList.get(i);
                if (!clone.func_70089_S()) {
                    this.cloneList.remove(i);
                    continue;
                }
                if (clone.func_70638_az() == MutantEndermanEntity.this.func_70638_az()) continue;
                clone.func_70624_b(MutantEndermanEntity.this.func_70638_az());
            }
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.setAttackID(0);
            MutantEndermanEntity.this.setClone(false);
            for (EndersoulCloneEntity clone : this.cloneList) {
                if (!clone.func_70089_S()) continue;
                clone.func_70106_y();
            }
            this.cloneList.clear();
            MutantEndermanEntity.this.func_70661_as().func_75499_g();
            MutantEndermanEntity.this.field_70138_W = 1.4f;
            this.attackTarget.func_70604_c((EntityLivingBase)MutantEndermanEntity.this);
            this.attackTarget = null;
        }

        private void createClone(double x, double y, double z) {
            EndersoulCloneEntity clone = new EndersoulCloneEntity(MutantEndermanEntity.this, x, y, z);
            clone.func_70624_b(this.attackTarget);
            MutantEndermanEntity.this.field_70170_p.func_72838_d((Entity)clone);
            this.cloneList.add(clone);
        }

        private EndersoulCloneEntity getRandomClone() {
            return this.cloneList.isEmpty() ? null : this.cloneList.get(MutantEndermanEntity.this.field_70146_Z.nextInt(this.cloneList.size()));
        }
    }

    class MeleeGoal
    extends EntityAIBase {
        MeleeGoal() {
        }

        public boolean func_75250_a() {
            return MutantEndermanEntity.this.attackID == 1;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.setAttackID(1);
        }

        public boolean func_75253_b() {
            return this.func_75250_a() && MutantEndermanEntity.this.attackTick < 10;
        }

        public void func_75246_d() {
            if (MutantEndermanEntity.this.attackTick == 3) {
                MutantEndermanEntity.this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, MutantEndermanEntity.this.func_70647_i());
                DamageSource damageSource = DamageSource.func_76358_a((EntityLivingBase)MutantEndermanEntity.this);
                boolean lower = MutantEndermanEntity.this.getActiveArm() >= 3;
                float attackDamage = (float)MutantEndermanEntity.this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                for (Entity entity : MutantEndermanEntity.this.field_70170_p.func_72839_b((Entity)MutantEndermanEntity.this, MutantEndermanEntity.this.func_174813_aQ().func_186662_g(4.0))) {
                    if (!entity.func_70067_L() || entity instanceof MutantEndermanEntity) continue;
                    double dist = MutantEndermanEntity.this.func_70032_d(entity);
                    double x = MutantEndermanEntity.this.field_70165_t - entity.field_70165_t;
                    double z = MutantEndermanEntity.this.field_70161_v - entity.field_70161_v;
                    if (!(MutantEndermanEntity.this.func_174813_aQ().field_72338_b <= entity.func_174813_aQ().field_72337_e) || !(dist <= 4.0) || !(EntityUtil.getHeadAngle((EntityLivingBase)MutantEndermanEntity.this, x, z) < 3.0f + (1.0f - (float)dist / 4.0f) * 40.0f)) continue;
                    if (entity.func_70097_a(damageSource, attackDamage > 0.0f ? attackDamage + (lower ? 1.0f : 3.0f) : 0.0f)) {
                        MutantEndermanEntity.this.func_174815_a((EntityLivingBase)MutantEndermanEntity.this, entity);
                    }
                    float power = 0.4f + MutantEndermanEntity.this.field_70146_Z.nextFloat() * 0.2f;
                    if (!lower) {
                        power += 0.2f;
                    }
                    entity.field_70159_w = -x / dist * (double)power;
                    entity.field_70181_x = power * 0.6f;
                    entity.field_70179_y = -z / dist * (double)power;
                }
            }
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.setAttackID(0);
        }
    }

    class StareGoal
    extends EntityAIBase {
        private EntityLivingBase attackTarget;

        public StareGoal() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantEndermanEntity.this.func_70638_az();
            MutantEndermanEntity.this.field_70757_a = -MutantEndermanEntity.this.func_70627_aG();
            return MutantEndermanEntity.this.attackID == 3 && this.attackTarget != null;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.setAttackID(3);
            MutantEndermanEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_STARE, 2.5f, 0.7f + MutantEndermanEntity.this.field_70146_Z.nextFloat() * 0.2f);
        }

        public boolean func_75253_b() {
            if (this.attackTarget instanceof EntityLiving) {
                return false;
            }
            return MutantEndermanEntity.this.attackID == 3 && this.attackTarget.func_70089_S() && MutantEndermanEntity.this.attackTick <= 100 && MutantEndermanEntity.this.isBeingLookedAtBy(this.attackTarget);
        }

        public void func_75246_d() {
            MutantEndermanEntity.this.func_70661_as().func_75499_g();
            MutantEndermanEntity.this.func_70671_ap().func_75651_a((Entity)this.attackTarget, 45.0f, 45.0f);
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.setAttackID(0);
            this.attackTarget.func_184210_p();
            this.attackTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)MutantEndermanEntity.this).func_76348_h().func_82726_p(), 2.0f);
            this.attackTarget.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 160 + MutantEndermanEntity.this.field_70146_Z.nextInt(140)));
            double x = MutantEndermanEntity.this.field_70165_t - this.attackTarget.field_70165_t;
            double z = MutantEndermanEntity.this.field_70161_v - this.attackTarget.field_70161_v;
            this.attackTarget.field_70159_w = x * (double)0.1f;
            this.attackTarget.field_70181_x = 0.3f;
            this.attackTarget.field_70179_y = z * (double)0.1f;
            EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
            this.attackTarget = null;
        }
    }

    static class FindTargetGoal
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public FindTargetGoal(MutantEndermanEntity mutantEnderman) {
            super((EntityCreature)mutantEnderman, EntityPlayer.class, 0, false, false, target -> {
                if (mutantEnderman.isBeingLookedAtBy((EntityLivingBase)target)) {
                    mutantEnderman.attackID = 3;
                    return true;
                }
                return EndersoulFragmentEntity.isProtected((Entity)target);
            });
        }

        public boolean func_75250_a() {
            return ((MutantEndermanEntity)this.field_75299_d).attackID == 0 && super.func_75250_a();
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.field_75309_a = null;
        }
    }
}

