/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.projectile;

import chumbanotz.mutantbeasts.entity.EndersoulFragmentEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantSnowGolemEntity;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.util.EntityUtil;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public class ThrowableBlockEntity
extends EntityThrowable
implements IEntityAdditionalSpawnData,
IThrowableEntity {
    private static final DataParameter<Boolean> HELD = EntityDataManager.func_187226_a(ThrowableBlockEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private IBlockState blockState = Blocks.field_150349_c.func_176223_P();
    private UUID ownerUUID;

    public ThrowableBlockEntity(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
    }

    public ThrowableBlockEntity(World worldIn, MutantSnowGolemEntity mutantSnowGolem) {
        super(worldIn, mutantSnowGolem.field_70165_t, mutantSnowGolem.field_70163_u + 1.954, mutantSnowGolem.field_70161_v);
        this.field_70177_z = mutantSnowGolem.field_70177_z;
        this.setThrower((Entity)mutantSnowGolem);
        this.blockState = Blocks.field_150432_aD.func_176223_P();
    }

    public ThrowableBlockEntity(World world, MutantEndermanEntity enderman, int armID) {
        super(world, enderman.field_70165_t, enderman.field_70163_u + 4.7, enderman.field_70161_v);
        this.setThrower((Entity)enderman);
        this.blockState = Block.func_176220_d((int)enderman.heldBlock[armID]);
        boolean outer = armID <= 2;
        boolean right = (armID & 1) == 1;
        EntityLivingBase living = enderman.func_70638_az();
        Vec3d forward = EntityUtil.getDirVector(this.field_70177_z, outer ? 2.7f : 1.4f);
        Vec3d strafe = EntityUtil.getDirVector(this.field_70177_z + (right ? 90.0f : -90.0f), outer ? 2.2f : 2.0f);
        this.field_70165_t += forward.field_72450_a + strafe.field_72450_a;
        this.field_70163_u += (double)((outer ? 2.8f : 1.1f) - 4.8f);
        this.field_70161_v += forward.field_72449_c + strafe.field_72449_c;
        if (living != null) {
            this.func_70186_c(living.field_70165_t - this.field_70165_t, living.field_70163_u + (double)living.func_70047_e() - this.field_70163_u, living.field_70161_v - this.field_70161_v, 1.4f, 1.0f);
        } else {
            this.throwBlock();
        }
    }

    public ThrowableBlockEntity(World world, EntityPlayer player, IBlockState blockState, BlockPos pos) {
        super(world, (EntityLivingBase)player);
        this.setThrower((Entity)player);
        this.blockState = blockState;
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        this.setHeld(true);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(HELD, (Object)false);
    }

    public IBlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public EntityLivingBase func_85052_h() {
        Entity entity;
        if (this.field_70192_c == null && this.ownerUUID != null && this.field_70170_p instanceof WorldServer && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.ownerUUID)) instanceof EntityLivingBase) {
            this.setThrower((Entity)((EntityLivingBase)entity));
        }
        return this.field_70192_c;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.field_70192_c = (EntityLivingBase)entity;
            this.ownerUUID = entity.func_110124_au();
        }
    }

    public boolean isHeld() {
        return (Boolean)this.field_70180_af.func_187225_a(HELD);
    }

    private void setHeld(boolean held) {
        this.field_70180_af.func_187227_b(HELD, (Object)held);
    }

    protected float func_70185_h() {
        if (this.field_70192_c instanceof MutantSnowGolemEntity) {
            return 0.06f;
        }
        if (this.field_70192_c instanceof EntityPlayer) {
            return 0.04f;
        }
        return 0.01f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return this.isHeld() && !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return this.isHeld() && !this.field_70128_L;
    }

    public boolean func_70075_an() {
        return false;
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn != this.field_70192_c) {
            super.func_70108_f(entityIn);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 3) {
            for (int i = 0; i < 60; ++i) {
                double x = this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N;
                double y = this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O);
                double z = this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N;
                double motx = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 3.0f;
                double moty = 0.5f + this.field_70146_Z.nextFloat() * 2.0f;
                double motz = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 3.0f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, x, y, z, motx, moty, motz, new int[]{Block.func_176210_f((IBlockState)this.blockState)});
            }
        }
    }

    public void func_70071_h_() {
        if (this.isHeld()) {
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70052_a(6, this.func_184202_aL());
            }
            this.func_70030_z();
            if (!(this.field_70192_c != null && this.field_70192_c.func_70089_S() && EntitySelectors.field_180132_d.apply((Object)this.field_70192_c) && EndersoulFragmentEntity.isProtected((Entity)this.field_70192_c))) {
                this.setHeld(false);
            } else {
                Vec3d vec = this.field_70192_c.func_70040_Z();
                double x = this.field_70192_c.field_70165_t + vec.field_72450_a * 1.6 - this.field_70165_t;
                double y = this.field_70192_c.field_70163_u + (double)this.field_70192_c.func_70047_e() + vec.field_72448_b * 1.6 - this.field_70163_u;
                double z = this.field_70192_c.field_70161_v + vec.field_72449_c * 1.6 - this.field_70161_v;
                float offset = 0.6f;
                this.field_70159_w = x * (double)offset;
                this.field_70181_x = y * (double)offset;
                this.field_70179_y = z * (double)offset;
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        } else {
            this.field_184539_c = this.field_70192_c;
            super.func_70071_h_();
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_70093_af() || itemStack.func_77973_b() != MBItems.ENDERSOUL_HAND) {
            return false;
        }
        if (this.isHeld() && this.field_70192_c == player) {
            if (!this.field_70170_p.field_72995_K) {
                this.setHeld(false);
                this.throwBlock();
            }
            player.func_184609_a(hand);
            itemStack.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    private void throwBlock() {
        this.field_70177_z = this.field_70192_c.field_70177_z;
        this.field_70125_A = this.field_70192_c.field_70125_A;
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.4f, 1.0f);
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(result.func_178782_a()).func_185890_d((IBlockAccess)this.field_70170_p, result.func_178782_a()) == Block.field_185506_k) {
            return;
        }
        if (this.field_70192_c instanceof MutantSnowGolemEntity) {
            if (result.field_72313_a == RayTraceResult.Type.ENTITY && (this.field_70192_c.func_184191_r(result.field_72308_g) || result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.field_70192_c), 4.0f) && result.field_72308_g instanceof EntityEnderman)) {
                return;
            }
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(2.5, 2.0, 2.5))) {
                if (!entity.func_70067_L() || this.field_70192_c.func_184191_r(entity) || !(this.func_70068_e(entity) <= 6.25)) continue;
                entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.field_70192_c), 4.0f + (float)this.field_70146_Z.nextInt(3));
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(this.blockState.func_177230_c().getSoundType(this.blockState, this.field_70170_p, this.func_180425_c(), (Entity)this).func_185845_c(), 0.8f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.8f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                this.func_70106_y();
            }
        } else if (!this.field_70170_p.field_72995_K) {
            Block block;
            boolean canOwnerGrief;
            BlockPos pos = new BlockPos((Entity)this);
            boolean bl = canOwnerGrief = !(this.field_70192_c instanceof EntityLiving) || ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.field_70192_c);
            if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                if (canOwnerGrief && this.canPlaceBlock(result.func_178782_a(), result.field_178784_b)) {
                    SoundType soundType = this.blockState.func_177230_c().getSoundType(this.blockState, this.field_70170_p, pos, (Entity)this.field_70192_c);
                    this.func_184185_a(soundType.func_185841_e(), (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                } else {
                    this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)this.blockState));
                    if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops") && canOwnerGrief) {
                        block = this.blockState.func_177230_c();
                        this.func_70099_a(new ItemStack(block, 1, block.func_180651_a(this.blockState)), 0.0f);
                    }
                }
            } else if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
                if (result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.field_70192_c), 4.0f) && result.field_72308_g instanceof EntityEnderman) {
                    return;
                }
                this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)this.blockState));
                if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops") && canOwnerGrief) {
                    block = this.blockState.func_177230_c();
                    this.func_70099_a(new ItemStack(block, 1, block.func_180651_a(this.blockState)), 0.0f);
                }
            }
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(2.0))) {
                if (!entity.func_70067_L() || entity.func_70028_i((Entity)this.field_70192_c) || !(this.func_70068_e(entity) <= 4.0)) continue;
                entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.field_70192_c), (float)(6 + this.field_70146_Z.nextInt(3)));
            }
            this.func_70106_y();
        }
    }

    private boolean canPlaceBlock(BlockPos pos, EnumFacing facing) {
        if (this.field_70192_c instanceof EntityPlayer && !((EntityPlayer)this.field_70192_c).func_175142_cm()) {
            return false;
        }
        if (!this.blockState.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) {
            pos = pos.func_177972_a(facing);
        }
        return this.field_70170_p.func_190527_a(this.blockState.func_177230_c(), pos, false, facing, (Entity)this.field_70192_c) && this.field_70170_p.func_180501_a(pos, this.blockState, 11);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("Held", this.isHeld());
        compound.func_74782_a("BlockState", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.blockState));
        if (this.ownerUUID != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUUID);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setHeld(compound.func_74767_n("Held"));
        if (compound.func_150297_b("BlockState", 10)) {
            this.blockState = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("BlockState"));
        }
        if (compound.func_186855_b("OwnerUUID")) {
            this.ownerUUID = compound.func_186857_a("OwnerUUID");
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(Block.func_176210_f((IBlockState)this.blockState));
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.blockState = Block.func_176220_d((int)additionalData.readInt());
    }
}

