/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.gui;

import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.gui.GUIDeathItems;
import de.maxhenkel.gravestone.util.Tools;
import java.util.Arrays;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class Page {
    private DeathInfo.ItemInfo[] items;
    private GUIDeathItems gui;

    public Page(DeathInfo.ItemInfo[] it, GUIDeathItems gui) {
        this.gui = gui;
        int arraySize = 10;
        this.items = new DeathInfo.ItemInfo[10];
        if (it.length < 10) {
            arraySize = it.length;
        }
        for (int i = 0; i < this.items.length && i < arraySize; ++i) {
            this.items[i] = it[i];
        }
    }

    public void drawPage(int num) {
        String title = new TextComponentTranslation("gui.deathinfo.title.items", new Object[0]).func_150254_d();
        int titleWidth = this.gui.getFontRenderer().func_78256_a(title);
        this.gui.getFontRenderer().func_78276_b(TextFormatting.BLACK + "" + TextFormatting.UNDERLINE + title, (this.gui.field_146294_l - titleWidth) / 2, 30, 0);
        String page = new TextComponentTranslation("gui.deathinfo.page", new Object[0]).func_150254_d();
        page = TextFormatting.DARK_GRAY + page + " " + TextFormatting.DARK_GRAY + String.valueOf(num);
        int pageWidth = this.gui.getFontRenderer().func_78256_a(page);
        this.gui.getFontRenderer().func_78276_b(page, (this.gui.field_146294_l - pageWidth) / 2, 43, 0);
        int y = 60;
        int space = 12;
        for (int i = 0; i < this.items.length; ++i) {
            String name;
            DeathInfo.ItemInfo s = this.items[i];
            if (s == null || (name = Tools.translateItem(s.getName(), s.getMeta())) == null) continue;
            this.gui.drawItem(TextFormatting.ITALIC + name, y);
            this.gui.drawItemSize(String.valueOf(s.getStackSize()), y);
            y += 12;
        }
    }

    public String toString() {
        return Arrays.toString(this.items);
    }
}

