/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.ai;

import com.dhanantry.scapeandrunparasites.client.particle.SRPEnumParticle;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPItems;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class EntityPMalleable
extends EntityParasiteBase {
    private static final DataParameter<Byte> HIT = EntityDataManager.func_187226_a(EntityPMalleable.class, (DataSerializer)DataSerializers.field_187191_a);
    private ArrayList<String> resistanceS = new ArrayList();
    private ArrayList<Integer> resistanceI = new ArrayList();
    protected float pointReduction = 0.1f;
    protected int pointCap = 10;
    protected int DamageTypeCap = 5;
    protected double chanceLearn = 0.5;
    protected double chanceLearnFire = 0.0;
    private int onFireA;
    private int onProj;
    protected float adaptationCap = 1.0f;
    protected float regen = 0.0f;
    private int lastTimeDama;
    private int stun;
    public boolean colonySpawned;

    public EntityPMalleable(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HIT, (Object)0);
    }

    @Override
    public void func_70636_d() {
        if (this.stun <= 0) {
            super.func_70636_d();
            if (!this.field_70170_p.field_72995_K) {
                if (this.func_70644_a(SRPPotions.RES_E)) {
                    this.removeAllResistance(1);
                }
                if (this.onFireA > 0) {
                    --this.onFireA;
                }
                if (this.onProj > 0) {
                    --this.onProj;
                }
                if (this.lastTimeDama > 0) {
                    --this.lastTimeDama;
                } else if (!this.field_70128_L && this.func_110143_aJ() > 0.0f && this.regen != 0.0f) {
                    this.func_70606_j(this.func_110143_aJ() + this.regen);
                }
            }
        } else {
            --this.stun;
            if (this.stun <= 0 && this.getParasiteStatus() == 25) {
                this.setParasiteStatus(0);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.field_70180_af.func_187227_b(HIT, (Object)0);
        if (SRPConfig.useOneMind && source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70690_d(new PotionEffect(SRPPotions.SENS_E, 300, 3, false, false));
            ParasiteEventEntity.alertOthers(this, (EntityLivingBase)source.func_76346_g(), this.field_70170_p, 3);
        }
        if (source == DamageSource.field_76380_i || source == DamageSource.field_76368_d) {
            return super.func_70097_a(source, amount);
        }
        if ((source == DamageSource.field_76372_a || source == DamageSource.field_76370_b) && this.field_70146_Z.nextDouble() < this.chanceLearnFire) {
            this.onFireA = SRPConfig.fireTickWindow;
        }
        float times = this.hasResistance(source.func_76355_l());
        float bonus = times * this.pointReduction * amount;
        amount = Math.max(amount - bonus * this.adaptationCap, 0.0f);
        if (bonus != 0.0f && amount != 0.0f) {
            this.particleStatus((byte)9);
            this.particleStatus((byte)9);
        }
        if (amount == 0.0f) {
            this.particleStatus((byte)9);
            this.particleStatus((byte)9);
        }
        this.outOfRange(source);
        boolean flag = super.func_70097_a(source, amount);
        if (flag) {
            this.lastTimeDama = SRPConfig.regenTimer;
        }
        return flag;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        Item wea = player.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b();
        if (wea == SRPItems.itembase) {
            String out = "Current adaptation for " + EntityList.func_191301_a((Entity)this).toString() + " (Damage type, points): ";
            for (int i = 0; i < this.resistanceS.size(); ++i) {
                out = out + "[" + this.resistanceS.get(i) + ", " + this.resistanceI.get(i) + "] ";
            }
            player.func_145747_a((ITextComponent)new TextComponentString(out));
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public int hasResistance(String damage) {
        if (this.func_70644_a(SRPPotions.RES_E) || this.field_70729_aU) {
            return 0;
        }
        if (this.checkList(damage)) {
            return 0;
        }
        if (this.DamageTypeCap <= 0) {
            return 0;
        }
        if (this.field_70146_Z.nextDouble() < this.chanceLearn) {
            this.addResistance(damage);
        }
        for (int i = 0; i < this.resistanceS.size(); ++i) {
            if (!this.resistanceS.get(i).equals(damage)) continue;
            int dama = this.resistanceI.get(i);
            if (dama <= this.pointCap) {
                this.field_70180_af.func_187227_b(HIT, (Object)1);
            } else {
                this.field_70180_af.func_187227_b(HIT, (Object)2);
            }
            return Math.min(dama, this.pointCap);
        }
        return 0;
    }

    public void addResistance(String damage) {
        if (this.onFireA > 0) {
            return;
        }
        boolean flag = true;
        for (int i = 0; i < this.resistanceS.size(); ++i) {
            if (!this.resistanceS.get(i).equals(damage)) continue;
            int iiii = this.resistanceI.get(i) + 1;
            this.resistanceI.set(i, iiii);
            flag = false;
            if (iiii > this.pointCap) break;
            this.particleStatus((byte)5);
            this.particleStatus((byte)5);
            break;
        }
        if (flag) {
            if (this.resistanceS.size() >= this.DamageTypeCap) {
                return;
            }
            this.resistanceS.add(damage);
            this.resistanceI.add(1);
            this.particleStatus((byte)5);
            this.particleStatus((byte)5);
        }
    }

    public void removeAllResistance(int value) {
        for (int i = 0; i < this.resistanceS.size(); ++i) {
            int iiii = this.resistanceI.get(i) - value;
            if (iiii <= 0) {
                this.resistanceI.remove(i);
                this.resistanceS.remove(i);
                continue;
            }
            this.resistanceI.set(i, iiii);
        }
    }

    public ArrayList<String> getResistanceS() {
        return this.resistanceS;
    }

    public ArrayList<Integer> getResistanceI() {
        return this.resistanceI;
    }

    public void copyResistancesFrom(EntityPMalleable in) {
        this.resistanceS = in.getResistanceS();
        this.resistanceI = in.getResistanceI();
    }

    public void cutResistances(int in) {
        if (this.DamageTypeCap <= 0) {
            return;
        }
        System.out.println(this.DamageTypeCap);
        this.stun += 40;
        this.setParasiteStatus(25);
        this.func_184185_a(SRPSounds.TENDRIL, 3.0f, 1.0f);
        this.func_70690_d(new PotionEffect(SRPPotions.RAGE_E, 200, 1, false, false));
        SRPPotions.applyBleeding((EntityLivingBase)this, 100, 0);
        if (in % 2 != 0) {
            ++in;
        }
        this.DamageTypeCap -= in;
        System.out.println(this.DamageTypeCap);
        if (this.resistanceI.size() != this.resistanceS.size()) {
            this.resistanceI = new ArrayList();
            this.resistanceS = new ArrayList();
            this.DamageTypeCap = 0;
            return;
        }
        int size = this.resistanceS.size() - in;
        if (size <= 0) {
            this.resistanceI = new ArrayList();
            this.resistanceS = new ArrayList();
            return;
        }
        while (in <= 0) {
            if (this.resistanceI.isEmpty()) {
                this.DamageTypeCap = 0;
                return;
            }
            if (this.resistanceI.size() == 0) {
                this.DamageTypeCap = 0;
                return;
            }
            this.resistanceI.remove(0);
            this.resistanceS.remove(0);
            --in;
        }
    }

    public void increaseDamageCap(int in) {
        this.DamageTypeCap += in;
    }

    private boolean checkList(String damage) {
        return ParasiteEventEntity.checkName(damage, SRPConfig.damageTypeBlackList, SRPConfig.damageTypeBlackListWhite);
    }

    private void outOfRange(DamageSource source) {
        if (this.func_70638_az() == null) {
            Vec3d vec3d;
            if (source.func_76346_g() instanceof Entity) {
                Entity sss = source.func_76346_g();
                if (sss instanceof EntityPlayer) {
                    EntityPlayer pl = (EntityPlayer)sss;
                    if (pl.field_71075_bZ.field_75102_a || pl.func_175149_v()) {
                        return;
                    }
                }
                if (this.func_70685_l(sss) && SRPPotions.applySense((EntityLivingBase)this, 600, this.func_70068_e(sss), 50)) {
                    this.func_70661_as().func_75492_a(sss.field_70165_t, sss.field_70163_u, sss.field_70161_v, 1.3);
                }
            } else if (this.func_70661_as().func_75505_d() == null && (vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this, (int)16, (int)7, (Vec3d)new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) != null && !this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.3) && (vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this, (int)16, (int)7, (Vec3d)new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) != null && !this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.3) && this.field_70173_aa % 20 == 0) {
                this.func_70661_as().func_75499_g();
                double dd0 = vec3d.field_72450_a - this.field_70165_t;
                double dd1 = vec3d.field_72449_c - this.field_70161_v;
                float f = MathHelper.func_76133_a((double)(dd0 * dd0 + dd1 * dd1));
                this.field_70159_w += dd0 / (double)f * 1.0 * (double)0.8f + this.field_70159_w * (double)0.2f;
                this.field_70179_y += dd1 / (double)f * 1.0 * (double)0.8f + this.field_70179_y * (double)0.2f;
                this.field_70181_x = 0.15;
            }
        }
    }

    public byte getHitStatus() {
        return (Byte)this.field_70180_af.func_187225_a(HIT);
    }

    public String getMostCommonDamage() {
        if (this.func_70644_a(SRPPotions.RES_E)) {
            return null;
        }
        String atm = null;
        int times = 0;
        for (int i = 0; i < this.resistanceS.size(); ++i) {
            if (this.resistanceI.get(i) <= times) continue;
            times = this.resistanceI.get(i);
            atm = this.resistanceS.get(i);
        }
        return atm;
    }

    public void removeCommonDamage(String damage, int times) {
        for (int i = 0; i < this.resistanceS.size(); ++i) {
            if (!this.resistanceS.get(i).equals(damage)) continue;
            int neww = this.resistanceI.get(i) - times;
            if (neww <= 0) {
                this.resistanceS.remove(i);
                this.resistanceI.remove(i);
                continue;
            }
            this.resistanceI.set(i, neww);
        }
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            ParasiteEventEntity.checkColony(this.field_70170_p, cause, this);
        }
    }

    @Override
    protected void onDeathUpdateOG() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            if (this.field_70170_p.field_72995_K) {
                for (int k = 0; k < 20; ++k) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 127, 0, 0);
                }
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("paracolony", this.colonySpawned);
        if (this.resistanceS.size() != this.resistanceI.size()) {
            return;
        }
        NBTTagList allResS = new NBTTagList();
        NBTTagList allResI = new NBTTagList();
        for (int i = 0; i < this.resistanceS.size(); ++i) {
            String res = this.resistanceS.get(i);
            NBTTagCompound resT = new NBTTagCompound();
            resT.func_74778_a("resistance" + i, res);
            allResS.func_74742_a((NBTBase)resT);
            int resi = this.resistanceI.get(i);
            NBTTagCompound resU = new NBTTagCompound();
            resU.func_74768_a("resistance" + i, resi);
            allResI.func_74742_a((NBTBase)resU);
        }
        compound.func_74768_a("damagetypecap", this.DamageTypeCap);
        compound.func_74782_a("sprresistances", (NBTBase)allResS);
        compound.func_74782_a("sprresistancei", (NBTBase)allResI);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("paracolony", 99)) {
            this.colonySpawned = compound.func_74767_n("paracolony");
        }
        if (compound.func_150297_b("damagetypecap", 99)) {
            this.DamageTypeCap = compound.func_74762_e("damagetypecap");
        }
        if (compound.func_74764_b("sprresistances")) {
            NBTTagList allResS = compound.func_150295_c("sprresistances", 10);
            NBTTagList allResI = compound.func_150295_c("sprresistancei", 10);
            if (allResS.func_74745_c() != allResI.func_74745_c()) {
                return;
            }
            for (int i = 0; i < allResS.func_74745_c(); ++i) {
                NBTTagCompound resT = allResS.func_150305_b(i);
                String res = resT.func_74779_i("resistance" + i);
                this.resistanceS.add(i, res);
                NBTTagCompound resU = allResI.func_150305_b(i);
                int resi = resU.func_74762_e("resistance" + i);
                this.resistanceI.add(i, resi);
            }
        }
    }
}

