/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.ai;

import com.dhanantry.scapeandrunparasites.block.BlockInfestedStain;
import com.dhanantry.scapeandrunparasites.client.particle.ParticleSpawner;
import com.dhanantry.scapeandrunparasites.client.particle.SRPEnumParticle;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityCanSummon;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityPStationary;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.SRPWorldData;
import com.dhanantry.scapeandrunparasites.world.biome.BiomeParasite;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityPVenkrol
extends EntityPStationary
implements EntityCanSummon {
    protected int totalP;
    protected int actualP;
    protected boolean convert = true;
    protected int[] mobID;
    protected int[] mobPT;
    protected boolean rsSpawned = false;
    protected byte stage;
    protected float body;
    protected int neededTime;
    protected int actualTime;
    protected int topParticles;

    public EntityPVenkrol(World worldIn) {
        super(worldIn);
        this.killcount = -10.0;
        this.canD = SRPConfig.rsDespawn;
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.folow);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.jumpT);
    }

    public void setConvert(boolean in) {
        this.convert = in;
    }

    public int setGT(int minGrowTime, int maxGrowTime) {
        int atm = maxGrowTime - minGrowTime + 1;
        if (atm <= 0 || maxGrowTime <= minGrowTime) {
            return 1;
        }
        return this.field_70146_Z.nextInt(atm) + minGrowTime;
    }

    public void setActualT(int in) {
        this.actualTime = in;
    }

    public int getActualT() {
        return this.actualTime;
    }

    public int getNeededTime() {
        return this.neededTime;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.topParticles > 0) {
            --this.topParticles;
        }
        this.freeDead();
    }

    protected void freeDead() {
        if (!this.field_70170_p.field_72995_K && this.field_70128_L) {
            int meta;
            BlockPos floor;
            World world;
            if (this.convert && (world = this.field_70170_p).func_180495_p(floor = new BlockPos((Entity)this).func_177977_b()).func_177230_c() instanceof BlockInfestedStain && (meta = world.func_180495_p(floor).func_177230_c().func_176201_c(world.func_180495_p(floor))) == 1) {
                this.field_70170_p.func_175656_a(floor, SRPBlocks.InfestedStain.func_176223_P().func_177226_a((IProperty)BlockInfestedStain.STAGE, (Comparable)Integer.valueOf(4)));
                world.func_175654_a(floor, SRPBlocks.InfestedStain.func_176223_P().func_177226_a((IProperty)BlockInfestedStain.STAGE, (Comparable)Integer.valueOf(4)).func_177230_c(), 40, 5);
            }
            if (this.rsSpawned) {
                SRPWorldData data = SRPWorldData.get(this.field_70170_p);
                data.setCurrentV(-1);
            }
        }
    }

    public float getBODY() {
        return this.body;
    }

    public byte getStageV() {
        return this.stage;
    }

    @Override
    public void addID(int id, int points) {
        for (int i = 0; i < this.mobID.length; ++i) {
            if (this.mobID[i] != -777) continue;
            this.mobID[i] = id;
            this.mobPT[i] = points;
            return;
        }
    }

    @Override
    public int IDable() {
        int flag = 0;
        for (int i = 0; i < this.mobID.length; ++i) {
            if (this.mobID[i] != -777) continue;
            ++flag;
        }
        if (flag > this.totalP) {
            flag = this.totalP;
        }
        return flag;
    }

    @Override
    public void checkID() {
        for (int i = 0; i < this.mobID.length; ++i) {
            Entity flag;
            if (this.mobID[i] <= 0 || (flag = this.field_70170_p.func_73045_a(this.mobID[i])) != null) continue;
            this.mobID[i] = -777;
            int negative = this.mobPT[i] * -1;
            this.setActualParasites(negative);
        }
    }

    @Override
    public int getTotalParasites() {
        return this.totalP;
    }

    @Override
    public int getActualParasites() {
        return this.actualP;
    }

    @Override
    public void setActualParasites(int i) {
        this.actualP += i;
    }

    public void setRSSpawned(boolean in) {
        this.rsSpawned = in;
    }

    public boolean getRSSpawned() {
        return this.rsSpawned;
    }

    @Override
    protected boolean func_70692_ba() {
        if (this.field_70170_p.func_180494_b(this.func_180425_c()) instanceof BiomeParasite) {
            return true;
        }
        return super.func_70692_ba();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        float red = this.getParasiteStatus() == 0 ? 0.4f : 1.0f;
        return super.func_70097_a(source, amount * red);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("belongtors", this.getRSSpawned());
        compound.func_74768_a("tickse", this.actualTime);
        compound.func_74768_a("neededtime", this.neededTime);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("belongtors", 99)) {
            this.setRSSpawned(compound.func_74767_n("belongtors"));
        }
        if (compound.func_150297_b("tickse", 99)) {
            this.actualTime = compound.func_74762_e("tickse");
        }
        if (compound.func_150297_b("neededtime", 99)) {
            this.neededTime = compound.func_74762_e("neededtime");
        }
    }

    @Override
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.topParticles = 20;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticlesTop(SRPEnumParticle particleType, int r, int g, int b) {
        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
        ParticleSpawner.spawnParticle(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)this.field_70131_O + (double)this.field_70146_Z.nextFloat() * ((double)(this.field_70131_O - this.func_70047_e()) + 0.5), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, r, g, b);
    }
}

