/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.ai;

import com.dhanantry.scapeandrunparasites.block.IMetaName;
import com.dhanantry.scapeandrunparasites.client.particle.ParticleSpawner;
import com.dhanantry.scapeandrunparasites.client.particle.SRPEnumParticle;
import com.dhanantry.scapeandrunparasites.entity.EntityGore;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIParasiteFollow;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIWanderStatus;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.item.tool.WeaponToolMeleeBase;
import com.dhanantry.scapeandrunparasites.item.tool.WeaponToolRangeBase;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.SRPWorldData;
import com.dhanantry.scapeandrunparasites.world.biome.BiomeParasite;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityParasiteBase
extends EntityMob {
    protected double killcount = 0.0;
    protected boolean canD = true;
    private int waitInt;
    private boolean canWorkTask;
    private EntityParasiteBase owner;
    private static final DataParameter<Byte> SPECIAL = EntityDataManager.func_187226_a(EntityParasiteBase.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> SELFE = EntityDataManager.func_187226_a(EntityParasiteBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(EntityParasiteBase.class, (DataSerializer)DataSerializers.field_187192_b);
    protected int srpTicks;
    protected int lastActiveTime;
    protected int timeSinceIgnited;
    protected int fuseTime = 40;
    protected byte canModRender = 0;
    protected int attackCooldown;
    protected double madeRng = -1.0;
    protected byte type = 0;
    protected int damageCap = 1;
    protected float MiniDamage = 0.0f;
    protected byte phaseCreated;
    protected EntityAIJumping jumpT = new EntityAIJumping((EntityLiving)this);
    protected EntityAIWait wait = new EntityAIWait();
    protected EntityAIParasiteFollow folow = new EntityAIParasiteFollow(this, 1.3, 16.0, 6.0, true);
    protected EntityAIWanderStatus aiWander = new EntityAIWanderStatus(this, 1.0, 0.001f, true);
    protected int oneMindDeathValue;
    protected int liquidLeap;
    private float blockH;
    private int BGheight;
    private int BGrange;
    private int items;
    private boolean SkillBGflag;
    private int attacking;
    private double targetX;
    private double targetZ;
    private float leapMotionY;
    private double jumpSpeed;
    private int jumpR;
    private boolean SkillLeapFlag;

    public EntityParasiteBase(World worldIn) {
        super(worldIn);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.wait);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiWander);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.folow);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.jumpT);
        this.attackCooldown = 0;
        this.canWorkTask = true;
        this.srpTicks = 0;
        this.madeRng = -1.0;
        this.SkillBGflag = false;
        this.SkillLeapFlag = false;
        this.oneMindDeathValue = 1;
    }

    public void setCreatedPhase(byte in) {
        this.phaseCreated = in;
    }

    public abstract int getParasiteIDRegister();

    public void applyBonuses(int colony, int node, byte phase) {
        this.phaseCreated = phase;
        if (this.phaseCreated >= SRPConfig.evolutionAssimilatedDehiding) {
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, true));
        }
        this.setColonyBonus(colony);
        this.setNodeBonus(node);
    }

    protected void setColonyBonus(int totalColonyPoints) {
        if (totalColonyPoints == 0) {
            return;
        }
        double bonus = (float)totalColonyPoints / SRPConfig.colonyExtraHealthPoint * SRPConfig.colonyExtraHealthValue;
        double currentV = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(currentV + currentV * bonus);
        this.func_70606_j((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
        bonus = (float)totalColonyPoints / SRPConfig.colonyExtraArmorPoint * SRPConfig.colonyExtraArmorValue;
        currentV = this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(currentV + currentV * bonus);
        bonus = (float)totalColonyPoints / SRPConfig.colonyExtraDamagePoint * SRPConfig.colonyExtraDamageValue;
        currentV = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(currentV + currentV * bonus);
        bonus = (float)totalColonyPoints / SRPConfig.colonyExtraKDResPoint * SRPConfig.colonyExtraKDResValue;
        currentV = this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(currentV + currentV * bonus);
        bonus = (float)totalColonyPoints / SRPConfig.colonyDamageCapPoint * SRPConfig.colonyDamageCapValue;
        this.damageCap = (int)((double)this.damageCap + (double)this.damageCap * bonus);
    }

    protected void setNodeBonus(int totalPoints) {
        if (totalPoints == 0) {
            return;
        }
        String[] here = new String[3];
        for (String i : SRPConfig.potionEffectForNodes) {
            here = i.split(";");
            int level = Integer.parseInt(here[0]);
            if (totalPoints < level) continue;
            int amp = Integer.parseInt(here[2]);
            Potion potion = Potion.func_180142_b((String)here[1]);
            if (potion == null) continue;
            this.func_70690_d(new PotionEffect(potion, 7777, amp));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPECIAL, (Object)0);
        this.field_70180_af.func_187214_a(SELFE, (Object)-1);
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
    }

    public int getParasiteReferenceID() {
        return 0;
    }

    public void cannotDespawn(boolean in) {
        this.canD = in;
    }

    public boolean canDespawnMob() {
        return this.canD;
    }

    protected boolean func_70692_ba() {
        return this.canD;
    }

    public void func_70636_d() {
        if (this.func_175446_cd()) {
            return;
        }
        if (this.getWait() > 0) {
            int j1 = this.getWait() - 1;
            if (j1 == 0) {
                this.setParasiteStatus(0);
            }
            this.setWait(j1);
        } else {
            super.func_70636_d();
        }
        if (!this.field_70170_p.field_72995_K) {
            ++this.srpTicks;
            byte k = this.getParasiteStatus();
            if (this.getAttackCooldownAni() != 0 || k == 1 || k == 2) {
                if (this.getAttackCooldownAni() != 0) {
                    int i = this.getAttackCooldownAni() - 1;
                    this.setAttackCooldownAni(i);
                }
                if (k == 1 || k == 2) {
                    if (this.func_70638_az() != null) {
                        if (!this.func_70638_az().func_70089_S()) {
                            this.func_70624_b(null);
                            this.setParasiteStatus(0);
                        }
                    } else {
                        this.setParasiteStatus(0);
                        this.func_70624_b(null);
                    }
                }
            }
            if (this.srpTicks % 15 == 0 && this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() instanceof BlockLiquid && this.func_70638_az() != null) {
                ++this.liquidLeap;
                if (this.liquidLeap > 4) {
                    this.liquidLeap = 4;
                }
            }
            if (this.srpTicks > 30) {
                this.srpTicks = 0;
                if (this.blockH != 0.0f) {
                    this.checkItemsFloor(this.field_70146_Z.nextInt(2) * 10);
                }
                if (this.func_70638_az() instanceof EntityPlayer) {
                    this.fearPlayer(this.func_70638_az());
                }
                if (SRPConfig.useEvolution && this.killcount >= 0.0) {
                    switch (this.phaseCreated) {
                        case 1: {
                            this.killcount += SRPConfig.phaseKillCountPlusOne;
                            break;
                        }
                        case 2: {
                            this.killcount += SRPConfig.phaseKillCountPlusTwo;
                            break;
                        }
                        case 3: {
                            this.killcount += SRPConfig.phaseKillCountPlusThree;
                            break;
                        }
                        case 4: {
                            this.killcount += SRPConfig.phaseKillCountPlusFour;
                            break;
                        }
                        case 5: {
                            this.killcount += SRPConfig.phaseKillCountPlusFive;
                            break;
                        }
                        case 6: {
                            this.killcount += SRPConfig.phaseKillCountPlusSix;
                            break;
                        }
                        case 7: {
                            this.killcount += SRPConfig.phaseKillCountPlusSeven;
                            break;
                        }
                        case 8: {
                            this.killcount += SRPConfig.phaseKillCountPlusEight;
                        }
                    }
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.killcount >= 0.0) {
                    this.killcount += SRPConfig.killcountplus;
                }
            }
        }
        if (this.liquidLeap >= 1) {
            double h = 0.1;
            double str = 0.5;
            EntityLivingBase entitylivingbase = this.func_70638_az();
            if (entitylivingbase != null) {
                Block bl = this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c();
                if (!bl.func_176205_b((IBlockAccess)this.field_70170_p, this.func_180425_c())) {
                    h = 0.3;
                    str = 1.0;
                }
                this.func_70661_as().func_75499_g();
                --this.liquidLeap;
                double dd0 = entitylivingbase.field_70165_t - this.field_70165_t;
                double dd1 = entitylivingbase.field_70161_v - this.field_70161_v;
                float f = MathHelper.func_76133_a((double)(dd0 * dd0 + dd1 * dd1));
                this.field_70159_w += dd0 / (double)f * str * (double)0.8f + this.field_70159_w * (double)0.2f;
                this.field_70179_y += dd1 / (double)f * str * (double)0.8f + this.field_70179_y * (double)0.2f;
                this.field_70181_x = h;
            }
        }
    }

    protected void fearPlayer(EntityLivingBase player) {
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getWait() > 0) {
            int j1 = this.getWait() - 1;
            if (j1 == 0) {
                this.setParasiteStatus(0);
            }
            this.setWait(j1);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.madeRng == -1.0) {
            this.madeRng = this.field_70146_Z.nextInt(2);
            if (this.madeRng == 0.0) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)40);
            }
        }
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, amount);
        }
        if (source == DamageSource.field_76368_d) {
            this.skillBreakBlocks();
        }
        if (source == DamageSource.field_76372_a || source == DamageSource.field_76370_b) {
            if (!this.field_70178_ae) {
                super.func_70097_a(source, amount * SRPConfig.firemultyplier);
            } else {
                return false;
            }
        }
        for (int i = 0; i < SRPConfig.parasiteWeakTo.length; ++i) {
            String[] here;
            if (SRPConfig.parasiteWeakTo[i] == null || !(here = SRPConfig.parasiteWeakTo[i].split(";"))[0].equals(source.func_76355_l())) continue;
            amount *= (float)Integer.parseInt(here[1]);
        }
        if (this.damageCap > 1) {
            if (ParasiteEventEntity.checkName(source.func_76355_l(), SRPConfig.damageCapBlackList, SRPConfig.damageCapBlackListWhite)) {
                return super.func_70097_a(source, amount);
            }
            float damage = this.func_110138_aP() / (float)this.damageCap + this.func_110138_aP() % (float)this.damageCap * 0.5f;
            if (amount >= damage) {
                source.func_76348_h();
            }
            return super.func_70097_a(source, Math.min(amount, damage));
        }
        if (SRPConfig.useOneMind && source.func_76364_f() instanceof EntityLivingBase && this.func_70638_az() == source.func_76364_f()) {
            ParasiteEventEntity.alertOthers(this, this.func_70638_az(), this.field_70170_p, 3);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean green = entityIn instanceof EntityLivingBase;
        this.attackEntityAsMobMinimum(entityIn, green);
        boolean flag = super.func_70652_k(entityIn);
        if (flag && green) {
            this.setAttackCooldownAni(100);
            if (SRPConfig.useOneMind) {
                ParasiteEventEntity.alertOthers(this, (EntityLivingBase)entityIn, this.field_70170_p, 3);
            }
        }
        return flag;
    }

    protected boolean attackEntityAsMobMinimum(Entity entityIn, boolean green) {
        if (this.MiniDamage != 0.0f && green) {
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (itemstack1.func_77973_b() instanceof ItemShield && entityplayer.func_184585_cz() && !entityplayer.func_184811_cZ().func_185141_a(itemstack1.func_77973_b())) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1 && this.type >= 31) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                    this.func_184590_k(this.MiniDamage);
                    return true;
                }
            }
            EntityLivingBase target = (EntityLivingBase)entityIn;
            DamageSource s = DamageSource.func_76358_a((EntityLivingBase)this);
            float f1 = target.func_110143_aJ();
            if (f1 <= 0.0f) {
                return false;
            }
            if (target instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75098_d) {
                return false;
            }
            target.func_110142_aN().func_94547_a(s, f1, this.MiniDamage);
            target.func_70606_j(f1 - this.MiniDamage);
            double d1 = this.field_70165_t - target.field_70165_t;
            double d0 = this.field_70161_v - target.field_70161_v;
            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                d1 = (Math.random() - Math.random()) * 0.01;
                d0 = (Math.random() - Math.random()) * 0.01;
            }
            target.func_70653_a((Entity)this, 0.4f, d1, d0);
            this.field_70170_p.func_72960_a((Entity)target, (byte)2);
            if (target.func_110143_aJ() <= 0.0f) {
                this.killcount += 1.0;
                target.func_70645_a(s);
            }
        }
        return true;
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        if (this.killcount >= 0.0) {
            this.killcount += 1.0;
        }
        if (!this.field_70170_p.field_72995_K && SRPConfig.useEvolution) {
            SRPWorldData data = SRPWorldData.get(this.field_70170_p);
            data.setTotalKills(SRPConfig.valueKill, true, this.field_70170_p);
        }
        if (entityLivingIn.func_70644_a(SRPPotions.COTH_E) && this.field_70146_Z.nextDouble() < (double)SRPConfig.cothConvert) {
            ParasiteEventEntity.convertEntity(entityLivingIn, entityLivingIn.getEntityData(), true, SRPConfig.COTHVictimParasite);
        }
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 80, 0, false, false));
        this.setWait(10);
    }

    public int getSelfeState() {
        return (Integer)this.field_70180_af.func_187225_a(SELFE);
    }

    public void setSelfeState(int state) {
        this.field_70180_af.func_187227_b(SELFE, (Object)state);
    }

    public int getLLeap() {
        return this.liquidLeap;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == MobEffects.field_76436_u || potioneffectIn.func_188419_a() == SRPPotions.COTH_E || potioneffectIn.func_188419_a() == SRPPotions.VIRA_E || potioneffectIn.func_188419_a() == SRPPotions.CORRO_E) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    protected boolean func_184228_n(Entity entityIn) {
        if (entityIn instanceof EntityBoat || entityIn instanceof EntityMinecart) {
            return false;
        }
        return super.func_184228_n(entityIn);
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        if (cls == EntityPlayer.class || cls == EntityPlayerMP.class) {
            return true;
        }
        String name = null;
        try {
            name = EntityList.func_191306_a(cls).toString();
        }
        catch (Exception e) {
            return true;
        }
        if (name == null) {
            return true;
        }
        if (name.contains("srparasites")) {
            return false;
        }
        return !SRPConfig.mobAttackingFull || !ParasiteEventEntity.checkName(name, SRPConfig.mobattackingBlackList, SRPConfig.mobattackingBlackListWhite);
    }

    public void setWorkTask(boolean in) {
        this.canWorkTask = in;
    }

    public boolean shouldWorkTask() {
        return this.canWorkTask;
    }

    public void setParasiteToFollow(@Nullable EntityParasiteBase in) {
        this.owner = in;
    }

    public EntityParasiteBase getParasiteFollowing() {
        if (this.owner != null) {
            if (this.owner.func_70089_S()) {
                return this.owner;
            }
            this.setParasiteToFollow(null);
        }
        return null;
    }

    public byte getParasiteStatus() {
        return (Byte)this.field_70180_af.func_187225_a(SPECIAL);
    }

    public void setParasiteStatus(int state) {
        this.field_70180_af.func_187227_b(SPECIAL, (Object)((byte)state));
    }

    public void setWait(int in) {
        this.waitInt = in;
    }

    public int getWait() {
        return this.waitInt;
    }

    public byte getPhaseCreated() {
        return this.phaseCreated;
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    public void setSkin(int texture) {
        this.field_70180_af.func_187227_b(SKIN, (Object)texture);
    }

    public int getCCDeathValue() {
        return this.oneMindDeathValue;
    }

    public void setAttackCooldownAni(int i) {
        this.attackCooldown = i;
    }

    public int getAttackCooldownAni() {
        return this.attackCooldown;
    }

    public void setKillC(double i) {
        this.killcount = i;
    }

    public double getKillC() {
        return this.killcount;
    }

    public byte getParasiteType() {
        return this.type;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            ParasiteEventEntity.spawnBeckon(this.field_70170_p, cause, this);
            ParasiteEventEntity.leaveScent(this.field_70170_p, cause, this);
        }
        if (cause.func_76346_g() != null && cause.func_76346_g() instanceof EntityPlayer) {
            this.checkWeapon((EntityPlayer)cause.func_76346_g());
        }
    }

    private void checkWeapon(EntityPlayer playerIn) {
        if (!SRPConfig.useOneMind) {
            return;
        }
        Item ga = playerIn.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b();
        if ((ga instanceof WeaponToolMeleeBase || ga instanceof WeaponToolRangeBase) && this.field_70146_Z.nextInt(10) == 0) {
            playerIn.func_70690_d(new PotionEffect(SRPPotions.PREY_E, 600, 0, false, false));
        }
    }

    protected void func_70609_aI() {
        if (this.canModRender == 1) {
            if (this.madeRng == 0.0) {
                this.setSelfeState(1);
                this.setParasiteStatus(6);
                this.dyingBurst(true, 1);
            } else {
                this.onDeathUpdateOG();
            }
        } else if (this.canModRender == 2) {
            if (this.madeRng == 0.0) {
                this.selfExplode();
                this.OnDeathHelper();
            } else {
                this.onDeathUpdateOG();
            }
        } else {
            this.onDeathUpdateOG();
        }
    }

    protected void onDeathUpdateOG() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            if (this.field_70170_p.field_72995_K) {
                for (int k = 0; k < 20; ++k) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 127, 0, 0);
                }
            }
        }
    }

    protected void dyingBurst(boolean fromDeath, int value) {
        int i = this.getSelfeState();
        if (i <= 0 || this.timeSinceIgnited == 0) {
            // empty if block
        }
        this.timeSinceIgnited += i * value;
        if (this.timeSinceIgnited < 0) {
            this.timeSinceIgnited = 0;
        }
        if (this.timeSinceIgnited >= this.fuseTime) {
            this.timeSinceIgnited = this.fuseTime;
            this.selfExplode();
            if (fromDeath) {
                this.OnDeathHelper();
            }
        }
    }

    public void OnDeathHelper() {
        if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
            int j;
            int i = this.func_70693_a(this.field_70717_bb);
            for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
        }
    }

    protected void selfExplode() {
        if (this.field_70170_p.field_72995_K) {
            this.spawnEffectsGore();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.spawnGore();
            this.func_184185_a(SRPSounds.MOBEXPLOTION, 1.0f, 1.0f);
            this.field_70729_aU = true;
            this.func_70106_y();
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityareaeffectcloud.func_184483_a(this.field_70130_N);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            entityareaeffectcloud.func_184496_a(new PotionEffect(MobEffects.field_76436_u, 300, 0));
            entityareaeffectcloud.func_184496_a(new PotionEffect(SRPPotions.COTH_E, 3600, 0, false, false));
            this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
        }
    }

    protected void spawnGore() {
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.func_70638_az() != null) {
            // empty if block
        }
        super.func_82167_n(entityIn);
    }

    public boolean func_70601_bi() {
        if (SRPConfig.useEvolution) {
            if (this.phaseCreated >= SRPConfig.evolutionSpawningIgnoreSunlight) {
                IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
                return iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevelTwo() && SRPConfig.spawnDays <= (int)this.field_70170_p.func_72820_D();
            }
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
            return iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevelOne() && SRPConfig.spawnDays <= (int)this.field_70170_p.func_72820_D();
        }
        if (SRPConfig.ignoreL) {
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
            return iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevelTwo() && SRPConfig.spawnDays <= (int)this.field_70170_p.func_72820_D();
        }
        IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevelOne() && SRPConfig.spawnDays <= (int)this.field_70170_p.func_72820_D();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValidLightLevelOne() {
        if (this.field_70170_p.func_180494_b(this.func_180425_c()) instanceof BiomeParasite) {
            return this.isValidLightLevelTwo();
        }
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        if (i > this.field_70146_Z.nextInt(8)) return false;
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (!(this.func_180484_a(blockPos) >= 0.0f)) return false;
        return true;
    }

    protected boolean isValidLightLevelTwo() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        int light = this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, blockpos);
        if (light > this.field_70146_Z.nextInt(1000) || light > 7) {
            return false;
        }
        return this.field_70146_Z.nextInt(8) == 0;
    }

    private boolean isInParasiteBiome() {
        return this.field_70146_Z.nextInt(8) == 0 && this.field_70170_p.func_180494_b(this.func_180425_c()) instanceof BiomeParasite;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("parasitetype", this.getSkin());
        compound.func_74757_a("parasitedespawn", this.func_70692_ba());
        compound.func_74776_a("parasitekills", (float)this.getKillC());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("parasitetype", 99)) {
            this.setSkin(compound.func_74762_e("parasitetype"));
        }
        if (compound.func_150297_b("parasitedespawn", 99)) {
            this.cannotDespawn(compound.func_74767_n("parasitedespawn"));
        }
        if (compound.func_150297_b("parasitekills", 99)) {
            this.setKillC(compound.func_74760_g("parasitekills"));
        }
    }

    public void particleStatus(byte id) {
        this.field_70170_p.func_72960_a((Entity)this, id);
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnEffectsGore() {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 5: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.RHAPPY, 0, 0, 0);
                }
                break;
            }
            case 6: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 127, 0, 0);
                }
                break;
            }
            case 7: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(EnumParticleTypes.EXPLOSION_LARGE);
                }
                break;
            }
            case 8: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.BIOMASS, 0, 0, 0);
                }
                break;
            }
            case 9: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(EnumParticleTypes.CRIT_MAGIC);
                }
                break;
            }
            case 10: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(EnumParticleTypes.CRIT_MAGIC);
                }
                break;
            }
            case 11: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 0, 0, 0);
                }
                break;
            }
            case 12: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 0, 0, 0);
                }
                break;
            }
            case 13: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GSPLASH, 4, -1, -1);
                }
                break;
            }
            case 40: {
                this.madeRng = 0.0;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(EnumParticleTypes particleType) {
        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
        this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(SRPEnumParticle particleType, int r, int g, int b) {
        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
        ParticleSpawner.spawnParticle(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, r, g, b);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticlesGore(SRPEnumParticle particleType, int r, int g, int b) {
        double d0 = (float)this.field_70165_t + this.field_70146_Z.nextFloat();
        double d1 = (float)this.field_70163_u + this.field_70146_Z.nextFloat();
        double d2 = (float)this.field_70161_v + this.field_70146_Z.nextFloat();
        double d3 = d0 - this.field_70165_t;
        double d4 = d1 - this.field_70163_u;
        double d5 = d2 - this.field_70161_v;
        double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
        d3 /= d6;
        d4 /= d6;
        d5 /= d6;
        double d7 = 0.5 / (d6 / 4.0 + 0.1);
        d3 *= (d7 *= (double)(this.field_70146_Z.nextFloat() * this.field_70146_Z.nextFloat() + 0.3f));
        d4 = d4 * d7 * 4.0;
        d5 *= d7;
        d3 = Math.min(d3, 0.2) * (Math.random() * 2.0 - 1.0);
        d4 = Math.min(d4, 0.6) * (Math.random() * 2.0 - 1.0);
        d5 = Math.min(d5, 0.2) * (Math.random() * 2.0 - 1.0);
        ParticleSpawner.spawnParticle(particleType, this.field_70165_t, this.field_70163_u + 0.2 + (double)this.field_70131_O, this.field_70161_v, d3, d4, d5, r, g, b);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(SRPEnumParticle particleType, int r, int g, int b, double d0, double d1, double d2, double d3, double d4, double d5) {
        ParticleSpawner.spawnParticle(particleType, d0, d1, d2, d3, d4, d5, r, g, b);
    }

    @SideOnly(value=Side.CLIENT)
    public float getSelfeFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getscale(float p_70831_1_) {
        return 0.0f;
    }

    public void doSpecialSkill(byte id) {
        switch (id) {
            case 13: {
                this.skillBreakBlocks();
                return;
            }
            case 14: {
                this.skillLeap();
                return;
            }
        }
    }

    public boolean getFinished(byte attID) {
        switch (attID) {
            case 13: {
                return this.SkillBGflag;
            }
            case 14: {
                return this.SkillLeapFlag;
            }
        }
        return false;
    }

    public void setFinished(byte attID, boolean in) {
        switch (attID) {
            case 13: {
                this.SkillBGflag = in;
            }
            case 14: {
                this.SkillLeapFlag = in;
            }
        }
    }

    public void setSkillBreakBlocksValues(float hardness, int heightIn, int rangeIn) {
        this.blockH = hardness;
        this.BGheight = heightIn;
        this.BGrange = rangeIn;
        this.items = 0;
    }

    protected void skillBreakBlocks() {
        EntityLivingBase target;
        if (this.blockH == 0.0f) {
            return;
        }
        int blocksbroke = 0;
        int i1 = MathHelper.func_76128_c((double)(this.field_70163_u + 0.1));
        double l1 = this.field_70165_t;
        double i2 = this.field_70161_v;
        boolean flag = false;
        int Brangeatm = this.BGrange;
        int offsetT = 0;
        if (this.func_70638_az() != null && (target = this.func_70638_az()).func_70092_e(this.field_70165_t, target.field_70163_u, this.field_70161_v) < 9.0) {
            if (target.field_70163_u - this.field_70163_u < -1.0) {
                offsetT -= 2;
            } else if (target.field_70163_u - this.field_70163_u > 2.0) {
                ++offsetT;
                this.BGrange = 0;
            }
        }
        for (int k2 = -1 * this.BGrange; k2 <= 1 * this.BGrange; ++k2) {
            for (int l2 = -1 * this.BGrange; l2 <= 1 * this.BGrange; ++l2) {
                for (int j = 1 + offsetT; j <= this.BGheight + offsetT; ++j) {
                    double i3 = l1 + (double)k2;
                    double k = i1 + j;
                    double l = i2 + (double)l2;
                    BlockPos blockpos = new BlockPos(i3, k, l);
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    float bHard = iblockstate.func_185887_b(this.field_70170_p, blockpos);
                    if (!(bHard <= this.blockH && bHard > 0.0f) && !(block instanceof IMetaName) || block == SRPBlocks.BiomeHeart || block == SRPBlocks.ColonyHeart || block == SRPBlocks.ParasiteRubbleDense || block == SRPBlocks.ParasiteCanisterActive || this.blockException(block) || block == Blocks.field_150350_a || !block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)blockpos, (IBlockState)iblockstate)) continue;
                    flag = this.field_70170_p.func_175655_b(blockpos, true) || flag;
                    ++blocksbroke;
                }
            }
        }
        this.checkItemsFloor(blocksbroke);
        this.BGrange = Brangeatm;
        this.SkillBGflag = true;
    }

    protected boolean blockException(Block block) {
        return ParasiteEventEntity.checkName(block.getRegistryName().toString(), SRPConfig.parasiteGriefingBlackList, SRPConfig.parasiteGriefingWhite);
    }

    private void checkItemsFloor(int count) {
        if (this.items < 100) {
            ++this.items;
        }
        if (count < 9) {
            return;
        }
        if (this.items > 0) {
            AxisAlignedBB axisalignedbb2 = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b(16.0, 16.0, 16.0);
            List moblist2 = this.field_70170_p.func_72872_a(EntityItem.class, axisalignedbb2);
            if (moblist2.size() >= 20) {
                ++this.items;
                if (this.items >= 3) {
                    double d0 = (float)this.field_70165_t + this.field_70170_p.field_73012_v.nextFloat();
                    double d1 = (float)this.field_70163_u + this.field_70170_p.field_73012_v.nextFloat();
                    double d2 = (float)this.field_70161_v + this.field_70170_p.field_73012_v.nextFloat();
                    double d3 = d0 - this.field_70165_t;
                    double d4 = d1 - this.field_70163_u;
                    double d5 = d2 - this.field_70161_v;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / 4.0 + 0.1);
                    d4 = d4 * d7 * 2.0;
                    EntityGore bomb = new EntityGore(this.field_70170_p);
                    bomb.setType((byte)10);
                    bomb.func_82149_j((Entity)this);
                    bomb.setMotion(d3 *= (d7 *= (double)(this.field_70170_p.field_73012_v.nextFloat() * this.field_70170_p.field_73012_v.nextFloat() + 0.3f)), d4, d5 *= d7, 0.1, 0.5);
                    this.field_70170_p.func_72838_d((Entity)bomb);
                    this.items = -15;
                }
            } else {
                this.items = 0;
            }
        }
    }

    public void setskillLeapValues(float leapY, double leapSpeed, int jumpRad) {
        this.leapMotionY = leapY;
        this.jumpSpeed = leapSpeed;
        this.jumpR = jumpRad;
    }

    protected void skillLeap() {
        if (this.leapMotionY == 0.0f) {
            return;
        }
        if (this.func_70638_az() != null && this.shouldWorkTask() && !this.func_70644_a(MobEffects.field_76421_d) && this.getParasiteStatus() <= 2) {
            EntityLivingBase entitylivingbase = this.func_70638_az();
            if (this.attacking == 0) {
                ++this.attacking;
                this.targetX = entitylivingbase.field_70165_t;
                this.targetZ = entitylivingbase.field_70161_v;
            }
        }
        if (this.attacking >= 1) {
            ++this.attacking;
            this.skillBreakBlocks();
            if (this.attacking == 2 && this.field_70122_E) {
                this.setParasiteStatus(10);
                this.func_70661_as().func_75499_g();
                double d0 = this.targetX - this.field_70165_t;
                double d1 = this.targetZ - this.field_70161_v;
                double f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70181_x = this.leapMotionY;
                this.field_70159_w += d0 / f * this.jumpSpeed * 0.9 + this.field_70159_w * 0.3;
                this.field_70179_y += d1 / f * this.jumpSpeed * 0.9 + this.field_70179_y * 0.3;
            }
            if (this.attacking > 2 && this.field_70122_E) {
                if (this.jumpR != 0) {
                    float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
                    AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b((double)this.jumpR, 2.0, (double)this.jumpR);
                    List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
                    for (EntityLivingBase mob : moblist) {
                        if (mob == this || mob instanceof EntityParasiteBase) continue;
                        mob.func_70653_a((Entity)mob, 2.5f, this.field_70165_t - mob.field_70165_t, this.field_70161_v - mob.field_70161_v);
                        this.func_70652_k((Entity)mob);
                    }
                }
                this.setParasiteStatus(0);
                this.attacking = 0;
                if (this.type >= 31) {
                    this.func_184185_a(SRPSounds.HITGROUND, 15.0f, 1.0f);
                }
                this.SkillLeapFlag = true;
            }
        }
    }

    public class EntityAIJumping
    extends EntityAIBase {
        private final EntityLiving parent;
        private int secs;

        public EntityAIJumping(EntityLiving parentIn) {
            this.parent = parentIn;
            this.func_75248_a(4);
            if (parentIn.func_70661_as() instanceof PathNavigateGround) {
                ((PathNavigateGround)parentIn.func_70661_as()).func_179693_d(true);
            } else if (parentIn.func_70661_as() instanceof PathNavigateFlying) {
                ((PathNavigateFlying)parentIn.func_70661_as()).func_192877_c(true);
            }
        }

        public boolean func_75250_a() {
            ++this.secs;
            if (this.secs < 10) {
                return false;
            }
            this.secs = 0;
            EntityLivingBase target = this.parent.func_70638_az();
            if (target == null) {
                return false;
            }
            if (target.func_70092_e(this.parent.field_70165_t, target.field_70163_u, this.parent.field_70161_v) < 4.0 && target.field_70163_u - (this.parent.field_70163_u + (double)this.parent.func_70047_e()) > 1.0 && this.parent.field_70122_E) {
                this.parent.func_70661_as().func_75499_g();
                double dd0 = target.field_70165_t - this.parent.field_70165_t;
                double dd1 = target.field_70161_v - this.parent.field_70161_v;
                float f = MathHelper.func_76133_a((double)(dd0 * dd0 + dd1 * dd1));
                this.parent.field_70159_w += dd0 / (double)f * 0.5 * (double)0.8f + this.parent.field_70159_w * (double)0.2f;
                this.parent.field_70179_y += dd1 / (double)f * 0.5 * (double)0.8f + this.parent.field_70179_y * (double)0.2f;
                this.parent.field_70181_x = 0.2 + (double)this.parent.field_70131_O * 0.15;
            }
            return false;
        }

        public void func_75246_d() {
            if (this.parent.func_70681_au().nextFloat() < 0.8f) {
                this.parent.func_70683_ar().func_75660_a();
            }
        }
    }

    class EntityAIWait
    extends EntityAIBase {
        public EntityAIWait() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntityParasiteBase.this.getWait() > 0;
        }

        public void func_75246_d() {
        }
    }
}

