/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.monster.crude;

import com.dhanantry.scapeandrunparasites.entity.EntityDamage;
import com.dhanantry.scapeandrunparasites.entity.SRPAttributes;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIAttackMeleeStatusAOE;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAINearestAttackableTargetStatus;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAISkill;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAISwimmingDiving;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIWaterLeapAtTargetStatus;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityCutomAttack;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityPCrude;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCrux
extends EntityPCrude
implements EntityCutomAttack {
    private float attackTimerM;
    private boolean upM;
    private float attackTimerR;
    private boolean upR;
    private double extraDamage;
    private double currentDamage;
    private int limit;
    private int border;
    private double targetX;
    private double targetZ;
    private double mottY;
    private boolean skillThrow;

    public EntityCrux(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.13333f, 3.3f);
        this.field_70138_W = 1.0f;
        this.extraDamage = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
        this.field_70714_bg.func_85156_a((EntityAIBase)this.folow);
        if (SRPConfig.mobattacking) {
            this.field_70715_bh.func_75776_a(4, new EntityAINearestAttackableTargetStatus<EntityLiving>(this, EntityLiving.class, 0, !SRPConfig.useOneMind, !SRPConfig.useOneMind, new Predicate<EntityLiving>(){

                public boolean apply(@Nullable EntityLiving entity) {
                    return !(entity instanceof EntityWaterMob) && !(entity instanceof EntityCreeper) && !ParasiteEventEntity.checkEntity(entity, SRPConfig.mobattackingBlackList, SRPConfig.mobattackingBlackListWhite);
                }
            }));
        }
        this.type = (byte)41;
        this.skillThrow = false;
    }

    @Override
    public int getParasiteIDRegister() {
        return 62;
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimmingDiving((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWaterLeapAtTargetStatus(this, 0.7f, 1.5, 3, 20, 0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISkill(this, 60, 20, 12, true, 1));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMeleeStatusAOE((EntityParasiteBase)this, 1.3, true, 0.0, 3.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(SRPAttributes.CRUXA_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(SRPAttributes.CRUXA_ARMOR);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(SRPAttributes.CRUXA_KD_RESISTANCE);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(SRPAttributes.CRUXA_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(SRPConfig.adaptedFollow);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.upM) {
            this.attackTimerM = (float)((double)this.attackTimerM + 0.2);
            if ((double)this.attackTimerM > 0.9) {
                this.upM = false;
            }
        } else {
            this.attackTimerM = (float)((double)this.attackTimerM - 0.1);
        }
        if (this.upR) {
            this.attackTimerR = (float)((double)this.attackTimerR + 0.4);
            if ((double)this.attackTimerR > 2.2) {
                this.upR = false;
            }
        } else {
            this.attackTimerR = (float)((double)this.attackTimerR - 0.2);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        if (flag) {
            // empty if block
        }
        return flag;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            // empty if block
        }
        return flag;
    }

    public float func_70047_e() {
        return 3.3f;
    }

    public static void registerFixesShyco(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityCrux.class);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SRPSounds.MONSTER_STEP, 0.15f, 1.0f);
    }

    @Override
    public boolean attackEntityAsMobAOE(Entity entityIn) {
        this.upM = true;
        this.attackTimerM = 0.0f;
        this.field_70170_p.func_72960_a((Entity)this, (byte)12);
        boolean flag = false;
        this.func_184185_a(SRPSounds.SWIPE, 2.0f, 1.0f);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, entityIn.field_70165_t + 1.0, entityIn.field_70163_u + 1.0, entityIn.field_70161_v + 1.0).func_186662_g(1.0);
        List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
        for (EntityLivingBase mob : moblist) {
            if (mob instanceof EntityParasiteBase) {
                if (this.func_70638_az() != mob) continue;
                this.func_70624_b(null);
                return false;
            }
            if (mob == this || !this.func_70685_l((Entity)mob) || !this.func_70652_k((Entity)mob)) continue;
            flag = true;
        }
        return flag;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        IEntityLivingData floo = super.func_180482_a(difficulty, livingdata);
        this.func_70690_d(new PotionEffect(SRPPotions.RAGE_E, 1333320, 0, false, false));
        return floo;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    @SideOnly(value=Side.CLIENT)
    public float getAttackTimerM() {
        return this.attackTimerM;
    }

    @SideOnly(value=Side.CLIENT)
    public float getAttackTimerR() {
        return this.attackTimerR;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.upM = true;
            this.attackTimerM = 0.0f;
        } else if (id == 13) {
            this.upR = true;
            this.attackTimerR = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    public boolean getFinished(byte attID) {
        switch (attID) {
            case 1: {
                return this.skillThrow;
            }
        }
        return super.getFinished(attID);
    }

    @Override
    public void setFinished(byte attID, boolean in) {
        switch (attID) {
            case 1: {
                this.skillThrow = in;
                return;
            }
        }
        super.setFinished(attID, in);
    }

    @Override
    public void doSpecialSkill(byte id) {
        switch (id) {
            case 1: {
                this.throwBlock();
                return;
            }
        }
        super.doSpecialSkill(id);
    }

    private void throwBlock() {
        EntityLivingBase entitylivingbase = this.func_70638_az();
        if (entitylivingbase != null) {
            this.targetX = entitylivingbase.field_70165_t;
            this.targetZ = entitylivingbase.field_70161_v;
            if (this.func_70068_e((Entity)entitylivingbase) < 144.0 || entitylivingbase.field_70163_u < this.field_70163_u || entitylivingbase.field_70163_u > this.field_70163_u + 3.0) {
                this.skillThrow = true;
                this.setParasiteStatus(0);
                this.border = 0;
                this.limit = 0;
                return;
            }
        } else {
            this.skillThrow = true;
            this.setParasiteStatus(0);
            this.border = 0;
            this.limit = 0;
            return;
        }
        this.mottY = this.func_70068_e((Entity)entitylivingbase);
        if (this.field_70173_aa % 20 != 0) {
            return;
        }
        ++this.border;
        IBlockState b = this.blockNotAvailable();
        if (b == null) {
            ++this.limit;
            if (this.limit >= 5) {
                this.skillThrow = true;
                this.setParasiteStatus(0);
                this.border = 0;
                this.limit = 0;
            }
            return;
        }
        this.skillBreakBlocks();
        this.setParasiteStatus(10);
        this.func_70661_as().func_75492_a(this.targetX, entitylivingbase.field_70163_u, this.targetZ, 0.0);
        this.field_70170_p.func_72960_a((Entity)this, (byte)13);
        BlockPos pos = this.func_180425_c();
        Vec3d vec3d = this.func_70676_i(1.0f);
        EntityFallingBlock entityfallingblock = new EntityFallingBlock(this.field_70170_p, this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)this.func_70047_e() - 0.7, this.field_70161_v + vec3d.field_72449_c, b);
        entityfallingblock.field_145812_b = -100;
        this.targetX += Math.random() * 2.0 - 1.0;
        this.targetZ += Math.random() * 2.0 - 1.0;
        double d0 = this.targetX - this.field_70165_t;
        double d1 = this.targetZ - this.field_70161_v;
        double f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        entityfallingblock.field_70181_x = this.mottY * 0.0;
        if (entitylivingbase.field_70163_u >= this.field_70163_u + 2.0) {
            entityfallingblock.field_70181_x += 0.5;
        }
        if (entitylivingbase.field_70163_u <= this.field_70163_u - 2.0) {
            entityfallingblock.field_70181_x += -0.5;
        }
        double mmx = d0 / f * (this.mottY * 0.009) * 0.9 + entityfallingblock.field_70159_w * 0.3;
        double mmz = d1 / f * (this.mottY * 0.009) * 0.9 + entityfallingblock.field_70179_y * 0.3;
        entityfallingblock.field_70159_w += mmx;
        entityfallingblock.field_70179_y += mmz;
        EntityDamage damage = new EntityDamage(this.field_70170_p, entityfallingblock.field_70165_t, entityfallingblock.field_70163_u, entityfallingblock.field_70161_v, 0.0f, (EntityLivingBase)this, 10.0f + b.func_185887_b(this.field_70170_p, this.func_180425_c()), false, 0.0f);
        damage.setFollower((Entity)entityfallingblock);
        this.field_70170_p.func_72838_d((Entity)entityfallingblock);
        this.field_70170_p.func_72838_d((Entity)damage);
        if (this.limit >= 5 || this.border > 8) {
            this.skillThrow = true;
            this.setParasiteStatus(0);
            this.border = 0;
            this.limit = 0;
        }
    }

    private IBlockState blockNotAvailable() {
        BlockPos pos;
        IBlockState b = null;
        int range = 2;
        int newX = this.field_70146_Z.nextInt(range) + 1;
        int newZ = this.field_70146_Z.nextInt(range) + 1;
        if (this.field_70146_Z.nextBoolean()) {
            newX *= -1;
        }
        if (this.field_70146_Z.nextBoolean()) {
            newZ *= -1;
        }
        if ((pos = ParasiteEventEntity.getFloor(this.field_70170_p, new BlockPos(this.field_70165_t + (double)newX, this.field_70163_u, this.field_70161_v + (double)newZ), 4)) != null) {
            if (this.checkBlock(this.field_70170_p.func_180495_p(pos = pos.func_177977_b()).func_177230_c(), this.field_70170_p.func_180495_p(pos), pos)) {
                return null;
            }
            b = this.field_70170_p.func_180495_p(pos);
            this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        return b;
    }

    private boolean checkBlock(Block in, IBlockState state, BlockPos pos) {
        return in == Blocks.field_150350_a || in instanceof BlockLiquid || !state.func_185913_b() || state.func_185887_b(this.field_70170_p, pos) <= 0.0f || this.blockException(in);
    }
}

