/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.init;

import com.dhanantry.scapeandrunparasites.entity.ai.EntityPStationary;
import com.dhanantry.scapeandrunparasites.potion.SRPEffectBase;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SRPPotions {
    public static final Potion COTH_E = new SRPEffectBase("coth", true, 894258, 0, 0);
    public static final Potion FEAR_E = new SRPEffectBase("fear", true, 894257, 0, 0);
    public static final Potion RES_E = new SRPEffectBase("antimall", true, 894257, 0, 0);
    public static final Potion BLEED_E = new SRPEffectBase("bleed", true, 894257, 0, 0);
    public static final Potion CORRO_E = new SRPEffectBase("corrosive", true, 894257, 0, 0).func_111184_a(SharedMonsterAttributes.field_188791_g, UUID.randomUUID().toString(), -SRPConfig.corroAmount, 2);
    public static final Potion VIRA_E = new SRPEffectBase("viral", true, 894257, 0, 0).func_111184_a(SharedMonsterAttributes.field_111267_a, UUID.randomUUID().toString(), -SRPConfig.viralAmount, 2);
    public static final Potion RAGE_E = new SRPEffectBase("rage", true, 894257, 0, 0).func_111184_a(SharedMonsterAttributes.field_111263_d, UUID.randomUUID().toString(), SRPConfig.rageSpeed, 2).func_111184_a(SharedMonsterAttributes.field_111264_e, UUID.randomUUID().toString(), SRPConfig.rageDamage, 2);
    public static final Potion EPEL_E = new SRPEffectBase("repel", true, 894257, 0, 0);
    public static final Potion SENS_E = new SRPEffectBase("senses", true, 894257, 0, 0).func_111184_a(SharedMonsterAttributes.field_111265_b, UUID.randomUUID().toString(), 0.1, 2);
    public static final Potion PREY_E = new SRPEffectBase("prey", true, 894257, 0, 0);
    public static final PotionType COTH_P = (PotionType)new PotionType("srparasites:coth", new PotionEffect[]{new PotionEffect(COTH_E, 2400)}).setRegistryName("srparasites:coth");
    public static final PotionType FEAR_P = (PotionType)new PotionType("srparasites:fear", new PotionEffect[]{new PotionEffect(FEAR_E, 2400)}).setRegistryName("srparasites:fear");
    public static final PotionType RES_P = (PotionType)new PotionType("srparasites:antimall", new PotionEffect[]{new PotionEffect(RES_E, 2400)}).setRegistryName("srparasites:res");
    public static final PotionType CORRO_P = (PotionType)new PotionType("srparasites:corrosive", new PotionEffect[]{new PotionEffect(CORRO_E, 2400)}).setRegistryName("srparasites:corro");
    public static final PotionType VIRA_P = (PotionType)new PotionType("srparasites:viral", new PotionEffect[]{new PotionEffect(VIRA_E, 2400)}).setRegistryName("srparasites:vira");
    public static final PotionType RAGE_P = (PotionType)new PotionType("srparasites:rage", new PotionEffect[]{new PotionEffect(RAGE_E, 2400)}).setRegistryName("srparasites:rage");
    public static final PotionType EPEL_P = (PotionType)new PotionType("srparasites:repel", new PotionEffect[]{new PotionEffect(EPEL_E, 2400)}).setRegistryName("srparasites:repel");
    public static final PotionType SENS_P = (PotionType)new PotionType("srparasites:senses", new PotionEffect[]{new PotionEffect(SENS_E, 2400)}).setRegistryName("srparasites:senses");

    public static void applyBleeding(EntityLivingBase in, int duration, int amp) {
        PotionEffect flag = in.func_70660_b(BLEED_E);
        if (flag != null) {
            in.func_70690_d(new PotionEffect(BLEED_E, duration, flag.func_76458_c() + 1, false, false));
        } else {
            in.func_70690_d(new PotionEffect(BLEED_E, duration, amp, false, false));
        }
    }

    public static void applyCorrosive(EntityLivingBase in, int duration, int amp) {
        PotionEffect flag = in.func_70660_b(CORRO_E);
        if (flag != null) {
            in.func_70690_d(new PotionEffect(CORRO_E, duration, flag.func_76458_c() + 1, false, false));
        } else {
            in.func_70690_d(new PotionEffect(CORRO_E, duration, amp, false, false));
        }
    }

    public static void applyViral(EntityLivingBase in, int duration, int amp) {
        if (amp <= 0) {
            return;
        }
        double va = (double)in.func_110138_aP() * SRPConfig.viralAmount * (double)amp + 1.0;
        if ((double)in.func_110138_aP() - va <= (double)in.func_110138_aP() * SRPConfig.viralAmount * (double)amp + 2.0) {
            SRPPotions.applyViral(in, duration, amp - 1);
            return;
        }
        PotionEffect flag = in.func_70660_b(VIRA_E);
        if (flag != null) {
            if (amp == 0) {
                ++amp;
            }
            in.func_70690_d(new PotionEffect(VIRA_E, duration, flag.func_76458_c() + amp, false, false));
        } else {
            in.func_70690_d(new PotionEffect(VIRA_E, duration, amp, false, false));
        }
    }

    public static boolean applySense(EntityLivingBase in, int duration, double rangeToCover, int withLimit) {
        if (in instanceof EntityPStationary) {
            return false;
        }
        if (rangeToCover >= (double)(withLimit * withLimit)) {
            return false;
        }
        double rangeB = in.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111125_b();
        if (rangeB * rangeB > rangeToCover) {
            return true;
        }
        int amp = 0;
        double bonus = rangeB * 0.1;
        int count = 0;
        boolean flag = true;
        while (flag) {
            if ((rangeB + bonus) * (rangeB + bonus) >= rangeToCover) {
                in.func_70690_d(new PotionEffect(SENS_E, duration, amp, false, false));
                flag = false;
                return true;
            }
            bonus = rangeB * (0.1 * (double)(++amp));
            if (++count <= 10) continue;
            flag = false;
            return false;
        }
        return false;
    }

    @Mod.EventBusSubscriber(modid="srparasites")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void onEventE(RegistryEvent.Register<Potion> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register((IForgeRegistryEntry)COTH_E);
            registry.register((IForgeRegistryEntry)FEAR_E);
            registry.register((IForgeRegistryEntry)RES_E);
            registry.register((IForgeRegistryEntry)BLEED_E);
            registry.register((IForgeRegistryEntry)CORRO_E);
            registry.register((IForgeRegistryEntry)VIRA_E);
            registry.register((IForgeRegistryEntry)RAGE_E);
            registry.register((IForgeRegistryEntry)EPEL_E);
            registry.register((IForgeRegistryEntry)SENS_E);
            registry.register((IForgeRegistryEntry)PREY_E);
        }

        @SubscribeEvent
        public static void onEventP(RegistryEvent.Register<PotionType> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register((IForgeRegistryEntry)COTH_P);
            registry.register((IForgeRegistryEntry)FEAR_P);
            registry.register((IForgeRegistryEntry)RES_P);
            registry.register((IForgeRegistryEntry)CORRO_P);
            registry.register((IForgeRegistryEntry)VIRA_P);
            registry.register((IForgeRegistryEntry)RAGE_P);
            registry.register((IForgeRegistryEntry)EPEL_P);
            registry.register((IForgeRegistryEntry)SENS_P);
        }
    }
}

