/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.init;

import com.dhanantry.scapeandrunparasites.entity.ai.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityBanoAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityCanraAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityEmanaAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityHullAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityNoglaAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityRanracAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityShycoAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.ancient.EntityOronco;
import com.dhanantry.scapeandrunparasites.entity.monster.ancient.EntityTerla;
import com.dhanantry.scapeandrunparasites.entity.monster.crude.EntityCrux;
import com.dhanantry.scapeandrunparasites.entity.monster.crude.EntityHeed;
import com.dhanantry.scapeandrunparasites.entity.monster.crude.EntityHost;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.EntityVenkrol;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityButhol;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityKol;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityLodo;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityMudo;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityRathol;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityDorpa;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfBear;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfCow;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfDragonE;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfEnderman;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfHorse;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfHuman;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfPig;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfPlayer;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfSheep;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfVillager;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfWolf;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityBano;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityCanra;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityEmana;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityHull;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityNogla;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityRanrac;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityShyco;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityAlafha;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityAnged;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityEsor;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityFlog;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityGanro;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityJinjo;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityOmboo;
import com.dhanantry.scapeandrunparasites.init.SRPBiomes;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import com.dhanantry.scapeandrunparasites.world.SRPWorldData;
import com.dhanantry.scapeandrunparasites.world.biome.BiomeParasite;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SRPSpawning {
    public static void init() {
        if (SRPConfig.allowMobs) {
            for (Biome biome : Biome.field_185377_q) {
                SRPSpawning.addSpawn(0, EntityShyco.class, 1, 1, biome, SRPConfig.shycoSpawnRate, SRPConfig.shycoEnabled);
                SRPSpawning.addSpawn(0, EntityShycoAdapted.class, 1, 1, biome, SRPConfig.shycoASpawnRate, SRPConfig.shycoEnabled);
                SRPSpawning.addSpawn(0, EntityEmana.class, 2, 3, biome, SRPConfig.emanaSpawnRate, SRPConfig.emanaEnabled);
                SRPSpawning.addSpawn(0, EntityEmanaAdapted.class, 2, 3, biome, SRPConfig.emanaASpawnRate, SRPConfig.emanaEnabled);
                SRPSpawning.addSpawn(0, EntityHull.class, 4, 6, biome, SRPConfig.hullSpawnRate, SRPConfig.hullEnabled);
                SRPSpawning.addSpawn(0, EntityHullAdapted.class, 4, 6, biome, SRPConfig.hullASpawnRate, SRPConfig.hullEnabled);
                SRPSpawning.addSpawn(0, EntityCanra.class, 1, 1, biome, SRPConfig.canraSpawnRate, SRPConfig.canraEnabled);
                SRPSpawning.addSpawn(0, EntityCanraAdapted.class, 1, 1, biome, SRPConfig.canraASpawnRate, SRPConfig.canraEnabled);
                SRPSpawning.addSpawn(0, EntityNogla.class, 1, 2, biome, SRPConfig.noglaSpawnRate, SRPConfig.noglaEnabled);
                SRPSpawning.addSpawn(0, EntityNoglaAdapted.class, 1, 2, biome, SRPConfig.noglaASpawnRate, SRPConfig.noglaEnabled);
                SRPSpawning.addSpawn(0, EntityBano.class, 1, 1, biome, SRPConfig.zetmoSpawnRate, SRPConfig.zetmoEnabled);
                SRPSpawning.addSpawn(0, EntityBanoAdapted.class, 1, 1, biome, SRPConfig.zetmoASpawnRate, SRPConfig.zetmoEnabled);
                SRPSpawning.addSpawn(0, EntityRanrac.class, 1, 1, biome, SRPConfig.arachnidaSpawnRate, SRPConfig.arachnidaEnabled);
                SRPSpawning.addSpawn(0, EntityRanracAdapted.class, 1, 1, biome, SRPConfig.arachnidaASpawnRate, SRPConfig.arachnidaEnabled);
                SRPSpawning.addSpawn(0, EntityRathol.class, 2, 2, biome, SRPConfig.ratholSpawnRate, SRPConfig.ratholEnabled);
                SRPSpawning.addSpawn(0, EntityButhol.class, 1, 2, biome, SRPConfig.butholSpawnRate, SRPConfig.butholEnabled);
                SRPSpawning.addSpawn(0, EntityMudo.class, 3, 6, biome, SRPConfig.mudoSpawnRate, SRPConfig.mudoEnabled);
                SRPSpawning.addSpawn(0, EntityLodo.class, 2, 5, biome, SRPConfig.lodoSpawnRate, SRPConfig.lodoEnabled);
                SRPSpawning.addSpawn(0, EntityKol.class, 1, 1, biome, SRPConfig.kolSpawnRate, SRPConfig.kolEnabled);
                SRPSpawning.addSpawn(0, EntityInfBear.class, 1, 1, biome, SRPConfig.infbearSpawnRate, SRPConfig.infbearEnabled);
                SRPSpawning.addSpawn(0, EntityDorpa.class, 1, 1, biome, SRPConfig.dorpaSpawnRate, SRPConfig.dorpaEnabled);
                SRPSpawning.addSpawn(0, EntityInfEnderman.class, 1, 1, biome, SRPConfig.infendermanSpawnRate, SRPConfig.infendermanEnabled);
                SRPSpawning.addSpawn(0, EntityInfHuman.class, 3, 5, biome, SRPConfig.infhumanSpawnRate, SRPConfig.infhumanEnabled);
                SRPSpawning.addSpawn(0, EntityInfCow.class, 1, 3, biome, SRPConfig.infcowSpawnRate, SRPConfig.infcowEnabled);
                SRPSpawning.addSpawn(0, EntityInfSheep.class, 1, 3, biome, SRPConfig.infsheepSpawnRate, SRPConfig.infsheepEnabled);
                SRPSpawning.addSpawn(0, EntityInfWolf.class, 3, 6, biome, SRPConfig.infwolfSpawnRate, SRPConfig.infwolfEnabled);
                SRPSpawning.addSpawn(0, EntityInfPig.class, 3, 6, biome, SRPConfig.infpigSpawnRate, SRPConfig.infpigEnabled);
                SRPSpawning.addSpawn(0, EntityInfVillager.class, 3, 6, biome, SRPConfig.infvillagerSpawnRate, SRPConfig.infvillagerEnabled);
                SRPSpawning.addSpawn(0, EntityInfHorse.class, 3, 6, biome, SRPConfig.infhorseSpawnRate, SRPConfig.infhorseEnabled);
                SRPSpawning.addSpawn(0, EntityInfPlayer.class, 3, 6, biome, SRPConfig.infadventurerSpawnRate, SRPConfig.infadventurerEnabled);
                SRPSpawning.addSpawn(0, EntityInfDragonE.class, 3, 6, biome, SRPConfig.infdragoneSpawnRate, SRPConfig.infdragoneEnabled);
                SRPSpawning.addSpawn(0, EntityHost.class, 1, 1, biome, SRPConfig.hostSpawnRate, SRPConfig.hostEnabled);
                SRPSpawning.addSpawn(0, EntityHeed.class, 1, 1, biome, SRPConfig.heedSpawnRate, SRPConfig.heedEnabled);
                SRPSpawning.addSpawn(0, EntityCrux.class, 1, 1, biome, SRPConfig.cruxaSpawnRate, SRPConfig.cruxaEnabled);
                SRPSpawning.addSpawn(0, EntityAlafha.class, 1, 1, biome, SRPConfig.alafhaSpawnRate, SRPConfig.alafhaEnabled);
                SRPSpawning.addSpawn(0, EntityGanro.class, 1, 1, biome, SRPConfig.ganroSpawnRate, SRPConfig.ganroEnabled);
                SRPSpawning.addSpawn(0, EntityAnged.class, 2, 2, biome, SRPConfig.angedSpawnRate, SRPConfig.angedEnabled);
                SRPSpawning.addSpawn(0, EntityEsor.class, 1, 1, biome, SRPConfig.esorSpawnRate, SRPConfig.esorEnabled);
                SRPSpawning.addSpawn(0, EntityOmboo.class, 2, 2, biome, SRPConfig.ombooSpawnRate, SRPConfig.ombooEnabled);
                SRPSpawning.addSpawn(0, EntityFlog.class, 3, 6, biome, SRPConfig.flogSpawnRate, SRPConfig.flogEnabled);
                SRPSpawning.addSpawn(0, EntityJinjo.class, 3, 6, biome, SRPConfig.jinjoSpawnRate, SRPConfig.jinjoEnabled);
                SRPSpawning.addSpawn(0, EntityOronco.class, 1, 1, biome, SRPConfig.oroncoSpawnRate, SRPConfig.oroncoEnabled);
                SRPSpawning.addSpawn(0, EntityTerla.class, 1, 1, biome, SRPConfig.terlaSpawnRate, SRPConfig.terlaEnabled);
                SRPSpawning.addSpawn(1, EntityVenkrol.class, 1, 1, biome, SRPConfig.venkrolSpawnrate, SRPConfig.rsEnabled);
            }
        }
    }

    public static void initBiome() {
        BiomeParasite biome = SRPBiomes.biomeInfested;
        String[] here = new String[5];
        for (int i = 0; i < SRPConfig.biomeSpawnEntry.length; ++i) {
            if (SRPConfig.biomeSpawnEntry[i] == null) continue;
            here = SRPConfig.biomeSpawnEntry[i].split(";");
            int min = Integer.parseInt(here[1]);
            int max = Integer.parseInt(here[2]);
            int weight = Integer.parseInt(here[3]);
            int type = Integer.parseInt(here[4]);
            SRPSpawning.addSpawn(type, EntityList.getClass((ResourceLocation)new ResourceLocation(here[0])), min, max, biome, weight, true);
        }
    }

    public static void addSpawn(int type, Class<? extends EntityLiving> entity, int groupMin, int groupMax, Biome biome, int weight, boolean addSpawn) {
        if (weight > 0 && addSpawn && type == 0) {
            biome.func_76747_a(EnumCreatureType.MONSTER).add(new Biome.SpawnListEntry(entity, weight, groupMin, groupMax));
        } else if (weight > 0 && addSpawn && type == 1) {
            biome.func_76747_a(EnumCreatureType.CREATURE).add(new Biome.SpawnListEntry(entity, weight, groupMin, groupMax));
        }
    }

    @Mod.EventBusSubscriber(modid="srparasites")
    public static class DimensionHandler {
        @SubscribeEvent
        public static void onSpawn(LivingSpawnEvent.CheckSpawn event) {
            if (event.getEntity() instanceof EntityParasiteBase) {
                if (!SRPConfig.useEvolution) {
                    boolean inv = false;
                    boolean flagI = false;
                    if (SRPConfig.blackListedDimensionsWhite) {
                        inv = true;
                    }
                    for (int i : SRPConfig.blackListedDimensions) {
                        if (SRPConfig.blackListedDimensionsWhite) {
                            if (i != event.getWorld().field_73011_w.getDimension()) continue;
                            flagI = true;
                            break;
                        }
                        if (i != event.getWorld().field_73011_w.getDimension()) continue;
                        event.setResult(Event.Result.DENY);
                        return;
                    }
                    if (inv && !flagI) {
                        event.setResult(Event.Result.DENY);
                        return;
                    }
                }
                if (SRPConfig.useEvolution || SRPConfig.coloniesActivated) {
                    EntityParasiteBase parasite = (EntityParasiteBase)event.getEntity();
                    SRPWorldData data = SRPWorldData.get(parasite.field_70170_p);
                    if (data.getEvolutionPhase() <= -1) {
                        event.setResult(Event.Result.DENY);
                        return;
                    }
                    if (parasite.getParasiteType() == 7) {
                        BlockPos origin;
                        if (!SRPConfig.coloniesActivated) {
                            event.setResult(Event.Result.DENY);
                        }
                        if ((origin = data.nearestColonyPosition(parasite.func_180425_c(), 0, false)) != null) {
                            EntityKol kol = (EntityKol)parasite;
                            kol.setTask(origin, data.getColonyDistanceSpreadByPosition(origin, false, 0));
                            return;
                        }
                        event.setResult(Event.Result.DENY);
                    }
                    if (SRPConfig.useEvolution && !DimensionHandler.canSpawninPhase(data.getEvolutionPhase(), parasite)) {
                        event.setResult(Event.Result.DENY);
                        return;
                    }
                    if (DimensionHandler.checkEvoLock(parasite.getParasiteIDRegister(), SRPSaveData.get(parasite.field_70170_p)) || DimensionHandler.checkColoLock(parasite.getParasiteIDRegister())) {
                        event.setResult(Event.Result.DENY);
                        return;
                    }
                }
            }
        }

        private static boolean canSpawninPhase(byte evPhase, EntityParasiteBase parasite) {
            byte type = parasite.getParasiteType();
            switch (evPhase) {
                case -1: {
                    return false;
                }
                case 0: {
                    if (type < SRPConfig.phaseMaxParasiteIDZero && type > SRPConfig.phaseCancelParasiteIDZero) break;
                    return false;
                }
                case 1: {
                    if (type < SRPConfig.phaseMaxParasiteIDOne && type > SRPConfig.phaseCancelParasiteIDOne) break;
                    return false;
                }
                case 2: {
                    if (type < SRPConfig.phaseMaxParasiteIDTwo && type > SRPConfig.phaseCancelParasiteIDTwo) break;
                    return false;
                }
                case 3: {
                    if (type < SRPConfig.phaseMaxParasiteIDThree && type > SRPConfig.phaseCancelParasiteIDThree) break;
                    return false;
                }
                case 4: {
                    if (type < SRPConfig.phaseMaxParasiteIDFour && type > SRPConfig.phaseCancelParasiteIDFour) break;
                    return false;
                }
                case 5: {
                    if (type < SRPConfig.phaseMaxParasiteIDFive && type > SRPConfig.phaseCancelParasiteIDFive) break;
                    return false;
                }
                case 6: {
                    if (type < SRPConfig.phaseMaxParasiteIDSix && type > SRPConfig.phaseCancelParasiteIDSix) break;
                    return false;
                }
                case 7: {
                    if (type < SRPConfig.phaseMaxParasiteIDSeven && type > SRPConfig.phaseCancelParasiteIDSeven) break;
                    return false;
                }
                case 8: {
                    if (type < SRPConfig.phaseMaxParasiteIDEight && type > SRPConfig.phaseCancelParasiteIDEight) break;
                    return false;
                }
            }
            parasite.setCreatedPhase(evPhase);
            return true;
        }

        private static boolean checkEvoLock(int in, SRPSaveData data) {
            return data.checkParasiteID(in);
        }

        private static boolean checkColoLock(int in) {
            return false;
        }
    }
}

