/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.potion;

import com.dhanantry.scapeandrunparasites.SRPMain;
import com.dhanantry.scapeandrunparasites.entity.EntityParasiticScent;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.network.SRPPacketParticle;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.SRPWorldData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SRPEffectBase
extends Potion {
    private ResourceLocation icon;

    public SRPEffectBase(String name, boolean isBadEffectIn, int liquidColorIn, int IconIndexX, int IconIndexY) {
        super(isBadEffectIn, liquidColorIn);
        this.setRegistryName("srparasites:" + name);
        this.func_76390_b("mob_effect." + this.getRegistryName());
        this.func_76399_b(IconIndexX, IconIndexY);
        this.icon = new ResourceLocation("srparasites:textures/gui/potion_" + name + ".png");
    }

    public boolean func_76400_d() {
        return false;
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    public boolean func_76397_a(int duration, int amplifier) {
        if (this == SRPPotions.BLEED_E || this == SRPPotions.EPEL_E) {
            int j = 25 >> amplifier;
            if (j > 0) {
                return duration % j == 0;
            }
            return true;
        }
        return true;
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        if (this == SRPPotions.BLEED_E) {
            float damage = entity.func_110138_aP() * SRPConfig.bleedingDamage;
            if (entity.field_70165_t != entity.field_70169_q || entity.field_70161_v != entity.field_70166_s) {
                damage *= (float)(amplifier + 1);
            }
            entity.func_70097_a(DamageSource.field_76376_m, damage);
        } else if (this == SRPPotions.COTH_E) {
            this.effectCOTH(entity, amplifier);
        } else if (this == SRPPotions.RAGE_E) {
            SRPMain.network.sendToAll((IMessage)new SRPPacketParticle(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70130_N, entity.field_70131_O, 2));
        } else if (this == SRPPotions.PREY_E) {
            this.effectPrey(entity, amplifier);
        }
    }

    private void InfectNearby(EntityLivingBase entity, int range) {
        if (SRPConfig.cothAura == 0) {
            return;
        }
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70165_t + 1.0, entity.field_70163_u + 1.0, entity.field_70161_v + 1.0).func_186662_g((double)range);
        List moblist = entity.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
        for (EntityLivingBase mob : moblist) {
            if (mob == entity || mob.func_70644_a(SRPPotions.COTH_E)) continue;
            if (mob.func_70644_a(SRPPotions.EPEL_E)) {
                if (!(mob.field_70170_p.field_73012_v.nextDouble() >= SRPConfig.epelChanceCOTH)) continue;
                mob.func_70690_d(new PotionEffect(SRPPotions.COTH_E, 4800, 0, false, false));
                continue;
            }
            mob.func_70690_d(new PotionEffect(SRPPotions.COTH_E, 4800, 0, false, false));
        }
    }

    private void effectCOTH(EntityLivingBase entity, int amplifier) {
        if (entity instanceof EntityPlayer) {
            return;
        }
        boolean flag = !entity.field_70170_p.field_72995_K;
        boolean particle = false;
        int dur = entity.func_70660_b(SRPPotions.COTH_E).func_76459_b();
        switch (entity.func_70660_b(SRPPotions.COTH_E).func_76458_c()) {
            case 0: {
                NBTTagCompound tags;
                if (dur >= 200 || !flag || !(tags = entity.getEntityData()).func_74764_b("srpcothimmunity")) break;
                if (tags.func_74762_e("srpcothimmunity") != 0) {
                    entity.func_70690_d(new PotionEffect(SRPPotions.COTH_E, 3600, 1, false, false));
                    break;
                }
                entity.func_184596_c(SRPPotions.COTH_E);
                break;
            }
            case 1: {
                NBTTagCompound tags;
                boolean tickFlag;
                if (!flag) break;
                boolean bl = tickFlag = entity.field_70173_aa % 20 == 0;
                if (tickFlag) {
                    this.InfectNearby(entity, SRPConfig.cothAura);
                }
                if (entity.func_110138_aP() * SRPConfig.cothUnhide > entity.func_110143_aJ() && entity.func_110143_aJ() > 0.0f) {
                    tags = entity.getEntityData();
                    if (tags.func_74764_b("srpcothimmunity")) {
                        if (tags.func_74762_e("srpcothimmunity") != 0 && tickFlag) {
                            ParasiteEventEntity.spawnInsider(entity, entity.field_70170_p, tags);
                        }
                        if (tags.func_74762_e("srpcothimmunity") > 1) {
                            particle = true;
                        }
                    } else {
                        entity.func_184596_c(SRPPotions.COTH_E);
                    }
                }
                if (dur >= 200 || !(tags = entity.getEntityData()).func_74764_b("srpcothimmunity")) break;
                if (tags.func_74762_e("srpcothimmunity") != 0) {
                    entity.func_70690_d(new PotionEffect(SRPPotions.COTH_E, 3600, 2, false, false));
                    if (entity.field_70170_p.field_72995_K || !SRPConfig.useEvolution) break;
                    SRPWorldData data = SRPWorldData.get(entity.field_70170_p);
                    data.setTotalKills(SRPConfig.valueCOTH, true, entity.field_70170_p);
                    if (data.getEvolutionPhase() < SRPConfig.evolutionAssimilatedDehiding) break;
                    int key = tags.func_74762_e("srpcothimmunity");
                    tags.func_74768_a("srpcothimmunity", ++key);
                    break;
                }
                entity.func_184596_c(SRPPotions.COTH_E);
                break;
            }
            default: {
                if (!flag) break;
                boolean tickFlag = entity.field_70173_aa % 20 == 0;
                NBTTagCompound tags = entity.getEntityData();
                if (tags.func_74764_b("srpcothimmunity")) {
                    if (tags.func_74762_e("srpcothimmunity") > 1) {
                        if (tickFlag) {
                            ParasiteEventEntity.convertEntity(entity, tags, false, SRPConfig.COTHVictimParasite);
                        }
                        particle = true;
                        break;
                    }
                    if (tickFlag) {
                        this.InfectNearby(entity, SRPConfig.cothAura);
                    }
                    if (entity.func_110138_aP() * SRPConfig.cothUnhide > entity.func_110143_aJ() && entity.func_110143_aJ() > 0.0f && tickFlag) {
                        if (tags.func_74762_e("srpcothimmunity") != 0) {
                            ParasiteEventEntity.convertEntity(entity, tags, false, SRPConfig.COTHVictimParasite);
                        }
                        if (tags.func_74762_e("srpcothimmunity") > 1) {
                            particle = true;
                        }
                    }
                    if (dur >= 200) break;
                    entity.func_70690_d(new PotionEffect(SRPPotions.COTH_E, 3600, 2, false, false));
                    if (!SRPConfig.useEvolution || SRPWorldData.get(entity.field_70170_p).getEvolutionPhase() < SRPConfig.evolutionAssimilatedDehiding) break;
                    int key = tags.func_74762_e("srpcothimmunity");
                    tags.func_74768_a("srpcothimmunity", ++key);
                    break;
                }
                entity.func_184596_c(SRPPotions.COTH_E);
            }
        }
        if (particle) {
            SRPMain.network.sendToAll((IMessage)new SRPPacketParticle(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70130_N, entity.field_70131_O, 1));
        }
    }

    private void effectPrey(EntityLivingBase entity, int amplifier) {
        if (!entity.field_70170_p.field_72995_K && entity.field_70173_aa % 40 == 0) {
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70165_t + 1.0, entity.field_70163_u + 1.0, entity.field_70161_v + 1.0).func_186662_g(20.0);
            List moblist = entity.field_70170_p.func_72872_a(EntityParasiticScent.class, axisalignedbb);
            for (EntityParasiticScent mob : moblist) {
                if (mob.getTargetToKill() != entity || !mob.getCanFollow()) continue;
                return;
            }
            byte phase = SRPWorldData.get(entity.field_70170_p).getEvolutionPhase();
            EntityParasiticScent nut = new EntityParasiticScent(entity.field_70170_p, 1, entity);
            nut.func_82149_j((Entity)entity);
            nut.setScentLife(SRPConfig.scentLifeObserver * 20);
            nut.increaseDanger(ParasiteEventEntity.getScentBonus(phase), true);
            nut.setScentReaction(ParasiteEventEntity.getScentReactionBonus(phase), false);
            nut.setCanFollow(true);
            entity.field_70170_p.func_72838_d((Entity)nut);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
        if (mc.field_71462_r != null) {
            mc.func_110434_K().func_110577_a(this.icon);
            Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
        }
    }

    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        mc.func_110434_K().func_110577_a(this.icon);
        Gui.func_146110_a((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }
}

