/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.additionalstructures.mystcraft;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import xxrexraptorxx.additionalstructures.config.ConfigGeneral;
import xxrexraptorxx.additionalstructures.main.Reference;
import xxrexraptorxx.additionalstructures.world.WorldGenStructures;

public class MystcraftWorldGenStructures
extends WorldGenStructures {
    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!world.field_73011_w.func_186058_p().equals((Object)Mystcraft.dimensionType)) {
            super.generate(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            return;
        }
        int dimId = world.field_73011_w.getDimension();
        try {
            if (world.field_73011_w instanceof WorldProviderMyst) {
                int blockZ;
                int blockX;
                if (dimId < 0) {
                    if (ConfigGeneral.activateOverworldGeneration) {
                        this.generateOverworldFeatures(world, random, chunkX, chunkZ);
                    }
                    return;
                }
                AgeData data = AgeData.getAge((int)dimId, (boolean)false);
                List symbolList = data.getSymbols(false);
                if (symbolList.contains(Reference.SYMBOL_NORMAL_STRUCTURE_GENERATION)) {
                    blockX = chunkX * 16 + random.nextInt(16);
                    blockZ = chunkZ * 16 + random.nextInt(16);
                    this.generateNetherFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
                    this.generateOverworldFeatures(world, random, blockX, blockZ);
                    this.generateEndFeatures(world, random, blockX, blockZ, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
                }
                blockX = chunkX * 16 + random.nextInt(16);
                blockZ = chunkZ * 16 + random.nextInt(16);
                if (symbolList.contains(Reference.SYMBOL_END_STRUCTURES)) {
                    this.generateEndFeatures(world, random, blockX, blockZ, null);
                }
                if (symbolList.contains(Reference.SYMBOL_NETHER_STRUCTURES)) {
                    this.generateNetherFeatures(world, random, blockX, blockZ, null);
                }
                if (symbolList.contains(Reference.SYMBOL_DESERT_STRUCTURES)) {
                    this.generateDesertFeatures(world, random, blockX, blockZ, null);
                }
                if (symbolList.contains(Reference.SYMBOL_SNOW_STRUCTURES)) {
                    this.generateSnowFeatures(world, random, blockX, blockZ, null);
                }
                if (symbolList.contains(Reference.SYMBOL_JUNGLE_STRUCTURES)) {
                    this.generateJungleFeatures(world, random, blockX, blockZ, null);
                }
                if (symbolList.contains(Reference.SYMBOL_SWAMP_STRUCTURES)) {
                    this.generateSwampFeatures(world, random, blockX, blockZ, null);
                }
                if (symbolList.contains(Reference.SYMBOL_FOREST_STRUCTURES)) {
                    this.generateForestFeatures(world, random, blockX, blockZ, null);
                }
                if (symbolList.contains(Reference.SYMBOL_PLAINS_STRUCTURES)) {
                    this.generatePlainsFeatures(world, random, blockX, blockZ, null);
                }
                if (symbolList.contains(Reference.SYMBOL_MOUNTAIN_STRUCTURES)) {
                    this.generateMountainFeatures(world, random, blockX, blockZ, null);
                }
                if (symbolList.contains(Reference.SYMBOL_MESA_STRUCTURES)) {
                    this.generateMesaFeatures(world, random, blockX, blockZ, null);
                }
                if (symbolList.contains(Reference.SYMBOL_OCEAN_STRUCTURES)) {
                    this.generateOceanFeatures(world, random, blockX, blockZ, null);
                }
                if (symbolList.contains(Reference.SYMBOL_SAVANNA_STRUCTURES)) {
                    this.generateSavannaFeatures(world, random, blockX, blockZ, null);
                }
                if (symbolList.contains(Reference.SYMBOL_WASTELAND_STRUCTURES)) {
                    this.generateWastelandFeatures(world, random, blockX, blockZ, null);
                }
                if (symbolList.contains(Reference.SYMBOL_SPOOKY_STRUCTURES)) {
                    this.generateSpookyFeatures(world, random, blockX, blockZ, null);
                }
            }
        }
        catch (NullPointerException e) {
            System.out.println("NPE in Additional Structure's Mystcraft generator");
            return;
        }
        catch (IllegalArgumentException e) {
            System.out.println("Invalid Dimension ID: " + Integer.toString(dimId));
        }
    }
}

