/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect;

import alexiy.secure.contain.protect.DefaultColors;
import alexiy.secure.contain.protect.General;
import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.api.Loot;
import alexiy.secure.contain.protect.api.LootContainer;
import alexiy.secure.contain.protect.api.OriginalContexts;
import alexiy.secure.contain.protect.api.UniqueList;
import alexiy.secure.contain.protect.registration.SCPItems;
import alexiy.secure.contain.protect.tileentity.TileDesk;
import alexiy.secure.contain.protect.tileentity.TileFileCabinet;
import alexiy.secure.contain.protect.tileentity.TileItemPlate;
import alexiy.secure.contain.protect.tileentity.TileShelf;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomUtils;

public class ServerProxy {
    public UniqueList<String> donorList;
    Gson lootFileGson;

    public void registerModel(Item item, String identifier) {
    }

    public void registerModel(Item item, int metadata, String identifier) {
    }

    public List<String> getKnowledge(Locale locale, String key) {
        return null;
    }

    public List<String> getInfo(Locale locale, String key) {
        return null;
    }

    public void preLoad() {
        this.donorList = this.loadDonorNames();
        SCP.logger.info("Loaded {} donor names", (Object)this.donorList.size());
    }

    public void load() {
        Loot rottenFlesh = new Loot(Items.field_151078_bh, 50, 2, 16, arg_0 -> ((ResourceLocation)OriginalContexts.POCKET_DIMENSION).equals(arg_0));
        Loot bones = new Loot(Items.field_151103_aS, 60, 3, 15, arg_0 -> ((ResourceLocation)OriginalContexts.POCKET_DIMENSION).equals(arg_0));
        Loot skull = new Loot(Items.field_151144_bL, 10, 1, 1, 0, arg_0 -> ((ResourceLocation)OriginalContexts.POCKET_DIMENSION).equals(arg_0));
        Loot witherSkull = new Loot(Items.field_151144_bL, 5, 1, 1, 1, arg_0 -> ((ResourceLocation)OriginalContexts.POCKET_DIMENSION).equals(arg_0));
        Loot ironHelmet = new Loot((Item)Items.field_151028_Y, 1, 1, 1, -9, arg_0 -> ((ResourceLocation)OriginalContexts.POCKET_DIMENSION).equals(arg_0));
        Loot flashlight = new Loot(SCPItems.flashlight, 5, 1, 1, arg_0 -> ((ResourceLocation)OriginalContexts.POCKET_DIMENSION).equals(arg_0));
        Loot leatherLeggings = new Loot((Item)Items.field_151026_S, stack1 -> Items.field_151021_T.func_82813_b(stack1, RandomUtils.nextBoolean() ? General.ORANGE.getARGBColor() : DefaultColors.GREEN.colorValue), 6, 1, 1, arg_0 -> ((ResourceLocation)OriginalContexts.POCKET_DIMENSION).equals(arg_0));
        Loot leatherBoots = new Loot((Item)Items.field_151021_T, stack1 -> Items.field_151021_T.func_82813_b(stack1, RandomUtils.nextBoolean() ? General.ORANGE.getARGBColor() : DefaultColors.GREEN.colorValue), 6, 1, 1, arg_0 -> ((ResourceLocation)OriginalContexts.POCKET_DIMENSION).equals(arg_0));
        Loot leatherChestpl = new Loot((Item)Items.field_151027_R, stack1 -> Items.field_151021_T.func_82813_b(stack1, RandomUtils.nextBoolean() ? General.ORANGE.getARGBColor() : DefaultColors.GREEN.colorValue), 6, 1, 1, arg_0 -> ((ResourceLocation)OriginalContexts.POCKET_DIMENSION).equals(arg_0));
        Loot leatherHelmet = new Loot((Item)Items.field_151024_Q, stack1 -> Items.field_151021_T.func_82813_b(stack1, RandomUtils.nextBoolean() ? General.ORANGE.getARGBColor() : DefaultColors.GREEN.colorValue), 6, 1, 1, arg_0 -> ((ResourceLocation)OriginalContexts.POCKET_DIMENSION).equals(arg_0));
        Loot[] loots = (Loot[])ArrayUtils.toArray((Object[])new Loot[]{rottenFlesh, bones, skull, ironHelmet, witherSkull, flashlight, leatherBoots, leatherChestpl, leatherHelmet, leatherLeggings});
        Loot[] armors = (Loot[])ArrayUtils.toArray((Object[])new Loot[]{ironHelmet, leatherBoots, leatherChestpl, leatherHelmet, leatherLeggings});
        LootContainer.registerLoot(TileFileCabinet.class, loots);
        LootContainer.registerLoot(TileShelf.class, loots);
        LootContainer.registerLoot(TileItemPlate.class, armors);
        LootContainer.registerLoot2(TileEntityDropper.class, loots);
        LootContainer.registerLoot2(TileEntityShulkerBox.class, loots);
        LootContainer.registerLoot2(TileEntityChest.class, loots);
        Loot blankDocument = new Loot(SCPItems.blankDocument, 4, 1, 3, arg_0 -> ((ResourceLocation)OriginalContexts.FACILITY).equals(arg_0));
        Loot keycard1 = new Loot(SCPItems.card1, 4, 1, 1, arg_0 -> ((ResourceLocation)OriginalContexts.FACILITY).equals(arg_0));
        Loot keycard2 = new Loot(SCPItems.card2, 3, 1, 1, arg_0 -> ((ResourceLocation)OriginalContexts.FACILITY).equals(arg_0));
        Loot keycard3 = new Loot(SCPItems.card3, 2, 1, 1, arg_0 -> ((ResourceLocation)OriginalContexts.FACILITY).equals(arg_0));
        Loot emptySyringe = new Loot(SCPItems.emptySyringe, 4, 1, 2, arg_0 -> ((ResourceLocation)OriginalContexts.FACILITY).equals(arg_0));
        Loot screwdriver = new Loot(SCPItems.screwdriver, 2, 1, 1, arg_0 -> ((ResourceLocation)OriginalContexts.FACILITY).equals(arg_0));
        Loot visionGoggles = new Loot(SCPItems.nightvisionGoggles, 2, 1, 1, arg_0 -> ((ResourceLocation)OriginalContexts.FACILITY).equals(arg_0));
        Loot battery = new Loot(SCPItems.battery, 10, 1, 4, arg_0 -> ((ResourceLocation)OriginalContexts.FACILITY).equals(arg_0));
        Loot panacea = new Loot(SCPItems.panaceaPills, 5, 1, 1, arg_0 -> ((ResourceLocation)OriginalContexts.FACILITY).equals(arg_0));
        Loot book = new Loot(Items.field_151122_aG, 16, 4, 13, arg_0 -> ((ResourceLocation)OriginalContexts.FACILITY).equals(arg_0));
        Loot flashlight2 = new Loot(SCPItems.flashlight, 2, 1, 1, arg_0 -> ((ResourceLocation)OriginalContexts.FACILITY).equals(arg_0));
        Loot[] facilityLoot = (Loot[])ArrayUtils.toArray((Object[])new Loot[]{blankDocument, keycard1, keycard2, keycard3, emptySyringe, screwdriver, visionGoggles, battery, panacea, book, flashlight2});
        LootContainer.registerLoot(TileDesk.class, facilityLoot);
        LootContainer.registerLoot(TileFileCabinet.class, facilityLoot);
        LootContainer.registerLoot(TileShelf.class, facilityLoot);
        LootContainer.registerLoot2(TileEntityChest.class, facilityLoot);
        this.lootFileGson = new GsonBuilder().setPrettyPrinting().create();
        Path lootFolder = Paths.get("config", "scp".toUpperCase() + " loot files");
        if (Files.notExists(lootFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(lootFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Field field = Utils.getSecureField(TileEntity.class, 1);
            if (field != null && field.getType() == RegistryNamespaced.class) {
                RegistryNamespaced tileEntityRegistry = (RegistryNamespaced)field.get(TileEntity.class);
                Stream<Path> lootfiles = Files.list(lootFolder);
                lootfiles.forEach(path -> {
                    try {
                        JsonArray o = (JsonArray)this.lootFileGson.fromJson(new JsonReader((Reader)new FileReader(path.toFile())), JsonArray.class);
                        o.forEach(jsonElement -> {
                            JsonObject jsonObject = jsonElement.getAsJsonObject();
                            String itemIdentifier = jsonObject.get("item_id").getAsString();
                            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemIdentifier));
                            if (item != null) {
                                int metavalue = 0;
                                if (jsonObject.has("metadata")) {
                                    metavalue = jsonObject.get("metadata").getAsInt();
                                }
                                int minimum = jsonObject.get("min_count").getAsInt();
                                int maximum = jsonObject.get("max_count").getAsInt();
                                int probability = jsonObject.get("chance").getAsInt();
                                JsonArray contexts = jsonObject.getAsJsonArray("contexts");
                                ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>(contexts.size());
                                for (JsonElement context : contexts) {
                                    ResourceLocation rs = new ResourceLocation(context.getAsString());
                                    resourceLocations.add(rs);
                                }
                                JsonArray targettiles = jsonObject.getAsJsonArray("tile_entities");
                                HashSet otherContainers = new HashSet(targettiles.size());
                                HashSet lootContainers = new HashSet(targettiles.size());
                                targettiles.forEach(jsonElement1 -> {
                                    ResourceLocation tl = new ResourceLocation(jsonElement1.getAsString());
                                    Class tileEntityClass = (Class)tileEntityRegistry.func_82594_a((Object)tl);
                                    if (tileEntityClass != null) {
                                        if (LootContainer.class.isAssignableFrom(tileEntityClass)) {
                                            lootContainers.add(tileEntityClass);
                                        } else {
                                            otherContainers.add(tileEntityClass);
                                        }
                                    } else {
                                        SCP.logger.error("Tile entity with id {} doesn't exist", (Object)tl);
                                    }
                                });
                                Loot loot = new Loot(item, probability, minimum, maximum, metavalue, resourceLocations::contains, tileEntity -> otherContainers.contains(tileEntity.getClass()) || lootContainers.contains(tileEntity.getClass()), null);
                                for (Class lootContainer : lootContainers) {
                                    LootContainer.registerLoot(lootContainer, loot);
                                }
                                for (Class otherContainer : otherContainers) {
                                    LootContainer.registerLoot2(otherContainer, loot);
                                }
                                SCP.logger.info("Registered {} loot pool to {} tile entities", (Object)itemIdentifier, (Object)(lootContainers.size() + otherContainers.size()));
                            }
                        });
                        SCP.logger.info("Completed parsing of {} with {} entries", (Object)path.getFileName(), (Object)o.size());
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                });
                lootfiles.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerCustomMeshDefinition(Item item, ModelResourceLocation modelResourceLocation) {
    }

    public void registerCustomMeshDefinition(Item item, ItemMeshDefinition meshDefinition) {
    }

    public void registerStateMapper(Block block, ModelResourceLocation modelResourceLocation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniqueList<String> loadDonorNames() {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("assets/scp/donors.txt");
        try {
            if (stream != null) {
                List strings = IOUtils.readLines((InputStream)stream, (String)"UTF-8");
                UniqueList<String> uniqueList = new UniqueList<String>((Collection<String>)strings);
                return uniqueList;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

