/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect;

import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public class SoundCooldown<T extends EntityLivingBase> {
    private final HashMap<T, Integer> cooldowns = new HashMap();
    private final SoundEvent sound;
    private final SoundCategory category;
    private final Predicate<T> condition;
    private CooldownHandler<T> cooldownHandler;

    public SoundCooldown(int cooldown, SoundEvent sound, SoundCategory category) {
        this(cooldown, sound, category, (T input) -> true);
    }

    public SoundCooldown(int cooldown, SoundEvent sound, SoundCategory category, Predicate<T> condition) {
        this(sound, category, condition, new CooldownHandler(cooldown));
    }

    public SoundCooldown(SoundEvent sound, SoundCategory category, Predicate<T> condition, CooldownHandler<T> cooldownHandler) {
        this.sound = sound;
        this.category = category;
        this.condition = condition;
        this.cooldownHandler = cooldownHandler;
    }

    public void updateCooldowns(T entity) {
        if (this.condition.test(entity)) {
            this.cooldowns.put(entity, this.cooldowns.getOrDefault(entity, 0) - 1);
            if (this.cooldownHandler.test(this.cooldowns, entity)) {
                if (entity instanceof EntityPlayer) {
                    ((EntityLivingBase)entity).field_70170_p.func_184133_a((EntityPlayer)entity, entity.func_180425_c(), this.sound, this.category, 1.0f, 1.0f);
                } else {
                    ((EntityLivingBase)entity).field_70170_p.func_184134_a(((EntityLivingBase)entity).field_70165_t, ((EntityLivingBase)entity).field_70163_u, ((EntityLivingBase)entity).field_70161_v, this.sound, this.category, 1.0f, 1.0f, true);
                }
                this.cooldowns.put(entity, this.cooldownHandler.getCooldown(entity));
            }
        } else {
            this.cooldowns.remove(entity);
        }
    }

    public static class CooldownHandler<T extends EntityLivingBase> {
        private final int cooldown;

        public CooldownHandler() {
            this(0);
        }

        public CooldownHandler(int cooldown) {
            this.cooldown = cooldown;
        }

        public boolean test(HashMap<T, Integer> cooldownMap, T entity) {
            return cooldownMap.get(entity) <= 0;
        }

        public int getCooldown(T entity) {
            return this.cooldown;
        }
    }
}

