/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect;

import alexiy.secure.contain.protect.Configg;
import alexiy.secure.contain.protect.General;
import alexiy.secure.contain.protect.IntegerColor;
import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.ai.OpenDoor;
import alexiy.secure.contain.protect.world.PlacementSettings2;
import alexiy.secure.contain.protect.world.TemplateUnwrapper;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class Utils {
    public static void addPotionEffectNoParticles(EntityLivingBase entityLivingBase, Potion potion, int duration, int strength) {
        entityLivingBase.func_70690_d(new PotionEffect(potion, duration, strength, false, false));
    }

    public static Entity spawnEntity(World world, Entity entity, BlockPos position) {
        Vec3d vec3d = Utils.getPositionForEntityFrom(position);
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            entity.func_70012_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_180482_a(world.func_175649_E(position), null);
            world.func_72838_d(entity);
            entityliving.func_70642_aH();
        } else if (entity != null) {
            entity.func_70012_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            world.func_72838_d(entity);
        }
        if (world.field_72995_K) {
            SCP.logger.warn("Spawned {} in client world!", (Object)entity);
        }
        return entity;
    }

    public static Entity spawnEntity(World world, ResourceLocation entityId, BlockPos pos) {
        if (entityId != null && EntityList.field_75627_a.containsKey(entityId)) {
            Vec3d vec3d = Utils.getPositionForEntityFrom(pos);
            Entity entity = EntityList.func_188429_b((ResourceLocation)entityId, (World)world);
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                entity.func_70012_b(vec3d.field_72450_a + 0.5, vec3d.field_72448_b, vec3d.field_72449_c + 0.5, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                entityliving.field_70759_as = entityliving.field_70177_z;
                entityliving.field_70761_aq = entityliving.field_70177_z;
                entityliving.func_180482_a(world.func_175649_E(pos), null);
                world.func_72838_d(entity);
                entityliving.func_70642_aH();
            } else if (entity != null) {
                entity.func_70012_b(vec3d.field_72450_a + 0.5, vec3d.field_72448_b, vec3d.field_72449_c + 0.5, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                world.func_72838_d(entity);
            }
            return entity;
        }
        return null;
    }

    public static boolean deobfuscated() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    public static int ticksToSeconds(int ticks) {
        return ticks / 20;
    }

    public static int ticksToMinutes(int ticks) {
        return Utils.ticksToSeconds(ticks) / 60;
    }

    public static int ticksToHours(int ticks) {
        return Utils.ticksToMinutes(ticks) / 60;
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static int minutesToTicks(int minutes) {
        return Utils.secondsToTicks(minutes * 60);
    }

    public static int hoursToTicks(int hours) {
        return Utils.minutesToTicks(hours * 60);
    }

    public static float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    @Nullable
    public static Entity findEntityOnPath(Vec3d start, Vec3d end, World world, Entity exclude) {
        double range = 50.0;
        if (exclude instanceof EntityLiving) {
            range = ((EntityLiving)exclude).func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        } else if (exclude instanceof EntityPlayer) {
            range = 100.0;
        }
        Entity entity = null;
        List list = world.func_175674_a(exclude, exclude.func_174813_aQ().func_186662_g(range), null);
        double d0 = 0.0;
        for (Entity e : list) {
            double d1;
            AxisAlignedBB axisalignedbb = e.func_174813_aQ();
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(start, end);
            if (raytraceresult == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = e;
            d0 = d1;
        }
        return entity;
    }

    public static boolean isPlayerInSurvivalMode(EntityPlayer entityPlayer) {
        return !entityPlayer.func_175149_v() && !entityPlayer.func_184812_l_();
    }

    public static float getDefaultXRightLimbRotation(float limbSwing, float swingAmount) {
        return MathHelper.func_76134_b((float)((float)((double)limbSwing + Math.PI))) * swingAmount;
    }

    public static float getDefaultXLeftLimbRotation(float limbSwing, float swingAmount) {
        return MathHelper.func_76134_b((float)limbSwing) * swingAmount;
    }

    public static float getDefaultHeadYaw(float netYaw) {
        return netYaw * ((float)Math.PI / 180);
    }

    public static float getDefaultHeadPitch(float pitch) {
        return pitch * ((float)Math.PI / 180);
    }

    public static void sendMessageTo(EntityPlayer entityPlayer, String message) {
        entityPlayer.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    public static boolean isEntitySurvivalPlayer(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return Utils.isPlayerInSurvivalMode((EntityPlayer)entity);
        }
        return false;
    }

    public static float degreesToRadians(float degrees) {
        return (float)((double)degrees * Math.PI / 180.0);
    }

    public static void dropTileItems(TileEntity tileEntity) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            assert (!tileEntity.func_145831_w().field_72995_K) : "Don't drop items in client world";
            IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            Vec3d droplocation = Utils.getPositionForEntityFrom(tileEntity.func_174877_v());
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack itemStack = itemHandler.getStackInSlot(i);
                if (itemStack.func_190926_b()) continue;
                EntityItem entityItem = new EntityItem(tileEntity.func_145831_w(), droplocation.field_72450_a, droplocation.field_72448_b, droplocation.field_72449_c, itemStack);
                tileEntity.func_145831_w().func_72838_d((Entity)entityItem);
            }
        }
    }

    public static boolean isInSightOf(Entity watched, EntityLivingBase watcher, float angleRange) {
        float threshold;
        assert (angleRange <= 180.0f);
        Vec3d vecOne = new Vec3d(watched.field_70165_t - watcher.field_70165_t, watched.field_70163_u + (double)watched.func_70047_e() - watcher.field_70163_u - (double)watcher.func_70047_e(), watched.field_70161_v - watcher.field_70161_v).func_72432_b();
        Vec3d vecTwo = watcher.func_70676_i(1.0f).func_72432_b();
        double dotproduct = vecTwo.func_72430_b(vecOne);
        if (dotproduct > (double)(threshold = (180.0f - angleRange) / 180.0f)) {
            return watcher.func_70685_l(watched);
        }
        return false;
    }

    public static boolean isInSightOf(Entity watched, EntityLivingBase watcher, float angleRange, boolean bypassBlocks) {
        double threshold;
        Vec3d vecOne = new Vec3d(watched.field_70165_t - watcher.field_70165_t, watched.field_70163_u + (double)watched.func_70047_e() - watcher.field_70163_u - (double)watcher.func_70047_e(), watched.field_70161_v - watcher.field_70161_v).func_72432_b();
        Vec3d vecTwo = watcher.func_70676_i(1.0f).func_72432_b();
        double dotproduct = vecTwo.func_72430_b(vecOne);
        if (dotproduct > (threshold = (double)(180.0f - angleRange) / 180.0)) {
            return bypassBlocks || watcher.func_70685_l(watched);
        }
        return false;
    }

    public static boolean isWatcherLookingAtHead(EntityLivingBase watcher, Entity target) {
        Vec3d lookvector = watcher.func_70676_i(1.0f).func_72432_b();
        Vec3d positionvector = new Vec3d(target.field_70165_t - watcher.field_70165_t, watcher.func_174813_aQ().field_72338_b + (double)target.func_70047_e() - (watcher.field_70163_u + (double)watcher.func_70047_e()), target.field_70161_v - watcher.field_70161_v);
        double lengthVector = positionvector.func_72433_c();
        double dotProduct = lookvector.func_72430_b(positionvector = positionvector.func_72432_b());
        if (dotProduct > 1.0 - 0.025 / lengthVector) {
            return watcher.func_70685_l(target);
        }
        return false;
    }

    public static boolean isLookingAt(EntityLivingBase watcher, Entity target, double degreeRange, boolean mustSeeFace, Block ... canSeeThrough) {
        double threshold;
        boolean lookingAt;
        Vec3d positionVect = new Vec3d(target.field_70165_t - watcher.field_70165_t, target.field_70163_u + (double)target.func_70047_e() - watcher.field_70163_u - (double)watcher.func_70047_e(), target.field_70161_v - watcher.field_70161_v).func_72432_b();
        Vec3d vecTwo = watcher.func_70676_i(1.0f);
        double length = Math.sqrt(vecTwo.field_72450_a * vecTwo.field_72450_a + vecTwo.field_72448_b * vecTwo.field_72448_b + vecTwo.field_72449_c * vecTwo.field_72449_c);
        double dotproduct = vecTwo.func_72430_b(positionVect);
        boolean bl = lookingAt = dotproduct > (threshold = (180.0 - degreeRange) / 180.0) / length;
        if (mustSeeFace) {
            lookingAt = dotproduct > length - 0.001;
        }
        World world = watcher.field_70170_p;
        if (canSeeThrough.length > 0) {
            Vec3d increment = vecTwo.func_186678_a(0.9);
            Vec3d nextVector = new Vec3d(watcher.field_70165_t, watcher.field_70163_u + (double)watcher.func_70047_e(), watcher.field_70161_v);
            int c = 0;
            double range = 50.0;
            if (target instanceof EntityLiving) {
                range = ((EntityLiving)target).func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
            }
            Vec3d positionEyes = target.func_174824_e(1.0f);
            BlockPos eyepos = new BlockPos((double)Math.round(positionEyes.field_72450_a), (double)Math.round(positionEyes.field_72448_b), (double)Math.round(positionEyes.field_72449_c));
            while (!((double)c > range)) {
                ++c;
                BlockPos nextpos = new BlockPos((double)Math.round(nextVector.field_72450_a), (double)Math.round(nextVector.field_72448_b), (double)Math.round(nextVector.field_72449_c));
                Block block = world.func_180495_p(nextpos).func_177230_c();
                if (block != Blocks.field_150350_a && !ArrayUtils.contains((Object[])canSeeThrough, (Object)block)) break;
                if (target.func_174813_aQ().func_72318_a(nextVector) && nextpos.equals((Object)eyepos)) {
                    return lookingAt;
                }
                nextVector = nextVector.func_178787_e(increment);
            }
            return lookingAt && watcher.func_70685_l(target);
        }
        return lookingAt;
    }

    public static boolean isLookingAtBlock(Entity watcher, BlockPos position, float angleRange, Block targetBlock) {
        RayTraceResult traceResult;
        float threshold;
        assert (angleRange <= 180.0f);
        Vec3d target = new Vec3d((double)position.func_177958_n() + 0.5 - watcher.field_70165_t, (double)position.func_177956_o() + 0.5 - watcher.field_70163_u - (double)watcher.func_70047_e(), (double)position.func_177952_p() + 0.5 - watcher.field_70161_v).func_72432_b();
        Vec3d lookDirection = watcher.func_70676_i(1.0f).func_72432_b();
        double dotproduct = lookDirection.func_72430_b(target);
        if (dotproduct > (double)(threshold = (180.0f - angleRange) / 180.0f) && (traceResult = watcher.field_70170_p.func_147447_a(new Vec3d(watcher.field_70165_t, watcher.field_70163_u + (double)watcher.func_70047_e(), watcher.field_70161_v), Utils.getPositionForEntityFrom(position), false, true, false)) != null) {
            BlockPos resultpos = traceResult.func_178782_a();
            return watcher.field_70170_p.func_180495_p(resultpos).func_177230_c() == targetBlock;
        }
        return false;
    }

    public static boolean canSeeThroughBlocks(EntityLivingBase watcher, EntityLivingBase target, float angleRange, Block ... ignoredBlocks) {
        return false;
    }

    public static Vec3d getPositionForEntityFrom(BlockPos position) {
        return new Vec3d((double)position.func_177958_n() + 0.5, (double)position.func_177956_o(), (double)position.func_177952_p() + 0.5);
    }

    public static boolean isBlockNearby(World world, Block block, AxisAlignedBB searchRadius, Predicate<IBlockState> filter) {
        for (double x = searchRadius.field_72340_a; x < searchRadius.field_72336_d; x += 1.0) {
            for (double z = searchRadius.field_72339_c; z < searchRadius.field_72334_f; z += 1.0) {
                for (double y = searchRadius.field_72338_b; y < searchRadius.field_72337_e; y += 1.0) {
                    IBlockState blockState = world.func_180495_p(new BlockPos(x, y, z));
                    if (blockState.func_177230_c() != block || !filter.test(blockState)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isBlockNearby(World world, Block block, AxisAlignedBB searchRadius) {
        return Utils.isBlockNearby(world, block, searchRadius, input -> true);
    }

    public static <T extends Entity> List<T> getEntitiesInside(World world, Class<T> cls, AxisAlignedBB axisAlignedBB, Predicate<T> condition) {
        List entities = world.func_72872_a(cls, axisAlignedBB);
        if (condition != null) {
            entities.removeIf(condition.negate());
        }
        return entities;
    }

    public static <T extends Entity> List<T> getEntitiesInsideExcept(Entity entity, Class<T> cls, AxisAlignedBB axisAlignedBB, Predicate<T> condition) {
        List entities = entity.field_70170_p.func_72872_a(cls, axisAlignedBB);
        if (condition != null) {
            entities.removeIf(condition.negate());
        }
        entities.remove(entity);
        return entities;
    }

    public static void makeEntityJump(EntityLivingBase entityLivingBase, double amount) {
        double d = entityLivingBase.field_70181_x = amount == 0.0 ? 0.42 : amount;
        if (entityLivingBase.func_70644_a(MobEffects.field_76430_j)) {
            entityLivingBase.field_70181_x += (double)((float)(entityLivingBase.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        if (entityLivingBase.func_70051_ag()) {
            float f = entityLivingBase.field_70177_z * ((float)Math.PI / 180);
            entityLivingBase.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
            entityLivingBase.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        }
        entityLivingBase.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)entityLivingBase);
    }

    public static void show(String message, Object ... insertions) {
        SCP.info(Utils.interpolateString(message, insertions));
    }

    public static TextComponentTranslation translate(String k, Object ... values) {
        return new TextComponentTranslation("scp." + k, values);
    }

    public static boolean isAtPositionBrighterThan(World world, EntityLivingBase entity, int lightLevel) {
        return Utils.isBrighterThan(lightLevel, world, entity.func_180425_c());
    }

    public static boolean isBrighterThan(int lightLevel, World world, BlockPos blockPos) {
        int blocklight = world.func_175642_b(EnumSkyBlock.BLOCK, blockPos);
        if (blocklight > lightLevel) {
            return true;
        }
        boolean underSky = world.func_175710_j(blockPos);
        return underSky && world.func_175699_k(blockPos) > lightLevel;
    }

    @Nullable
    public static <T extends Entity> T getClosestEntity(BlockPos pos, Class<T> entityClass, World world, AxisAlignedBB aabb) {
        return Utils.getClosestEntity(pos, entityClass, world, aabb, input -> true);
    }

    @Nullable
    public static <T extends Entity> T getClosestEntity(BlockPos pos, Class<T> entityClass, World world, AxisAlignedBB aabb, com.google.common.base.Predicate<T> predicate) {
        List nearbyEntities = world.func_175647_a(entityClass, aabb, predicate);
        Entity closestEntity = null;
        for (Entity entity : nearbyEntities) {
            if (closestEntity == null) {
                closestEntity = entity;
                continue;
            }
            if (!(entity.func_174818_b(pos) < closestEntity.func_174818_b(pos))) continue;
            closestEntity = entity;
        }
        return (T)closestEntity;
    }

    public static boolean areItemTypesEqual(ItemStack one, ItemStack two) {
        if (!one.func_190926_b() && !two.func_190926_b()) {
            return one.func_77973_b() == two.func_77973_b() && one.func_77952_i() == two.func_77952_i() && one.func_77973_b().getRegistryName().equals((Object)two.func_77973_b().getRegistryName()) && ItemStack.func_77970_a((ItemStack)one, (ItemStack)two);
        }
        return false;
    }

    public static boolean areItemsEqualInDictionary(ItemStack one, ItemStack two) {
        if (!one.func_190926_b() && !two.func_190926_b()) {
            int[] firstIDs = OreDictionary.getOreIDs((ItemStack)one);
            int[] secondIDs = OreDictionary.getOreIDs((ItemStack)two);
            for (int f : firstIDs) {
                for (int s : secondIDs) {
                    if (f != s) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String interpolateString(String message, Object ... insertions) {
        for (Object ob : insertions) {
            message = StringUtils.replaceOnce((String)message, (String)"$$", (String)(ob == null ? "null" : ob.toString()));
        }
        return message;
    }

    public static BlockPos getPosAboveSolidBlock(World world, BlockPos blockPos) {
        blockPos = blockPos.func_177981_b(world.func_72940_L());
        IBlockState blockState = world.func_180495_p(blockPos);
        while (blockState.func_185904_a().func_76222_j() || blockState.func_185904_a() == Material.field_151584_j) {
            blockPos = blockPos.func_177977_b();
            blockState = world.func_180495_p(blockPos);
        }
        blockPos = blockPos.func_177984_a();
        return blockPos;
    }

    public static EntityItem spawnItemInWorld(ItemStack itemStack, World world, BlockPos pos) {
        if (world.field_72995_K) {
            throw new IllegalArgumentException("Don't spawn items in client world");
        }
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, itemStack);
        world.func_72838_d((Entity)entityItem);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70179_y = 0.0;
        entityItem.field_70181_x = 0.0;
        return entityItem;
    }

    public static boolean canReplaceBlock(BlockPos blockPos, World world) {
        IBlockState iBlockState = world.func_180495_p(blockPos);
        if (iBlockState.func_177230_c().hasTileEntity(iBlockState)) {
            return false;
        }
        return iBlockState.func_185887_b(world, blockPos) != -1.0f;
    }

    public static Field getSecureField(Class owner, int number) {
        Field[] fields = owner.getDeclaredFields();
        if (number < fields.length) {
            Field f = fields[number];
            if (f.getType() != owner.getEnclosingClass()) {
                f.setAccessible(true);
                return f;
            }
            return Utils.getSecureField(owner.getSuperclass(), number);
        }
        return null;
    }

    public static Field getSecureField(Class owningClass, String field) {
        Field f = null;
        try {
            f = owningClass.getDeclaredField(field);
            f.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            if (owningClass.getSuperclass() != null) {
                return Utils.getSecureField(owningClass.getSuperclass(), field);
            }
            System.err.println("Searched all super classes - field " + field + " not found");
        }
        return f;
    }

    public static int calculateStringWidth(String string) {
        if (string != null) {
            return Minecraft.func_71410_x().field_71466_p.func_78256_a(string);
        }
        return 0;
    }

    public static void sendToPlayersAround(IMessage message, World world, BlockPos blockPos, int range, SimpleNetworkWrapper networkWrapper) {
        networkWrapper.sendToAllAround(message, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), (double)range));
    }

    public static void sendToPlayersAround(IMessage message, World world, BlockPos blockPos, SimpleNetworkWrapper networkWrapper) {
        Utils.sendToPlayersAround(message, world, blockPos, 7, networkWrapper);
    }

    public static EnumFacing randomHorizontalFacing() {
        return EnumFacing.field_176754_o[General.RANDOM_GENERATOR.nextInt(EnumFacing.field_176754_o.length)];
    }

    public static void playSound(World world, BlockPos blockPos, SoundEvent sound, float volume, float pitch) {
        if (world != null) {
            world.func_184134_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), sound, null, volume, pitch, false);
        }
    }

    public static ItemStack tryExtractItems(IItemHandler itemHandler, ItemStack itemStack, boolean simulate) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack presentstack = itemHandler.getStackInSlot(slot);
            if (!Utils.areItemTypesEqual(itemStack, presentstack)) continue;
            return itemHandler.extractItem(slot, itemStack.func_190916_E(), simulate);
        }
        return ItemStack.field_190927_a;
    }

    public static void openContainerUI(EntityPlayer player, BlockPos blockPos, int guiID, Object mod) {
        if (!player.field_70170_p.field_72995_K) {
            player.openGui(mod, guiID, player.field_70170_p, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }
    }

    public static void openClientGui(World world, EntityPlayer player, int guiID, BlockPos position, Object mod) {
        if (world.field_72995_K) {
            player.openGui(mod, guiID, world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        }
    }

    public static void drawVerticalLine(int x, int startY, int endY, IntegerColor color) {
        Gui.func_73734_a((int)x, (int)startY, (int)(x + 1), (int)endY, (int)color.getARGBColor());
    }

    public static void drawHorizontalLine(int startX, int endX, int y, IntegerColor color) {
        Gui.func_73734_a((int)startX, (int)y, (int)(endX + 1), (int)(y + 1), (int)color.getARGBColor());
    }

    public static void drawString(Object o, int X, int Y, IntegerColor color) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b(o.toString(), X, Y, color.getARGBColor());
    }

    public static void sendTranslatedMessageToPlayer(EntityPlayer player, String tkey) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation(tkey, new Object[0]));
    }

    public static List<BlockPos> boundingBoxToPositions(AxisAlignedBB axisAlignedBB) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (double X = axisAlignedBB.field_72340_a; X <= axisAlignedBB.field_72336_d; X += 1.0) {
            for (double Y = axisAlignedBB.field_72338_b; Y <= axisAlignedBB.field_72337_e; Y += 1.0) {
                for (double Z = axisAlignedBB.field_72339_c; Z <= axisAlignedBB.field_72334_f; Z += 1.0) {
                    positions.add(new BlockPos(X, Y, Z));
                }
            }
        }
        return positions;
    }

    public static void sendBlockUpdate(WorldServer worldServer, BlockPos blockPos) {
        IBlockState blockState = worldServer.func_180495_p(blockPos);
        worldServer.func_184138_a(blockPos, blockState, blockState, 2);
    }

    public static ArrayList<BlockPos> getConnectedBlockPositions(World world, IBlockState block, BlockPos start, EnumFacing[] facings, ArrayList<BlockPos> startingList) {
        for (EnumFacing value : facings) {
            BlockPos side = start.func_177972_a(value);
            IBlockState b = world.func_180495_p(side);
            if (b != block || startingList.contains(side)) continue;
            startingList.add(side);
            Utils.getConnectedBlockPositions(world, block, side, (EnumFacing[])ArrayUtils.removeElement((Object[])EnumFacing.field_82609_l, (Object)value.func_176734_d()), startingList);
        }
        return startingList;
    }

    @Deprecated
    public static Color getRandomColor() {
        return new Color(General.RANDOM_GENERATOR.nextInt(256), General.RANDOM_GENERATOR.nextInt(256), General.RANDOM_GENERATOR.nextInt(256));
    }

    public static BlockPos chunkPosToBlockPosition(int chunkX, int chunkZ) {
        return new BlockPos(chunkX << 4, 0, chunkZ << 4);
    }

    public static boolean areChunksGeneratedAroundChunk(int cx, int cz, World world) {
        return world.func_190526_b(cx + 1, cz) && world.func_190526_b(cx - 1, cz) && world.func_190526_b(cx, cz + 1) && world.func_190526_b(cx, cz - 1);
    }

    public static boolean areChunksGeneratedAroundChunk(ChunkPos chunkPos, World world) {
        return Utils.areChunksGeneratedAroundChunk(chunkPos.field_77276_a, chunkPos.field_77275_b, world);
    }

    public static void exitJava() {
        FMLCommonHandler.instance().exitJava(0, false);
    }

    public static boolean canPlayerEditPosition(EntityPlayer player, BlockPos pos, EnumFacing facing, EnumHand hand) {
        return player.func_175151_a(pos, facing, player.func_184586_b(hand));
    }

    public static void addTask(EntityAIBase ai, int priority, EntityLiving entityCreature) {
        if (ai instanceof EntityAITarget) {
            entityCreature.field_70715_bh.func_75776_a(priority, ai);
        } else {
            entityCreature.field_70714_bg.func_75776_a(priority, ai);
        }
    }

    public static void addTask(EntityAIBase ai, int priority, int mutexBits, EntityLiving living) {
        ai.func_75248_a(mutexBits);
        Utils.addTask(ai, priority, living);
    }

    public static List<BlockPos> getPositions(BlockPos cornerOne, BlockPos cornerTwo) {
        Iterable mutableBlockPos = BlockPos.func_177975_b((BlockPos)cornerOne, (BlockPos)cornerTwo);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (BlockPos.MutableBlockPos mutableBlockPo : mutableBlockPos) {
            positions.add(mutableBlockPo.func_185334_h());
        }
        return positions;
    }

    public static void enableDoorEnter(EntityLiving entityLiving, boolean doClose) {
        PathNavigate pathNavigate = entityLiving.func_70661_as();
        if (pathNavigate instanceof PathNavigateGround) {
            PathNavigateGround navigateGround = (PathNavigateGround)pathNavigate;
            navigateGround.func_179688_b(true);
            navigateGround.func_179691_c(true);
            entityLiving.field_70714_bg.func_75776_a(7, (EntityAIBase)new OpenDoor(entityLiving, doClose));
        }
    }

    public static boolean isFluid(IBlockState iBlockState) {
        Block block = iBlockState.func_177230_c();
        return block instanceof BlockFluidBase || block instanceof BlockLiquid;
    }

    public static void generateTemplate(BlockPos start, WorldServer worldServer, ResourceLocation structureLocation) {
        start = worldServer.func_175672_r(start);
        TemplateManager templateManager = worldServer.func_184163_y();
        Template facility = templateManager.func_189942_b(worldServer.func_73046_m(), structureLocation);
        if (facility != null) {
            EnumFacing facing = Utils.randomHorizontalFacing();
            PlacementSettings2 placementSettings2 = new PlacementSettings2(facing);
            TemplateUnwrapper unwrapper = new TemplateUnwrapper(facility);
            List<Template.BlockInfo> blockInfo = unwrapper.getBlockInfoList();
            for (Template.BlockInfo b : blockInfo) {
                BlockPos adjustedPosition = Template.func_186266_a((PlacementSettings)placementSettings2, (BlockPos)b.field_186242_a).func_177971_a((Vec3i)start);
                if (Utils.canReplaceBlock(adjustedPosition, (World)worldServer)) continue;
                return;
            }
            facility.func_186253_b((World)worldServer, start, (PlacementSettings)placementSettings2);
            List<Template.EntityInfo> list = unwrapper.getEntityInfoList();
            for (Template.EntityInfo entityInfo : list) {
                Vec3d vec3d = entityInfo.field_186247_a;
                NBTTagCompound compound = entityInfo.field_186249_c;
                Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)worldServer);
                if (entity == null) continue;
                Class<?> enclass = entity.getClass();
                entity = EntityList.func_191304_a(enclass, (World)worldServer);
                BlockPos adjustedPosition = Template.func_186266_a((PlacementSettings)placementSettings2, (BlockPos)new BlockPos(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c)).func_177971_a((Vec3i)start);
                boolean entityReplaced = false;
                List entityLivings = worldServer.func_72872_a(EntityLiving.class, new AxisAlignedBB(adjustedPosition));
                for (EntityLiving entityLiving : entityLivings) {
                    if (entity == null || entityLiving.getClass() != enclass) continue;
                    if (entity instanceof EntityLiving) {
                        EntityLiving living = (EntityLiving)entity;
                        living.func_180482_a(worldServer.func_175649_E(adjustedPosition), null);
                    }
                    entity.func_70107_b(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v);
                    entityLiving.func_70106_y();
                    worldServer.func_72838_d(entity);
                    if (!Configg.experimentalSettings.enableDebugInformation) continue;
                    entityReplaced = true;
                    SCP.logger.info("Replaced " + entityLiving.func_70005_c_() + " with new instance");
                }
                if (!Configg.experimentalSettings.enableDebugInformation || entityReplaced || entity == null) continue;
                SCP.logger.info("Didn't replace " + entity.func_70005_c_());
            }
        }
    }

    public static BlockPos findAir(BlockPos startPosn, boolean upwards, World world) {
        while (!world.func_175623_d(startPosn) && (startPosn = upwards ? startPosn.func_177984_a() : startPosn.func_177977_b()).func_177956_o() >= 1 && startPosn.func_177956_o() <= 254) {
        }
        return startPosn;
    }

    public static boolean isLivingEntity(Entity entityLivingBase) {
        if (entityLivingBase instanceof EntityArmorStand) {
            return false;
        }
        if (entityLivingBase instanceof EntityPlayer) {
            return Utils.isEntitySurvivalPlayer(entityLivingBase);
        }
        return entityLivingBase instanceof EntityLiving;
    }

    public static void copyRotation(ModelRenderer to, ModelRenderer from) {
        to.field_78795_f = from.field_78795_f;
        to.field_78796_g = from.field_78796_g;
        to.field_78808_h = from.field_78808_h;
    }

    public static double getFraction(double number) {
        return number - Math.floor(number);
    }

    public static float translateToXcoord(float degrees) {
        if (degrees == 90.0f || degrees == -90.0f) {
            return 0.0f;
        }
        if (degrees == 180.0f || degrees == -180.0f) {
            return -1.0f;
        }
        return MathHelper.func_76134_b((float)Utils.degreesToRadians(degrees));
    }

    public static float translateToZcoord(float degrees) {
        if (degrees == 90.0f || degrees == -90.0f) {
            return 1.0f;
        }
        if (degrees == 180.0f || degrees == -180.0f) {
            return 0.0f;
        }
        return MathHelper.func_76126_a((float)Utils.degreesToRadians(degrees));
    }
}

