/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.api;

import alexiy.secure.contain.protect.General;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.RandomUtils;

public class Loot {
    protected ItemStack loot;
    protected int chance;
    protected int minCount;
    protected int maxCount;
    protected int meta;
    protected Predicate<ResourceLocation> context;
    protected Predicate<TileEntity> tileEntityPredicate;
    protected Consumer<ItemStack> itemOperations;

    public Loot(Item loot, int chance, int minCount, int maxCount, Predicate<ResourceLocation> context, Predicate<TileEntity> containerPredicate) {
        this(loot, chance, minCount, maxCount, 0, context, containerPredicate, null);
    }

    public Loot(Item loot, int chance, int minCount, int maxCount, Predicate<ResourceLocation> context) {
        this(loot, chance, minCount, maxCount, 0, context, null, null);
    }

    public Loot(Block loot, int chance, int minCount, int maxCount, int meta, Predicate<ResourceLocation> context, Predicate<TileEntity> containerPredicate) {
        this(Item.func_150898_a((Block)loot), chance, minCount, maxCount, meta, context, containerPredicate, null);
    }

    public Loot(Item loot, int chance, int minCount, int maxCount, int meta, Predicate<ResourceLocation> context, Predicate<TileEntity> containerPredicate, Consumer<ItemStack> itemOperations) {
        assert (loot != null) : "Item is null";
        this.loot = new ItemStack(loot, 1, meta);
        this.chance = MathHelper.func_76125_a((int)chance, (int)1, (int)100);
        this.minCount = MathHelper.func_76125_a((int)minCount, (int)1, (int)64);
        this.maxCount = MathHelper.func_76125_a((int)maxCount, (int)1, (int)64);
        this.meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
        this.context = context;
        this.tileEntityPredicate = containerPredicate;
        this.itemOperations = itemOperations;
    }

    public Loot(Item item, Consumer<ItemStack> operation, int chance, int minCount, int maxCount, Predicate<ResourceLocation> context) {
        this(item, chance, minCount, maxCount, 0, context, null, operation);
    }

    public Loot(Item loot, int chance, int minCount, int maxCount, int meta, Predicate<ResourceLocation> context) {
        this(loot, chance, minCount, maxCount, context);
    }

    public Loot(Block block, int chance, int minCount, int maxCount, Predicate<ResourceLocation> context, Predicate<TileEntity> containerPredicate) {
        this(Item.func_150898_a((Block)block), chance, minCount, maxCount, context, containerPredicate);
    }

    public Loot(ItemStack stack, int chance, int minCount, int maxCount, Predicate<ResourceLocation> context) {
        this(stack.func_77973_b(), chance, minCount, maxCount, context);
    }

    public ItemStack roll(ResourceLocation context, TileEntity target) {
        boolean success;
        boolean bl = success = this.context.test(context) && (this.tileEntityPredicate == null || this.tileEntityPredicate.test(target)) && this.chance > General.RANDOM_GENERATOR.nextInt(100);
        if (success) {
            ItemStack stack = new ItemStack(this.loot.func_77973_b(), 1, this.loot.func_77952_i());
            int count = RandomUtils.nextInt((int)this.minCount, (int)this.maxCount);
            count = MathHelper.func_76125_a((int)count, (int)1, (int)stack.func_77976_d());
            stack.func_190920_e(count);
            stack.func_77982_d(this.loot.func_77978_p());
            if (this.itemOperations != null) {
                this.itemOperations.accept(stack);
            }
            return stack;
        }
        return null;
    }
}

