/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.blocks;

import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.blocks.BlockHorizontalNonSolid;
import alexiy.secure.contain.protect.items.ItemKeyCard;
import alexiy.secure.contain.protect.registration.Sounds;
import alexiy.secure.contain.protect.tileentity.TileCardReader;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCardReader
extends BlockHorizontalNonSolid {
    public static final PropertyBool STATE = PropertyBool.func_177716_a((String)"powered");
    private AxisAlignedBB SOUTH = new AxisAlignedBB(0.75, 0.0, 0.0, 0.25, 0.75, 0.125);
    private AxisAlignedBB NORTH = new AxisAlignedBB(0.25, 0.0, 0.875, 0.75, 0.75, 1.0);
    private AxisAlignedBB WEST = new AxisAlignedBB(0.875, 0.0, 0.25, 1.0, 0.75, 0.75);
    private AxisAlignedBB EAST = new AxisAlignedBB(0.0, 0.0, 0.75, 0.125, 0.75, 0.25);

    public BlockCardReader() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)STATE, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemKeyCard keyCard;
        ItemStack itemStack = playerIn.func_184586_b(hand);
        TileCardReader cardReader = (TileCardReader)worldIn.func_175625_s(pos);
        Item item = itemStack.func_77973_b();
        boolean poweron = false;
        if (playerIn.func_184812_l_() && itemStack.func_190926_b()) {
            poweron = true;
        } else if (item instanceof ItemKeyCard && (keyCard = (ItemKeyCard)item).getSecurityLevel().ordinal() >= cardReader.securityLevel.ordinal()) {
            poweron = true;
        }
        if (poweron) {
            if (!((Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)STATE)).booleanValue()) {
                worldIn.func_184133_a(playerIn, pos, Sounds.keycardSwipe, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!worldIn.field_72995_K) {
                    EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)STATE, (Comparable)Boolean.valueOf(true)));
                    worldIn.func_175685_c(pos.func_177972_a(direction.func_176734_d()), (Block)this, false);
                }
                cardReader.ticksOpened = (short)60;
                return true;
            }
        } else {
            if (worldIn.field_72995_K) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(Utils.translate("level", new Object[0]).func_150254_d() + " " + (Object)((Object)cardReader.securityLevel) + " " + Utils.translate("card.required", new Object[0]).func_150254_d()));
            }
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        switch (facing) {
            case NORTH: {
                return this.NORTH;
            }
            case EAST: {
                return this.EAST;
            }
            case WEST: {
                return this.WEST;
            }
            case SOUTH: {
                return this.SOUTH;
            }
        }
        return field_185505_j;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STATE, field_185512_D});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        if (meta > 3) {
            return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)(meta - 4))).func_177226_a((IProperty)STATE, (Comparable)Boolean.valueOf(true));
        }
        return super.func_176203_a(meta).func_177226_a((IProperty)STATE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)STATE);
        if (powered) {
            return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b() + 4;
        }
        return super.func_176201_c(state);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)STATE) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)STATE) != false ? 15 : 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCardReader();
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(Utils.translate("use.screwdriver.cardreader", new Object[0]).func_150254_d());
    }
}

