/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.blocks;

import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.blocks.SCPBlock;
import alexiy.secure.contain.protect.packets.PlaySound;
import alexiy.secure.contain.protect.registration.Sounds;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class BlockRedIce
extends SCPBlock {
    public BlockRedIce() {
        super(Material.field_151588_w);
        this.func_149752_b(10.683333f);
        this.setSoundType(SoundType.field_185853_f);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (this.canSpread(worldIn, pos)) {
            worldIn.func_175684_a(pos, (Block)this, Utils.minutesToTicks(10));
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (blockIn != this && blockIn != Blocks.field_150350_a && this.canSpread(worldIn, pos)) {
            worldIn.func_175684_a(pos, (Block)this, Utils.minutesToTicks(10));
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        BlockPos up = pos.func_177984_a();
        BlockPos down = pos.func_177977_b();
        BlockPos north = pos.func_177978_c();
        BlockPos south = pos.func_177968_d();
        BlockPos east = pos.func_177974_f();
        BlockPos west = pos.func_177976_e();
        HashSet hashSet = Sets.newHashSet((Object[])new BlockPos[]{up, down, north, south, east, west});
        boolean surrounded = true;
        for (BlockPos blockPos : hashSet) {
            IBlockState state1 = worldIn.func_180495_p(blockPos);
            if (state1.func_177230_c() != Blocks.field_150355_j && state1.func_177230_c() != Blocks.field_150358_i) continue;
            worldIn.func_175656_a(blockPos, this.func_176223_P());
            Utils.sendToPlayersAround(new PlaySound(blockPos, Sounds.red_ice_spread), worldIn, blockPos, 16, SCP.SimpleNetworkWrapper);
            surrounded = false;
            break;
        }
        if (!surrounded && this.canSpread(worldIn, pos)) {
            worldIn.func_175684_a(pos, (Block)this, Utils.minutesToTicks(10));
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            entityIn.func_70097_a(DamageSource.field_76377_j, 1.0f);
            if (entityIn.field_70128_L) {
                List<BlockPos> posList = Utils.boundingBoxToPositions(entityIn.func_174813_aQ());
                posList.forEach(blockPos -> worldIn.func_175656_a(blockPos, this.func_176223_P()));
            }
        }
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    private boolean canSpread(World world, BlockPos ownPosition) {
        Biome biome = world.func_180494_b(ownPosition);
        if (biome.func_150559_j()) {
            return false;
        }
        BlockPos up = ownPosition.func_177984_a();
        BlockPos down = ownPosition.func_177977_b();
        BlockPos north = ownPosition.func_177978_c();
        BlockPos south = ownPosition.func_177968_d();
        BlockPos east = ownPosition.func_177974_f();
        BlockPos west = ownPosition.func_177976_e();
        HashSet hashSet = Sets.newHashSet((Object[])new BlockPos[]{up, down, north, south, east, west});
        for (BlockPos blockPos : hashSet) {
            IBlockState sidestate = world.func_180495_p(blockPos);
            if (sidestate.func_177230_c() != Blocks.field_150355_j && sidestate.func_177230_c() != Blocks.field_150358_i) continue;
            return true;
        }
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        if (blockState != iblockstate) {
            return true;
        }
        return block != this;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        ItemStack heldItem = playerIn.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof ItemTool) && !(heldItem.func_77973_b() instanceof ItemSword)) {
            playerIn.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
    }

    @Override
    public boolean isToolEffective(String type, IBlockState state) {
        return type.equals("shovel");
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return player.func_184614_ca().func_77973_b() instanceof ItemSpade;
    }
}

