/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.capability.bloodstone;

import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.SoundCooldown;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.capability.Capabilities;
import alexiy.secure.contain.protect.capability.bloodstone.IBloodstoneCapability;
import alexiy.secure.contain.protect.items.ItemTelekillArmor;
import alexiy.secure.contain.protect.packets.SyncBloodstone;
import alexiy.secure.contain.protect.registration.Potions;
import alexiy.secure.contain.protect.registration.Sounds;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BloodstoneCapability
implements IBloodstoneCapability {
    private int time;
    private int stage;
    private boolean lingering;
    private int lingerTime;
    private final Random random = new Random();
    private final SoundCooldown<EntityPlayer> beatCooldown = new SoundCooldown<EntityPlayer>(Sounds.heartbeat, SoundCategory.AMBIENT, input -> ((IBloodstoneCapability)input.getCapability(Capabilities.BLOODSTONE_CAPABILITY, null)).getStage() > 0, new SoundCooldown.CooldownHandler<EntityPlayer>(){

        @Override
        public int getCooldown(EntityPlayer player) {
            switch (((IBloodstoneCapability)player.getCapability(Capabilities.BLOODSTONE_CAPABILITY, null)).getStage()) {
                case 1: {
                    return Utils.secondsToTicks(3);
                }
                case 2: {
                    return Utils.secondsToTicks(2);
                }
            }
            return Utils.secondsToTicks(1);
        }
    });
    private final SoundCooldown<EntityPlayer> whisperCooldown = new SoundCooldown<EntityPlayer>(Utils.secondsToTicks(4), Sounds.whisper, SoundCategory.AMBIENT, input -> ((IBloodstoneCapability)input.getCapability(Capabilities.BLOODSTONE_CAPABILITY, null)).getStage() == 3);
    private final SoundCooldown<EntityPlayer> screamCooldown = new SoundCooldown<EntityPlayer>(Utils.secondsToTicks(3), Sounds.scream, SoundCategory.AMBIENT, input -> ((IBloodstoneCapability)input.getCapability(Capabilities.BLOODSTONE_CAPABILITY, null)).getStage() == 4);
    private final SoundCooldown<EntityPlayer> ambientScreamCooldown = new SoundCooldown<EntityPlayer>(Utils.secondsToTicks(36), Sounds.ambient_scream, SoundCategory.AMBIENT, input -> this.stage >= 5);

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int time) {
        this.time = time;
    }

    @Override
    public void increaseTime() {
        if (this.getStage() >= 1) {
            ++this.time;
            System.out.println(this.time);
            if (this.time >= this.getTimeForStage()) {
                this.increaseStage();
                this.time = 0;
            }
        }
    }

    private int getTimeForStage() {
        switch (this.getStage()) {
            case 1: {
                return 400;
            }
            case 2: 
            case 3: {
                return 400;
            }
        }
        return Utils.minutesToTicks(1);
    }

    @Override
    public int getStage() {
        return this.stage;
    }

    @Override
    public void setStage(int stage) {
        this.stage = stage;
    }

    @Override
    public void increaseStage() {
        ++this.stage;
    }

    @Override
    public void setLingering(boolean lingering) {
        this.lingering = lingering;
        if (lingering) {
            this.lingerTime = 0;
        }
    }

    private int getLingerForStage() {
        switch (this.stage) {
            case 2: {
                return Utils.minutesToTicks(1);
            }
            case 3: {
                return Utils.minutesToTicks(3);
            }
            case 4: {
                return Utils.minutesToTicks(5);
            }
            case 5: {
                return Utils.minutesToTicks(7);
            }
        }
        return 0;
    }

    @Override
    public boolean isLingering() {
        return this.lingering;
    }

    @Override
    public void increaseLingerTime() {
        if (this.lingering) {
            ++this.lingerTime;
            if (this.shouldReset()) {
                this.resetBloodstoneState();
            }
        }
    }

    @Override
    public int getLingerTime() {
        return this.lingerTime;
    }

    @Override
    public void setLingerTime(int lingerTime) {
        this.lingerTime = lingerTime;
    }

    @Override
    public void resetBloodstoneState() {
        this.lingering = false;
        this.lingerTime = 0;
        this.time = 0;
        this.stage = 0;
    }

    @Override
    public void handleBloodstoneEffects(EntityPlayer player) {
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            this.beatCooldown.updateCooldowns(player);
            this.whisperCooldown.updateCooldowns(player);
            this.screamCooldown.updateCooldowns(player);
            this.ambientScreamCooldown.updateCooldowns(player);
        } else if (this.getStage() > 0) {
            if (this.isLingering()) {
                this.increaseLingerTime();
            } else if (this.random.nextFloat() >= ItemTelekillArmor.calculateMindProtection((EntityLivingBase)player)) {
                this.increaseTime();
            }
            if (player instanceof EntityPlayerMP) {
                SCP.SimpleNetworkWrapper.sendTo((IMessage)new SyncBloodstone(this.getTime(), this.getStage()), (EntityPlayerMP)player);
            }
            switch (this.getStage()) {
                case 1: {
                    player.func_70690_d(new PotionEffect((Potion)Potions.anxiety, 65));
                    break;
                }
                case 2: {
                    player.func_70690_d(new PotionEffect((Potion)Potions.anxiety, 65));
                    player.func_70690_d(new PotionEffect((Potion)Potions.paranoiaEffect, 65));
                    break;
                }
                case 3: {
                    player.func_70690_d(new PotionEffect((Potion)Potions.anxiety, 65));
                    player.func_70690_d(new PotionEffect((Potion)Potions.paranoiaEffect, 65));
                    player.func_70690_d(new PotionEffect((Potion)Potions.guiltEffect, 65));
                    break;
                }
                case 4: 
                case 5: {
                    player.func_70690_d(new PotionEffect((Potion)Potions.anxiety, 65));
                    player.func_70690_d(new PotionEffect((Potion)Potions.paranoiaEffect, 65));
                    player.func_70690_d(new PotionEffect((Potion)Potions.guiltEffect, 65));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 65, 100));
                    if (this.random.nextInt(10000) != 0) break;
                    player.func_70097_a(SCP.holeDamage, player.func_110143_aJ());
                }
            }
        }
    }

    private boolean shouldReset() {
        return this.lingerTime >= this.getLingerForStage();
    }
}

