/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.capability.killedentities;

import alexiy.secure.contain.protect.capability.killedentities.EntityStorage;
import alexiy.secure.contain.protect.capability.killedentities.IKilledEntitiesCapability;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class KilledEntitiesCapability
implements IKilledEntitiesCapability {
    private final List<EntityStorage> storedEntities = new ArrayList<EntityStorage>();

    @Override
    public void addEntity(EntityLivingBase entityLiving) {
        for (EntityEntry entry : ForgeRegistries.ENTITIES.getValues()) {
            if (entry.getEntityClass() != entityLiving.getClass()) continue;
            this.storedEntities.add(new EntityStorage(entry, entityLiving.func_189511_e(new NBTTagCompound())));
            break;
        }
    }

    @Override
    public EntityLivingBase getRandomEntity(World world) {
        EntityStorage storage = this.storedEntities.get(world.field_73012_v.nextInt(this.storedEntities.size()));
        EntityLivingBase entity = (EntityLivingBase)storage.getEntityEntry().newInstance(world);
        NBTTagCompound entityCompound = storage.getTagCompound();
        entity.func_184221_a(UUID.randomUUID());
        entityCompound.func_186854_a("UUID", entity.func_110124_au());
        entityCompound.func_74778_a("id", entity.func_189512_bd());
        entity.func_70020_e(entityCompound);
        entity.func_70606_j(entity.func_110138_aP());
        return entity;
    }

    @Override
    public List<EntityStorage> getStoredEntities() {
        return this.storedEntities;
    }
}

