/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.capability.killedentities;

import alexiy.secure.contain.protect.capability.Capabilities;
import alexiy.secure.contain.protect.capability.killedentities.EntityStorage;
import alexiy.secure.contain.protect.capability.killedentities.IKilledEntitiesCapability;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class KilledEntitiesProvider
implements ICapabilitySerializable<NBTBase> {
    private final IKilledEntitiesCapability instance = (IKilledEntitiesCapability)Capabilities.KILLED_ENTITIES_CAPABILITY.getDefaultInstance();

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Capabilities.KILLED_ENTITIES_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Capabilities.KILLED_ENTITIES_CAPABILITY ? Capabilities.KILLED_ENTITIES_CAPABILITY.cast((Object)this.instance) : null);
    }

    public NBTBase serializeNBT() {
        return Capabilities.KILLED_ENTITIES_CAPABILITY.writeNBT((Object)this.instance, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        Capabilities.KILLED_ENTITIES_CAPABILITY.readNBT((Object)this.instance, null, nbt);
    }

    public static class Storage
    implements Capability.IStorage<IKilledEntitiesCapability> {
        @Nullable
        public NBTBase writeNBT(Capability<IKilledEntitiesCapability> capability, IKilledEntitiesCapability instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagList tagList = new NBTTagList();
            for (EntityStorage storage : instance.getStoredEntities()) {
                NBTTagCompound entityCompound = storage.getTagCompound();
                entityCompound.func_74778_a("EntityEntryName", storage.getEntityEntry().getName());
                tagList.func_74742_a((NBTBase)entityCompound);
            }
            compound.func_74782_a("Entities", (NBTBase)tagList);
            return compound;
        }

        public void readNBT(Capability<IKilledEntitiesCapability> capability, IKilledEntitiesCapability instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            NBTTagList tagList = compound.func_150295_c("Entities", 10);
            if (!tagList.func_82582_d()) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound entityCompound = tagList.func_150305_b(i);
                    for (EntityEntry entry : ForgeRegistries.ENTITIES.getValues()) {
                        if (!entry.getName().equals(entityCompound.func_74779_i("EntityEntryName"))) continue;
                        instance.getStoredEntities().add(new EntityStorage(entry, entityCompound));
                        return;
                    }
                }
            }
        }
    }
}

