/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.capability.shadowinfestation;

import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.capability.Capabilities;
import alexiy.secure.contain.protect.capability.shadowinfestation.IShadowInfestationCapability;
import alexiy.secure.contain.protect.entity.EntityShadowSpider;
import alexiy.secure.contain.protect.registration.Potions;
import alexiy.secure.contain.protect.registration.SCPBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class ShadowInfestationCapability
implements IShadowInfestationCapability {
    private int infestationTime = -1;
    private int infestationStage = 0;

    @Override
    public boolean isInfested() {
        return this.infestationStage > 0;
    }

    @Override
    public int getInfestationTime() {
        return this.infestationTime;
    }

    @Override
    public void setInfestationTime(int infestationTime) {
        this.infestationTime = infestationTime;
    }

    @Override
    public void increaseInfestationTime() {
        this.setInfestationTime(this.getInfestationTime() + 1);
    }

    @Override
    public int getInfestationStage() {
        return this.infestationStage;
    }

    @Override
    public void setInfestationStage(int level) {
        this.infestationStage = level;
    }

    @Override
    public void increaseInfestationStage() {
        this.setInfestationStage(this.getInfestationStage() + 1);
    }

    @Override
    public void handleInfestation(EntityLivingBase entityLivingBase) {
        if (entityLivingBase instanceof EntityLiving || entityLivingBase instanceof EntityPlayer && Utils.isPlayerInSurvivalMode((EntityPlayer)entityLivingBase)) {
            IShadowInfestationCapability capability = (IShadowInfestationCapability)entityLivingBase.getCapability(Capabilities.SHADOW_INFESTATION_CAPABILITY, null);
            World world = entityLivingBase.field_70170_p;
            if (capability.isInfested()) {
                Utils.addPotionEffectNoParticles(entityLivingBase, Potions.shadowSpiderInfestationIndicator, 95, 0);
                capability.increaseInfestationTime();
                int stage = capability.getInfestationStage();
                int time = capability.getInfestationTime();
                if (stage == 1 && time > Utils.minutesToTicks(3)) {
                    capability.increaseInfestationStage();
                }
                if (stage == 2) {
                    entityLivingBase.func_70690_d(new PotionEffect((Potion)Potions.aggressionEffect, 65));
                    entityLivingBase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 65));
                    if (!(entityLivingBase instanceof EntityPlayer)) {
                        entityLivingBase.func_70690_d(new PotionEffect(MobEffects.field_76420_g));
                    }
                    if (time > Utils.minutesToTicks(5)) {
                        capability.increaseInfestationStage();
                    }
                }
                if (stage == 3) {
                    if (entityLivingBase instanceof EntityPlayer) {
                        if (time == 6002) {
                            entityLivingBase.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GRAY + Utils.translate("hide.in.shadows", new Object[0]).func_150254_d(), new Object[0]));
                        }
                        if (world.func_175642_b(EnumSkyBlock.BLOCK, entityLivingBase.func_180425_c()) > 2 || world.func_175678_i(entityLivingBase.func_180425_c()) && world.func_175642_b(EnumSkyBlock.SKY, entityLivingBase.func_180425_c()) > 2) {
                            entityLivingBase.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100));
                        }
                        entityLivingBase.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 65));
                        entityLivingBase.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 65));
                    }
                    if (time > Utils.minutesToTicks(7)) {
                        capability.increaseInfestationStage();
                    }
                }
                if (stage == 4 && entityLivingBase.func_110143_aJ() > 0.0f) {
                    entityLivingBase.func_70097_a(SCP.shadowInfestation, entityLivingBase.func_110143_aJ());
                    world.func_175656_a(entityLivingBase.func_180425_c(), SCPBlocks.spiderFluidBlock.func_176223_P());
                    if (entityLivingBase instanceof EntityPlayer) {
                        EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
                    }
                    for (EntityPlayer facing : EnumFacing.field_176754_o) {
                        EntityShadowSpider shadowSpider = new EntityShadowSpider(world);
                        BlockPos spawnPos = entityLivingBase.func_180425_c().func_177972_a((EnumFacing)facing);
                        shadowSpider.func_70107_b(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
                        world.func_72838_d((Entity)shadowSpider);
                    }
                    if (time > Utils.minutesToTicks(7)) {
                        capability.increaseInfestationStage();
                    }
                }
            }
        }
    }
}

