/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.capability.zombievirus;

import alexiy.secure.contain.protect.AttributeModifierOperation;
import alexiy.secure.contain.protect.Configg;
import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.ai.AIMeleeAttack;
import alexiy.secure.contain.protect.api.Human;
import alexiy.secure.contain.protect.api.MainAPI;
import alexiy.secure.contain.protect.api.SCPEntity;
import alexiy.secure.contain.protect.capability.Capabilities;
import alexiy.secure.contain.protect.capability.zombievirus.Infection;
import alexiy.secure.contain.protect.entity.EntityBlizzard;
import alexiy.secure.contain.protect.entity.EntityHeavyGolem;
import alexiy.secure.contain.protect.entity.EntityHostileGolem;
import alexiy.secure.contain.protect.entity.SCPCreature;
import alexiy.secure.contain.protect.packets.SynchronizeZombieVirus;
import alexiy.secure.contain.protect.registration.Potions;
import alexiy.secure.contain.protect.registration.SCPItems;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBeg;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ZombieVirus
implements Infection {
    private final AttributeModifier healthIncrease;
    private final AttributeModifier increaseArmor;
    private final AttributeModifier damageIncrease;
    public static final Predicate<EntityLivingBase> INFECTION_CONDITION = entityLiving -> !entityLiving.func_70662_br() && !(entityLiving instanceof SCPEntity) && (entityLiving instanceof EntityLiving || entityLiving instanceof EntityPlayer || entityLiving instanceof Human) && entityLiving.hasCapability(Capabilities.INFECTIONABLE, null) && !((Infection)entityLiving.getCapability(Capabilities.INFECTIONABLE, null)).isActive();
    public static final int STAGE1 = Utils.minutesToTicks(3);
    public static final int STAGE2 = Utils.minutesToTicks(13);
    public static final int STAGE3 = Utils.minutesToTicks(23);
    private int infectionTime;
    private boolean isActive;
    public static List<Class> SCP008Exclusion = new ArrayList<Class>();

    public ZombieVirus() {
        this.healthIncrease = new AttributeModifier("scp:double health", 1.0, AttributeModifierOperation.MULTIPLY_BY_ONE_PLUS_VALUE.intOperation);
        this.increaseArmor = new AttributeModifier("scp:add armor", 2.0, AttributeModifierOperation.ADD.intOperation);
        this.damageIncrease = new AttributeModifier("scp:multiply damage", 0.7, AttributeModifierOperation.MULTIPLY_BY_ONE_PLUS_VALUE.intOperation);
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public int duration() {
        return this.infectionTime;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
    }

    @Override
    public void setDuration(int duration) {
        this.infectionTime = duration;
    }

    @Override
    public boolean infect(EntityLivingBase livingEntity) {
        if (SCP008Exclusion.contains(livingEntity.getClass())) {
            return false;
        }
        if (livingEntity.getClass().getName().contains("noppes.npcs")) {
            return false;
        }
        if (livingEntity instanceof EntityPlayer && ((EntityPlayer)livingEntity).func_184812_l_()) {
            return false;
        }
        World world = livingEntity.field_70170_p;
        if (!world.field_72995_K) {
            EntityPlayer entityPlayer;
            if (livingEntity instanceof EntityLiving) {
                this.isActive = true;
                if (Configg.experimentalSettings.enableDebugInformation) {
                    SCP.info("Infected " + livingEntity);
                }
                livingEntity.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(this.increaseArmor);
                IAttributeInstance health = livingEntity.func_110148_a(SharedMonsterAttributes.field_111267_a);
                health.func_111121_a(this.healthIncrease);
                IAttributeInstance attack = livingEntity.func_110148_a(SharedMonsterAttributes.field_111264_e);
                if (attack != null) {
                    attack.func_111121_a(this.damageIncrease);
                    if (Configg.experimentalSettings.enableDebugInformation) {
                        SCP.info(" Damage " + livingEntity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b() + " -> " + livingEntity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    }
                } else {
                    livingEntity.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(health.func_111125_b() * 3.0 / 20.0);
                    if (!world.field_72995_K && Configg.experimentalSettings.enableDebugInformation) {
                        SCP.info(" Damage " + livingEntity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    }
                }
                if (Configg.experimentalSettings.enableDebugInformation) {
                    SCP.info(" Health " + health.func_111125_b() + " -> " + health.func_111126_e());
                    SCP.info(" Armor " + livingEntity.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111125_b() + " -> " + livingEntity.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e());
                }
                return true;
            }
            if (livingEntity instanceof EntityPlayer && (entityPlayer = (EntityPlayer)livingEntity).func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() != SCPItems.hazardSuit) {
                this.isActive = true;
                if (Configg.experimentalSettings.enableDebugInformation) {
                    SCP.info("Infected " + ((EntityPlayer)livingEntity).getDisplayNameString());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void advance(EntityLivingBase livingEntity) {
        if (this.infectionTime != -1) {
            ++this.infectionTime;
            World world = livingEntity.field_70170_p;
            if (livingEntity.func_110148_a(SharedMonsterAttributes.field_111264_e) == null && !world.field_72995_K) {
                IAttributeInstance health = livingEntity.func_110148_a(SharedMonsterAttributes.field_111267_a);
                double clampedDamage = MathHelper.func_151237_a((double)(health.func_111125_b() * 3.0 / 20.0), (double)2.23, (double)100.0);
                livingEntity.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(clampedDamage);
                if (Configg.experimentalSettings.enableDebugInformation) {
                    SCP.info("Granted attack damage to " + livingEntity);
                }
            }
            Utils.addPotionEffectNoParticles(livingEntity, Potions.zombieIndicator, 95, 0);
            if (this.infectionTime > STAGE1) {
                if (livingEntity instanceof EntityLiving && !(livingEntity instanceof SCPCreature)) {
                    EntityLiving entityLiving2 = (EntityLiving)livingEntity;
                    if (!world.field_72995_K) {
                        boolean makeHostileToHumans;
                        Utils.sendToPlayersAround(new SynchronizeZombieVirus(this.duration(), entityLiving2.func_145782_y()), world, entityLiving2.func_180425_c(), 32, SCP.SimpleNetworkWrapper);
                        EntityAITasks targetTasks = entityLiving2.field_70715_bh;
                        EntityAITasks usualtasks = entityLiving2.field_70714_bg;
                        usualtasks.field_75782_a.removeIf(entityAITaskEntry -> {
                            EntityAIBase aiBase = entityAITaskEntry.field_75733_a;
                            return aiBase instanceof EntityAIPanic || aiBase instanceof EntityAIAvoidEntity || aiBase instanceof EntityAIBeg || aiBase instanceof EntityAIMate || aiBase instanceof EntityAITempt || aiBase instanceof EntityAISit || aiBase instanceof EntityAIRunAroundLikeCrazy || aiBase instanceof EntityAIFollowOwner || aiBase instanceof EntityAIFollowParent;
                        });
                        boolean addMeleeAttack = true;
                        for (EntityAITasks.EntityAITaskEntry taskEntry : usualtasks.field_75782_a) {
                            if (!(taskEntry.field_75733_a instanceof EntityAIAttackMelee)) continue;
                            addMeleeAttack = false;
                            break;
                        }
                        if (targetTasks.field_75782_a.isEmpty()) {
                            makeHostileToHumans = true;
                        } else {
                            makeHostileToHumans = true;
                            for (EntityAITasks.EntityAITaskEntry taskEntry : targetTasks.field_75782_a) {
                                if (taskEntry.field_75733_a instanceof EntityAINearestAttackableTarget) {
                                    EntityAINearestAttackableTarget nearestAttackableTarget = (EntityAINearestAttackableTarget)taskEntry.field_75733_a;
                                    Field field = Utils.getSecureField(nearestAttackableTarget.getClass(), 0);
                                    if (field == null) continue;
                                    try {
                                        Object cl = field.get(nearestAttackableTarget);
                                        if (cl == null || cl.getClass() != Class.class || !Human.class.isAssignableFrom((Class)cl) && !EntityPlayer.class.isAssignableFrom((Class)cl)) continue;
                                        makeHostileToHumans = false;
                                        break;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        continue;
                                    }
                                }
                                if (!(taskEntry.field_75733_a instanceof EntityAIFindEntityNearestPlayer)) continue;
                                makeHostileToHumans = false;
                                break;
                            }
                        }
                        if (entityLiving2 instanceof EntityCreature) {
                            EntityCreature entityCreature = (EntityCreature)entityLiving2;
                            if (addMeleeAttack) {
                                usualtasks.func_75776_a(3, (EntityAIBase)new AIMeleeAttack(entityCreature, 1.5, true));
                                if (Configg.experimentalSettings.enableDebugInformation) {
                                    SCP.info("Added melee attack to " + entityCreature);
                                }
                            }
                            if (makeHostileToHumans) {
                                targetTasks.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget(entityCreature, EntityPlayer.class, false, false));
                                targetTasks.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entityCreature, EntityLiving.class, 0, false, false, MainAPI.humanTargets));
                                if (Configg.experimentalSettings.enableDebugInformation) {
                                    SCP.info("Added attack task A on Humans to " + entityCreature);
                                }
                            }
                        } else if (makeHostileToHumans) {
                            targetTasks.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer(entityLiving2));
                            if (Configg.experimentalSettings.enableDebugInformation) {
                                SCP.info("Added attack task B on player to " + entityLiving2);
                            }
                        }
                    }
                } else if (Utils.isEntitySurvivalPlayer((Entity)livingEntity)) {
                    livingEntity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 45));
                    livingEntity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 45));
                    livingEntity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 45));
                }
            }
            if (this.infectionTime > STAGE2 && Utils.isEntitySurvivalPlayer((Entity)livingEntity)) {
                livingEntity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 45, 1));
                livingEntity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 45, 1));
                livingEntity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 45, 1));
            }
            if (this.infectionTime > STAGE3) {
                livingEntity.func_70097_a(SCP.zombieVirusDamage, 2.0f);
            }
            AxisAlignedBB near = new AxisAlignedBB(livingEntity.func_180425_c()).func_186662_g(1.0);
            List entitites = world.func_72872_a(EntityLiving.class, near);
            entitites.addAll(world.func_72872_a(EntityPlayer.class, near));
            entitites.forEach(entityLiving -> {
                if (INFECTION_CONDITION.test((EntityLivingBase)entityLiving)) {
                    ((Infection)entityLiving.getCapability(Capabilities.INFECTIONABLE, null)).infect((EntityLivingBase)entityLiving);
                }
            });
        }
    }

    @Override
    public void cure(EntityLivingBase entity) {
        this.setCured(true);
        if (entity.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
            entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(this.damageIncrease);
        }
        entity.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111124_b(this.increaseArmor);
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(this.healthIncrease);
    }

    @Override
    public boolean isCured() {
        return this.infectionTime == -1 && !this.isActive;
    }

    @Override
    public void setCured(boolean b) {
        this.infectionTime = -1;
        this.isActive = false;
    }

    static {
        SCP008Exclusion.add(EntityBlizzard.class);
        SCP008Exclusion.add(EntityHostileGolem.class);
        SCP008Exclusion.add(EntityHeavyGolem.class);
        SCP008Exclusion.add(EntityBlaze.class);
        SCP008Exclusion.add(EntityElderGuardian.class);
        SCP008Exclusion.add(EntityGuardian.class);
        SCP008Exclusion.add(EntityGhast.class);
        SCP008Exclusion.add(EntityMagmaCube.class);
        SCP008Exclusion.add(EntityShulker.class);
        SCP008Exclusion.add(EntitySlime.class);
        SCP008Exclusion.add(EntitySpider.class);
        SCP008Exclusion.add(EntitySquid.class);
        SCP008Exclusion.add(EntityVex.class);
    }
}

