/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.entity;

import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.ai.AIMeleeAttack;
import alexiy.secure.contain.protect.ai.AINearestTarget;
import alexiy.secure.contain.protect.ai.climbing.PathNavigatorClimb2;
import alexiy.secure.contain.protect.api.MainAPI;
import alexiy.secure.contain.protect.entity.SCPCreature;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityIceSpider
extends SCPCreature {
    protected boolean insideWeb;

    public EntityIceSpider(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.5f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIMeleeAttack(this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new Burrowing(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AINearestTarget<EntityLivingBase>(this, EntityLivingBase.class, true, false, input -> MainAPI.humanTargets.apply(input) && (double)this.field_70170_p.func_180494_b(this.func_180425_c()).func_185353_n() >= 0.95));
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigatorClimb2((EntityLiving)this, worldIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entityIn;
            Utils.addPotionEffectNoParticles(living, MobEffects.field_76421_d, Utils.secondsToTicks(10), 1);
            this.func_130011_c(entityIn);
            return true;
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.insideWeb && this.age % Utils.secondsToTicks(10) == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.field_70170_p.func_180495_p(this.func_180425_c()) != Blocks.field_150321_G) {
            this.insideWeb = false;
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Inside web", this.insideWeb);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.insideWeb = compound.func_74767_n("Inside web");
    }

    public void func_70110_aj() {
        this.insideWeb = true;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70617_f_() {
        return this.field_70123_F;
    }

    protected class Burrowing
    extends EntityAIBase {
        EntityIceSpider spider;
        BlockPos webPosition;
        int time = 0;

        Burrowing(EntityIceSpider iceSpider) {
            this.spider = iceSpider;
        }

        public boolean func_75250_a() {
            return !this.spider.field_70171_ac && (this.spider.func_70638_az() == null && this.spider.func_70643_av() == null || this.spider.func_110143_aJ() < 4.0f);
        }

        public void func_75246_d() {
            BlockPos blockPos;
            IBlockState down;
            Block block;
            ++this.time;
            if (this.time > Utils.secondsToTicks(10) && ((block = (down = EntityIceSpider.this.field_70170_p.func_180495_p(blockPos = this.spider.func_180425_c().func_177977_b())).func_177230_c()) == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_185774_da || block == Blocks.field_150351_n || block == Blocks.field_150354_m)) {
                EntityIceSpider.this.field_70170_p.func_175656_a(blockPos, Blocks.field_150321_G.func_176223_P());
                this.time = 0;
                this.webPosition = blockPos;
            }
            if (this.webPosition != null) {
                Vec3d webvector = Utils.getPositionForEntityFrom(this.webPosition);
                if (this.spider.func_70011_f(webvector.field_72450_a, webvector.field_72448_b, webvector.field_72449_c) > 1.0) {
                    this.spider.func_70605_aq().func_75642_a(webvector.field_72450_a, webvector.field_72448_b, webvector.field_72449_c, 1.0);
                }
            }
        }
    }
}

