/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.entity;

import alexiy.secure.contain.protect.Configg;
import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.ai.AIBase;
import alexiy.secure.contain.protect.ai.AIMeleeAttack;
import alexiy.secure.contain.protect.ai.AINearestTarget;
import alexiy.secure.contain.protect.ai.OpenDoor;
import alexiy.secure.contain.protect.api.UniqueList;
import alexiy.secure.contain.protect.entity.SCPCreature;
import alexiy.secure.contain.protect.packets.PlaySound;
import alexiy.secure.contain.protect.registration.Sounds;
import alexiy.secure.contain.protect.slidingdoors.BlockSlDoor;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomUtils;

public class EntityShyGuy
extends SCPCreature {
    public static final String UUID = "targetUUID";
    private final UniqueList<EntityLivingBase> KILL_LIST = new UniqueList(3);
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(EntityShyGuy.class, (DataSerializer)DataSerializers.field_187191_a);
    private int cryTimer = 0;
    private int idleCryingTime;
    private int chaseAndScreamTime;

    public EntityShyGuy(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.9f);
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new Attack());
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1024.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)((byte)ShyGuyState.SITTING.ordinal()));
    }

    @Override
    protected int getSpawnProbability() {
        return 25;
    }

    public float func_70047_e() {
        if (this.getState() == ShyGuyState.SITTING) {
            return 1.1875f;
        }
        if (this.getState() == ShyGuyState.CRYING) {
            return super.func_70047_e();
        }
        return this.field_70131_O + 0.1875f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            WorldServer worldServer = (WorldServer)this.field_70170_p;
            if (this.getState() == ShyGuyState.CRYING) {
                ++this.cryTimer;
            }
            if (!this.KILL_LIST.isEmpty() && this.getState().isPassive) {
                SCP.SimpleNetworkWrapper.sendToAllTracking((IMessage)new PlaySound(this.func_180425_c(), Sounds.shyguy_anger), (Entity)this);
                this.setState(ShyGuyState.CRYING);
                this.func_70661_as().func_75499_g();
                this.field_70714_bg.field_75782_a.removeIf(entityAITaskEntry -> !(entityAITaskEntry.field_75733_a instanceof Attack) && !(entityAITaskEntry.field_75733_a instanceof EntityAISwimming) && !(entityAITaskEntry.field_75733_a instanceof OpenDoor));
            }
            if (this.getState() == ShyGuyState.RUNNING) {
                if (this.KILL_LIST.isEmpty()) {
                    this.field_70714_bg.field_75782_a.clear();
                    this.field_70715_bh.field_75782_a.clear();
                    this.func_184651_r();
                    this.setState(ShyGuyState.SITTING);
                } else if (Configg.shyguyBlockBreaking != Configg.ShyguyBlockBreaking.OFF && this.func_70661_as().func_75500_f()) {
                    EnumFacing facing = this.func_174811_aO();
                    AxisAlignedBB axisAlignedBB = new AxisAlignedBB(this.func_180425_c()).func_72321_a((double)facing.func_82601_c(), 1.0, (double)facing.func_82599_e());
                    List<BlockPos> blockPos = Utils.boundingBoxToPositions(axisAlignedBB);
                    for (BlockPos position : blockPos) {
                        String name;
                        IBlockState blockState = this.field_70170_p.func_180495_p(position);
                        Block block = blockState.func_177230_c();
                        if (block instanceof BlockLiquid || block instanceof BlockFluidClassic) continue;
                        if (Configg.shyguyBlockBreaking == Configg.ShyguyBlockBreaking.ON) {
                            if (!(block instanceof BlockSlDoor) && !Utils.canReplaceBlock(position, this.field_70170_p)) continue;
                            this.field_70170_p.func_175655_b(position, true);
                            continue;
                        }
                        if (Configg.shyguyBlockBreaking != Configg.ShyguyBlockBreaking.SPECIFIC || !ArrayUtils.contains((Object[])Configg.breakable, (Object)(name = block.getRegistryName().toString()))) continue;
                        if (block instanceof BlockSlDoor) {
                            if (blockState.func_177229_b(BlockSlDoor.DOOR_HALF) == BlockDoor.EnumDoorHalf.LOWER) {
                                worldServer.func_175655_b(position, true);
                                continue;
                            }
                            worldServer.func_175698_g(position);
                            continue;
                        }
                        this.field_70170_p.func_175655_b(position, true);
                    }
                }
            }
            if (this.getState().isPassive && this.func_70661_as().func_75500_f()) {
                if (this.getState() != ShyGuyState.SITTING) {
                    this.setState(ShyGuyState.SITTING);
                }
            } else if (this.getState().isPassive && this.getState() != ShyGuyState.WALKING) {
                this.setState(ShyGuyState.WALKING);
            }
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 2, false, false));
            }
        }
        --this.idleCryingTime;
        if (this.getState() == ShyGuyState.RUNNING && Configg.soundEffects.scp096chasing) {
            if (this.chaseAndScreamTime <= 0 && (this.field_70159_w != 0.0 || this.field_70179_y != 0.0)) {
                if (this.hasTarget()) {
                    this.chaseAndScreamTime = Utils.secondsToTicks(11);
                    this.field_70170_p.func_184149_a(this.func_180425_c(), Sounds.shyguyRaging);
                }
            } else {
                --this.chaseAndScreamTime;
            }
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (Configg.soundEffects.scp096crying) {
            return Sounds.shyguyCrying;
        }
        return null;
    }

    public void func_70642_aH() {
        if (this.func_184639_G() != null && this.idleCryingTime <= 0) {
            this.func_184185_a(this.func_184639_G(), 1.5f, RandomUtils.nextFloat((float)0.7f, (float)1.0f));
            this.idleCryingTime = Utils.secondsToTicks(35);
        }
    }

    private void enableAttackAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIMeleeAttack(this, 2.0, true));
        this.field_70715_bh.func_75776_a(1, new AINearestTarget<EntityLivingBase>(this, EntityLivingBase.class, true, false, this.KILL_LIST::contains));
    }

    public void setState(ShyGuyState state) {
        this.field_70180_af.func_187227_b(STATE, (Object)((byte)state.ordinal()));
    }

    public ShyGuyState getState() {
        return ShyGuyState.values()[(Byte)this.field_70180_af.func_187225_a(STATE)];
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        super.func_189511_e(compound);
        NBTTagList tagList = new NBTTagList();
        for (EntityLivingBase entityLivingBase : this.KILL_LIST) {
            if (entityLivingBase == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_186854_a(UUID, entityLivingBase.func_110124_au());
            tagList.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("players", (NBTBase)tagList);
        compound.func_74774_a("state", (byte)this.getState().ordinal());
        compound.func_74768_a("Crytime", this.cryTimer);
        return compound;
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        NBTTagList tagList = compound.func_150295_c("players", 11);
        this.cryTimer = compound.func_74762_e("Crytime");
        tagList.forEach(input -> {
            if (!((NBTTagCompound)input).func_74764_b(UUID)) {
                this.KILL_LIST.add((EntityLivingBase)this.field_70170_p.func_152378_a(((NBTTagCompound)input).func_186857_a(UUID)));
            }
        });
        this.setState(ShyGuyState.values()[compound.func_74771_c("state")]);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.getState() == ShyGuyState.RUNNING) {
            this.enableAttackAI();
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        strength = this.getState().isPassive ? (strength /= 2.0f) : (strength /= 4.0f);
        this.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
        this.field_70159_w /= 2.0;
        this.field_70179_y /= 2.0;
        this.field_70159_w -= xRatio / (double)f * (double)strength;
        this.field_70179_y -= zRatio / (double)f * (double)strength;
        if (this.field_70122_E) {
            this.field_70181_x /= 2.0;
            this.field_70181_x += (double)strength;
            if (this.field_70181_x > (double)0.4f) {
                this.field_70181_x = 0.4f;
            }
        }
    }

    class Attack
    extends AIBase {
        Attack() {
        }

        public boolean func_75250_a() {
            double followrange = EntityShyGuy.this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
            List<EntityLivingBase> observers = Utils.getEntitiesInsideExcept((Entity)EntityShyGuy.this, EntityLivingBase.class, new AxisAlignedBB(EntityShyGuy.this.func_180425_c()).func_186662_g(followrange), input -> input != EntityShyGuy.this && Utils.isLivingEntity((Entity)input) && Utils.isInSightOf((Entity)input, (EntityLivingBase)EntityShyGuy.this, 90.0f, true) && Utils.isLookingAt(input, (Entity)EntityShyGuy.this, 1.0, true, new Block[]{Blocks.field_150359_w, Blocks.field_150399_cn, Blocks.field_150410_aZ, Blocks.field_150397_co}));
            observers.removeIf(list -> list instanceof EntityShyGuy);
            EntityShyGuy.this.KILL_LIST.addAll(observers);
            return !EntityShyGuy.this.KILL_LIST.isEmpty() && EntityShyGuy.this.cryTimer >= Utils.secondsToTicks(29);
        }

        public void func_75249_e() {
            EntityShyGuy.this.setState(ShyGuyState.RUNNING);
            if (EntityShyGuy.this.func_70643_av() != null) {
                EntityShyGuy.this.KILL_LIST.add(EntityShyGuy.this.func_70643_av());
            }
            if (EntityShyGuy.this.func_70638_az() != null) {
                EntityShyGuy.this.KILL_LIST.add(EntityShyGuy.this.func_70638_az());
            }
            EntityShyGuy.this.enableAttackAI();
            EntityShyGuy.this.cryTimer = 0;
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            EntityShyGuy.this.KILL_LIST.removeIf(input -> input.field_70128_L || input instanceof EntityPlayer && !Utils.isEntitySurvivalPlayer((Entity)input));
        }

        public boolean func_75253_b() {
            return !EntityShyGuy.this.KILL_LIST.isEmpty();
        }

        public void func_75251_c() {
            EntityShyGuy.this.KILL_LIST.clear();
        }
    }

    public static enum ShyGuyState {
        SITTING(true),
        WALKING(true),
        CRYING(false),
        RUNNING(false);

        public final boolean isPassive;

        private ShyGuyState(boolean isPassive) {
            this.isPassive = isPassive;
        }
    }
}

