/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.events;

import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.entity.staff.EntityDPersonnel;
import alexiy.secure.contain.protect.items.ItemTelekillArmor;
import alexiy.secure.contain.protect.packets.EntityYawAndPitch;
import alexiy.secure.contain.protect.packets.MovementSync;
import alexiy.secure.contain.protect.packets.StopUserInput;
import alexiy.secure.contain.protect.registration.Potions;
import alexiy.secure.contain.protect.registration.SCPBlocks;
import alexiy.secure.contain.protect.tileentity.luring.TileLure;
import alexiy.secure.contain.protect.tileentity.luring.TileSCP012;
import alexiy.secure.contain.protect.tileentity.luring.TileSCP1074;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class LurePlayer {
    public static void lureTickEvent() {
        try {
            for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                block17: for (Entity entity : world.field_72996_f) {
                    if (!(entity instanceof EntityPlayer) && !(entity instanceof EntityDPersonnel)) continue;
                    boolean isWearingTelekill = new Random().nextFloat() < ItemTelekillArmor.calculateMindProtection((EntityLivingBase)entity);
                    getRangedSCP result = new getRangedSCP(entity);
                    DistanceToSCP distance = result.getDist();
                    WhatSCP whatSCP = result.getSCP();
                    if (distance == DistanceToSCP.FAR) {
                        LurePlayer.controlPlayer(entity, false);
                        continue;
                    }
                    BlockPos blockPos = new BlockPos(0, 0, 0);
                    if (result.getBlockPos() != null) {
                        blockPos = result.getBlockPos();
                    }
                    if (entity instanceof EntityPlayer && (((EntityPlayer)entity).func_184812_l_() || ((EntityPlayer)entity).func_175149_v())) {
                        try {
                            ((TileSCP1074)world.func_175625_s(blockPos)).removeEntityFromList(entity);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        LurePlayer.controlPlayer(entity, false);
                        continue;
                    }
                    try {
                        if (!result.inInventory) {
                            EnumFacing facing = (EnumFacing)world.func_180495_p(blockPos).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                            double xOffset = facing.func_82601_c();
                            double zOffset = facing.func_82599_e();
                            if (xOffset > 0.0) {
                                xOffset -= 0.45;
                            }
                            if (xOffset < 0.0) {
                                xOffset += 0.45;
                            }
                            if (zOffset > 0.0) {
                                zOffset -= 0.45;
                            }
                            if (zOffset < 0.0) {
                                zOffset += 0.45;
                            }
                            double x = (double)blockPos.func_177958_n() + 0.5 + xOffset;
                            double z = (double)blockPos.func_177952_p() + 0.5 + zOffset;
                            Vec3d vec3d = new Vec3d(x, (double)blockPos.func_177956_o() + 0.5, z);
                            RayTraceResult rayTraceResult = world.func_72933_a(vec3d, entity.func_174791_d().func_72441_c(0.0, 1.5, 0.0));
                            if ((distance == DistanceToSCP.MID || distance == DistanceToSCP.CLOSE) && rayTraceResult.field_72313_a.equals((Object)RayTraceResult.Type.BLOCK)) {
                                LurePlayer.controlPlayer(entity, false);
                                continue;
                            }
                        }
                    }
                    catch (NullPointerException facing) {
                        // empty catch block
                    }
                    if (isWearingTelekill) {
                        LurePlayer.controlPlayer(entity, true);
                        continue;
                    }
                    if (whatSCP == WhatSCP.SCP012) {
                        if (result.getInInventory()) {
                            LurePlayer.controlPlayer(true, entity, result.blockPos, 0.0);
                            entity.func_70097_a(SCP.SCP_012_CURSE, 0.5f);
                            continue;
                        }
                        switch (distance) {
                            case MID: {
                                LurePlayer.controlPlayer(false, entity, blockPos, 0.1);
                                continue block17;
                            }
                            case CLOSE: {
                                LurePlayer.controlPlayer(true, entity, blockPos, 0.2);
                                continue block17;
                            }
                            case NEXT: {
                                LurePlayer.controlPlayer(true, entity, blockPos, 0.0);
                                entity.func_70097_a(SCP.SCP_012_CURSE, 0.5f);
                                continue block17;
                            }
                        }
                        continue;
                    }
                    if (whatSCP != WhatSCP.SCP1074) continue;
                    TileSCP1074 te = (TileSCP1074)world.func_175625_s(blockPos);
                    te.luringPlayer = true;
                    switch (distance) {
                        case MID: {
                            LurePlayer.controlPlayer(false, entity, blockPos, 0.1);
                            continue block17;
                        }
                        case CLOSE: {
                            LurePlayer.controlPlayer(true, entity, blockPos, 0.2);
                            continue block17;
                        }
                        case NEXT: {
                            LurePlayer.controlPlayer(true, entity, blockPos, 0.0);
                            te.event(entity);
                            continue block17;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            SCP.logger.error("Unable to Execute Lure Event");
        }
    }

    public static void controlPlayer(boolean restrictInput, Entity entity, @Nullable BlockPos scp, double moveFactor) {
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_70690_d(new PotionEffect((Potion)Potions.anxiety, 100, 1, false, false));
            try {
                if (restrictInput) {
                    SCP.SimpleNetworkWrapper.sendTo((IMessage)new StopUserInput(true), (EntityPlayerMP)entity);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70605_aq().func_75642_a((double)scp.func_177958_n(), (double)scp.func_177956_o(), (double)scp.func_177952_p(), (double)0.06f);
            }
            double distX = (double)scp.func_177958_n() + 0.5 - entity.field_70165_t;
            double distZ = (double)scp.func_177952_p() + 0.5 - entity.field_70161_v;
            double dir = MathHelper.func_181159_b((double)distZ, (double)distX);
            double speed = 1.0 / entity.func_70011_f((double)scp.func_177958_n(), (double)scp.func_177956_o(), (double)scp.func_177952_p()) * moveFactor;
            if (entity instanceof EntityPlayerMP) {
                SCP.SimpleNetworkWrapper.sendTo((IMessage)new MovementSync((double)MathHelper.func_76134_b((float)((float)dir)) * speed, (double)MathHelper.func_76126_a((float)((float)dir)) * speed), (EntityPlayerMP)entity);
            } else {
                entity.field_70159_w = (double)MathHelper.func_76134_b((float)((float)dir)) * speed;
                entity.field_70179_y = (double)MathHelper.func_76126_a((float)((float)dir)) * speed;
                entity.func_70071_h_();
            }
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                double x = player.field_70165_t - ((double)scp.func_177958_n() + 0.5);
                double y = player.field_70163_u + (double)player.getDefaultEyeHeight() - ((double)scp.func_177956_o() + 0.5);
                double z = player.field_70161_v - ((double)scp.func_177952_p() + 0.5);
                float heading = (float)Math.toDegrees(Math.atan2(z, x));
                float pitch = (float)Math.toDegrees(Math.atan2(y, Math.sqrt(x * x + z * z)));
                player.field_70125_A = MathHelper.func_76142_g((float)pitch);
                player.field_70177_z = MathHelper.func_76142_g((float)heading) + 90.0f;
                SCP.SimpleNetworkWrapper.sendTo((IMessage)new EntityYawAndPitch(player.field_70177_z, player.field_70125_A), player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void controlPlayer(Entity entity, boolean potionEffect) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (potionEffect) {
                player.func_70690_d(new PotionEffect((Potion)Potions.anxiety, 100, 1, false, false));
            }
            try {
                SCP.SimpleNetworkWrapper.sendTo((IMessage)new StopUserInput(false), (EntityPlayerMP)entity);
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum DistanceToSCP {
        NEXT,
        CLOSE,
        MID,
        FAR;

    }

    private static enum WhatSCP {
        SCP012,
        SCP1074;

    }

    private static class getRangedSCP {
        private DistanceToSCP dist;
        private WhatSCP whatSCP;
        private boolean inInventory = false;
        private BlockPos blockPos;

        public getRangedSCP(Entity entity) {
            Entity entityInRange;
            double CLOSE_DIST = 4.0;
            double NEXT_DIST = 1.5;
            if (entity instanceof EntityPlayer && this.isInInventory((EntityPlayer)entity)) {
                this.dist = DistanceToSCP.CLOSE;
                this.inInventory = true;
                return;
            }
            BlockPos corner1 = new BlockPos(entity.field_70165_t + 8.0, entity.field_70163_u + 2.0, entity.field_70161_v + 8.0);
            BlockPos corner2 = new BlockPos(entity.field_70165_t - 8.0, entity.field_70163_u - 2.0, entity.field_70161_v - 8.0);
            TreeMap<Double, TileLure> blockList = new TreeMap<Double, TileLure>();
            for (TileEntity te : entity.field_70170_p.field_147482_g) {
                if (!(te instanceof TileLure) || !(entity.func_70011_f((double)((TileLure)te).getX(), (double)((TileLure)te).getY(), (double)((TileLure)te).getZ()) < 8.0)) continue;
                blockList.put(entity.func_70011_f((double)((TileLure)te).getX(), (double)((TileLure)te).getY(), (double)((TileLure)te).getZ()), (TileLure)te);
            }
            Iterator<Object> iterator = blockList.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry ent = (Map.Entry)iterator.next();
                if (ent.getValue() instanceof TileSCP012) {
                    this.whatSCP = WhatSCP.SCP012;
                }
                if (ent.getValue() instanceof TileSCP1074) {
                    this.whatSCP = WhatSCP.SCP1074;
                }
                this.blockPos = ((TileLure)((Object)ent.getValue())).func_174877_v();
                if ((Double)ent.getKey() < CLOSE_DIST) {
                    if ((Double)ent.getKey() < NEXT_DIST) {
                        this.dist = DistanceToSCP.NEXT;
                        return;
                    }
                    this.dist = DistanceToSCP.CLOSE;
                    return;
                }
                this.dist = DistanceToSCP.MID;
                return;
            }
            iterator = entity.field_70170_p.func_175674_a(entity, new AxisAlignedBB(corner1, corner2), null).iterator();
            while (iterator.hasNext() && entityInRange.field_70170_p.func_175671_l((entityInRange = (Entity)iterator.next()).func_180425_c()) >= 9) {
                if (entityInRange instanceof EntityItem && ((EntityItem)entityInRange).func_92059_d().func_77973_b().equals(Item.func_150898_a((Block)SCPBlocks.scp012))) {
                    this.whatSCP = WhatSCP.SCP012;
                    this.blockPos = entityInRange.func_180425_c();
                    if ((double)entity.func_70032_d(entityInRange) < CLOSE_DIST) {
                        if ((double)entity.func_70032_d(entityInRange) < NEXT_DIST) {
                            this.dist = DistanceToSCP.NEXT;
                            return;
                        }
                        this.dist = DistanceToSCP.CLOSE;
                        return;
                    }
                    this.dist = DistanceToSCP.MID;
                    return;
                }
                if (!(entityInRange instanceof EntityPlayer) || !this.isInInventory((EntityPlayer)entityInRange)) continue;
                this.blockPos = entityInRange.func_180425_c();
                if ((double)entity.func_70032_d(entityInRange) < CLOSE_DIST) {
                    if ((double)entity.func_70032_d(entityInRange) < NEXT_DIST) {
                        this.dist = DistanceToSCP.NEXT;
                        return;
                    }
                    this.dist = DistanceToSCP.CLOSE;
                    return;
                }
                this.dist = DistanceToSCP.MID;
                return;
            }
            this.dist = DistanceToSCP.FAR;
        }

        private boolean isInInventory(EntityPlayer player) {
            for (ItemStack item : player.field_71069_bz.field_75153_a) {
                if (!item.func_77973_b().equals(Item.func_150898_a((Block)SCPBlocks.scp012))) continue;
                this.whatSCP = WhatSCP.SCP012;
                return true;
            }
            return false;
        }

        private WhatSCP getSCP() {
            return this.whatSCP;
        }

        private boolean getInInventory() {
            return this.inInventory;
        }

        private DistanceToSCP getDist() {
            return this.dist;
        }

        private BlockPos getBlockPos() {
            return this.blockPos;
        }
    }
}

