/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.items;

import alexiy.secure.contain.protect.Configg;
import alexiy.secure.contain.protect.ItemNBTHelper;
import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.SCPItem;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.api.ObjectClass;
import alexiy.secure.contain.protect.api.SCPEntry;
import alexiy.secure.contain.protect.blocks.BlockPreview;
import alexiy.secure.contain.protect.registration.SCPBlocks;
import alexiy.secure.contain.protect.registration.SCPItems;
import alexiy.secure.contain.protect.registration.SCPs;
import alexiy.secure.contain.protect.slidingdoors.BlockSlDoor;
import alexiy.secure.contain.protect.world.PlacementSettings2;
import alexiy.secure.contain.protect.world.Template2;
import alexiy.secure.contain.protect.world.TemplateUnwrapper;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class ItemDocument
extends SCPItem {
    public static final String CLASS = "ObjectClass";
    public static final String SCP_NAME = "ObjectName";
    public static final String NUMBER = "Number";

    public ItemDocument() {
        this.func_77625_d(1);
        this.func_77637_a(SCPItems.documentTab);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.place(player, worldIn, pos, hand, facing);
    }

    public String func_77653_i(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, SCP_NAME)) {
            String name = ItemNBTHelper.getString(stack, SCP_NAME);
            name = name.replaceAll("[ \\-]", "_").replaceAll("['\"]", "").toLowerCase() + ".name";
            String s = Utils.translate(name, new Object[0]).func_150254_d();
            return s + " " + ItemNBTHelper.getString(stack, NUMBER);
        }
        return TextFormatting.DARK_GRAY + "Unknown";
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (ItemNBTHelper.hasKey(stack, CLASS)) {
            ObjectClass objectClass = ObjectClass.valueOf(ItemNBTHelper.getString(stack, CLASS));
            tooltip.add(objectClass.getColor() + objectClass.getName());
            if (GuiScreen.func_146272_n()) {
                tooltip.add(Utils.translate("shift.click.for.preview", new Object[0]).func_150254_d());
            } else {
                tooltip.add("Shift +");
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == SCPItems.documentTab || tab == CreativeTabs.field_78027_g) {
            for (SCPEntry scpEntry : SCPs.scpRegistry.getValuesCollection()) {
                ItemStack document = SCPs.getDocument(scpEntry);
                boolean add = true;
                for (ItemStack stack : items) {
                    if (!Utils.areItemTypesEqual(stack, document)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                items.add((Object)document);
            }
        }
    }

    protected EnumActionResult place2(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing) {
        SCPEntry scpEntry;
        ItemStack document = player.func_184586_b(hand);
        String string = ItemNBTHelper.getString(document, NUMBER);
        if (!string.isEmpty() && (scpEntry = SCPs.getByNumber(string)) != null && worldIn instanceof WorldServer) {
            if (scpEntry.getStructureLocation() != null) {
                WorldServer worldServer = (WorldServer)worldIn;
                MinecraftServer minecraftServer = worldServer.func_73046_m();
                TemplateManager templateManager = worldServer.func_184163_y();
                Template template = templateManager.func_189942_b(minecraftServer, scpEntry.getStructureLocation());
                if (template != null) {
                    long starttime = System.currentTimeMillis();
                    EnumFacing playerfacing = player.func_174811_aO();
                    PlacementSettings2 placementSettings = new PlacementSettings2(playerfacing);
                    Template2 template2 = new Template2(template, placementSettings);
                    BlockPos dimensions = template.func_186259_a();
                    int width = dimensions.func_177958_n();
                    int depth = dimensions.func_177952_p();
                    Rotation rotationFix = scpEntry.getRotation();
                    placementSettings.setRotation(placementSettings.func_186215_c().func_185830_a(rotationFix));
                    List<Template.BlockInfo> blockInfoList = template2.getBlockInfo();
                    BlockPos startposition = pos.func_177972_a(EnumFacing.UP);
                    switch (playerfacing) {
                        case WEST: 
                        case EAST: {
                            startposition = startposition.func_177967_a(playerfacing, width).func_177967_a(playerfacing.func_176746_e(), depth / 2);
                            break;
                        }
                        case SOUTH: 
                        case NORTH: {
                            startposition = startposition.func_177967_a(playerfacing, width).func_177967_a(playerfacing.func_176746_e(), width / 2);
                        }
                    }
                    if (rotationFix == Rotation.CLOCKWISE_180) {
                        startposition = startposition.func_177967_a(playerfacing, -depth).func_177967_a(playerfacing.func_176735_f(), width);
                    } else if (rotationFix == Rotation.COUNTERCLOCKWISE_90) {
                        startposition = startposition.func_177967_a(playerfacing.func_176746_e(), -depth);
                    } else if (rotationFix == Rotation.CLOCKWISE_90) {
                        startposition = startposition.func_177967_a(playerfacing, -width);
                    }
                    HashMap<BlockPos, IBlockState> stateposmap = new HashMap<BlockPos, IBlockState>(blockInfoList.size());
                    for (Template.BlockInfo blockInfo : blockInfoList) {
                        BlockPos adjustedPosition = Template2.transformedBlockPos(blockInfo.field_186242_a, placementSettings.func_186212_b(), placementSettings.func_186215_c()).func_177971_a((Vec3i)startposition);
                        stateposmap.put(adjustedPosition, blockInfo.field_186243_b);
                        if (Utils.canReplaceBlock(adjustedPosition, worldIn)) continue;
                        player.func_145747_a((ITextComponent)new TextComponentString(Utils.interpolateString(Utils.translate("cant.replace", new Object[0]).func_150254_d() + " $$ at $$ $$ $$", worldIn.func_180495_p(adjustedPosition).func_177230_c().func_149732_F(), adjustedPosition.func_177958_n(), adjustedPosition.func_177956_o(), adjustedPosition.func_177952_p())));
                        return EnumActionResult.FAIL;
                    }
                    if (player.func_70093_af()) {
                        IBlockState state;
                        for (BlockPos blockposition : stateposmap.keySet()) {
                            state = worldIn.func_180495_p(blockposition);
                            if (state == Blocks.field_150350_a.func_176223_P() || state.func_177230_c() instanceof BlockPreview) continue;
                            player.func_145747_a((ITextComponent)new TextComponentString(Utils.interpolateString(Utils.translate("cant.replace", new Object[0]).func_150254_d() + " $$ at $$ $$ $$", worldIn.func_180495_p(blockposition).func_177230_c().func_149732_F(), blockposition.func_177958_n(), blockposition.func_177956_o(), blockposition.func_177952_p())));
                            return EnumActionResult.FAIL;
                        }
                        for (BlockPos blockposition : stateposmap.keySet()) {
                            state = (IBlockState)stateposmap.get(blockposition);
                            Block block = state.func_177230_c();
                            if (block instanceof BlockSlDoor || block instanceof BlockDoor) {
                                worldIn.func_175656_a(blockposition, SCPBlocks.bluePreviewBlock.func_176223_P());
                                continue;
                            }
                            worldIn.func_175656_a(blockposition, SCPBlocks.whitePreviewBlock.func_176223_P());
                        }
                        worldIn.func_175656_a(pos.func_177972_a(facing), SCPBlocks.greenPreviewBlock.func_176223_P());
                        return EnumActionResult.SUCCESS;
                    }
                    template2.func_186253_b(worldIn, startposition, placementSettings);
                    List<Template.EntityInfo> list = template2.getEntityInfo();
                    for (Template.EntityInfo entityInfo : list) {
                        Vec3d vec3d = entityInfo.field_186247_a;
                        NBTTagCompound compound = entityInfo.field_186249_c;
                        Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)worldIn);
                        if (entity == null) continue;
                        Class<?> enclass = entity.getClass();
                        entity = EntityList.func_191304_a(enclass, (World)worldIn);
                        BlockPos adjustedPosition = Template.func_186266_a((PlacementSettings)placementSettings, (BlockPos)new BlockPos(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c)).func_177971_a((Vec3i)startposition);
                        boolean entityReplaced = false;
                        List entityLivings = worldIn.func_72872_a(EntityLiving.class, new AxisAlignedBB(adjustedPosition));
                        for (EntityLiving entityLiving : entityLivings) {
                            if (entity == null || entityLiving.getClass() != enclass) continue;
                            if (entity instanceof EntityLiving) {
                                EntityLiving living = (EntityLiving)entity;
                                living.func_180482_a(worldIn.func_175649_E(adjustedPosition), null);
                            }
                            entity.func_70107_b(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v);
                            entityLiving.func_70106_y();
                            worldIn.func_72838_d(entity);
                            if (!Configg.experimentalSettings.enableDebugInformation) continue;
                            entityReplaced = true;
                            SCP.logger.info("Replaced " + entityLiving.func_70005_c_() + " with new instance");
                        }
                        if (!Configg.experimentalSettings.enableDebugInformation || entityReplaced || entity == null) continue;
                        SCP.logger.info("Didn't replace " + entity.func_70005_c_());
                    }
                    document.func_190918_g(1);
                    SCP.logger.info("Finished after {} seconds", (Object)Float.valueOf((float)(System.currentTimeMillis() - starttime) / 1000.0f));
                    return EnumActionResult.SUCCESS;
                }
                player.func_145747_a((ITextComponent)Utils.translate("document.unfinished", new Object[0]));
                return EnumActionResult.FAIL;
            }
            Object object = scpEntry.getAlternative();
            if (object != null) {
                WorldGenerator worldGenerator;
                if (object instanceof Item) {
                    Utils.spawnItemInWorld(new ItemStack((Item)object), worldIn, pos);
                    document.func_190918_g(1);
                } else if (object instanceof Block) {
                    Utils.spawnItemInWorld(new ItemStack((Block)object), worldIn, pos);
                    document.func_190918_g(1);
                } else if (object instanceof Class) {
                    Vec3d vec3d = Utils.getPositionForEntityFrom(pos.func_177984_a());
                    ItemMonsterPlacer.func_77840_a((World)worldIn, (ResourceLocation)EntityList.func_191306_a((Class)((Class)object)), (double)vec3d.field_72450_a, (double)vec3d.field_72448_b, (double)vec3d.field_72449_c);
                    document.func_190918_g(1);
                } else if (object instanceof WorldGenerator && (worldGenerator = (WorldGenerator)object).func_180709_b(worldIn, field_77697_d, pos)) {
                    document.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            player.func_145747_a((ITextComponent)Utils.translate("document.unfinished", new Object[0]));
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    protected EnumActionResult place(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing) {
        SCPEntry scpEntry;
        ItemStack document = player.func_184586_b(hand);
        String string = ItemNBTHelper.getString(document, NUMBER);
        if (!string.isEmpty() && (scpEntry = SCPs.getByNumber(string)) != null && worldIn instanceof WorldServer) {
            if (scpEntry.getStructureLocation() != null) {
                WorldServer worldServer = (WorldServer)worldIn;
                MinecraftServer minecraftServer = worldServer.func_73046_m();
                TemplateManager templateManager = worldServer.func_184163_y();
                Template template = templateManager.func_189942_b(minecraftServer, scpEntry.getStructureLocation());
                if (template != null) {
                    long starttime = System.currentTimeMillis();
                    EnumFacing playerfacing = player.func_174811_aO();
                    BlockPos dimensions = template.func_186259_a();
                    int width = dimensions.func_177958_n();
                    int depth = dimensions.func_177952_p();
                    Rotation rotationFix = scpEntry.getRotation();
                    PlacementSettings2 placementSettings = new PlacementSettings2(playerfacing);
                    placementSettings.setRotation(placementSettings.func_186215_c().func_185830_a(rotationFix));
                    TemplateUnwrapper templateUnwrapper = new TemplateUnwrapper(template);
                    List<Template.BlockInfo> blockInfoList = templateUnwrapper.getBlockInfoList();
                    BlockPos startposition = pos.func_177972_a(EnumFacing.UP);
                    switch (playerfacing) {
                        case WEST: 
                        case EAST: {
                            startposition = startposition.func_177967_a(playerfacing, depth).func_177967_a(playerfacing.func_176746_e(), depth / 2);
                            break;
                        }
                        case SOUTH: 
                        case NORTH: {
                            startposition = startposition.func_177967_a(playerfacing, depth).func_177967_a(playerfacing.func_176746_e(), width / 2);
                        }
                    }
                    if (rotationFix == Rotation.CLOCKWISE_180) {
                        startposition = startposition.func_177967_a(playerfacing, -depth).func_177967_a(playerfacing.func_176735_f(), width);
                    } else if (rotationFix == Rotation.COUNTERCLOCKWISE_90) {
                        startposition = startposition.func_177967_a(playerfacing.func_176746_e(), -width);
                    } else if (rotationFix == Rotation.CLOCKWISE_90) {
                        startposition = startposition.func_177967_a(playerfacing, -width);
                    }
                    HashMap<BlockPos, IBlockState> stateposmap = new HashMap<BlockPos, IBlockState>(blockInfoList.size());
                    for (Template.BlockInfo blockInfo : blockInfoList) {
                        BlockPos adjustedPosition = Template.func_186266_a((PlacementSettings)placementSettings, (BlockPos)blockInfo.field_186242_a).func_177971_a((Vec3i)startposition);
                        stateposmap.put(adjustedPosition, blockInfo.field_186243_b);
                        if (Utils.canReplaceBlock(adjustedPosition, worldIn)) continue;
                        player.func_145747_a((ITextComponent)new TextComponentString(Utils.interpolateString(Utils.translate("cant.replace", new Object[0]).func_150254_d() + " $$ at $$ $$ $$", worldIn.func_180495_p(adjustedPosition).func_177230_c().func_149732_F(), adjustedPosition.func_177958_n(), adjustedPosition.func_177956_o(), adjustedPosition.func_177952_p())));
                        return EnumActionResult.FAIL;
                    }
                    if (player.func_70093_af()) {
                        IBlockState state;
                        for (BlockPos blockposition : stateposmap.keySet()) {
                            state = worldIn.func_180495_p(blockposition);
                            if (state == Blocks.field_150350_a.func_176223_P() || state.func_177230_c() instanceof BlockPreview) continue;
                            player.func_145747_a((ITextComponent)new TextComponentString(Utils.interpolateString(Utils.translate("cant.replace", new Object[0]).func_150254_d() + " $$ at $$ $$ $$", worldIn.func_180495_p(blockposition).func_177230_c().func_149732_F(), blockposition.func_177958_n(), blockposition.func_177956_o(), blockposition.func_177952_p())));
                            return EnumActionResult.FAIL;
                        }
                        for (BlockPos blockposition : stateposmap.keySet()) {
                            state = (IBlockState)stateposmap.get(blockposition);
                            Block block = state.func_177230_c();
                            if (block instanceof BlockSlDoor || block instanceof BlockDoor) {
                                worldIn.func_175656_a(blockposition, SCPBlocks.bluePreviewBlock.func_176223_P());
                                continue;
                            }
                            if (block.hasTileEntity(state)) {
                                worldIn.func_175656_a(blockposition, SCPBlocks.greenPreview2.func_176223_P());
                                continue;
                            }
                            if (block == Blocks.field_150350_a) continue;
                            worldIn.func_175656_a(blockposition, SCPBlocks.whitePreviewBlock.func_176223_P());
                        }
                        worldIn.func_175656_a(pos.func_177972_a(facing), SCPBlocks.greenPreviewBlock.func_176223_P());
                        return EnumActionResult.SUCCESS;
                    }
                    template.func_186253_b(worldIn, startposition, (PlacementSettings)placementSettings);
                    List<Template.EntityInfo> list = templateUnwrapper.getEntityInfoList();
                    for (Template.EntityInfo entityInfo : list) {
                        Vec3d vec3d = entityInfo.field_186247_a;
                        NBTTagCompound compound = entityInfo.field_186249_c;
                        Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)worldIn);
                        if (entity == null) continue;
                        Class<?> enclass = entity.getClass();
                        entity = EntityList.func_191304_a(enclass, (World)worldIn);
                        BlockPos adjustedPosition = Template.func_186266_a((PlacementSettings)placementSettings, (BlockPos)new BlockPos(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c)).func_177971_a((Vec3i)startposition);
                        boolean entityReplaced = false;
                        List entityLivings = worldIn.func_72872_a(EntityLiving.class, new AxisAlignedBB(adjustedPosition));
                        for (EntityLiving entityLiving : entityLivings) {
                            if (entity == null || entityLiving.getClass() != enclass) continue;
                            if (entity instanceof EntityLiving) {
                                EntityLiving living = (EntityLiving)entity;
                                living.func_180482_a(worldIn.func_175649_E(adjustedPosition), null);
                            }
                            entity.func_70107_b(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v);
                            entityLiving.func_70106_y();
                            worldIn.func_72838_d(entity);
                            if (!Configg.experimentalSettings.enableDebugInformation) continue;
                            entityReplaced = true;
                            SCP.logger.info("Replaced " + entityLiving.func_70005_c_() + " with new instance");
                        }
                        if (!Configg.experimentalSettings.enableDebugInformation || entityReplaced || entity == null) continue;
                        SCP.logger.info("Didn't replace " + entity.func_70005_c_());
                    }
                    document.func_190918_g(1);
                    SCP.logger.info("Finished after {} seconds", (Object)Float.valueOf((float)(System.currentTimeMillis() - starttime) / 1000.0f));
                    return EnumActionResult.SUCCESS;
                }
                player.func_145747_a((ITextComponent)Utils.translate("document.unfinished", new Object[0]));
                return EnumActionResult.FAIL;
            }
            Object object = scpEntry.getAlternative();
            if (object != null) {
                WorldGenerator worldGenerator;
                if (object instanceof Item) {
                    Utils.spawnItemInWorld(new ItemStack((Item)object), worldIn, pos);
                    document.func_190918_g(1);
                } else if (object instanceof Block) {
                    Utils.spawnItemInWorld(new ItemStack((Block)object), worldIn, pos);
                    document.func_190918_g(1);
                } else if (object instanceof Class) {
                    Vec3d vec3d = Utils.getPositionForEntityFrom(pos.func_177984_a());
                    ItemMonsterPlacer.func_77840_a((World)worldIn, (ResourceLocation)EntityList.func_191306_a((Class)((Class)object)), (double)vec3d.field_72450_a, (double)vec3d.field_72448_b, (double)vec3d.field_72449_c);
                    document.func_190918_g(1);
                } else if (object instanceof WorldGenerator && (worldGenerator = (WorldGenerator)object).func_180709_b(worldIn, field_77697_d, pos)) {
                    document.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            player.func_145747_a((ITextComponent)Utils.translate("document.unfinished", new Object[0]));
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.SUCCESS;
    }
}

