/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.items;

import alexiy.secure.contain.protect.ItemNBTHelper;
import alexiy.secure.contain.protect.SCPItem;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.registration.SCPBlocks;
import alexiy.secure.contain.protect.registration.Sounds;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemFlashlight
extends SCPItem {
    private static final String UPDATE_RATE = "Update rate";
    private static final String PREVIOUS_POSITION = "Previous light position";

    public ItemFlashlight() {
        this.func_77625_d(1);
        this.setNoRepair();
        this.setRechargable(true);
        this.func_77656_e(Utils.minutesToTicks(20));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack usedItem = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            Block standingOn = worldIn.func_180495_p(playerIn.func_180425_c().func_177977_b()).func_177230_c();
            if (standingOn == SCPBlocks.floor087 || standingOn == SCPBlocks.stairs087) {
                playerIn.func_145747_a((ITextComponent)Utils.translate("flashlight.stopped.working", new Object[0]));
                worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, Sounds.flashlight_off, SoundCategory.PLAYERS, 1.0f, 1.0f);
            } else {
                ItemNBTHelper.toggleBoolean(usedItem, "On");
                worldIn.func_175656_a(ItemNBTHelper.getPosition(usedItem, PREVIOUS_POSITION), Blocks.field_150350_a.func_176223_P());
                SoundEvent sound = ItemNBTHelper.getBoolean(usedItem, "On") ? Sounds.flashlight_on : Sounds.flashlight_off;
                worldIn.func_184133_a(null, playerIn.func_180425_c(), sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)usedItem);
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        if (item.func_77978_p() == null) {
            return true;
        }
        BlockPos prevLightPos = ItemNBTHelper.getPosition(item, PREVIOUS_POSITION);
        player.field_70170_p.func_175656_a(prevLightPos, Blocks.field_150350_a.func_176223_P());
        return true;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            if (stack.func_77978_p() == null) {
                ItemNBTHelper.setBoolean(stack, "On", false);
            }
            EntityLivingBase livingBase = null;
            if (entityIn instanceof EntityLivingBase) {
                livingBase = (EntityLivingBase)entityIn;
            }
            BlockPos prevLightPos = ItemNBTHelper.getPosition(stack, PREVIOUS_POSITION);
            Block standingOn = worldIn.func_180495_p(entityIn.func_180425_c().func_177977_b()).func_177230_c();
            if ((standingOn == SCPBlocks.floor087 || standingOn == SCPBlocks.stairs087) && ItemNBTHelper.getBoolean(stack, "On")) {
                ItemNBTHelper.setBoolean(stack, "On", false);
                entityIn.func_145747_a((ITextComponent)Utils.translate("flashlight.turned.off", new Object[0]));
                worldIn.func_184133_a(null, entityIn.func_180425_c(), Sounds.flashlight_off, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (worldIn.func_180495_p(prevLightPos).func_177230_c() == SCPBlocks.lightSource) {
                    worldIn.func_175698_g(prevLightPos);
                }
            } else if (isSelected && stack.func_77952_i() < stack.func_77958_k() - 1 || livingBase != null && livingBase.func_184592_cb().func_77973_b() == stack.func_77973_b()) {
                Vec3d vec3d = entityIn.func_174824_e(1.0f);
                Vec3d vec3d1 = entityIn.func_70676_i(1.0f);
                Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * 10.0, vec3d1.field_72448_b * 10.0, vec3d1.field_72449_c * 10.0);
                RayTraceResult traceResult = worldIn.func_147447_a(vec3d, vec3d2, true, true, true);
                if (ItemNBTHelper.getBoolean(stack, "On")) {
                    if (traceResult != null && traceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                        BlockPos targetpos = traceResult.func_178782_a().func_177972_a(traceResult.field_178784_b);
                        IBlockState blockState = worldIn.func_180495_p(targetpos);
                        EnumFacing offsetback = entityIn.func_174811_aO().func_176734_d();
                        int breakcounter = 0;
                        while (blockState != Blocks.field_150350_a.func_176223_P() && blockState != SCPBlocks.lightSource.func_176223_P()) {
                            targetpos = targetpos.func_177972_a(offsetback);
                            blockState = worldIn.func_180495_p(targetpos);
                            if (++breakcounter <= 12) continue;
                        }
                        if (!targetpos.equals((Object)prevLightPos)) {
                            worldIn.func_175698_g(prevLightPos);
                            ItemNBTHelper.setPosition(stack, PREVIOUS_POSITION, targetpos);
                            worldIn.func_175656_a(targetpos, SCPBlocks.lightSource.func_176223_P());
                        }
                    } else if (traceResult == null) {
                        worldIn.func_175698_g(prevLightPos);
                    }
                }
            } else if (worldIn.func_180495_p(prevLightPos) == SCPBlocks.lightSource.func_176223_P()) {
                worldIn.func_175656_a(prevLightPos, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    @Override
    public boolean shouldItemRecharge(ItemStack itemStack) {
        return ItemNBTHelper.getBoolean(itemStack, "On");
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return newStack.func_77973_b() != this;
    }
}

