/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.packets;

import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.blocks.BlockCoffeeMachine;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DispenseObject
implements IMessage {
    BlockPos target;
    String fluid;
    String user;
    boolean isFluid;

    public DispenseObject() {
    }

    public DispenseObject(BlockPos pos, String fluidName, EntityPlayer entityPlayer, boolean isFluid) {
        this.target = pos;
        this.fluid = fluidName;
        this.user = entityPlayer.func_110124_au().toString();
        this.isFluid = isFluid;
    }

    public void fromBytes(ByteBuf buf) {
        this.target = BlockPos.func_177969_a((long)buf.readLong());
        this.fluid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.isFluid = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.target.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.fluid);
        buf.writeBoolean(this.isFluid);
    }

    public static class Handler
    implements IMessageHandler<DispenseObject, IMessage> {
        public IMessage onMessage(DispenseObject message, MessageContext ctx) {
            WorldServer worldServer = ctx.getServerHandler().field_147369_b.func_71121_q();
            worldServer.func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                IBlockState blockState = worldServer.func_180495_p(message.target);
                EnumFacing enumFacing = (EnumFacing)blockState.func_177229_b((IProperty)BlockCoffeeMachine.field_185512_D);
                if (message.isFluid) {
                    ItemStack bucket = new ItemStack(Items.field_151133_ar);
                    IFluidHandlerItem fluidBucketWrapper = (IFluidHandlerItem)bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    fluidBucketWrapper.fill(FluidRegistry.getFluidStack((String)message.fluid, (int)1000), true);
                    Utils.spawnItemInWorld(fluidBucketWrapper.getContainer(), (World)worldServer, message.target.func_177972_a(enumFacing));
                    player.func_184614_ca().func_190918_g(3);
                } else {
                    ItemStack potion = new ItemStack((Item)Items.field_151068_bn);
                    PotionUtils.func_185188_a((ItemStack)potion, (PotionType)PotionType.func_185168_a((String)message.fluid));
                    Utils.spawnItemInWorld(potion, (World)worldServer, message.target.func_177972_a(enumFacing));
                    player.func_184614_ca().func_190918_g(1);
                }
            });
            return null;
        }
    }
}

