/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.registration;

import alexiy.secure.contain.protect.Configg;
import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.api.ClockworksMode;
import alexiy.secure.contain.protect.api.ClockworksRecipe;
import alexiy.secure.contain.protect.clockworks.ClockworksRecipeOld;
import alexiy.secure.contain.protect.registration.SCPItems;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ClockworksRecipes {
    public static IForgeRegistry<ClockworksRecipe> forgeRegistry;

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public static void registerClockworksRecipes(RegistryEvent.Register<ClockworksRecipe> registryEvent) {
        Path customRecipes;
        forgeRegistry = registryEvent.getRegistry();
        if (!Configg.clockworksSettings.disableOriginalClockworksRecipes) {
            String name = "original";
            int i = 0;
            for (ClockworksRecipeOld clockworksRecipe : alexiy.secure.contain.protect.clockworks.ClockworksRecipes.getRecipes()) {
                ClockworksRecipe clockworksRecipe2 = new ClockworksRecipe(clockworksRecipe.getInput(), clockworksRecipe.getOutput(), clockworksRecipe.duration, clockworksRecipe.mode);
                clockworksRecipe2.setRegistryName("scp", name + i++);
                forgeRegistry.register((IForgeRegistryEntry)clockworksRecipe2);
            }
            String wool = "wool";
            String DYE = "dye";
            for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
                ClockworksRecipe recipe;
                if (dyeColor.ordinal() < 15) {
                    recipe = new ClockworksRecipe(new ItemStack(Blocks.field_150325_L, 1, dyeColor.ordinal()), new ItemStack(Blocks.field_150325_L, 1, dyeColor.ordinal() + 1), 20, ClockworksMode.ONETOONE);
                    recipe.setRegistryName("scp", wool + dyeColor.ordinal());
                    forgeRegistry.register((IForgeRegistryEntry)recipe);
                    ClockworksRecipe dyerecipe = new ClockworksRecipe(new ItemStack(Items.field_151100_aR, 1, dyeColor.ordinal()), new ItemStack(Items.field_151100_aR, 1, dyeColor.ordinal() + 1), 20, ClockworksMode.ONETOONE);
                    dyerecipe.setRegistryName("scp", DYE + dyeColor.ordinal());
                    forgeRegistry.register((IForgeRegistryEntry)dyerecipe);
                    continue;
                }
                recipe = new ClockworksRecipe(new ItemStack(Blocks.field_150325_L, 1, dyeColor.ordinal()), new ItemStack(Blocks.field_150325_L, 1, 0), 20, ClockworksMode.ONETOONE);
                recipe.setRegistryName("scp", wool + 15);
                forgeRegistry.register((IForgeRegistryEntry)recipe);
                ClockworksRecipe dye = new ClockworksRecipe(new ItemStack(Items.field_151100_aR, 1, dyeColor.ordinal()), new ItemStack(Items.field_151100_aR, 1, 0), 20, ClockworksMode.ONETOONE);
                dye.setRegistryName("scp", DYE + 15);
                forgeRegistry.register((IForgeRegistryEntry)dye);
            }
            ClockworksRecipes.registerRecipe(Blocks.field_150347_e, Blocks.field_150348_b, 4, ClockworksMode.FINE, name + "_stone");
            ClockworksRecipes.registerRecipe(SCPItems.card5, new ItemStack(Items.field_151045_i, 3), 200, ClockworksMode.ROUGH, name + "_diamonds");
            ClockworksRecipes.registerRecipe((Block)Blocks.field_150349_c, (Block)Blocks.field_150391_bh, 200, ClockworksMode.COARSE, name + "_mycelium");
            ClockworksRecipes.registerRecipe((Item)Items.field_151029_X, (Item)Items.field_151167_ab, 160, ClockworksMode.VERYFINE, name + "_iron_boots");
            ClockworksRecipes.registerRecipe((Item)Items.field_151022_W, (Item)Items.field_151165_aa, 160, ClockworksMode.VERYFINE, name + "_iron_leggings");
            ClockworksRecipes.registerRecipe((Item)Items.field_151023_V, (Item)Items.field_151030_Z, 160, ClockworksMode.VERYFINE, name + "_iron_chestplate");
            ClockworksRecipes.registerRecipe((Item)Items.field_151020_U, (Item)Items.field_151028_Y, 160, ClockworksMode.VERYFINE, name + "_iron_helmet");
            HashSet hashSet = Sets.newHashSet((Object[])new String[]{"pickaxe"});
            HashSet axe = Sets.newHashSet((Object[])new String[]{"axe"});
            HashSet shovel = Sets.newHashSet((Object[])new String[]{"shovel"});
            String deconstruct = "deconstruction";
            int c = 0;
            for (Item item : ForgeRegistries.ITEMS.getValuesCollection()) {
                ClockworksRecipe recipe;
                int metadata;
                ItemStack repairstack;
                if (item instanceof ItemTool) {
                    ItemTool tool = (ItemTool)item;
                    SCP.tools.add(tool);
                    try {
                        Item.ToolMaterial toolMaterial = Item.ToolMaterial.valueOf((String)tool.func_77861_e());
                        repairstack = toolMaterial.getRepairItemStack();
                        if (repairstack.func_190926_b()) continue;
                        metadata = repairstack.func_77960_j() == Short.MAX_VALUE ? 0 : repairstack.func_77960_j();
                        Set set = tool.getToolClasses(new ItemStack((Item)tool));
                        if (set.equals(hashSet) || set.equals(axe)) {
                            recipe = new ClockworksRecipe((Item)tool, new ItemStack(repairstack.func_77973_b(), 3, metadata), toolMaterial.func_77997_a() / 2, ClockworksMode.COARSE);
                            recipe.setRegistryName("scp", deconstruct + c++);
                            forgeRegistry.register((IForgeRegistryEntry)recipe);
                            continue;
                        }
                        if (!set.equals(shovel)) continue;
                        recipe = new ClockworksRecipe((Item)tool, new ItemStack(repairstack.func_77973_b(), 1, metadata), toolMaterial.func_77997_a() / 2, ClockworksMode.ONETOONE);
                        recipe.setRegistryName("scp", deconstruct + c++);
                        forgeRegistry.register((IForgeRegistryEntry)recipe);
                    }
                    catch (Exception e) {
                        SCP.logger.error(e.getMessage() + " of " + tool.func_77658_a());
                    }
                    continue;
                }
                if (item instanceof ItemArmor) {
                    ItemArmor armor = (ItemArmor)item;
                    SCP.armorlist.add(armor);
                    ItemArmor.ArmorMaterial armorMaterial = armor.func_82812_d();
                    ItemStack repairItemStack = armorMaterial.getRepairItemStack();
                    if (repairItemStack.func_190926_b()) continue;
                    int amount = 0;
                    switch (armor.field_77881_a) {
                        case HEAD: {
                            amount = 5;
                            break;
                        }
                        case CHEST: {
                            amount = 8;
                            break;
                        }
                        case LEGS: {
                            amount = 7;
                            break;
                        }
                        case FEET: {
                            amount = 4;
                        }
                    }
                    if (amount == 0) continue;
                    int metadata2 = repairItemStack.func_77960_j() == Short.MAX_VALUE ? 0 : repairItemStack.func_77960_j();
                    recipe = new ClockworksRecipe((Item)armor, new ItemStack(repairItemStack.func_77973_b(), amount, metadata2), armorMaterial.func_78046_a(armor.field_77881_a) / 2, ClockworksMode.COARSE);
                    recipe.setRegistryName("scp", deconstruct + c++);
                    forgeRegistry.register((IForgeRegistryEntry)recipe);
                    continue;
                }
                if (!(item instanceof ItemSword)) continue;
                ItemSword sword = (ItemSword)item;
                SCP.swordlist.add(sword);
                try {
                    Item.ToolMaterial swordmat = Item.ToolMaterial.valueOf((String)sword.func_150932_j());
                    repairstack = swordmat.getRepairItemStack();
                    if (repairstack.func_190926_b()) continue;
                    metadata = repairstack.func_77960_j() == Short.MAX_VALUE ? 0 : repairstack.func_77960_j();
                    ClockworksRecipe recipe2 = new ClockworksRecipe((Item)sword, new ItemStack(repairstack.func_77973_b(), 2, metadata), swordmat.func_77997_a() / 2, ClockworksMode.COARSE);
                    recipe2.setRegistryName("scp", deconstruct + c++);
                    forgeRegistry.register((IForgeRegistryEntry)recipe2);
                }
                catch (Exception e) {
                    SCP.logger.error(e.getMessage() + " of " + sword.func_77658_a());
                }
            }
        }
        if (!Files.exists(customRecipes = Paths.get(SCP.configs.getPath(), "SCP-914 recipes.cfg"), new LinkOption[0])) {
            try {
                Files.createFile(customRecipes, new FileAttribute[0]);
                ArrayList<String> comments = new ArrayList<String>(2);
                comments.add("#Recipe format (without braces): <input item's registry name>/<metadata>/<mode>/<time (ticks)>/<output item's registry name>/<amount>/<metadata>");
                comments.add("#Mode names: ROUGH, COARSE, ONETOONE, FINE, VERYFINE");
                Files.write(customRecipes, comments, new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String fileRecipes = "file_recipe";
        int r = 0;
        try {
            List<String> fileLines = Files.readAllLines(customRecipes);
            for (String s : fileLines) {
                if (s.isEmpty() || s.startsWith("#")) continue;
                String[] parameters = s.split("/");
                if (parameters.length != 7) {
                    throw new IllegalArgumentException("Wrong number of arguments in string - " + s + " - must be seven");
                }
                String inputName = parameters[0];
                int inputMetadata = Integer.parseInt(parameters[1]);
                ClockworksMode mode = ClockworksMode.valueOf(parameters[2]);
                int ticks = Integer.parseInt(parameters[3]);
                String outputName = parameters[4];
                int amount = Integer.parseInt(parameters[5]);
                int outputMetadata = Integer.parseInt(parameters[6]);
                Item itemin = Item.func_111206_d((String)inputName);
                Item itemout = Item.func_111206_d((String)outputName);
                if (itemin == null) {
                    throw new IllegalArgumentException("Item " + inputName + " doesn't exist");
                }
                if (itemout == null) {
                    throw new IllegalArgumentException("Item " + outputName + " doesn't exist");
                }
                ClockworksRecipe clockworksRecipe = new ClockworksRecipe(new ItemStack(itemin, 1, inputMetadata), new ItemStack(itemout, amount, outputMetadata), ticks, mode);
                clockworksRecipe.setRegistryName("scp", fileRecipes + r++);
                forgeRegistry.register((IForgeRegistryEntry)clockworksRecipe);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String modRecipe = "mod_recipe";
        int n = 0;
        if (SCP.AE2) {
            NonNullList ae2certusCrystalDust = OreDictionary.getOres((String)"dustCertusQuartz");
            NonNullList ae2certusCrystal = OreDictionary.getOres((String)"crystalCertusQuartz");
            if (!ae2certusCrystal.isEmpty() && !ae2certusCrystalDust.isEmpty()) {
                void var5_16;
                ClockworksRecipe clockworksRecipe = new ClockworksRecipe(((ItemStack)ae2certusCrystal.get(0)).func_77973_b(), new ItemStack(((ItemStack)ae2certusCrystalDust.get(0)).func_77973_b(), 2), 60, ClockworksMode.COARSE);
                ++var5_16;
                clockworksRecipe.setRegistryName("scp", modRecipe + n);
                forgeRegistry.register((IForgeRegistryEntry)clockworksRecipe);
                SCP.info("AE2 recipe: " + (Object)((Object)clockworksRecipe));
            }
        }
    }

    private static void registerRecipe(ItemStack in, ItemStack out, int time, ClockworksMode mode, String type) {
        ClockworksRecipe recipe = new ClockworksRecipe(in, out, time, mode);
        recipe.setRegistryName("scp", type);
        forgeRegistry.register((IForgeRegistryEntry)recipe);
    }

    private static void registerRecipe(Item in, ItemStack out, int time, ClockworksMode mode, String type) {
        ClockworksRecipes.registerRecipe(new ItemStack(in), out, time, mode, type);
    }

    private static void registerRecipe(Block in, ItemStack out, int time, ClockworksMode mode, String type) {
        ClockworksRecipes.registerRecipe(new ItemStack(in), out, time, mode, type);
    }

    static void registerRecipe(Block in, Block out, int time, ClockworksMode mode, String identifier) {
        ClockworksRecipes.registerRecipe(in, new ItemStack(out), time, mode, identifier);
    }

    static void registerRecipe(Item in, Item out, int time, ClockworksMode mode, String identifier) {
        ClockworksRecipes.registerRecipe(in, new ItemStack(out), time, mode, identifier);
    }
}

