/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.slidingdoors;

import alexiy.secure.contain.protect.blocks.BlockHorizontalNonSolid;
import alexiy.secure.contain.protect.slidingdoors.TileSlidingDoor;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSlDoor
extends BlockHorizontalNonSolid {
    public static final PropertyEnum<BlockDoor.EnumDoorHalf> DOOR_HALF = BlockDoor.field_176523_O;
    private static final AxisAlignedBB STATIC_X_BOX = new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625);
    private static final AxisAlignedBB STATIC_Z_BOX = new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0);

    public BlockSlDoor() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DOOR_HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER));
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, DOOR_HALF});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState def = this.func_176223_P();
        switch (meta) {
            case 0: {
                return def.func_177226_a(DOOR_HALF, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.EAST);
            }
            case 1: {
                return def.func_177226_a(DOOR_HALF, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.WEST);
            }
            case 2: {
                return def.func_177226_a(DOOR_HALF, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH);
            }
            case 3: {
                return def.func_177226_a(DOOR_HALF, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.SOUTH);
            }
            case 4: {
                return def.func_177226_a(DOOR_HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.EAST);
            }
            case 5: {
                return def.func_177226_a(DOOR_HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.WEST);
            }
            case 6: {
                return def.func_177226_a(DOOR_HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH);
            }
            case 7: {
                return def.func_177226_a(DOOR_HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.SOUTH);
            }
        }
        return super.func_176203_a(meta);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        BlockDoor.EnumDoorHalf doorHalf = (BlockDoor.EnumDoorHalf)state.func_177229_b(DOOR_HALF);
        if (doorHalf == BlockDoor.EnumDoorHalf.UPPER) {
            switch (dir) {
                case EAST: {
                    return 0;
                }
                case WEST: {
                    return 1;
                }
                case NORTH: {
                    return 2;
                }
                case SOUTH: {
                    return 3;
                }
            }
        } else {
            switch (dir) {
                case EAST: {
                    return 4;
                }
                case WEST: {
                    return 5;
                }
                case NORTH: {
                    return 6;
                }
                case SOUTH: {
                    return 7;
                }
            }
        }
        return super.func_176201_c(state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileSlidingDoor();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileSlidingDoor slidingDoor = (TileSlidingDoor)worldIn.func_175625_s(pos);
        BlockDoor.EnumDoorHalf doorHalf = (BlockDoor.EnumDoorHalf)state.func_177229_b(DOOR_HALF);
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        boolean open = worldIn.func_175640_z(pos);
        if (open || blockIn == Blocks.field_180401_cv) {
            if (!slidingDoor.opening) {
                slidingDoor.opening = true;
                slidingDoor.closing = false;
                slidingDoor.openingProgress = slidingDoor.closingProgress;
                slidingDoor.underPower = true;
                worldIn.func_175641_c(pos, (Block)this, 0, (int)slidingDoor.openingProgress);
                if (doorHalf == BlockDoor.EnumDoorHalf.LOWER) {
                    worldIn.func_175641_c(pos.func_177984_a(), (Block)this, 0, (int)slidingDoor.openingProgress);
                } else {
                    worldIn.func_175641_c(pos.func_177977_b(), (Block)this, 0, (int)slidingDoor.openingProgress);
                }
                BlockPos position = pos.func_177972_a(dir.func_176735_f());
                IBlockState adjacent = worldIn.func_180495_p(position);
                if (adjacent.func_177230_c() == this && ((EnumFacing)adjacent.func_177229_b((IProperty)field_185512_D)).func_176734_d() == state.func_177229_b((IProperty)field_185512_D)) {
                    this.func_189540_a(adjacent, worldIn, position, Blocks.field_180401_cv, pos);
                }
            }
        } else if (!(open && blockIn != Blocks.field_150461_bJ || slidingDoor.closing)) {
            slidingDoor.opening = false;
            slidingDoor.closing = true;
            slidingDoor.underPower = false;
            slidingDoor.closingProgress = slidingDoor.openingProgress;
            worldIn.func_175641_c(pos, (Block)this, 1, (int)slidingDoor.closingProgress);
            if (doorHalf == BlockDoor.EnumDoorHalf.LOWER) {
                worldIn.func_175641_c(pos.func_177984_a(), (Block)this, 1, (int)slidingDoor.closingProgress);
            } else {
                worldIn.func_175641_c(pos.func_177977_b(), (Block)this, 1, (int)slidingDoor.closingProgress);
            }
            BlockPos position = pos.func_177972_a(dir.func_176735_f());
            IBlockState adjacent = worldIn.func_180495_p(position);
            if (adjacent.func_177230_c() == this && ((EnumFacing)adjacent.func_177229_b((IProperty)field_185512_D)).func_176734_d() == state.func_177229_b((IProperty)field_185512_D)) {
                this.func_189540_a(adjacent, worldIn, position, (Block)Blocks.field_150461_bJ, pos);
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177229_b(DOOR_HALF) == BlockDoor.EnumDoorHalf.UPPER) {
            worldIn.func_175698_g(pos.func_177977_b());
        } else {
            worldIn.func_175698_g(pos.func_177984_a());
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity slidingDoor = source.func_175625_s(pos);
        if (slidingDoor instanceof TileSlidingDoor) {
            TileSlidingDoor tileSlDoor = (TileSlidingDoor)slidingDoor;
            byte opentime = tileSlDoor.openingProgress;
            byte closetime = tileSlDoor.closingProgress;
            EnumFacing orientation = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
            if (tileSlDoor.opening) {
                switch (orientation) {
                    case EAST: {
                        return STATIC_Z_BOX.func_72317_d(0.0, 0.0, 1.0 - (double)opentime / 32.0);
                    }
                    case WEST: {
                        return STATIC_Z_BOX.func_72317_d(0.0, 0.0, (double)opentime / 32.0 - 1.0);
                    }
                    case NORTH: {
                        return STATIC_X_BOX.func_72317_d(-((double)opentime / 32.0 - 1.0), 0.0, 0.0);
                    }
                    case SOUTH: {
                        return STATIC_X_BOX.func_72317_d((double)opentime / 32.0 - 1.0, 0.0, 0.0);
                    }
                }
            }
            if (tileSlDoor.closing) {
                switch (orientation) {
                    case EAST: {
                        return STATIC_Z_BOX.func_72317_d(0.0, 0.0, 1.0 - (double)closetime / 32.0);
                    }
                    case WEST: {
                        return STATIC_Z_BOX.func_72317_d(0.0, 0.0, (double)closetime / 32.0 - 1.0);
                    }
                    case NORTH: {
                        return STATIC_X_BOX.func_72317_d(1.0 - (double)closetime / 32.0, 0.0, 0.0);
                    }
                    case SOUTH: {
                        return STATIC_X_BOX.func_72317_d((double)closetime / 32.0 - 1.0, 0.0, 0.0);
                    }
                }
            }
        }
        return field_185505_j;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos.func_177984_a())) {
            return super.func_176196_c(worldIn, pos);
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a(DOOR_HALF, (Comparable)BlockDoor.EnumDoorHalf.UPPER));
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        AxisAlignedBB axisAlignedBB = this.func_185496_a(state, world, pos);
        if (axisAlignedBB.field_72334_f == 2.0 || axisAlignedBB.field_72336_d == 2.0 || axisAlignedBB.field_72340_a == -1.0 || axisAlignedBB.field_72339_c == -1.0) {
            return PathNodeType.DOOR_OPEN;
        }
        return PathNodeType.DOOR_IRON_CLOSED;
    }
}

