/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.core.SpawnUtil;
import com.Fishmod.mod_LavaCow.entities.IAggressive;
import com.Fishmod.mod_LavaCow.init.FishItems;
import com.Fishmod.mod_LavaCow.mod_LavaCow;
import com.Fishmod.mod_LavaCow.util.LootTableHandler;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBanshee
extends EntityMob
implements IAggressive {
    private static final DataParameter<Byte> CASTING = EntityDataManager.func_187226_a(EntityBanshee.class, (DataSerializer)DataSerializers.field_187191_a);
    private boolean isAggressive = false;
    private int attackTimer = 0;
    protected int spellTicks;

    public EntityBanshee(World worldIn) {
        super(worldIn);
        this.field_70765_h = new AIMoveControl(this);
        this.func_70105_a(0.75f, 2.25f);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AICastingApell());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIUseSpell());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack());
        if (!Modconfig.SunScreen_Mode) {
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        }
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.Banshee_Health);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Modconfig.Banshee_Attack);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
    }

    public boolean func_70601_bi() {
        return SpawnUtil.isAllowedDimension(this.field_71093_bK) && super.func_70601_bi();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_189654_d(true);
        this.field_70180_af.func_187214_a(CASTING, (Object)0);
    }

    public boolean isSpellcasting() {
        return ((Byte)this.field_70180_af.func_187225_a(CASTING) & 1) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSpellcastingC() {
        return ((Byte)this.field_70180_af.func_187225_a(CASTING) & 1) != 0;
    }

    public int getSpellTicks() {
        return this.spellTicks;
    }

    protected boolean isBanshee() {
        return true;
    }

    protected String ParticleType() {
        return "spore";
    }

    public void func_70071_h_() {
        this.field_70145_X = this.field_70163_u > (double)SpawnUtil.getHeight((Entity)this).func_177956_o() + 0.5 && this.func_70638_az() == null;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
        if (this.field_70173_aa % 2 == 0 && this.func_130014_f_().field_72995_K) {
            mod_LavaCow.PROXY.spawnCustomParticle(this.ParticleType(), this.field_70170_p, this.field_70165_t + (double)(new Random().nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(new Random().nextFloat() * this.field_70131_O), this.field_70161_v + (double)(new Random().nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, 0.2f, 0.21f, 0.23f);
        }
        if (this.isBanshee() && this.getSpellTicks() > 8 && this.getSpellTicks() < 13) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v, 0.0, 1.0, 0.0, new int[0]);
        }
    }

    public void func_70636_d() {
        float f;
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }
        if (!Modconfig.SunScreen_Mode && this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && this.isBanshee() && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            this.func_70015_d(8);
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        return livingdata;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            this.isAggressive = true;
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
        } else {
            this.isAggressive = false;
            this.field_70170_p.func_72960_a((Entity)this, (byte)34);
        }
    }

    @Override
    public boolean isAggressive() {
        return this.isAggressive;
    }

    @Override
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Override
    public void setAttackTimer(int i) {
        this.attackTimer = i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.spellTicks = 30;
        } else if (id == 4) {
            this.attackTimer = 5;
        } else if (id == 11) {
            this.isAggressive = true;
        } else if (id == 34) {
            this.isAggressive = false;
        } else {
            super.func_70103_a(id);
        }
    }

    public void setIsCasting(boolean isHanging) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CASTING);
        if (isHanging) {
            this.field_70180_af.func_187227_b(CASTING, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(CASTING, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    protected SoundEvent func_184639_G() {
        return FishItems.ENTITY_BANSHEE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FishItems.ENTITY_BANSHEE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FishItems.ENTITY_BANSHEE_DEATH;
    }

    protected SoundEvent getSpellSound() {
        return FishItems.ENTITY_BANSHEE_ATTACK;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.BANSHEE;
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityBanshee.this.func_70605_aq().func_75640_a() && EntityBanshee.this.field_70146_Z.nextInt(7) == 0 && !EntityBanshee.this.isAggressive();
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityBanshee.this);
            int y = EntityBanshee.this.field_70146_Z.nextInt(11) - 5;
            if (Modconfig.FlyingHeight_limit != 0) {
                y = Math.min(SpawnUtil.getHeight((Entity)EntityBanshee.this).func_177956_o() + Modconfig.FlyingHeight_limit, y);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityBanshee.this.field_70146_Z.nextInt(15) - 7, y, EntityBanshee.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityBanshee.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityBanshee.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityBanshee.this.func_70638_az() != null) break;
                EntityBanshee.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityBanshee Banshee) {
            super((EntityLiving)Banshee);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityBanshee.this.field_70165_t;
                double d1 = this.field_75647_c - EntityBanshee.this.field_70163_u;
                double d2 = this.field_75644_d - EntityBanshee.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityBanshee.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityBanshee.this.field_70159_w *= 0.5;
                    EntityBanshee.this.field_70181_x *= 0.5;
                    EntityBanshee.this.field_70179_y *= 0.5;
                } else {
                    EntityBanshee.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityBanshee.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityBanshee.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityBanshee.this.func_70638_az() == null) {
                        EntityBanshee.this.field_70761_aq = EntityBanshee.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityBanshee.this.field_70159_w, (double)EntityBanshee.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityBanshee.this.func_70638_az().field_70165_t - EntityBanshee.this.field_70165_t;
                        double d5 = EntityBanshee.this.func_70638_az().field_70161_v - EntityBanshee.this.field_70161_v;
                        EntityBanshee.this.field_70761_aq = EntityBanshee.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }

    class AIChargeAttack
    extends EntityAIBase {
        public AIChargeAttack() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityBanshee.this.func_70638_az() != null && !EntityBanshee.this.func_70605_aq().func_75640_a() && EntityBanshee.this.field_70146_Z.nextInt(7) == 0) {
                return EntityBanshee.this.func_70068_e((Entity)EntityBanshee.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntityBanshee.this.func_70605_aq().func_75640_a() && EntityBanshee.this.func_70638_az() != null && EntityBanshee.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = EntityBanshee.this.func_70638_az();
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            EntityBanshee.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.5);
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = EntityBanshee.this.func_70638_az();
            if (entitylivingbase != null) {
                if (EntityBanshee.this.func_174813_aQ().func_72326_a(entitylivingbase.func_174813_aQ())) {
                    EntityBanshee.this.func_70652_k((Entity)entitylivingbase);
                } else {
                    double d0 = EntityBanshee.this.func_70068_e((Entity)entitylivingbase);
                    if (d0 < 36.0) {
                        Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                        EntityBanshee.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.5);
                    }
                }
            }
            super.func_75246_d();
        }
    }

    public class AIUseSpell
    extends EntityAIBase {
        protected int spellWarmup;
        protected int spellCooldown;

        public boolean func_75250_a() {
            if (EntityBanshee.this.func_70638_az() == null) {
                return false;
            }
            if (EntityBanshee.this.isSpellcasting()) {
                return false;
            }
            return EntityBanshee.this.field_70173_aa >= this.spellCooldown && EntityBanshee.this.func_70032_d((Entity)EntityBanshee.this.func_70638_az()) < 3.0f;
        }

        public boolean func_75253_b() {
            return EntityBanshee.this.func_70638_az() != null && this.spellWarmup > 0;
        }

        public void func_75249_e() {
            this.spellWarmup = this.getCastWarmupTime();
            EntityBanshee.this.spellTicks = this.getCastingTime();
            EntityBanshee.this.field_70170_p.func_72960_a((Entity)EntityBanshee.this, (byte)10);
            this.spellCooldown = EntityBanshee.this.field_70173_aa + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                EntityBanshee.this.func_184185_a(soundevent, 1.0f, 1.0f);
            }
        }

        public void func_75246_d() {
            --this.spellWarmup;
            if (this.spellWarmup == 5) {
                this.castSpell();
                EntityBanshee.this.func_184185_a(EntityBanshee.this.getSpellSound(), 4.0f, 1.2f);
            }
        }

        protected void castSpell() {
            List list = EntityBanshee.this.field_70170_p.func_72839_b((Entity)EntityBanshee.this, EntityBanshee.this.func_174813_aQ().func_72314_b(Modconfig.Banshee_Ability_Radius, Modconfig.Banshee_Ability_Radius, Modconfig.Banshee_Ability_Radius));
            EntityBanshee.this.field_70170_p.func_72960_a((Entity)EntityBanshee.this, (byte)11);
            for (Entity entity1 : list) {
                if (!(entity1 instanceof EntityLivingBase) || ((EntityLivingBase)entity1).func_70668_bt() == EnumCreatureAttribute.UNDEAD) continue;
                float local_difficulty = EntityBanshee.this.field_70170_p.func_175649_E(new BlockPos((Entity)EntityBanshee.this)).func_180168_b();
                ((EntityLivingBase)entity1).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 80 * (int)local_difficulty, 2));
                ((EntityLivingBase)entity1).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 40 * (int)local_difficulty, 6));
                ((EntityLivingBase)entity1).func_70097_a(DamageSource.func_76358_a((EntityLivingBase)EntityBanshee.this).func_82726_p().func_76348_h(), (float)EntityBanshee.this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 1.0f);
            }
        }

        protected int getCastWarmupTime() {
            return 20;
        }

        protected int getCastingTime() {
            return 30;
        }

        protected int getCastingInterval() {
            return 160;
        }

        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return null;
        }
    }

    public class AICastingApell
    extends EntityAIBase {
        public AICastingApell() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return EntityBanshee.this.getSpellTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityBanshee.this.setIsCasting(true);
            EntityBanshee.this.field_70699_by.func_75499_g();
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityBanshee.this.setIsCasting(false);
        }

        public void func_75246_d() {
            if (EntityBanshee.this.func_70638_az() != null) {
                EntityBanshee.this.func_70671_ap().func_75651_a((Entity)EntityBanshee.this.func_70638_az(), (float)EntityBanshee.this.func_184649_cE(), (float)EntityBanshee.this.func_70646_bf());
            }
            if (EntityBanshee.this.getSpellTicks() > 8 && EntityBanshee.this.getSpellTicks() < 13) {
                EntityBanshee.this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, EntityBanshee.this.field_70165_t, EntityBanshee.this.field_70163_u + (double)EntityBanshee.this.field_70131_O, EntityBanshee.this.field_70161_v, 0.0, 1.0, 0.0, new int[0]);
            }
        }
    }
}

