/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities.ai;

import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityAIDestroyCrops
extends EntityAIBase {
    protected final EntityCreature entity;
    public int destroyTicks;
    private boolean isHarvest;
    private final double movementSpeed;
    protected int runDelay;
    private int timeoutCounter;
    private int maxStayTicks;
    protected BlockPos destinationBlock = BlockPos.field_177992_a;
    private boolean isAboveDestination;
    private final int searchLength;

    public EntityAIDestroyCrops(EntityCreature creature, double speedIn, boolean isHarvestIn) {
        this.entity = creature;
        this.destroyTicks = 0;
        this.isHarvest = isHarvestIn;
        this.movementSpeed = speedIn;
        this.searchLength = 16;
        this.func_75248_a(5);
    }

    public boolean func_75250_a() {
        if (!ForgeEventFactory.getMobGriefingEvent((World)this.entity.field_70170_p, (Entity)this.entity)) {
            return false;
        }
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = 40 + this.entity.func_70681_au().nextInt(40);
        return this.searchForDestination();
    }

    public boolean func_75253_b() {
        return this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.shouldMoveTo(this.entity.field_70170_p, this.destinationBlock);
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
        this.timeoutCounter = 0;
        this.maxStayTicks = this.entity.func_70681_au().nextInt(this.entity.func_70681_au().nextInt(1200) + 1200) + 1200;
    }

    public void func_75246_d() {
        if (this.entity.func_174831_c(this.destinationBlock.func_177984_a()) > 1.0) {
            this.isAboveDestination = false;
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.entity.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
            }
        } else {
            this.isAboveDestination = true;
            --this.timeoutCounter;
        }
        this.entity.func_70671_ap().func_75650_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, 10.0f, (float)this.entity.func_70646_bf());
        if (this.getIsAboveDestination()) {
            World world = this.entity.field_70170_p;
            BlockPos blockpos = this.destinationBlock.func_177984_a();
            ++this.destroyTicks;
            if (this.destroyTicks > 30) {
                Block block = world.func_180495_p(blockpos).func_177230_c();
                world.func_175655_b(blockpos, true);
                if (this.isHarvest) {
                    world.func_180501_a(blockpos, block.func_176223_P(), 3);
                    world.func_175715_c(this.entity.func_145782_y(), blockpos, 0);
                }
            } else if (this.destroyTicks % 10 == 0) {
                world.func_175715_c(this.entity.func_145782_y(), blockpos, this.destroyTicks / 10);
            }
        }
    }

    protected boolean getIsAboveDestination() {
        return this.isAboveDestination;
    }

    private boolean searchForDestination() {
        int i = this.searchLength;
        BlockPos blockpos = new BlockPos((Entity)this.entity);
        int k = 0;
        while (k <= 1) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        BlockPos blockpos1 = blockpos.func_177982_a(i1, k - 1, j1);
                        if (this.entity.func_180485_d(blockpos1) && this.shouldMoveTo(this.entity.field_70170_p, blockpos1)) {
                            this.destinationBlock = blockpos1;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    protected boolean shouldMoveTo(World worldIn, BlockPos pos) {
        IBlockState iblockstate;
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150458_ak && (block = (iblockstate = worldIn.func_180495_p(pos = pos.func_177984_a())).func_177230_c()) instanceof BlockCrops && (!this.isHarvest || ((BlockCrops)block).func_185525_y(iblockstate))) {
            return true;
        }
        pos = pos.func_177984_a();
        iblockstate = worldIn.func_180495_p(pos);
        block = iblockstate.func_177230_c();
        return !this.isHarvest && block instanceof BlockBush;
    }
}

