/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities.ai;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.util.math.AxisAlignedBB;

public class EntityAIPickupMeat<T extends EntityItem>
extends EntityAITarget {
    protected final Class<T> targetClass;
    private final int targetChance;
    protected final EntityAINearestAttackableTarget.Sorter sorter;
    protected final Predicate<? super EntityItem> targetEntitySelector;
    protected EntityItem targetEntity;

    public EntityAIPickupMeat(EntityCreature creature, Class<T> classTarget, boolean checkSight) {
        this(creature, classTarget, checkSight, false);
    }

    public EntityAIPickupMeat(EntityCreature creature, Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
        this(creature, classTarget, 10, checkSight, onlyNearby, null);
    }

    public EntityAIPickupMeat(EntityCreature creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super(creature, checkSight, onlyNearby);
        this.targetClass = classTarget;
        this.targetChance = chance;
        this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)creature);
        this.func_75248_a(1);
        this.targetEntitySelector = new Predicate<EntityItem>(){

            public boolean apply(@Nullable EntityItem item) {
                return item instanceof EntityItem && !item.func_92059_d().func_190926_b() && item.func_92059_d().func_77973_b() instanceof ItemFood && ((ItemFood)item.func_92059_d().func_77973_b()).func_77845_h();
            }
        };
    }

    public boolean func_75250_a() {
        if (this.targetChance > 0 && this.field_75299_d.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        List list = this.field_75299_d.field_70170_p.func_175647_a(EntityItem.class, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
        if (list.isEmpty()) {
            return false;
        }
        Collections.sort(list, this.sorter);
        this.targetEntity = (EntityItem)list.get(0);
        return true;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70661_as().func_75492_a(this.targetEntity.field_70165_t, this.targetEntity.field_70163_u, this.targetEntity.field_70161_v, 1.0);
        super.func_75249_e();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.targetEntity == null || this.targetEntity != null && this.targetEntity.field_70128_L) {
            this.func_75251_c();
        }
        if (this.targetEntity != null && !this.targetEntity.field_70128_L && this.field_75299_d.func_70068_e((Entity)this.targetEntity) < 1.5) {
            this.targetEntity.func_92059_d().func_190918_g(1);
            this.field_75299_d.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            this.field_75299_d.func_70691_i(this.field_75299_d.func_110138_aP() * 0.1f);
            this.func_75251_c();
        }
    }

    public boolean func_75253_b() {
        return !this.field_75299_d.func_70661_as().func_75500_f();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        public Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.entity.func_70068_e(p_compare_1_);
            if (d0 < (d1 = this.entity.func_70068_e(p_compare_2_))) {
                return -1;
            }
            return d0 > d1 ? 1 : 0;
        }
    }
}

