/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.galaxies;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GalaxyRegistry {
    static int maxSolarSystemID = 0;
    static int maxPlanetID = 0;
    static int maxMoonID = 0;
    static int maxSatelliteID = 0;
    static HashMap<String, SolarSystem> solarSystems = Maps.newHashMap();
    static BiMap<String, Integer> solarSystemIDs = HashBiMap.create();
    static TreeMap<String, Planet> planets = Maps.newTreeMap();
    static BiMap<String, Integer> planetIDs = HashBiMap.create();
    static TreeMap<String, Moon> moons = Maps.newTreeMap();
    static BiMap<String, Integer> moonIDs = HashBiMap.create();
    static HashMap<String, Satellite> satellites = Maps.newHashMap();
    static BiMap<String, Integer> satelliteIDs = HashBiMap.create();
    static HashMap<Planet, List<Moon>> moonList = Maps.newHashMap();
    static HashMap<CelestialBody, List<Satellite>> satelliteList = Maps.newHashMap();
    static HashMap<SolarSystem, List<Planet>> solarSystemList = Maps.newHashMap();

    public static CelestialBody getCelestialBodyFromDimensionID(int dimensionID) {
        for (Planet planet : planets.values()) {
            if (planet.getDimensionID() != dimensionID) continue;
            return planet;
        }
        for (Moon moon : moons.values()) {
            if (moon.getDimensionID() != dimensionID) continue;
            return moon;
        }
        for (Satellite satellite : satellites.values()) {
            if (satellite.getDimensionID() != dimensionID) continue;
            return satellite;
        }
        return null;
    }

    public static void refreshGalaxies() {
        moonList.clear();
        satelliteList.clear();
        solarSystemList.clear();
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            Planet planet = moon.getParentPlanet();
            List<Moon> listOfMoons = moonList.get(planet);
            if (listOfMoons == null) {
                listOfMoons = new ArrayList<Moon>();
            }
            listOfMoons.add(moon);
            moonList.put(planet, listOfMoons);
        }
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            Planet celestialBody = satellite.getParentPlanet();
            List<Satellite> satelliteList1 = satelliteList.get(celestialBody);
            if (satelliteList1 == null) {
                satelliteList1 = new ArrayList<Satellite>();
            }
            satelliteList1.add(satellite);
            satelliteList.put(celestialBody, satelliteList1);
        }
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            SolarSystem solarSystem = planet.getParentSolarSystem();
            List<Planet> planetList = solarSystemList.get(solarSystem);
            if (planetList == null) {
                planetList = new ArrayList<Planet>();
            }
            planetList.add(planet);
            solarSystemList.put(solarSystem, planetList);
        }
    }

    public static List<Planet> getPlanetsForSolarSystem(SolarSystem solarSystem) {
        List<Planet> solarSystemListLocal = solarSystemList.get(solarSystem);
        if (solarSystemListLocal == null) {
            return new ArrayList<Planet>();
        }
        return ImmutableList.copyOf(solarSystemListLocal);
    }

    public static List<Moon> getMoonsForPlanet(Planet planet) {
        List<Moon> moonListLocal = moonList.get(planet);
        if (moonListLocal == null) {
            return new ArrayList<Moon>();
        }
        return ImmutableList.copyOf(moonListLocal);
    }

    public static List<Satellite> getSatellitesForCelestialBody(CelestialBody celestialBody) {
        List<Satellite> satelliteList1 = satelliteList.get(celestialBody);
        if (satelliteList1 == null) {
            return new ArrayList<Satellite>();
        }
        return ImmutableList.copyOf(satelliteList1);
    }

    public static CelestialBody getCelestialBodyFromUnlocalizedName(String unlocalizedName) {
        for (Planet planet : planets.values()) {
            if (!planet.getTranslationKey().equals(unlocalizedName)) continue;
            return planet;
        }
        for (Moon moon : moons.values()) {
            if (!moon.getTranslationKey().equals(unlocalizedName)) continue;
            return moon;
        }
        return null;
    }

    public static boolean registerSolarSystem(SolarSystem solarSystem) {
        if (solarSystemIDs.containsKey((Object)solarSystem.getName())) {
            return false;
        }
        solarSystems.put(solarSystem.getName(), solarSystem);
        solarSystemIDs.put((Object)solarSystem.getName(), (Object)(++maxSolarSystemID));
        MinecraftForge.EVENT_BUS.post((Event)new SolarSystemRegisterEvent(solarSystem.getName(), maxSolarSystemID));
        return true;
    }

    public static boolean registerPlanet(Planet planet) {
        if (planetIDs.containsKey((Object)planet.getName())) {
            return false;
        }
        planets.put(planet.getName(), planet);
        planetIDs.put((Object)planet.getName(), (Object)(++maxPlanetID));
        MinecraftForge.EVENT_BUS.post((Event)new PlanetRegisterEvent(planet.getName(), maxPlanetID));
        return true;
    }

    public static boolean registerMoon(Moon moon) {
        if (moonIDs.containsKey((Object)moon.getName())) {
            return false;
        }
        moons.put(moon.getName(), moon);
        moonIDs.put((Object)moon.getName(), (Object)(++maxMoonID));
        MinecraftForge.EVENT_BUS.post((Event)new MoonRegisterEvent(moon.getName(), maxMoonID));
        return true;
    }

    public static boolean registerSatellite(Satellite satellite) {
        if (satelliteIDs.containsKey((Object)satellite.getName())) {
            return false;
        }
        if (satellite.getParentPlanet() == null) {
            throw new RuntimeException("Registering satellite without a parent!!!");
        }
        satellites.put(satellite.getName(), satellite);
        satelliteIDs.put((Object)satellite.getName(), (Object)(++maxSatelliteID));
        MinecraftForge.EVENT_BUS.post((Event)new SatelliteRegisterEvent(satellite.getName(), maxSatelliteID));
        return true;
    }

    public static Map<String, SolarSystem> getRegisteredSolarSystems() {
        return ImmutableMap.copyOf(solarSystems);
    }

    public static Map<String, Integer> getRegisteredSolarSystemIDs() {
        return ImmutableMap.copyOf(solarSystemIDs);
    }

    public static Map<String, Planet> getRegisteredPlanets() {
        return ImmutableMap.copyOf(planets);
    }

    public static Map<String, Integer> getRegisteredPlanetIDs() {
        return ImmutableMap.copyOf(planetIDs);
    }

    public static Map<String, Moon> getRegisteredMoons() {
        return ImmutableMap.copyOf(moons);
    }

    public static Map<String, Integer> getRegisteredMoonIDs() {
        return ImmutableMap.copyOf(moonIDs);
    }

    public static Map<String, Satellite> getRegisteredSatellites() {
        return ImmutableMap.copyOf(satellites);
    }

    public static Map<String, Integer> getRegisteredSatelliteIDs() {
        return ImmutableMap.copyOf(satelliteIDs);
    }

    public static int getSolarSystemID(String solarSystemName) {
        return (Integer)solarSystemIDs.get((Object)solarSystemName);
    }

    public static int getPlanetID(String planetName) {
        return (Integer)planetIDs.get((Object)planetName);
    }

    public static int getMoonID(String moonName) {
        return (Integer)moonIDs.get((Object)moonName);
    }

    public static int getSatelliteID(String satelliteName) {
        return (Integer)satelliteIDs.get((Object)satelliteName);
    }

    public static class SatelliteRegisterEvent
    extends Event {
        public final String satelliteName;
        public final int satelliteID;

        public SatelliteRegisterEvent(String satelliteName, int satelliteID) {
            this.satelliteName = satelliteName;
            this.satelliteID = satelliteID;
        }
    }

    public static class MoonRegisterEvent
    extends Event {
        public final String moonName;
        public final int moonID;

        public MoonRegisterEvent(String moonName, int moonID) {
            this.moonName = moonName;
            this.moonID = moonID;
        }
    }

    public static class PlanetRegisterEvent
    extends Event {
        public final String planetName;
        public final int planetID;

        public PlanetRegisterEvent(String planetName, int planetID) {
            this.planetName = planetName;
            this.planetID = planetID;
        }
    }

    public static class SolarSystemRegisterEvent
    extends Event {
        public final String solarSystemName;
        public final int solarSystemID;

        public SolarSystemRegisterEvent(String solarSystemName, int solarSystemID) {
            this.solarSystemName = solarSystemName;
            this.solarSystemID = solarSystemID;
        }
    }
}

