/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.world;

import net.minecraft.world.biome.Biome;

public class BiomeData {
    private String biomeName;
    private float baseHeight;
    private float heightVariation;
    private float temperature;
    private float rainfall;
    private int waterColor;
    private boolean enableSnow;
    private boolean enableRain;
    private String baseBiomeRegName;

    public Biome.BiomeProperties toBiomeProperties() {
        Biome.BiomeProperties biomeProperties = new Biome.BiomeProperties(this.biomeName).func_185398_c(this.baseHeight).func_185400_d(this.heightVariation).func_185410_a(this.temperature).func_185395_b(this.rainfall).func_185402_a(this.waterColor).func_185399_a(this.baseBiomeRegName);
        if (!this.enableRain) {
            biomeProperties.func_185396_a();
        }
        if (!this.enableSnow) {
            biomeProperties.func_185411_b();
        }
        return biomeProperties;
    }

    private static float $default$baseHeight() {
        return 0.1f;
    }

    private static float $default$heightVariation() {
        return 0.2f;
    }

    private static float $default$temperature() {
        return 0.5f;
    }

    private static float $default$rainfall() {
        return 0.0f;
    }

    private static int $default$waterColor() {
        return 0xFFFFFF;
    }

    private static boolean $default$enableSnow() {
        return false;
    }

    private static boolean $default$enableRain() {
        return false;
    }

    public static BiomeDataBuilder builder() {
        return new BiomeDataBuilder();
    }

    public String getBiomeName() {
        return this.biomeName;
    }

    public float getBaseHeight() {
        return this.baseHeight;
    }

    public float getHeightVariation() {
        return this.heightVariation;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getRainfall() {
        return this.rainfall;
    }

    public int getWaterColor() {
        return this.waterColor;
    }

    public boolean isEnableSnow() {
        return this.enableSnow;
    }

    public boolean isEnableRain() {
        return this.enableRain;
    }

    public String getBaseBiomeRegName() {
        return this.baseBiomeRegName;
    }

    public void setBiomeName(String biomeName) {
        this.biomeName = biomeName;
    }

    public void setBaseHeight(float baseHeight) {
        this.baseHeight = baseHeight;
    }

    public void setHeightVariation(float heightVariation) {
        this.heightVariation = heightVariation;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public void setRainfall(float rainfall) {
        this.rainfall = rainfall;
    }

    public void setWaterColor(int waterColor) {
        this.waterColor = waterColor;
    }

    public void setEnableSnow(boolean enableSnow) {
        this.enableSnow = enableSnow;
    }

    public void setEnableRain(boolean enableRain) {
        this.enableRain = enableRain;
    }

    public void setBaseBiomeRegName(String baseBiomeRegName) {
        this.baseBiomeRegName = baseBiomeRegName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BiomeData)) {
            return false;
        }
        BiomeData other = (BiomeData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getBaseHeight(), other.getBaseHeight()) != 0) {
            return false;
        }
        if (Float.compare(this.getHeightVariation(), other.getHeightVariation()) != 0) {
            return false;
        }
        if (Float.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (Float.compare(this.getRainfall(), other.getRainfall()) != 0) {
            return false;
        }
        if (this.getWaterColor() != other.getWaterColor()) {
            return false;
        }
        if (this.isEnableSnow() != other.isEnableSnow()) {
            return false;
        }
        if (this.isEnableRain() != other.isEnableRain()) {
            return false;
        }
        String this$biomeName = this.getBiomeName();
        String other$biomeName = other.getBiomeName();
        if (this$biomeName == null ? other$biomeName != null : !this$biomeName.equals(other$biomeName)) {
            return false;
        }
        String this$baseBiomeRegName = this.getBaseBiomeRegName();
        String other$baseBiomeRegName = other.getBaseBiomeRegName();
        return !(this$baseBiomeRegName == null ? other$baseBiomeRegName != null : !this$baseBiomeRegName.equals(other$baseBiomeRegName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BiomeData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getBaseHeight());
        result = result * 59 + Float.floatToIntBits(this.getHeightVariation());
        result = result * 59 + Float.floatToIntBits(this.getTemperature());
        result = result * 59 + Float.floatToIntBits(this.getRainfall());
        result = result * 59 + this.getWaterColor();
        result = result * 59 + (this.isEnableSnow() ? 79 : 97);
        result = result * 59 + (this.isEnableRain() ? 79 : 97);
        String $biomeName = this.getBiomeName();
        result = result * 59 + ($biomeName == null ? 43 : $biomeName.hashCode());
        String $baseBiomeRegName = this.getBaseBiomeRegName();
        result = result * 59 + ($baseBiomeRegName == null ? 43 : $baseBiomeRegName.hashCode());
        return result;
    }

    public String toString() {
        return "BiomeData(biomeName=" + this.getBiomeName() + ", baseHeight=" + this.getBaseHeight() + ", heightVariation=" + this.getHeightVariation() + ", temperature=" + this.getTemperature() + ", rainfall=" + this.getRainfall() + ", waterColor=" + this.getWaterColor() + ", enableSnow=" + this.isEnableSnow() + ", enableRain=" + this.isEnableRain() + ", baseBiomeRegName=" + this.getBaseBiomeRegName() + ")";
    }

    public BiomeData() {
        this.baseHeight = BiomeData.$default$baseHeight();
        this.heightVariation = BiomeData.$default$heightVariation();
        this.temperature = BiomeData.$default$temperature();
        this.rainfall = BiomeData.$default$rainfall();
        this.waterColor = BiomeData.$default$waterColor();
        this.enableSnow = BiomeData.$default$enableSnow();
        this.enableRain = BiomeData.$default$enableRain();
    }

    public BiomeData(String biomeName, float baseHeight, float heightVariation, float temperature, float rainfall, int waterColor, boolean enableSnow, boolean enableRain, String baseBiomeRegName) {
        this.biomeName = biomeName;
        this.baseHeight = baseHeight;
        this.heightVariation = heightVariation;
        this.temperature = temperature;
        this.rainfall = rainfall;
        this.waterColor = waterColor;
        this.enableSnow = enableSnow;
        this.enableRain = enableRain;
        this.baseBiomeRegName = baseBiomeRegName;
    }

    public static class BiomeDataBuilder {
        private String biomeName;
        private boolean baseHeight$set;
        private float baseHeight$value;
        private boolean heightVariation$set;
        private float heightVariation$value;
        private boolean temperature$set;
        private float temperature$value;
        private boolean rainfall$set;
        private float rainfall$value;
        private boolean waterColor$set;
        private int waterColor$value;
        private boolean enableSnow$set;
        private boolean enableSnow$value;
        private boolean enableRain$set;
        private boolean enableRain$value;
        private String baseBiomeRegName;

        BiomeDataBuilder() {
        }

        public BiomeDataBuilder biomeName(String biomeName) {
            this.biomeName = biomeName;
            return this;
        }

        public BiomeDataBuilder baseHeight(float baseHeight) {
            this.baseHeight$value = baseHeight;
            this.baseHeight$set = true;
            return this;
        }

        public BiomeDataBuilder heightVariation(float heightVariation) {
            this.heightVariation$value = heightVariation;
            this.heightVariation$set = true;
            return this;
        }

        public BiomeDataBuilder temperature(float temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        public BiomeDataBuilder rainfall(float rainfall) {
            this.rainfall$value = rainfall;
            this.rainfall$set = true;
            return this;
        }

        public BiomeDataBuilder waterColor(int waterColor) {
            this.waterColor$value = waterColor;
            this.waterColor$set = true;
            return this;
        }

        public BiomeDataBuilder enableSnow(boolean enableSnow) {
            this.enableSnow$value = enableSnow;
            this.enableSnow$set = true;
            return this;
        }

        public BiomeDataBuilder enableRain(boolean enableRain) {
            this.enableRain$value = enableRain;
            this.enableRain$set = true;
            return this;
        }

        public BiomeDataBuilder baseBiomeRegName(String baseBiomeRegName) {
            this.baseBiomeRegName = baseBiomeRegName;
            return this;
        }

        public BiomeData build() {
            float baseHeight$value = this.baseHeight$value;
            if (!this.baseHeight$set) {
                baseHeight$value = BiomeData.$default$baseHeight();
            }
            float heightVariation$value = this.heightVariation$value;
            if (!this.heightVariation$set) {
                heightVariation$value = BiomeData.$default$heightVariation();
            }
            float temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = BiomeData.$default$temperature();
            }
            float rainfall$value = this.rainfall$value;
            if (!this.rainfall$set) {
                rainfall$value = BiomeData.$default$rainfall();
            }
            int waterColor$value = this.waterColor$value;
            if (!this.waterColor$set) {
                waterColor$value = BiomeData.$default$waterColor();
            }
            boolean enableSnow$value = this.enableSnow$value;
            if (!this.enableSnow$set) {
                enableSnow$value = BiomeData.$default$enableSnow();
            }
            boolean enableRain$value = this.enableRain$value;
            if (!this.enableRain$set) {
                enableRain$value = BiomeData.$default$enableRain();
            }
            return new BiomeData(this.biomeName, baseHeight$value, heightVariation$value, temperature$value, rainfall$value, waterColor$value, enableSnow$value, enableRain$value, this.baseBiomeRegName);
        }

        public String toString() {
            return "BiomeData.BiomeDataBuilder(biomeName=" + this.biomeName + ", baseHeight$value=" + this.baseHeight$value + ", heightVariation$value=" + this.heightVariation$value + ", temperature$value=" + this.temperature$value + ", rainfall$value=" + this.rainfall$value + ", waterColor$value=" + this.waterColor$value + ", enableSnow$value=" + this.enableSnow$value + ", enableRain$value=" + this.enableRain$value + ", baseBiomeRegName=" + this.baseBiomeRegName + ")";
        }
    }
}

