/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.ITelemetry;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTelemetry
extends TileEntity
implements ITickable {
    public Class<?> clientClass;
    public int[] clientData = new int[]{-1};
    public String clientName;
    public GameProfile clientGameProfile = null;
    public static HashSet<BlockVec3Dim> loadedList = new HashSet();
    public Entity linkedEntity;
    private UUID toUpdate = null;
    private int pulseRate = 400;
    private int lastHurttime = 0;
    private int ticks = 0;

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            loadedList.add(new BlockVec3Dim(this));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            loadedList.remove(new BlockVec3Dim(this));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && ++this.ticks % 2 == 0) {
            if (this.toUpdate != null) {
                this.addTrackedEntity(this.toUpdate);
                this.toUpdate = null;
            }
            String name = null;
            int[] data = new int[]{-1, -1, -1, -1, -1};
            String strUUID = "";
            if (this.linkedEntity != null) {
                if (this.linkedEntity.field_70128_L) {
                    this.linkedEntity = null;
                    name = "";
                } else {
                    if (this.linkedEntity instanceof EntityPlayerMP) {
                        name = "$" + this.linkedEntity.func_70005_c_();
                    } else {
                        EntityEntry entityEntry = EntityRegistry.getEntry(this.linkedEntity.getClass());
                        if (entityEntry != null && entityEntry.getRegistryName() != null) {
                            name = entityEntry.getRegistryName().toString();
                        }
                    }
                    if (name == null) {
                        GalacticraftCore.logger.info("Telemetry Unit: Error finding name for " + this.linkedEntity.getClass().getSimpleName(), new Object[0]);
                        name = "";
                    }
                    double xmotion = this.linkedEntity.field_70159_w;
                    double ymotion = this.linkedEntity instanceof EntityLivingBase ? this.linkedEntity.field_70181_x + 0.078 : this.linkedEntity.field_70181_x;
                    double zmotion = this.linkedEntity.field_70179_y;
                    data[2] = (int)((double)MathHelper.func_76133_a((double)(xmotion * xmotion + ymotion * ymotion + zmotion * zmotion)) * 2000.0);
                    if (this.linkedEntity instanceof ITelemetry) {
                        ((ITelemetry)this.linkedEntity).transmitData(data);
                    } else if (this.linkedEntity instanceof EntityLivingBase) {
                        EntityLivingBase eLiving = (EntityLivingBase)this.linkedEntity;
                        data[0] = eLiving.field_70737_aN;
                        --this.pulseRate;
                        if (eLiving.field_70737_aN > this.lastHurttime) {
                            this.pulseRate += 100;
                        }
                        this.lastHurttime = eLiving.field_70737_aN;
                        if (eLiving.func_184187_bx() != null) {
                            data[2] = data[2] / 4;
                        } else if (data[2] > 1) {
                            this.pulseRate += 2;
                        }
                        this.pulseRate += Math.max(data[2] - this.pulseRate, 0) / 4;
                        if (this.pulseRate > 2000) {
                            this.pulseRate = 2000;
                        }
                        if (this.pulseRate < 400) {
                            this.pulseRate = 400;
                        }
                        data[2] = this.pulseRate / 10;
                        data[1] = (int)(eLiving.func_110143_aJ() * 100.0f / eLiving.func_110138_aP());
                        if (eLiving instanceof EntityPlayerMP) {
                            data[3] = ((EntityPlayerMP)eLiving).func_71024_bL().func_75116_a() * 5;
                            GCPlayerStats stats = GCPlayerStats.get((Entity)eLiving);
                            data[4] = stats.getAirRemaining() * 4096 + stats.getAirRemaining2();
                            UUID uuid = ((EntityPlayerMP)eLiving).func_110124_au();
                            if (uuid != null) {
                                strUUID = uuid.toString();
                            }
                        } else if (eLiving instanceof EntityHorse) {
                            data[4] = ((EntityHorse)eLiving).func_110202_bQ();
                        } else if (eLiving instanceof EntityVillager) {
                            data[3] = ((EntityVillager)eLiving).func_70946_n();
                            data[4] = ((EntityVillager)eLiving).func_70874_b();
                        } else if (eLiving instanceof EntityWolf) {
                            data[3] = ((EntityWolf)eLiving).func_175546_cu().func_176767_b();
                            data[4] = ((EntityWolf)eLiving).func_70922_bv() ? 1 : 0;
                        } else if (eLiving instanceof EntitySheep) {
                            data[3] = ((EntitySheep)eLiving).func_175509_cj().func_176767_b();
                            data[4] = ((EntitySheep)eLiving).func_70892_o() ? 1 : 0;
                        } else if (eLiving instanceof EntityOcelot) {
                            data[3] = ((EntityOcelot)eLiving).func_70913_u();
                        } else if (!(eLiving instanceof EntitySkeleton) && eLiving instanceof EntityZombie) {
                            data[4] = ((EntityZombie)eLiving).func_70631_g_() ? 1 : 0;
                        }
                    }
                }
            } else {
                name = "";
            }
            GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_TELEMETRY, this.field_145850_b.field_73011_w.getDimension(), new Object[]{this.func_174877_v(), name, data[0], data[1], data[2], data[3], data[4], strUUID}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 320.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void receiveUpdate(List<Object> data, int dimID) {
        String name = (String)data.get(1);
        if (name.startsWith("$")) {
            String strName;
            this.clientClass = EntityPlayerMP.class;
            this.clientName = strName = name.substring(1);
            this.clientGameProfile = PlayerUtil.getSkinForName(strName, (String)data.get(7), dimID);
        } else {
            EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(name));
            this.clientClass = entityEntry == null ? null : entityEntry.getEntityClass();
        }
        this.clientData = new int[5];
        for (int i = 2; i < 7; ++i) {
            this.clientData[i - 2] = (Integer)data.get(i);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        Long msb = nbt.func_74763_f("entityUUIDMost");
        Long lsb = nbt.func_74763_f("entityUUIDLeast");
        this.toUpdate = new UUID(msb, lsb);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.linkedEntity != null && !this.linkedEntity.field_70128_L) {
            nbt.func_74772_a("entityUUIDMost", this.linkedEntity.func_110124_au().getMostSignificantBits());
            nbt.func_74772_a("entityUUIDLeast", this.linkedEntity.func_110124_au().getLeastSignificantBits());
        }
        return nbt;
    }

    public void addTrackedEntity(UUID uuid) {
        this.pulseRate = 400;
        this.lastHurttime = 0;
        List eList = this.field_145850_b.field_72996_f;
        for (Entity e : eList) {
            if (!e.func_110124_au().equals(uuid)) continue;
            this.linkedEntity = e;
            if (e instanceof EntitySpaceshipBase) {
                ((EntitySpaceshipBase)e).addTelemetry(this);
            }
            return;
        }
        this.linkedEntity = null;
    }

    public void addTrackedEntity(Entity e) {
        this.pulseRate = 400;
        this.lastHurttime = 0;
        this.linkedEntity = e;
        if (e instanceof EntitySpaceshipBase) {
            ((EntitySpaceshipBase)e).addTelemetry(this);
        }
    }

    public void removeTrackedEntity() {
        this.pulseRate = 400;
        this.linkedEntity = null;
    }

    public static TileEntityTelemetry getNearest(TileEntity te) {
        if (te == null) {
            return null;
        }
        BlockVec3 target = new BlockVec3(te);
        int distSq = 1025;
        BlockVec3Dim nearest = null;
        int dim = GCCoreUtil.getDimensionID(te.func_145831_w());
        for (BlockVec3Dim telemeter : loadedList) {
            int dist;
            if (telemeter.dim != dim || (dist = telemeter.distanceSquared(target)) >= distSq) continue;
            distSq = dist;
            nearest = telemeter;
        }
        if (nearest == null) {
            return null;
        }
        TileEntity result = te.func_145831_w().func_175625_s(new BlockPos(nearest.x, nearest.y, nearest.z));
        if (result instanceof TileEntityTelemetry) {
            return (TileEntityTelemetry)result;
        }
        return null;
    }

    public static void frequencyModulePlayer(ItemStack held, EntityPlayerMP player, boolean remove) {
        if (held == null) {
            return;
        }
        NBTTagCompound fmData = held.func_77978_p();
        if (fmData != null && fmData.func_74764_b("teDim")) {
            int dim = fmData.func_74762_e("teDim");
            int x = fmData.func_74762_e("teCoordX");
            int y = fmData.func_74762_e("teCoordY");
            int z = fmData.func_74762_e("teCoordZ");
            WorldProvider wp = WorldUtil.getProviderForDimensionServer(dim);
            if (wp == null || wp.field_76579_a == null) {
                GalacticraftCore.logger.debug("Frequency module worn: world provider is null.  This is a bug. " + dim, new Object[0]);
            } else {
                TileEntity te = wp.field_76579_a.func_175625_s(new BlockPos(x, y, z));
                if (te instanceof TileEntityTelemetry) {
                    if (remove) {
                        if (((TileEntityTelemetry)te).linkedEntity == player) {
                            ((TileEntityTelemetry)te).removeTrackedEntity();
                        }
                    } else {
                        ((TileEntityTelemetry)te).addTrackedEntity(player.func_110124_au());
                    }
                }
            }
        }
    }

    public static void updateLinkedPlayer(EntityPlayerMP playerOld, EntityPlayerMP playerNew) {
        for (BlockVec3Dim telemeter : loadedList) {
            TileEntity te = telemeter.getTileEntityNoLoad();
            if (!(te instanceof TileEntityTelemetry) || ((TileEntityTelemetry)te).linkedEntity != playerOld) continue;
            ((TileEntityTelemetry)te).linkedEntity = playerNew;
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

