/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import com.google.common.primitives.Ints;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import micdoodle8.mods.galacticraft.api.vector.BlockTuple;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.recipe.RecipeManagerGC;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerClient;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConfigManagerCore {
    static Configuration config;
    public static boolean forceOverworldRespawn;
    public static boolean hardMode;
    public static boolean quickMode;
    public static boolean challengeMode;
    private static int challengeFlags;
    public static boolean challengeRecipes;
    public static boolean challengeMobDropsAndSpawning;
    public static boolean challengeSpawnHandling;
    public static boolean challengeAsteroidPopulation;
    public static boolean disableRocketsToOverworld;
    public static boolean disableSpaceStationCreation;
    public static boolean spaceStationsRequirePermission;
    public static boolean disableUpdateCheck;
    public static boolean enableSpaceRaceManagerPopup;
    public static boolean enableDebug;
    public static boolean enableSealerEdgeChecks;
    public static boolean disableLander;
    public static boolean recipesRequireGCAdvancedMetals;
    public static boolean allowLiquidGratings;
    public static int idDimensionOverworld;
    public static int idDimensionOverworldOrbit;
    public static int idDimensionOverworldOrbitStatic;
    public static int idDimensionMoon;
    public static int biomeIDbase;
    public static boolean disableBiomeTypeRegistrations;
    public static int[] staticLoadDimensions;
    public static int[] disableRocketLaunchDimensions;
    public static boolean disableRocketLaunchAllNonGC;
    public static int otherPlanetWorldBorders;
    public static boolean keepLoadedNewSpaceStations;
    public static int idSchematicRocketT1;
    public static int idSchematicMoonBuggy;
    public static int idSchematicAddSchematic;
    public static int idAchievBase;
    public static boolean moreStars;
    public static boolean disableSpaceshipParticles;
    public static boolean disableVehicleCameraChanges;
    public static boolean oxygenIndicatorLeft;
    public static boolean oxygenIndicatorBottom;
    public static boolean overrideCapes;
    public static boolean disableRocketIconRotation;
    public static double dungeonBossHealthMod;
    public static int suffocationCooldown;
    public static int suffocationDamage;
    public static int rocketFuelFactor;
    public static double meteorSpawnMod;
    public static boolean meteorBlockDamageEnabled;
    public static boolean disableSpaceshipGrief;
    public static double spaceStationEnergyScalar;
    public static boolean enableCopperOreGen;
    public static boolean enableTinOreGen;
    public static boolean enableAluminumOreGen;
    public static boolean enableSiliconOreGen;
    public static boolean disableCheeseMoon;
    public static boolean disableTinMoon;
    public static boolean disableCopperMoon;
    public static boolean disableMoonVillageGen;
    public static boolean disableSapphireMoon;
    public static int[] externalOilGen;
    public static double oilGenFactor;
    public static boolean retrogenOil;
    public static String[] oregenIDs;
    public static boolean enableOtherModsFeatures;
    public static boolean whitelistCoFHCoreGen;
    public static boolean enableThaumCraftNodes;
    public static String[] sealableIDs;
    public static String[] detectableIDs;
    public static boolean alternateCanisterRecipe;
    public static String otherModsSilicon;
    public static boolean useOldOilFluidID;
    public static boolean useOldFuelFluidID;
    public static String keyOverrideMap;
    public static String keyOverrideFuelLevel;
    public static String keyOverrideToggleAdvGoggles;
    public static int keyOverrideMapI;
    public static int keyOverrideFuelLevelI;
    public static int keyOverrideToggleAdvGogglesI;
    public static float mapMouseScrollSensitivity;
    public static boolean invertMapMouseScroll;
    public static ArrayList<Object> clientSave;
    private static Map<String, List<String>> propOrder;
    private static String currentCat;

    public static void initialize(File file) {
        config = new Configuration(file);
        ConfigManagerCore.syncConfig(true);
    }

    public static void forceSave() {
        config.save();
    }

    public static void syncConfig(boolean load) {
        try {
            propOrder.clear();
            if (!ConfigManagerCore.config.isChild && load) {
                config.load();
            }
            Property prop = ConfigManagerCore.getConfig("general", "Enable Debug Messages", false);
            prop.setComment("If this is enabled, debug messages will appear in the console. This is useful for finding bugs in the mod.");
            prop.setLanguageKey("gc.configgui.enable_debug");
            enableDebug = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("dimensions", "idDimensionOverworld", 0);
            prop.setComment("Dimension ID for the Overworld (as seen in the Celestial Map)");
            prop.setLanguageKey("gc.configgui.id_dimension_overworld").setRequiresMcRestart(true);
            idDimensionOverworld = prop.getInt();
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("dimensions", "idDimensionMoon", -28);
            prop.setComment("Dimension ID for the Moon");
            prop.setLanguageKey("gc.configgui.id_dimension_moon").setRequiresMcRestart(true);
            idDimensionMoon = prop.getInt();
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("dimensions", "idDimensionOverworldOrbit", -27);
            prop.setComment("WorldProvider ID for Overworld Space Stations (advanced: do not change unless you have conflicts)");
            prop.setLanguageKey("gc.configgui.id_dimension_overworld_orbit").setRequiresMcRestart(true);
            idDimensionOverworldOrbit = prop.getInt();
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("dimensions", "idDimensionOverworldOrbitStatic", -26);
            prop.setComment("WorldProvider ID for Static Space Stations (advanced: do not change unless you have conflicts)");
            prop.setLanguageKey("gc.configgui.id_dimension_overworld_orbit_static").setRequiresMcRestart(true);
            idDimensionOverworldOrbitStatic = prop.getInt();
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("dimensions", "biomeIDBase", 102);
            prop.setComment("Biome ID base. GC will use biome IDs from this to this + 3, or more with addons. Allowed 40-250. Default 102.");
            prop.setLanguageKey("gc.configgui.biome_id_base").setRequiresMcRestart(true);
            biomeIDbase = prop.getInt();
            if (biomeIDbase < 40 || biomeIDbase > 250) {
                biomeIDbase = 102;
            }
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("dimensions", "Static Loaded Dimensions", staticLoadDimensions);
            prop.setComment("IDs to load at startup, and keep loaded until server stops. Can be added via /gckeeploaded");
            prop.setLanguageKey("gc.configgui.static_loaded_dimensions");
            staticLoadDimensions = prop.getIntList();
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("dimensions", "Set new Space Stations to be static loaded", true);
            prop.setComment("Set this to true to have an automatic /gckeeploaded for any new Space Station created.");
            prop.setLanguageKey("gc.configgui.static_loaded_new_ss");
            keepLoadedNewSpaceStations = prop.getBoolean();
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("dimensions", "Dimensions where rockets cannot launch", new String[]{"1", "-1"});
            prop.setComment("IDs of dimensions where rockets should not launch - this should always include the Nether.");
            prop.setLanguageKey("gc.configgui.rocket_disabled_dimensions");
            disableRocketLaunchDimensions = prop.getIntList();
            disableRocketLaunchAllNonGC = ConfigManagerCore.searchAsterisk(prop.getStringList());
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("dimensions", "Disable rockets from returning to Overworld", false);
            prop.setComment("If true, rockets will be unable to reach the Overworld (only use this in special modpacks!)");
            prop.setLanguageKey("gc.configgui.rocket_disable_overworld_return");
            disableRocketsToOverworld = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("server", "World border for landing location on other planets (Moon, Mars, etc)", 0);
            prop.setComment("Set this to 0 for no borders (default).  If set to e.g. 2000, players will land on the Moon inside the x,z range -2000 to 2000.)");
            prop.setLanguageKey("gc.configgui.planet_worldborders");
            otherPlanetWorldBorders = prop.getInt(0);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("general", "Force Overworld Spawn", false);
            prop.setComment("By default, you will respawn on Galacticraft dimensions if you die. If you are dying over and over on a planet, set this to true, and you will respawn back on the Overworld.");
            prop.setLanguageKey("gc.configgui.force_overworld_respawn");
            forceOverworldRespawn = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("schematic", "idSchematicRocketT1", 0);
            prop.setComment("Schematic ID for Tier 1 Rocket, must be unique.");
            prop.setLanguageKey("gc.configgui.id_schematic_rocket_t1");
            idSchematicRocketT1 = prop.getInt(0);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("schematic", "idSchematicMoonBuggy", 1);
            prop.setComment("Schematic ID for Moon Buggy, must be unique.");
            prop.setLanguageKey("gc.configgui.id_schematic_moon_buggy");
            idSchematicMoonBuggy = prop.getInt(1);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("schematic", "idSchematicAddSchematic", Integer.MAX_VALUE);
            prop.setComment("Schematic ID for \"Add Schematic\" Page, must be unique");
            prop.setLanguageKey("gc.configgui.id_schematic_add_schematic");
            idSchematicAddSchematic = prop.getInt(Integer.MAX_VALUE);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("achievements", "idAchievBase", 1784);
            prop.setComment("Base Achievement ID. All achievement IDs will start at this number.");
            prop.setLanguageKey("gc.configgui.id_achiev_base");
            idAchievBase = prop.getInt(1784);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("client", "More Stars", true);
            prop.setComment("Setting this to false will revert night skies back to default minecraft star count");
            prop.setLanguageKey("gc.configgui.more_stars");
            moreStars = prop.getBoolean(true);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("client", "Disable Spaceship Particles", false);
            prop.setComment("If you have FPS problems, setting this to true will help if rocket particles are in your sights");
            prop.setLanguageKey("gc.configgui.disable_spaceship_particles");
            disableSpaceshipParticles = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("client", "Disable Vehicle Third-Person and Zoom", false);
            prop.setComment("If you're using this mod in virtual reality, or if you don't want the camera changes when entering a Galacticraft vehicle, set this to true.");
            prop.setLanguageKey("gc.configgui.disable_vehicle_camera_changes");
            disableVehicleCameraChanges = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("client", "Minimap Left", false);
            prop.setComment("If true, this will move the Oxygen Indicator to the left side. You can combine this with \"Minimap Bottom\"");
            prop.setLanguageKey("gc.configgui.oxygen_indicator_left");
            oxygenIndicatorLeft = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("client", "Minimap Bottom", false);
            prop.setComment("If true, this will move the Oxygen Indicator to the bottom. You can combine this with \"Minimap Left\"");
            prop.setLanguageKey("gc.configgui.oxygen_indicator_bottom");
            oxygenIndicatorBottom = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("client", "Disable Rocket Icon Rotation", false);
            prop.setComment("If you have FPS problems, setting this to true will disable GC Rocket icons from rotating in GUI's");
            prop.setLanguageKey("gc.configgui.disable_rocket_icon_rotation");
            disableRocketIconRotation = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Oil Generation Factor", 1.8);
            prop.setComment("Increasing this will increase amount of oil that will generate in each chunk.");
            prop.setLanguageKey("gc.configgui.oil_gen_factor");
            oilGenFactor = prop.getDouble(1.8);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Oil gen in external dimensions", new int[]{0});
            prop.setComment("List of non-galacticraft dimension IDs to generate oil in.");
            prop.setLanguageKey("gc.configgui.external_oil_gen");
            externalOilGen = prop.getIntList();
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Retro Gen of GC Oil in existing map chunks", false);
            prop.setComment("If this is enabled, GC oil will be added to existing Overworld maps where possible.");
            prop.setLanguageKey("gc.configgui.enable_retrogen_oil");
            retrogenOil = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Enable Copper Ore Gen", true);
            prop.setComment("If this is enabled, copper ore will generate on the overworld.");
            prop.setLanguageKey("gc.configgui.enable_copper_ore_gen").setRequiresMcRestart(true);
            enableCopperOreGen = prop.getBoolean(true);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Enable Tin Ore Gen", true);
            prop.setComment("If this is enabled, tin ore will generate on the overworld.");
            prop.setLanguageKey("gc.configgui.enable_tin_ore_gen").setRequiresMcRestart(true);
            enableTinOreGen = prop.getBoolean(true);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Enable Aluminum Ore Gen", true);
            prop.setComment("If this is enabled, aluminum ore will generate on the overworld.");
            prop.setLanguageKey("gc.configgui.enable_aluminum_ore_gen").setRequiresMcRestart(true);
            enableAluminumOreGen = prop.getBoolean(true);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Enable Silicon Ore Gen", true);
            prop.setComment("If this is enabled, silicon ore will generate on the overworld.");
            prop.setLanguageKey("gc.configgui.enable_silicon_ore_gen").setRequiresMcRestart(true);
            enableSiliconOreGen = prop.getBoolean(true);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Disable Cheese Ore Gen on Moon", false);
            prop.setComment("Disable Cheese Ore Gen on Moon.");
            prop.setLanguageKey("gc.configgui.disable_cheese_moon");
            disableCheeseMoon = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Disable Tin Ore Gen on Moon", false);
            prop.setComment("Disable Tin Ore Gen on Moon.");
            prop.setLanguageKey("gc.configgui.disable_tin_moon");
            disableTinMoon = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Disable Copper Ore Gen on Moon", false);
            prop.setComment("Disable Copper Ore Gen on Moon.");
            prop.setLanguageKey("gc.configgui.disable_copper_moon");
            disableCopperMoon = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Disable Sapphire Ore Gen on Moon", false);
            prop.setComment("Disable Sapphire Ore Gen on Moon.");
            prop.setLanguageKey("gc.configgui.disable_sapphire_moon");
            disableSapphireMoon = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Disable Moon Village Gen", false);
            prop.setComment("If true, moon villages will not generate.");
            prop.setLanguageKey("gc.configgui.disable_moon_village_gen");
            disableMoonVillageGen = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Generate all other mods features on planets", false);
            prop.setComment("If this is enabled, other mods' standard ores and all other features (eg. plants) can generate on the Moon and planets. Apart from looking wrong, this make cause 'Already Decorating!' type crashes.  NOT RECOMMENDED!  See Wiki.");
            prop.setLanguageKey("gc.configgui.enable_other_mods_features");
            enableOtherModsFeatures = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Whitelist CoFHCore worldgen to generate its ores and lakes on planets", false);
            prop.setComment("If generate other mods features is disabled as recommended, this setting can whitelist CoFHCore custom worldgen on planets.");
            prop.setLanguageKey("gc.configgui.whitelist_co_f_h_core_gen");
            whitelistCoFHCoreGen = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Generate ThaumCraft wild nodes on planetary surfaces", true);
            prop.setComment("If ThaumCraft is installed, ThaumCraft wild nodes can generate on the Moon and planets.");
            prop.setLanguageKey("gc.configgui.enable_thaum_craft_nodes");
            enableThaumCraftNodes = prop.getBoolean(true);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Other mods ores for GC to generate on the Moon and planets", new String[0]);
            prop.setComment("Enter IDs of other mods' ores here for Galacticraft to generate them on the Moon and other planets. Format is BlockName or BlockName:metadata. Use optional parameters at end of each line: /RARE /UNCOMMON or /COMMON for rarity in a chunk; /DEEP /SHALLOW or /BOTH for height; /SINGLE /STANDARD or /LARGE for clump size; /XTRARANDOM for ores sometimes there sometimes not at all.  /ONLYMOON or /ONLYMARS if wanted on one planet only.  If nothing specified, defaults are /COMMON, /BOTH and /STANDARD.  Repeat lines to generate a huge quantity of ores.");
            prop.setLanguageKey("gc.configgui.other_mod_ore_gen_i_ds");
            oregenIDs = prop.getStringList();
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("compatibility", "Use legacy oilgc fluid registration", false);
            prop.setComment("Set to true to make Galacticraft oil register as oilgc, for backwards compatibility with previously generated worlds.");
            prop.setLanguageKey("gc.configgui.use_old_oil_fluid_i_d");
            useOldOilFluidID = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("compatibility", "Use legacy fuelgc fluid registration", false);
            prop.setComment("Set to true to make Galacticraft fuel register as fuelgc, for backwards compatibility with previously generated worlds.");
            prop.setLanguageKey("gc.configgui.use_old_fuel_fluid_i_d");
            useOldFuelFluidID = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("general", "Disable lander on Moon and other planets", false);
            prop.setComment("If this is true, the player will parachute onto the Moon instead - use only in debug situations.");
            prop.setLanguageKey("gc.configgui.disable_lander");
            disableLander = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("difficulty", "Disable Spaceship Explosion", false);
            prop.setComment("Spaceships will not explode on contact if set to true.");
            prop.setLanguageKey("gc.configgui.disable_spaceship_grief");
            disableSpaceshipGrief = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("server", "Space Stations Require Permission", true);
            prop.setComment("While true, space stations require you to invite other players using /ssinvite <playername>");
            prop.setLanguageKey("gc.configgui.space_stations_require_permission");
            spaceStationsRequirePermission = prop.getBoolean(true);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("server", "Disable Space Station creation", false);
            prop.setComment("If set to true on a server, players will be completely unable to create space stations.");
            prop.setLanguageKey("gc.configgui.disable_space_station_creation");
            disableSpaceStationCreation = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("client", "Override Capes", true);
            prop.setComment("By default, Galacticraft will override capes with the mod's donor cape. Set to false to disable.");
            prop.setLanguageKey("gc.configgui.override_capes");
            overrideCapes = prop.getBoolean(true);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("difficulty", "Space Station Solar Energy Multiplier", 2.0);
            prop.setComment("Solar panels will work (default 2x) more effective on space stations.");
            prop.setLanguageKey("gc.configgui.space_station_energy_scalar");
            spaceStationEnergyScalar = prop.getDouble(2.0);
            ConfigManagerCore.finishProp(prop);
            try {
                prop = ConfigManagerCore.getConfig("compatibility", "External Sealable IDs", new String[]{Block.field_149771_c.func_177774_c((Object)Blocks.field_150410_aZ) + ":0"});
                prop.setComment("List non-opaque blocks from other mods (for example, special types of glass) that the Oxygen Sealer should recognize as solid seals. Format is BlockName or BlockName:metadata");
                prop.setLanguageKey("gc.configgui.sealable_i_ds").setRequiresMcRestart(true);
                sealableIDs = prop.getStringList();
                ConfigManagerCore.finishProp(prop);
            }
            catch (Exception e) {
                GalacticraftCore.logger.error("[Galacticraft] It appears you have installed the 'Dev' version of Galacticraft instead of the regular version (or vice versa).  Please re-install.", new Object[0]);
            }
            prop = ConfigManagerCore.getConfig("compatibility", "External Detectable IDs", new String[]{((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150365_q)).func_110623_a(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150482_ag)).func_110623_a(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150352_o)).func_110623_a(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150366_p)).func_110623_a(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150369_x)).func_110623_a(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150450_ax)).func_110623_a(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150439_ay)).func_110623_a()});
            prop.setComment("List blocks from other mods that the Sensor Glasses should recognize as solid blocks. Format is BlockName or BlockName:metadata.");
            prop.setLanguageKey("gc.configgui.detectable_i_ds").setRequiresMcRestart(true);
            detectableIDs = prop.getStringList();
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("difficulty", "Quick Game Mode", false);
            prop.setComment("Set this to true for less metal use in Galacticraft recipes (makes the game easier).");
            prop.setLanguageKey("gc.configgui.quick_mode");
            quickMode = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("difficulty", "Harder Difficulty", false);
            prop.setComment("Set this to true for increased difficulty in modpacks (see forum for more info).");
            prop.setLanguageKey("gc.configgui.hard_mode");
            hardMode = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("difficulty", "Adventure Game Mode", false);
            prop.setComment("Set this to true for a challenging adventure where the player starts the game stranded in the Asteroids dimension with low resources (only effective if Galacticraft Planets installed).");
            prop.setLanguageKey("gc.configgui.asteroids_start");
            challengeMode = prop.getBoolean(false);
            if (!GalacticraftCore.isPlanetsLoaded) {
                challengeMode = false;
            }
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("difficulty", "Adventure Game Mode Flags", 15);
            prop.setComment("Add together flags 8, 4, 2, 1 to enable the four elements of adventure game mode. Default 15.  1 = extended compressor recipes.  2 = mob drops and spawning.  4 = more trees in hollow asteroids.  8 = start stranded in Asteroids.");
            prop.setLanguageKey("gc.configgui.asteroids_flags");
            challengeFlags = prop.getInt(15);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("difficulty", "Suffocation Cooldown", 100);
            prop.setComment("Lower/Raise this value to change time between suffocation damage ticks (allowed range 50-250)");
            prop.setLanguageKey("gc.configgui.suffocation_cooldown");
            suffocationCooldown = Math.min(Math.max(50, prop.getInt(100)), 250);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("difficulty", "Suffocation Damage", 2);
            prop.setComment("Change this value to modify the damage taken per suffocation tick");
            prop.setLanguageKey("gc.configgui.suffocation_damage");
            suffocationDamage = prop.getInt(2);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("difficulty", "Dungeon Boss Health Modifier", 1.0);
            prop.setComment("Change this if you wish to balance the mod (if you have more powerful weapon mods).");
            prop.setLanguageKey("gc.configgui.dungeon_boss_health_mod");
            dungeonBossHealthMod = prop.getDouble(1.0);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("server", "Enable Sealed edge checks", true);
            prop.setComment("If this is enabled, areas sealed by Oxygen Sealers will run a seal check when the player breaks or places a block (or on block updates).  This should be enabled for a 100% accurate sealed status, but can be disabled on servers for performance reasons.");
            prop.setLanguageKey("gc.configgui.enable_sealer_edge_checks");
            enableSealerEdgeChecks = prop.getBoolean(true);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("compatibility", "Alternate recipe for canisters", false);
            prop.setComment("Enable this if the standard canister recipe causes a conflict.");
            prop.setLanguageKey("gc.configgui.alternate_canister_recipe").setRequiresMcRestart(true);
            alternateCanisterRecipe = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("compatibility", "OreDict name of other mod's silicon", "itemSilicon");
            prop.setComment("This needs to match the OreDictionary name used in the other mod. Set a nonsense name to disable.");
            prop.setLanguageKey("gc.configgui.ore_dict_silicon");
            otherModsSilicon = prop.getString();
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("compatibility", "Must use GC's own space metals in recipes", true);
            prop.setComment("Should normally be true. If you set this to false, in a modpack with other mods with the same metals, players may be able to craft advanced GC items without travelling to Moon, Mars, Asteroids etc.");
            prop.setLanguageKey("gc.configgui.disable_ore_dict_space_metals");
            recipesRequireGCAdvancedMetals = prop.getBoolean(true);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("keybindings_initial", "Open Galaxy Map", "KEY_M");
            prop.setComment("Default Map key on first Galacticraft run only. After first run, change keys by Minecraft in-game Controls menu.  Valid settings: KEY_ followed by 0-9 or A-Z.");
            prop.setLanguageKey("gc.configgui.override_map").setRequiresMcRestart(true);
            keyOverrideMap = prop.getString();
            keyOverrideMapI = ConfigManagerCore.parseKeyValue(keyOverrideMap);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("keybindings_initial", "Open Rocket GUI", "KEY_G");
            prop.setComment("Default Rocket/Fuel key on first Galacticraft run only. After first run, change keys by Minecraft in-game Controls menu.  Valid settings: KEY_ followed by 0-9 or A-Z.");
            prop.setLanguageKey("gc.configgui.key_override_fuel_level").setRequiresMcRestart(true);
            keyOverrideFuelLevel = prop.getString();
            keyOverrideFuelLevelI = ConfigManagerCore.parseKeyValue(keyOverrideFuelLevel);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("keybindings_initial", "Toggle Advanced Goggles", "KEY_K");
            prop.setComment("Default Goggles key on first Galacticraft run only. After first run, change keys by Minecraft in-game Controls menu.  Valid settings: KEY_ followed by 0-9 or A-Z.");
            prop.setLanguageKey("gc.configgui.key_override_toggle_adv_goggles").setRequiresMcRestart(true);
            keyOverrideToggleAdvGoggles = prop.getString();
            keyOverrideToggleAdvGogglesI = ConfigManagerCore.parseKeyValue(keyOverrideToggleAdvGoggles);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("compatibility", "Rocket fuel factor", 1);
            prop.setComment("The normal factor is 1.  Increase this to 2 - 5 if other mods with a lot of oil (e.g. BuildCraft) are installed to increase GC rocket fuel requirement.");
            prop.setLanguageKey("gc.configgui.rocket_fuel_factor");
            rocketFuelFactor = prop.getInt(1);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("controls", "Map Scroll Mouse Sensitivity", 1.0);
            prop.setComment("Increase to make the mouse drag scroll more sensitive, decrease to lower sensitivity.");
            prop.setLanguageKey("gc.configgui.map_scroll_sensitivity");
            mapMouseScrollSensitivity = (float)prop.getDouble(1.0);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("controls", "Map Scroll Mouse Invert", false);
            prop.setComment("Set to true to invert the mouse scroll feature on the galaxy map.");
            prop.setLanguageKey("gc.configgui.map_scroll_invert");
            invertMapMouseScroll = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("difficulty", "Meteor Spawn Modifier", 1.0);
            prop.setComment("Set to a value between 0.0 and 1.0 to decrease meteor spawn chance (all dimensions).");
            prop.setLanguageKey("gc.configgui.meteor_spawn_mod");
            meteorSpawnMod = prop.getDouble(1.0);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("difficulty", "Meteor Block Damage Enabled", true);
            prop.setComment("Set to false to stop meteors from breaking blocks on contact.");
            prop.setLanguageKey("gc.configgui.meteor_block_damage");
            meteorBlockDamageEnabled = prop.getBoolean(true);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("general", "Disable Update Check", false);
            prop.setComment("Update check will not run if this is set to true.");
            prop.setLanguageKey("gc.configgui.disable_update_check");
            disableUpdateCheck = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("general", "Allow liquids into Gratings", true);
            prop.setComment("Liquids will not flow into Grating block if this is set to false.");
            prop.setLanguageKey("gc.configgui.allow_liquids_grating").setRequiresMcRestart(true);
            allowLiquidGratings = prop.getBoolean(true);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("worldgen", "Disable Biome Type Registrations", false);
            prop.setComment("Biome Types will not be registered in the BiomeDictionary if this is set to true.");
            prop.setLanguageKey("gc.configgui.disable_biome_type_registrations");
            disableBiomeTypeRegistrations = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            prop = ConfigManagerCore.getConfig("general", "Enable Space Race Manager Popup", false);
            prop.setComment("Space Race Manager will show on-screen after login, if enabled.");
            prop.setLanguageKey("gc.configgui.enable_space_race_manager_popup");
            enableSpaceRaceManagerPopup = prop.getBoolean(false);
            ConfigManagerCore.finishProp(prop);
            ConfigManagerCore.cleanConfig(config, propOrder);
            if (config.hasChanged()) {
                config.save();
            }
            ConfigManagerCore.challengeModeUpdate();
        }
        catch (Exception e) {
            GalacticraftCore.logger.error("Problem loading core config (\"core.conf\")", new Object[0]);
            e.printStackTrace();
        }
    }

    public static void cleanConfig(Configuration config, Map<String, List<String>> propOrder) {
        LinkedList<String> categoriesToRemove = new LinkedList<String>();
        for (String catName : config.getCategoryNames()) {
            List<String> newProps = propOrder.get(catName);
            if (newProps == null) {
                categoriesToRemove.add(catName);
                continue;
            }
            ConfigCategory cat = config.getCategory(catName);
            LinkedList<String> toRemove = new LinkedList<String>();
            for (String oldprop : cat.keySet()) {
                if (newProps.contains(oldprop)) continue;
                toRemove.add(oldprop);
            }
            for (String removeMe : toRemove) {
                cat.remove((Object)removeMe);
            }
            config.setCategoryPropertyOrder(catName, propOrder.get(catName));
        }
        for (String catName : categoriesToRemove) {
            config.removeCategory(config.getCategory(catName));
        }
    }

    private static Property getConfig(String cat, String key, int defaultValue) {
        config.moveProperty("general", key, cat);
        currentCat = cat;
        return config.get(cat, key, defaultValue);
    }

    private static Property getConfig(String cat, String key, double defaultValue) {
        config.moveProperty("general", key, cat);
        currentCat = cat;
        return config.get(cat, key, defaultValue);
    }

    private static Property getConfig(String cat, String key, boolean defaultValue) {
        config.moveProperty("general", key, cat);
        currentCat = cat;
        return config.get(cat, key, defaultValue);
    }

    private static Property getConfig(String cat, String key, String defaultValue) {
        config.moveProperty("general", key, cat);
        config.moveProperty("controls", key, cat);
        currentCat = cat;
        return config.get(cat, key, defaultValue);
    }

    private static Property getConfig(String cat, String key, String[] defaultValue) {
        config.moveProperty("general", key, cat);
        currentCat = cat;
        return config.get(cat, key, defaultValue);
    }

    private static Property getConfig(String cat, String key, int[] defaultValue) {
        config.moveProperty("general", key, cat);
        currentCat = cat;
        return config.get(cat, key, defaultValue);
    }

    private static void finishProp(Property prop) {
        if (propOrder.get(currentCat) == null) {
            propOrder.put(currentCat, new ArrayList());
        }
        propOrder.get(currentCat).add(prop.getName());
    }

    public static boolean setLoaded(int newID) {
        boolean found = false;
        for (int staticLoadDimension : staticLoadDimensions) {
            if (staticLoadDimension != newID) continue;
            found = true;
            break;
        }
        if (!found) {
            int[] oldIDs = staticLoadDimensions;
            staticLoadDimensions = new int[staticLoadDimensions.length + 1];
            System.arraycopy(oldIDs, 0, staticLoadDimensions, 0, oldIDs.length);
            ConfigManagerCore.staticLoadDimensions[ConfigManagerCore.staticLoadDimensions.length - 1] = newID;
            String[] values = new String[staticLoadDimensions.length];
            Arrays.sort(staticLoadDimensions);
            for (int i = 0; i < values.length; ++i) {
                values[i] = String.valueOf(staticLoadDimensions[i]);
            }
            Property prop = config.get("dimensions", "Static Loaded Dimensions", staticLoadDimensions);
            prop.setComment("IDs to load at startup, and keep loaded until server stops. Can be added via /gckeeploaded");
            prop.setLanguageKey("gc.configgui.static_loaded_dimensions");
            prop.set(values);
            config.save();
        }
        return !found;
    }

    public static boolean setUnloaded(int idToRemove) {
        int foundCount = 0;
        for (int staticLoadDimension : staticLoadDimensions) {
            if (staticLoadDimension != idToRemove) continue;
            ++foundCount;
        }
        if (foundCount > 0) {
            ArrayList idArray = new ArrayList(Ints.asList((int[])staticLoadDimensions));
            idArray.removeAll(Collections.singleton(idToRemove));
            staticLoadDimensions = new int[idArray.size()];
            for (int i = 0; i < idArray.size(); ++i) {
                ConfigManagerCore.staticLoadDimensions[i] = (Integer)idArray.get(i);
            }
            String[] values = new String[staticLoadDimensions.length];
            Arrays.sort(staticLoadDimensions);
            for (int i = 0; i < values.length; ++i) {
                values[i] = String.valueOf(staticLoadDimensions[i]);
            }
            Property prop = config.get("dimensions", "Static Loaded Dimensions", staticLoadDimensions);
            prop.setComment("IDs to load at startup, and keep loaded until server stops. Can be added via /gckeeploaded");
            prop.setLanguageKey("gc.configgui.static_loaded_dimensions");
            prop.set(values);
            config.save();
        }
        return foundCount > 0;
    }

    public static void challengeModeUpdate() {
        if (challengeMode) {
            challengeRecipes = (challengeFlags & 1) > 0;
            challengeMobDropsAndSpawning = (challengeFlags & 2) > 0;
            challengeAsteroidPopulation = (challengeFlags & 4) > 0;
            challengeSpawnHandling = (challengeFlags & 8) > 0;
        } else {
            challengeRecipes = false;
            challengeMobDropsAndSpawning = false;
            challengeAsteroidPopulation = false;
            challengeSpawnHandling = false;
        }
    }

    private static boolean searchAsterisk(String[] strings) {
        for (String s : strings) {
            if (s == null || !"*".equals(s.trim())) continue;
            return true;
        }
        return false;
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("difficulty")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("general")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("client")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("controls")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("compatibility")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("worldgen")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("server")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("dimensions")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("schematic")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("achievements")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("entities")).getChildElements());
        return list;
    }

    public static BlockTuple stringToBlock(String s, String caller, boolean logging) {
        String name;
        Block block;
        int lastColon = s.lastIndexOf(58);
        int meta = -1;
        if (lastColon > 0) {
            try {
                meta = Integer.parseInt(s.substring(lastColon + 1, s.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((block = Block.func_149684_b((String)(name = meta == -1 ? s : s.substring(0, lastColon)))) == null) {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
            if (item instanceof ItemBlock) {
                block = ((ItemBlock)item).func_179223_d();
            }
            if (block == null) {
                if (logging) {
                    GalacticraftCore.logger.error("[config] " + caller + ": unrecognised block name '" + s + "'.", new Object[0]);
                }
                return null;
            }
        }
        try {
            Integer.parseInt(name);
            String bName = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
            if (logging) {
                GalacticraftCore.logger.info("[config] " + caller + ": the use of numeric IDs is discouraged, please use " + bName + " instead of " + name, new Object[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (Blocks.field_150350_a == block) {
            if (logging) {
                GalacticraftCore.logger.info("[config] " + caller + ": not a good idea to specify air, skipping that!", new Object[0]);
            }
            return null;
        }
        return new BlockTuple(block, meta);
    }

    public static List<Object> getServerConfigOverride() {
        ArrayList<Object> returnList = new ArrayList<Object>();
        int modeFlags = hardMode ? 1 : 0;
        modeFlags += quickMode ? 2 : 0;
        modeFlags += challengeMode ? 4 : 0;
        modeFlags += disableSpaceStationCreation ? 8 : 0;
        modeFlags += recipesRequireGCAdvancedMetals ? 16 : 0;
        modeFlags += challengeRecipes ? 32 : 0;
        returnList.add(modeFlags += allowLiquidGratings ? 64 : 0);
        returnList.add(dungeonBossHealthMod);
        returnList.add(suffocationDamage);
        returnList.add(suffocationCooldown);
        returnList.add(rocketFuelFactor);
        returnList.add(otherModsSilicon);
        EnergyConfigHandler.serverConfigOverride(returnList);
        returnList.add(detectableIDs.clone());
        return returnList;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setConfigOverride(List<Object> configs) {
        int modeFlag;
        int dataCount = 0;
        hardMode = ((modeFlag = ((Integer)configs.get(dataCount++)).intValue()) & 1) != 0;
        quickMode = (modeFlag & 2) != 0;
        challengeMode = (modeFlag & 4) != 0;
        disableSpaceStationCreation = (modeFlag & 8) != 0;
        recipesRequireGCAdvancedMetals = (modeFlag & 0x10) != 0;
        challengeRecipes = (modeFlag & 0x20) != 0;
        allowLiquidGratings = (modeFlag & 0x40) != 0;
        dungeonBossHealthMod = (Double)configs.get(dataCount++);
        suffocationDamage = (Integer)configs.get(dataCount++);
        suffocationCooldown = (Integer)configs.get(dataCount++);
        rocketFuelFactor = (Integer)configs.get(dataCount++);
        otherModsSilicon = (String)configs.get(dataCount++);
        EnergyConfigHandler.setConfigOverride(((Float)configs.get(dataCount++)).floatValue(), ((Float)configs.get(dataCount++)).floatValue(), ((Float)configs.get(dataCount++)).floatValue(), ((Float)configs.get(dataCount++)).floatValue(), (Integer)configs.get(dataCount++));
        int sizeIDs = configs.size() - dataCount;
        if (sizeIDs > 0) {
            Object dataLast = configs.get(dataCount);
            if (dataLast instanceof String) {
                detectableIDs = new String[sizeIDs];
                for (int j = 0; j < sizeIDs; ++j) {
                    ConfigManagerCore.detectableIDs[j] = new String((String)configs.get(dataCount++));
                }
            } else if (dataLast instanceof String[]) {
                detectableIDs = (String[])dataLast;
            }
            TickHandlerClient.registerDetectableBlocks(false);
        }
        ConfigManagerCore.challengeModeUpdate();
        RecipeManagerGC.setConfigurableRecipes();
    }

    public static void saveClientConfigOverrideable() {
        if (clientSave == null) {
            clientSave = (ArrayList)ConfigManagerCore.getServerConfigOverride();
        }
    }

    public static void restoreClientConfigOverrideable() {
        if (clientSave != null) {
            ConfigManagerCore.setConfigOverride(clientSave);
        }
    }

    private static int parseKeyValue(String key) {
        if (key.equals("KEY_A")) {
            return 30;
        }
        if (key.equals("KEY_B")) {
            return 48;
        }
        if (key.equals("KEY_C")) {
            return 46;
        }
        if (key.equals("KEY_D")) {
            return 32;
        }
        if (key.equals("KEY_E")) {
            return 18;
        }
        if (key.equals("KEY_F")) {
            return 33;
        }
        if (key.equals("KEY_G")) {
            return 34;
        }
        if (key.equals("KEY_H")) {
            return 35;
        }
        if (key.equals("KEY_I")) {
            return 23;
        }
        if (key.equals("KEY_J")) {
            return 36;
        }
        if (key.equals("KEY_K")) {
            return 37;
        }
        if (key.equals("KEY_L")) {
            return 38;
        }
        if (key.equals("KEY_M")) {
            return 50;
        }
        if (key.equals("KEY_N")) {
            return 49;
        }
        if (key.equals("KEY_O")) {
            return 24;
        }
        if (key.equals("KEY_P")) {
            return 25;
        }
        if (key.equals("KEY_Q")) {
            return 16;
        }
        if (key.equals("KEY_R")) {
            return 19;
        }
        if (key.equals("KEY_S")) {
            return 31;
        }
        if (key.equals("KEY_T")) {
            return 20;
        }
        if (key.equals("KEY_U")) {
            return 22;
        }
        if (key.equals("KEY_V")) {
            return 47;
        }
        if (key.equals("KEY_W")) {
            return 17;
        }
        if (key.equals("KEY_X")) {
            return 45;
        }
        if (key.equals("KEY_Y")) {
            return 21;
        }
        if (key.equals("KEY_Z")) {
            return 44;
        }
        if (key.equals("KEY_1")) {
            return 2;
        }
        if (key.equals("KEY_2")) {
            return 3;
        }
        if (key.equals("KEY_3")) {
            return 4;
        }
        if (key.equals("KEY_4")) {
            return 5;
        }
        if (key.equals("KEY_5")) {
            return 6;
        }
        if (key.equals("KEY_6")) {
            return 7;
        }
        if (key.equals("KEY_7")) {
            return 8;
        }
        if (key.equals("KEY_8")) {
            return 9;
        }
        if (key.equals("KEY_9")) {
            return 10;
        }
        if (key.equals("KEY_0")) {
            return 11;
        }
        GalacticraftCore.logger.error("Failed to parse keyboard key: " + key + "... Use values A-Z or 0-9", new Object[0]);
        return 0;
    }

    static {
        recipesRequireGCAdvancedMetals = true;
        biomeIDbase = 102;
        staticLoadDimensions = new int[0];
        disableRocketLaunchDimensions = new int[]{-1, 1};
        otherPlanetWorldBorders = 0;
        oregenIDs = new String[0];
        sealableIDs = new String[0];
        detectableIDs = new String[0];
        clientSave = null;
        propOrder = new TreeMap<String, List<String>>();
    }
}

