/*
 * Decompiled with CFR 0.152.
 */
package api.player.render;

import java.util.Map;
import java.util.Stack;
import org.objectweb.asm.MethodVisitor;

public final class LayerPlayerArmorConstructorVisitor
extends MethodVisitor {
    private final boolean isObfuscated;
    private final Map<String, Stack<String>> constructorReplacements;

    public LayerPlayerArmorConstructorVisitor(MethodVisitor paramMethodVisitor, boolean isObfuscated, Map<String, Stack<String>> constructorReplacements) {
        super(262144, paramMethodVisitor);
        this.isObfuscated = isObfuscated;
        this.constructorReplacements = constructorReplacements;
    }

    public void visitTypeInsn(int opcode, String type) {
        if (opcode == 187 && this.constructorReplacements != null && this.constructorReplacements.containsKey(type)) {
            int typeSeparatorIndex;
            Stack<String> replacementOwnerList = this.constructorReplacements.get(type);
            if (!replacementOwnerList.isEmpty()) {
                type = replacementOwnerList.peek();
            }
            if ((typeSeparatorIndex = type.indexOf(":")) > 0) {
                type = type.substring(0, typeSeparatorIndex);
            }
        }
        super.visitTypeInsn(opcode, type);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (name.equals("<init>") && this.constructorReplacements != null && this.constructorReplacements.containsKey(owner)) {
            int typeSeparatorIndex;
            Stack<String> replacementOwnerList = this.constructorReplacements.get(owner);
            if (!replacementOwnerList.isEmpty()) {
                owner = replacementOwnerList.pop();
            }
            if ((typeSeparatorIndex = owner.indexOf(":")) > 0) {
                this.mv.visitLdcInsn((Object)owner.substring(typeSeparatorIndex + 1));
                owner = owner.substring(0, typeSeparatorIndex);
                int resultSeparatorIndex = desc.indexOf(")");
                desc = desc.substring(0, resultSeparatorIndex) + "Ljava/lang/String;" + desc.substring(resultSeparatorIndex);
            }
        }
        if (this.isObfuscated && name.equals("<init>") && owner.equals("net/minecraft/client/renderer/entity/layers/LayerBipedArmor")) {
            owner = "ccb";
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }
}

