/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.attributes;

import java.util.Collections;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import xzeroair.trinkets.attributes.JumpAttribute;

public class UpdatingAttribute {
    public String modifierName;
    public String attribute;
    public UUID uuid;
    public double amount;
    public int operation;
    public boolean isSavedInNBT;

    public UpdatingAttribute(UUID uuid, IAttribute attribute) {
        this("xat." + attribute.func_111108_a() + ".modifier", uuid, attribute.func_111108_a());
    }

    public UpdatingAttribute(String name, UUID uuid, String attributeName) {
        this.modifierName = name;
        this.uuid = uuid;
        this.attribute = attributeName;
        this.isSavedInNBT = true;
        this.amount = 0.0;
        this.operation = 0;
    }

    public UpdatingAttribute setSavedInNBT(boolean isSavedInNBT) {
        this.isSavedInNBT = isSavedInNBT;
        return this;
    }

    public UpdatingAttribute setAmount(double amount) {
        this.amount = amount;
        return this;
    }

    public UpdatingAttribute setOperation(int operation) {
        this.operation = operation;
        return this;
    }

    private AttributeModifier createModifier(double amount, int operation) {
        if (!this.isSavedInNBT) {
            return new AttributeModifier(this.uuid, this.modifierName, amount, operation).func_111168_a(false);
        }
        return new AttributeModifier(this.uuid, this.modifierName, amount, operation);
    }

    public void addModifier(EntityLivingBase entity) {
        this.addModifier(entity, this.amount, this.operation);
    }

    public void addModifier(EntityLivingBase entity, double amount, int operation) {
        World world;
        World world2 = world = entity == null ? null : entity.func_130014_f_();
        if (entity == null || world == null || world.field_72995_K) {
            return;
        }
        IAttributeInstance AttributeInstance = entity.func_110140_aT().func_111152_a(this.attribute);
        if (AttributeInstance == null || this.uuid.compareTo(UUID.fromString("00000000-0000-0000-0000-000000000000")) == 0) {
            return;
        }
        if (AttributeInstance.func_111127_a(this.uuid) != null) {
            AttributeModifier m = AttributeInstance.func_111127_a(this.uuid);
            if (m.func_111164_d() != amount || m.func_111169_c() != operation) {
                this.removeModifier(entity);
            }
            if (entity.field_70128_L) {
                this.removeModifier(entity);
                return;
            }
        }
        if (amount != 0.0 && !entity.field_70128_L && AttributeInstance.func_111127_a(this.uuid) == null) {
            if (AttributeInstance.func_111123_a() == SharedMonsterAttributes.field_111267_a) {
                AttributeModifier modifier = this.createModifier(amount, operation);
                float health = entity.func_110143_aJ();
                float oldMaxHealth = entity.func_110138_aP();
                AttributeInstance.func_111121_a(modifier);
                float maxHealth = entity.func_110138_aP();
                float difference = oldMaxHealth - maxHealth;
                if (oldMaxHealth > maxHealth) {
                    entity.func_70606_j(maxHealth);
                } else {
                    entity.func_70606_j(health + -difference);
                }
                if (!entity.func_130014_f_().field_72995_K && entity.func_130014_f_() instanceof WorldServer) {
                    SPacketEntityProperties packet = new SPacketEntityProperties(entity.func_145782_y(), Collections.singleton(AttributeInstance));
                    ((WorldServer)entity.func_130014_f_()).func_73039_n().func_151248_b((Entity)entity, (Packet)packet);
                }
            } else {
                AttributeInstance.func_111121_a(this.createModifier(amount, operation));
            }
        }
    }

    public void removeModifier(EntityLivingBase entity) {
        World world;
        World world2 = world = entity == null ? null : entity.func_130014_f_();
        if (entity == null || world == null || world.field_72995_K) {
            return;
        }
        IAttributeInstance AttributeInstance = entity.func_110140_aT().func_111152_a(this.attribute);
        if (AttributeInstance == null || AttributeInstance.func_111127_a(this.uuid) == null) {
            return;
        }
        if (AttributeInstance.func_111123_a() == SharedMonsterAttributes.field_111267_a) {
            float health = entity.func_110143_aJ();
            AttributeInstance.func_188479_b(this.uuid);
            if ((double)health > AttributeInstance.func_111126_e()) {
                entity.func_70606_j(entity.func_110138_aP());
            }
        } else {
            if (AttributeInstance.func_111123_a() == JumpAttribute.stepHeight && (double)entity.field_70138_W != AttributeInstance.func_111125_b()) {
                entity.field_70138_W = (float)AttributeInstance.func_111125_b();
            }
            AttributeInstance.func_188479_b(this.uuid);
        }
    }
}

